/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.extensions.IForgeVertexBuilder;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public interface IVertexBuilder
extends IForgeVertexBuilder {
    public static final Logger field_227884_f_ = LogManager.getLogger();
    public static final ThreadLocal<RenderEnv> RENDER_ENV = ThreadLocal.withInitial(() -> new RenderEnv(Blocks.field_150350_a.func_176223_P(), new BlockPos(0, 0, 0)));
    public static final boolean FORGE = Reflector.ForgeHooksClient.exists();

    default public RenderEnv getRenderEnv(BlockState blockState, BlockPos blockPos) {
        RenderEnv renderEnv = (RenderEnv)RENDER_ENV.get();
        renderEnv.reset(blockState, blockPos);
        return renderEnv;
    }

    public IVertexBuilder func_225582_a_(double var1, double var3, double var5);

    public IVertexBuilder func_225586_a_(int var1, int var2, int var3, int var4);

    public IVertexBuilder func_225583_a_(float var1, float var2);

    public IVertexBuilder func_225585_a_(int var1, int var2);

    public IVertexBuilder func_225587_b_(int var1, int var2);

    public IVertexBuilder func_225584_a_(float var1, float var2, float var3);

    public void func_181675_d();

    default public void func_225588_a_(float x2, float y2, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        this.func_225582_a_((double)x2, (double)y2, (double)z);
        this.func_227885_a_(red, green, blue, alpha);
        this.func_225583_a_(texU, texV);
        this.func_227891_b_(overlayUV);
        this.func_227886_a_(lightmapUV);
        this.func_225584_a_(normalX, normalY, normalZ);
        this.func_181675_d();
    }

    default public IVertexBuilder func_227885_a_(float red, float green, float blue, float alpha) {
        return this.func_225586_a_((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    default public IVertexBuilder func_227886_a_(int lightmapUV) {
        return this.func_225587_b_(lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF);
    }

    default public IVertexBuilder func_227891_b_(int overlayUV) {
        return this.func_225585_a_(overlayUV & 0xFFFF, overlayUV >> 16 & 0xFFFF);
    }

    default public void func_227889_a_(MatrixStack.Entry matrixEntryIn, BakedQuad quadIn, float redIn, float greenIn, float blueIn, int combinedLightIn, int combinedOverlayIn) {
        this.func_227890_a_(matrixEntryIn, quadIn, this.getTempFloat4(1.0f, 1.0f, 1.0f, 1.0f), redIn, greenIn, blueIn, this.getTempInt4(combinedLightIn, combinedLightIn, combinedLightIn, combinedLightIn), combinedOverlayIn, false);
    }

    default public void addVertexData(MatrixStack.Entry matrixEntry, BakedQuad bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmapCoords, int overlayCoords, boolean readExistingColor) {
        this.addQuad(matrixEntry, bakedQuad, baseBrightness, red, green, blue, alpha, lightmapCoords, overlayCoords, readExistingColor);
    }

    default public void func_227890_a_(MatrixStack.Entry matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        this.addQuad(matrixEntryIn, quadIn, colorMuls, redIn, greenIn, blueIn, 1.0f, combinedLightsIn, combinedOverlayIn, mulColor);
    }

    default public void addQuad(MatrixStack.Entry matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, float alphaIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        IRandomEntity entity;
        boolean shadersVelocity;
        int[] aint = this.isMultiTexture() ? quadIn.getVertexDataSingle() : quadIn.func_178209_a();
        this.putSprite(quadIn.getSprite());
        boolean separateAoInAlpha = BlockModelRenderer.isSeparateAoLightValue();
        Vector3i vector3i = quadIn.func_178210_d().func_176730_m();
        float xv = vector3i.func_177958_n();
        float yv = vector3i.func_177956_o();
        float zv = vector3i.func_177952_p();
        Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
        Matrix3f matrixNormal = matrixEntryIn.func_227872_b_();
        float xn = matrixNormal.getTransformX(xv, yv, zv);
        float yn = matrixNormal.getTransformY(xv, yv, zv);
        float zn = matrixNormal.getTransformZ(xv, yv, zv);
        int i2 = 8;
        int vertexIntSize = DefaultVertexFormats.field_176600_a.func_181719_f();
        int j2 = aint.length / vertexIntSize;
        boolean bl = shadersVelocity = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        if (shadersVelocity && (entity = RandomEntities.getRandomEntityRendered()) != null) {
            VertexPosition[] quadPos = quadIn.getVertexPositions(entity.getId());
            this.setQuadVertexPositions(quadPos);
        }
        for (int k2 = 0; k2 < j2; ++k2) {
            Vector3f forgeNormals;
            float f5;
            float f4;
            float f3;
            float colorMulAo;
            int pos = k2 * vertexIntSize;
            float f2 = Float.intBitsToFloat(aint[pos + 0]);
            float f1 = Float.intBitsToFloat(aint[pos + 1]);
            float f22 = Float.intBitsToFloat(aint[pos + 2]);
            float ca = 1.0f;
            float f6 = colorMulAo = separateAoInAlpha ? 1.0f : colorMuls[k2];
            if (mulColor) {
                int col = aint[pos + 3];
                float f62 = (float)(col & 0xFF) / 255.0f;
                float f7 = (float)(col >> 8 & 0xFF) / 255.0f;
                float f8 = (float)(col >> 16 & 0xFF) / 255.0f;
                f3 = f62 * colorMulAo * redIn;
                f4 = f7 * colorMulAo * greenIn;
                f5 = f8 * colorMulAo * blueIn;
                if (FORGE) {
                    float a2 = (float)(col >> 24 & 0xFF) / 255.0f;
                    ca = a2 * alphaIn;
                }
            } else {
                f3 = colorMulAo * redIn;
                f4 = colorMulAo * greenIn;
                f5 = colorMulAo * blueIn;
                if (FORGE) {
                    ca = alphaIn;
                }
            }
            int l2 = combinedLightsIn[k2];
            if (FORGE) {
                l2 = this.applyBakedLighting(combinedLightsIn[k2], aint, pos);
            }
            float f9 = Float.intBitsToFloat(aint[pos + 4]);
            float f10 = Float.intBitsToFloat(aint[pos + 5]);
            float xt = matrix4f.getTransformX(f2, f1, f22, 1.0f);
            float yt = matrix4f.getTransformY(f2, f1, f22, 1.0f);
            float zt2 = matrix4f.getTransformZ(f2, f1, f22, 1.0f);
            if (FORGE && (forgeNormals = this.applyBakedNormals(aint, pos, matrixEntryIn.func_227872_b_())) != null) {
                xn = forgeNormals.func_195899_a();
                yn = forgeNormals.func_195900_b();
                zn = forgeNormals.func_195902_c();
            }
            if (separateAoInAlpha) {
                ca = colorMuls[k2];
            }
            this.func_225588_a_(xt, yt, zt2, f3, f4, f5, ca, f9, f10, combinedOverlayIn, l2, xn, yn, zn);
        }
    }

    default public IVertexBuilder func_227888_a_(Matrix4f matrixIn, float x2, float y2, float z) {
        float xt = matrixIn.getTransformX(x2, y2, z, 1.0f);
        float yt = matrixIn.getTransformY(x2, y2, z, 1.0f);
        float zt2 = matrixIn.getTransformZ(x2, y2, z, 1.0f);
        return this.func_225582_a_((double)xt, (double)yt, (double)zt2);
    }

    default public IVertexBuilder func_227887_a_(Matrix3f matrixIn, float x2, float y2, float z) {
        float xt = matrixIn.getTransformX(x2, y2, z);
        float yt = matrixIn.getTransformY(x2, y2, z);
        float zt2 = matrixIn.getTransformZ(x2, y2, z);
        return this.func_225584_a_(xt, yt, zt2);
    }

    default public void putSprite(TextureAtlasSprite sprite) {
    }

    default public void setSprite(TextureAtlasSprite sprite) {
    }

    default public boolean isMultiTexture() {
        return false;
    }

    default public void setRenderType(RenderType layer) {
    }

    default public RenderType getRenderType() {
        return null;
    }

    default public void setRenderBlocks(boolean renderBlocks) {
    }

    default public Vector3f getTempVec3f(Vector3f vec) {
        return vec.func_229195_e_();
    }

    default public Vector3f getTempVec3f(float x2, float y2, float z) {
        return new Vector3f(x2, y2, z);
    }

    default public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        return new float[]{f1, f2, f3, f4};
    }

    default public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        return new int[]{i1, i2, i3, i4};
    }

    default public IRenderTypeBuffer.Impl getRenderTypeBuffer() {
        return null;
    }

    default public void setQuadVertexPositions(VertexPosition[] vps) {
    }

    default public void setMidBlock(float mbx, float mby, float mbz) {
    }

    default public IVertexBuilder getSecondaryBuilder() {
        return null;
    }

    default public int applyBakedLighting(int lightmapCoord, int[] data, int pos) {
        int offsetInt = IVertexBuilder.getLightOffset((int)0);
        int blBaked = LightTexture.func_228450_a_((int)data[pos + offsetInt]);
        int slBaked = LightTexture.func_228454_b_((int)data[pos + offsetInt]);
        if (blBaked == 0 && slBaked == 0) {
            return lightmapCoord;
        }
        int bl = LightTexture.func_228450_a_((int)lightmapCoord);
        int sl = LightTexture.func_228454_b_((int)lightmapCoord);
        bl = Math.max(bl, blBaked);
        sl = Math.max(sl, slBaked);
        return LightTexture.func_228451_a_((int)bl, (int)sl);
    }

    public static int getLightOffset(int v2) {
        return v2 * 8 + 6;
    }

    default public Vector3f applyBakedNormals(int[] data, int pos, Matrix3f normalTransform) {
        int offsetNormal = 7;
        int val = data[pos + offsetNormal];
        byte nx = (byte)(val >> 0 & 0xFF);
        byte ny = (byte)(val >> 8 & 0xFF);
        byte nz = (byte)(val >> 16 & 0xFF);
        if (nx != 0 || ny != 0 || nz != 0) {
            Vector3f generated = this.getTempVec3f((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.func_229188_a_(normalTransform);
            return generated;
        }
        return null;
    }
}

