/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.EmissiveTextures;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.ITextureFormat;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.ColorBlenderLinear;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ekb
extends ejq
implements eke {
    private static final Logger f = LogManager.getLogger();
    @Deprecated
    public static final vk d = biz.c;
    @Deprecated
    public static final vk e = new vk("textures/atlas/particles.png");
    private final List<ekc> g = Lists.newArrayList();
    private final Set<vk> h = Sets.newHashSet();
    private final Map<vk, ekc> i = Maps.newHashMap();
    private final vk j;
    private final int k;
    private Map<vk, ekc> mapRegisteredSprites = new LinkedHashMap<vk, ekc>();
    private Map<vk, ekc> mapMissingSprites = new LinkedHashMap<vk, ekc>();
    private ekc[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private CounterInt counterIndexInMap = new CounterInt(0);
    public int atlasWidth = 0;
    public int atlasHeight = 0;
    public int mipmapLevel = 0;
    private int countAnimationsActive;
    private int frameCountAnimations;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private ITextureFormat textureFormat;

    public ekb(vk textureLocationIn) {
        this.j = textureLocationIn;
        this.k = RenderSystem.maxSupportedTextureSize();
        this.terrain = textureLocationIn.equals(d);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        if (this.terrain) {
            Config.setTextureMap(this);
        }
    }

    @Override
    public void a(ach manager) throws IOException {
    }

    public void a(a sheetDataIn) {
        List<ekc> listSprites;
        this.h.clear();
        this.h.addAll(sheetDataIn.a);
        f.info("Created: {}x{}x{} {}-atlas", (Object)sheetDataIn.b, (Object)sheetDataIn.c, (Object)sheetDataIn.d, (Object)this.j);
        dex.a((int)this.b(), (int)sheetDataIn.d, (int)sheetDataIn.b, (int)sheetDataIn.c);
        this.atlasWidth = sheetDataIn.b;
        this.atlasHeight = sheetDataIn.c;
        this.mipmapLevel = sheetDataIn.d;
        if (this.shaders) {
            ShadersTex.allocateTextureMapNS(sheetDataIn.d, sheetDataIn.b, sheetDataIn.c, this);
        }
        this.f();
        for (ekc textureatlassprite : sheetDataIn.e) {
            this.i.put(textureatlassprite.l(), textureatlassprite);
            try {
                textureatlassprite.o();
            }
            catch (Throwable throwable) {
                l crashreport = l.a(throwable, "Stitching texture atlas");
                m crashreportcategory = crashreport.a("Texture being stitched together");
                crashreportcategory.a("Atlas path", (Object)this.j);
                crashreportcategory.a("Sprite", (Object)textureatlassprite);
                throw new u(crashreport);
            }
            if (!textureatlassprite.r()) continue;
            textureatlassprite.setAnimationIndex(this.g.size());
            this.g.add(textureatlassprite);
        }
        TextureUtils.refreshCustomSprites(this);
        Config.log("Animated sprites: " + this.g.size());
        if (Config.isMultiTexture()) {
            listSprites = sheetDataIn.e;
            for (ekc tas : listSprites) {
                ekb.uploadMipmapsSingle(tas);
                if (tas.spriteNormal != null) {
                    ekb.uploadMipmapsSingle(tas.spriteNormal);
                }
                if (tas.spriteSpecular == null) continue;
                ekb.uploadMipmapsSingle(tas.spriteSpecular);
            }
            dem.s(this.b());
        }
        if (Config.isShaders()) {
            listSprites = sheetDataIn.e;
            if (Shaders.configNormalMap) {
                dem.s(this.getMultiTexID().norm);
                for (ekc tas : listSprites) {
                    ekc spriteNormal = tas.spriteNormal;
                    if (spriteNormal == null) continue;
                    spriteNormal.o();
                }
            }
            if (Shaders.configSpecularMap) {
                dem.s(this.getMultiTexID().spec);
                for (ekc tas : listSprites) {
                    ekc spriteSpecular = tas.spriteSpecular;
                    if (spriteSpecular == null) continue;
                    spriteSpecular.o();
                }
            }
            dem.s(this.b());
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        this.updateIconGrid(sheetDataIn.b, sheetDataIn.c);
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.j);
            TextureUtils.saveGlTexture("debug/" + this.j.a().replaceAll("/", "_"), this.b(), sheetDataIn.d, sheetDataIn.b, sheetDataIn.c);
            if (this.shaders) {
                if (Shaders.configNormalMap) {
                    TextureUtils.saveGlTexture("debug/" + this.j.a().replaceAll("/", "_").replace(".png", "_n.png"), this.multiTex.norm, sheetDataIn.d, sheetDataIn.b, sheetDataIn.c);
                }
                if (Shaders.configSpecularMap) {
                    TextureUtils.saveGlTexture("debug/" + this.j.a().replaceAll("/", "_").replace(".png", "_s.png"), this.multiTex.spec, sheetDataIn.d, sheetDataIn.b, sheetDataIn.c);
                }
                dem.s(this.b());
            }
        }
    }

    public a a(ach resourceManagerIn, Stream<vk> resourceLocationsIn, anw profilerIn, int maxMipmapLevelIn) {
        int k1;
        int minSpriteSize;
        this.terrain = this.j.equals(d);
        this.shaders = Config.isShaders();
        this.multiTexture = Config.isMultiTexture();
        this.textureFormat = ITextureFormat.readConfiguration();
        int mipmapLevels = maxMipmapLevelIn;
        this.mapRegisteredSprites.clear();
        this.mapMissingSprites.clear();
        this.counterIndexInMap.reset();
        profilerIn.a("preparing");
        Set<vk> set = resourceLocationsIn.peek(p_229222_0_ -> {
            if (p_229222_0_ == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
        }).collect(Collectors.toSet());
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        TextureUtils.registerCustomSprites(this);
        set.addAll(this.mapRegisteredSprites.keySet());
        Set<vk> locsEmissive = ekb.newHashSet(set, this.mapRegisteredSprites.keySet());
        EmissiveTextures.updateIcons(this, locsEmissive);
        set.addAll(this.mapRegisteredSprites.keySet());
        if (mipmapLevels >= 4) {
            mipmapLevels = this.detectMaxMipmapLevel(set, resourceManagerIn);
            Config.log("Mipmap levels: " + mipmapLevels);
        }
        int i2 = TextureUtils.getGLMaximumTextureSize();
        ejz stitcher = new ejz(i2, i2, maxMipmapLevelIn);
        int j2 = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = ekb.getMinSpriteSize(mipmapLevels);
        int k2 = 1 << maxMipmapLevelIn;
        profilerIn.b("extracting_frames");
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this, set);
        for (ekc.a textureatlassprite$info : this.a(resourceManagerIn, set)) {
            int ws = textureatlassprite$info.b();
            int hs = textureatlassprite$info.c();
            if (ws < 1 || hs < 1) {
                Config.warn("Invalid sprite size: " + textureatlassprite$info.a());
                continue;
            }
            if (ws < minSpriteSize || mipmapLevels > 0) {
                int ws2;
                int n2 = ws2 = mipmapLevels > 0 ? TextureUtils.scaleToGrid(ws, minSpriteSize) : TextureUtils.scaleToMin(ws, minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo(ws)) {
                        Config.log("Scaled non power of 2: " + textureatlassprite$info.a() + ", " + ws + " -> " + ws2);
                    } else {
                        Config.log("Scaled too small texture: " + textureatlassprite$info.a() + ", " + ws + " -> " + ws2);
                    }
                    int hs2 = hs * ws2 / ws;
                    textureatlassprite$info.setSpriteWidth(ws2);
                    textureatlassprite$info.setSpriteHeight(hs2);
                    textureatlassprite$info.setScaleFactor((double)ws2 * 1.0 / (double)ws);
                }
            }
            j2 = Math.min(j2, Math.min(textureatlassprite$info.b(), textureatlassprite$info.c()));
            int l2 = Math.min(Integer.lowestOneBit(textureatlassprite$info.b()), Integer.lowestOneBit(textureatlassprite$info.c()));
            if (l2 < k2) {
                f.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite$info.a(), (Object)textureatlassprite$info.b(), (Object)textureatlassprite$info.c(), (Object)afm.f(k2), (Object)afm.f(l2));
                k2 = l2;
            }
            stitcher.a(textureatlassprite$info);
        }
        int i1 = Math.min(j2, k2);
        int j1 = afm.f(i1);
        if (j1 < 0) {
            j1 = 0;
        }
        if (j1 < maxMipmapLevelIn) {
            f.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.j, (Object)maxMipmapLevelIn, (Object)j1, (Object)i1);
            k1 = j1;
        } else {
            k1 = maxMipmapLevelIn;
        }
        profilerIn.b("register");
        ekc.a missingInfo = ekb.fixSpriteSize(ejv.b(), minSpriteSize);
        stitcher.a(missingInfo);
        profilerIn.b("stitching");
        try {
            stitcher.c();
        }
        catch (eka stitcherexception) {
            l crashreport = l.a(stitcherexception, "Stitching");
            m crashreportcategory = crashreport.a("Stitcher");
            crashreportcategory.a("Sprites", (Object)stitcherexception.a().stream().map(p_229216_0_ -> String.format("%s[%dx%d]", p_229216_0_.a(), p_229216_0_.b(), p_229216_0_.c())).collect(Collectors.joining(",")));
            crashreportcategory.a("Max Texture Size", (Object)i2);
            throw new u(crashreport);
        }
        profilerIn.b("loading");
        List<ekc> list = this.a(resourceManagerIn, stitcher, k1);
        profilerIn.c();
        return new a(set, stitcher.a(), stitcher.b(), k1, list);
    }

    private Collection<ekc.a> a(ach resourceManagerIn, Set<vk> spriteLocationsIn) {
        ArrayList list = Lists.newArrayList();
        ConcurrentLinkedQueue<ekc.a> concurrentlinkedqueue = new ConcurrentLinkedQueue<ekc.a>();
        for (vk resourcelocation : spriteLocationsIn) {
            if (ejv.a().equals(resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                ekc.a textureatlassprite$info;
                vk resourcelocation1 = this.b(resourcelocation);
                try (acg iresource = resourceManagerIn.a(resourcelocation1);){
                    deu pngsizeinfo = new deu(iresource.toString(), iresource.b());
                    elc animationmetadatasection = (elc)iresource.a((abn)elc.a);
                    if (animationmetadatasection == null) {
                        animationmetadatasection = elc.b;
                    }
                    Pair pair = animationmetadatasection.a(pngsizeinfo.a, pngsizeinfo.b);
                    textureatlassprite$info = new ekc.a(resourcelocation, (Integer)pair.getFirst(), (Integer)pair.getSecond(), animationmetadatasection);
                }
                catch (RuntimeException runtimeexception) {
                    f.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                catch (IOException ioexception) {
                    f.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite$info);
            }, x.f()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<ekc> a(ach resourceManagerIn, ejz stitcherIn, int mipmapLevelIn) {
        ConcurrentLinkedQueue concurrentlinkedqueue = new ConcurrentLinkedQueue();
        ArrayList list = Lists.newArrayList();
        stitcherIn.a((ekc.a p_229215_5_, int p_229215_6_, int p_229215_7_, int p_229215_8_, int p_229215_9_) -> {
            if (p_229215_5_.a().equals(ejv.b().a())) {
                ejv missingtexturesprite = new ejv(this, p_229215_5_, mipmapLevelIn, p_229215_6_, p_229215_7_, p_229215_8_, p_229215_9_);
                missingtexturesprite.update(resourceManagerIn);
                concurrentlinkedqueue.add(missingtexturesprite);
            } else {
                list.add(CompletableFuture.runAsync(() -> {
                    ekc textureatlassprite = this.a(resourceManagerIn, p_229215_5_, p_229215_6_, p_229215_7_, mipmapLevelIn, p_229215_8_, p_229215_9_);
                    if (textureatlassprite != null) {
                        concurrentlinkedqueue.add(textureatlassprite);
                    }
                }, x.f()));
            }
        });
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return Lists.newArrayList(concurrentlinkedqueue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private ekc a(ach resourceManagerIn, ekc.a spriteInfoIn, int widthIn, int heightIn, int mipmapLevelIn, int originX, int originY) {
        vk resourcelocation = this.b(spriteInfoIn.a());
        try (acg iresource = resourceManagerIn.a(resourcelocation);){
            det nativeimage = det.a(iresource.b());
            ekc textureatlassprite = new ekc(this, spriteInfoIn, mipmapLevelIn, widthIn, heightIn, originX, originY, nativeimage);
            textureatlassprite.update(resourceManagerIn);
            ekc ekc2 = textureatlassprite;
            return ekc2;
        }
        catch (RuntimeException runtimeexception) {
            f.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
            return null;
        }
        catch (IOException ioexception) {
            f.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
            return null;
        }
    }

    public vk b(vk location) {
        if (this.isAbsoluteLocation(location)) {
            return new vk(location.b(), location.a() + ".png");
        }
        return new vk(location.b(), String.format("textures/%s%s", location.a(), ".png"));
    }

    public void a() {
        boolean hasNormal = false;
        boolean hasSpecular = false;
        if (!this.g.isEmpty()) {
            this.d();
        }
        int countActive = 0;
        for (ekc textureatlassprite : this.g) {
            if (!this.isAnimationEnabled(textureatlassprite)) continue;
            textureatlassprite.q();
            if (textureatlassprite.isAnimationActive()) {
                ++countActive;
            }
            if (textureatlassprite.spriteNormal != null) {
                hasNormal = true;
            }
            if (textureatlassprite.spriteSpecular == null) continue;
            hasSpecular = true;
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                dem.s(this.getMultiTexID().norm);
                for (ekc textureatlassprite : this.g) {
                    if (textureatlassprite.spriteNormal == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteNormal.q();
                    if (!textureatlassprite.spriteNormal.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasSpecular) {
                dem.s(this.getMultiTexID().spec);
                for (ekc textureatlassprite : this.g) {
                    if (textureatlassprite.spriteSpecular == null || !this.isAnimationEnabled(textureatlassprite) || !textureatlassprite.isAnimationActive()) continue;
                    textureatlassprite.spriteSpecular.q();
                    if (!textureatlassprite.spriteSpecular.isAnimationActive()) continue;
                    ++countActive;
                }
            }
            if (hasNormal || hasSpecular) {
                dem.s(this.b());
            }
        }
        if (Config.isMultiTexture()) {
            for (ekc ts : this.g) {
                if (!this.isAnimationEnabled(ts) || !ts.isAnimationActive()) continue;
                countActive += ekb.updateAnimationSingle(ts);
                if (ts.spriteNormal != null) {
                    countActive += ekb.updateAnimationSingle(ts.spriteNormal);
                }
                if (ts.spriteSpecular == null) continue;
                countActive += ekb.updateAnimationSingle(ts.spriteSpecular);
            }
            dem.s(this.b());
        }
        if (this.terrain) {
            int frameCount = Config.getMinecraft().e.getFrameCount();
            if (frameCount != this.frameCountAnimations) {
                this.countAnimationsActive = countActive;
                this.frameCountAnimations = frameCount;
            }
            if (SmartAnimations.isActive()) {
                SmartAnimations.resetSpritesRendered(this);
            }
        }
    }

    public void e() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::a);
        } else {
            this.a();
        }
    }

    public ekc a(vk location) {
        ekc textureatlassprite = this.i.get(location);
        return textureatlassprite == null ? this.i.get(ejv.a()) : textureatlassprite;
    }

    public void f() {
        for (ekc textureatlassprite : this.i.values()) {
            textureatlassprite.close();
        }
        if (this.multiTexture) {
            for (ekc ts : this.i.values()) {
                ts.deleteSpriteTexture();
                if (ts.spriteNormal != null) {
                    ts.spriteNormal.deleteSpriteTexture();
                }
                if (ts.spriteSpecular == null) continue;
                ts.spriteSpecular.deleteSpriteTexture();
            }
        }
        this.i.clear();
        this.g.clear();
    }

    public vk g() {
        return this.j;
    }

    public void b(a sheetDataIn) {
        this.a(false, sheetDataIn.d > 0);
    }

    private boolean isAbsoluteLocation(vk loc) {
        String path = loc.a();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("optifine/");
    }

    public ekc getRegisteredSprite(String name) {
        vk loc = new vk(name);
        return this.getRegisteredSprite(loc);
    }

    public ekc getRegisteredSprite(vk loc) {
        return this.mapRegisteredSprites.get(loc);
    }

    public ekc getUploadedSprite(String name) {
        vk loc = new vk(name);
        return this.getUploadedSprite(loc);
    }

    public ekc getUploadedSprite(vk loc) {
        return this.i.get(loc);
    }

    private boolean isAnimationEnabled(ekc ts) {
        if (!this.terrain) {
            return true;
        }
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulFireLayer0 || ts == TextureUtils.iconSoulFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconCampFire || ts == TextureUtils.iconCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconSoulCampFire || ts == TextureUtils.iconSoulCampFireLogLit) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        return Config.isAnimatedTerrain();
    }

    private static void uploadMipmapsSingle(ekc tas) {
        ekc ss = tas.spriteSingle;
        if (ss != null) {
            ss.setAnimationIndex(tas.getAnimationIndex());
            tas.bindSpriteTexture();
            try {
                ss.o();
            }
            catch (Exception e2) {
                Config.dbg("Error uploading sprite single: " + ss + ", parent: " + tas);
                e2.printStackTrace();
            }
        }
    }

    private static int updateAnimationSingle(ekc tas) {
        ekc spriteSingle = tas.spriteSingle;
        if (spriteSingle != null) {
            tas.bindSpriteTexture();
            spriteSingle.q();
            if (spriteSingle.isAnimationActive()) {
                return 1;
            }
        }
        return 0;
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap.getValue();
    }

    private int detectMaxMipmapLevel(Set<vk> setSpriteLocations, ach rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(setSpriteLocations, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = afm.c(minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = afm.f(minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Set<vk> setSpriteLocations, ach rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        for (vk loc : setSpriteLocations) {
            vk locComplete = this.b(loc);
            try {
                InputStream in;
                acg res = rm.a(locComplete);
                if (res == null || (in = res.b()) == null) continue;
                Dimension dim = TextureUtils.getImageSize(in, "png");
                in.close();
                if (dim == null) continue;
                int width = dim.width;
                int width2 = afm.c(width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e2) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count2 = (Integer)mapSizeCounts.get(size);
            countSprites += count2;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private static int getMinSpriteSize(int mipmapLevels) {
        int minSize = 1 << mipmapLevels;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    private static ekc.a fixSpriteSize(ekc.a info, int minSpriteSize) {
        if (info.b() >= minSpriteSize && info.c() >= minSpriteSize) {
            return info;
        }
        int widthNew = Math.max(info.b(), minSpriteSize);
        int heightNew = Math.max(info.c(), minSpriteSize);
        ekc.a infoNew = new ekc.a(info.a(), widthNew, heightNew, info.getSpriteAnimationMetadata());
        return infoNew;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = dem.getBoundTexture();
        return boundTexId == (texId = this.b());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new ekc[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (ekc ts : this.i.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.h(), ts.i()) + deltaU;
            double vMin = (double)Math.min(ts.j(), ts.k()) + deltaV;
            double uMax = (double)Math.max(ts.h(), ts.i()) - deltaU;
            double vMax = (double)Math.max(ts.j(), ts.k()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu + ", icon: " + ts.l());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.l());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public ekc getIconByUV(double u2, double v2) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v2 / this.iconGridSizeV);
        int iu = (int)(u2 / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public int getCountAnimations() {
        return this.g.size();
    }

    public int getCountAnimationsActive() {
        return this.countAnimationsActive;
    }

    public ekc registerSprite(vk location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        ekc sprite = this.mapRegisteredSprites.get(location);
        if (sprite != null) {
            return sprite;
        }
        this.h.add(location);
        sprite = new ekc(location);
        this.mapRegisteredSprites.put(location, sprite);
        sprite.updateIndexInMap(this.counterIndexInMap);
        return sprite;
    }

    public Collection<ekc> getRegisteredSprites() {
        return Collections.unmodifiableCollection(this.mapRegisteredSprites.values());
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    public CounterInt getCounterIndexInMap() {
        return this.counterIndexInMap;
    }

    private void onSpriteMissing(vk loc) {
        ekc sprite = this.mapRegisteredSprites.get(loc);
        if (sprite == null) {
            return;
        }
        this.mapMissingSprites.put(loc, sprite);
    }

    private static <T> Set<T> newHashSet(Set<T> set1, Set<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public int getMipmapLevel() {
        return this.mipmapLevel;
    }

    public boolean isMipmaps() {
        return this.mipmapLevel > 0;
    }

    public ITextureFormat getTextureFormat() {
        return this.textureFormat;
    }

    public IColorBlender getShadersColorBlender(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return null;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.getColorBlender(typeIn);
        }
        return new ColorBlenderLinear();
    }

    public boolean isTextureBlend(ShadersTextureType typeIn) {
        if (typeIn == null) {
            return true;
        }
        if (this.textureFormat != null) {
            return this.textureFormat.isTextureBlend(typeIn);
        }
        return true;
    }

    public boolean isNormalBlend() {
        return this.isTextureBlend(ShadersTextureType.NORMAL);
    }

    public boolean isSpecularBlend() {
        return this.isTextureBlend(ShadersTextureType.SPECULAR);
    }

    public String toString() {
        return "" + this.j;
    }

    public static class a {
        final Set<vk> a;
        final int b;
        final int c;
        final int d;
        final List<ekc> e;

        public a(Set<vk> spriteLocationsIn, int widthIn, int heightIn, int mipmapLevelIn, List<ekc> spritesIn) {
            this.a = spriteLocationsIn;
            this.b = widthIn;
            this.c = heightIn;
            this.d = mipmapLevelIn;
            this.e = spritesIn;
        }
    }
}

