/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VideoMode;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.NarratorStatus;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.HandSide;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomSky;
import net.optifine.DynamicLights;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.config.FloatOptions;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import net.optifine.util.FontUtils;
import net.optifine.util.KeyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class GameSettings {
    private static final Logger field_151454_ax = LogManager.getLogger();
    private static final Gson field_151450_ay = new Gson();
    private static final TypeToken<List<String>> field_151449_az = new /* Unavailable Anonymous Inner Class!! */;
    private static final Splitter field_230003_aR_ = Splitter.on((char)':').limit(2);
    public double field_74341_c = 0.5;
    public int field_151451_c = -1;
    public float field_238329_c_ = 1.0f;
    public int field_74350_i = 120;
    public CloudOption field_74345_l = CloudOption.FANCY;
    public GraphicsFanciness field_238330_f_ = GraphicsFanciness.FANCY;
    public AmbientOcclusionStatus field_74348_k = AmbientOcclusionStatus.MAX;
    public List<String> field_151453_l = Lists.newArrayList();
    public List<String> field_183018_l = Lists.newArrayList();
    public ChatVisibility field_74343_n = ChatVisibility.FULL;
    public double field_74357_r = 1.0;
    public double field_238331_l_ = 0.0;
    public double field_216845_l = 0.5;
    @Nullable
    public String field_198019_u;
    public boolean field_80005_w;
    public boolean field_82882_x;
    public boolean field_82881_y = true;
    private final Set<PlayerModelPart> field_178882_aU = Sets.newHashSet((Object[])PlayerModelPart.values());
    public HandSide field_186715_A = HandSide.RIGHT;
    public int field_92118_B;
    public int field_92119_C;
    public boolean field_92117_D = true;
    public double field_96691_E = 1.0;
    public double field_96692_F = 1.0;
    public double field_96693_G = 0.44366195797920227;
    public double field_96694_H = 1.0;
    public double field_238332_z_ = 0.0;
    public int field_151442_I = 4;
    private final Map<SoundCategory, Float> field_186714_aM = Maps.newEnumMap(SoundCategory.class);
    public boolean field_181150_U = true;
    public AttackIndicatorStatus field_186716_M = AttackIndicatorStatus.CROSSHAIR;
    public TutorialSteps field_193631_S = TutorialSteps.MOVEMENT;
    public boolean field_244601_E = false;
    public int field_205217_U = 2;
    public double field_208033_V = 1.0;
    public boolean field_225307_E = true;
    public int field_209231_W = 1;
    public boolean field_189989_R = true;
    public boolean field_198018_T = true;
    public boolean field_74344_o = true;
    public boolean field_74359_p = true;
    public boolean field_74358_q = true;
    public boolean field_74352_v = true;
    public boolean field_181151_V = true;
    public boolean field_211842_aO;
    public boolean field_74338_d;
    public boolean field_216843_O;
    public boolean field_183509_X = true;
    public boolean field_178879_v;
    public boolean field_74355_t = true;
    public boolean field_186717_N;
    public boolean field_216844_T = true;
    public boolean field_85185_A;
    public boolean field_74353_u;
    public boolean field_74336_f = true;
    public boolean field_228044_Y_;
    public boolean field_228045_Z_;
    public boolean field_230152_Z_;
    public boolean field_244794_ae = true;
    public final KeyBinding field_74351_w = new KeyBinding("key.forward", 87, "key.categories.movement");
    public final KeyBinding field_74370_x = new KeyBinding("key.left", 65, "key.categories.movement");
    public final KeyBinding field_74368_y = new KeyBinding("key.back", 83, "key.categories.movement");
    public final KeyBinding field_74366_z = new KeyBinding("key.right", 68, "key.categories.movement");
    public final KeyBinding field_74314_A = new KeyBinding("key.jump", 32, "key.categories.movement");
    public final KeyBinding field_228046_af_ = new ToggleableKeyBinding("key.sneak", 340, "key.categories.movement", () -> this.field_228044_Y_);
    public final KeyBinding field_151444_V = new ToggleableKeyBinding("key.sprint", 341, "key.categories.movement", () -> this.field_228045_Z_);
    public final KeyBinding field_151445_Q = new KeyBinding("key.inventory", 69, "key.categories.inventory");
    public final KeyBinding field_186718_X = new KeyBinding("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyBinding field_74316_C = new KeyBinding("key.drop", 81, "key.categories.inventory");
    public final KeyBinding field_74313_G = new KeyBinding("key.use", InputMappings.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyBinding field_74312_F = new KeyBinding("key.attack", InputMappings.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyBinding field_74322_I = new KeyBinding("key.pickItem", InputMappings.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyBinding field_74310_D = new KeyBinding("key.chat", 84, "key.categories.multiplayer");
    public final KeyBinding field_74321_H = new KeyBinding("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyBinding field_74323_J = new KeyBinding("key.command", 47, "key.categories.multiplayer");
    public final KeyBinding field_244602_au = new KeyBinding("key.socialInteractions", 80, "key.categories.multiplayer");
    public final KeyBinding field_151447_Z = new KeyBinding("key.screenshot", 291, "key.categories.misc");
    public final KeyBinding field_151457_aa = new KeyBinding("key.togglePerspective", 294, "key.categories.misc");
    public final KeyBinding field_151458_ab = new KeyBinding("key.smoothCamera", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_152395_am = new KeyBinding("key.fullscreen", 300, "key.categories.misc");
    public final KeyBinding field_178883_an = new KeyBinding("key.spectatorOutlines", InputMappings.field_197958_a.func_197937_c(), "key.categories.misc");
    public final KeyBinding field_194146_ao = new KeyBinding("key.advancements", 76, "key.categories.misc");
    public final KeyBinding[] field_151456_ac = new KeyBinding[]{new KeyBinding("key.hotbar.1", 49, "key.categories.inventory"), new KeyBinding("key.hotbar.2", 50, "key.categories.inventory"), new KeyBinding("key.hotbar.3", 51, "key.categories.inventory"), new KeyBinding("key.hotbar.4", 52, "key.categories.inventory"), new KeyBinding("key.hotbar.5", 53, "key.categories.inventory"), new KeyBinding("key.hotbar.6", 54, "key.categories.inventory"), new KeyBinding("key.hotbar.7", 55, "key.categories.inventory"), new KeyBinding("key.hotbar.8", 56, "key.categories.inventory"), new KeyBinding("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyBinding field_193629_ap = new KeyBinding("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyBinding field_193630_aq = new KeyBinding("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyBinding[] field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])new KeyBinding[]{this.field_74312_F, this.field_74313_G, this.field_74351_w, this.field_74370_x, this.field_74368_y, this.field_74366_z, this.field_74314_A, this.field_228046_af_, this.field_151444_V, this.field_74316_C, this.field_151445_Q, this.field_74310_D, this.field_74321_H, this.field_74322_I, this.field_74323_J, this.field_244602_au, this.field_151447_Z, this.field_151457_aa, this.field_151458_ab, this.field_152395_am, this.field_178883_an, this.field_186718_X, this.field_193629_ap, this.field_193630_aq, this.field_194146_ao}, (Object[])this.field_151456_ac);
    protected Minecraft field_74317_L;
    private final File field_74354_ai;
    public Difficulty field_74318_M = Difficulty.NORMAL;
    public boolean field_74319_N;
    private PointOfView field_243228_bb = PointOfView.FIRST_PERSON;
    public boolean field_74330_P;
    public boolean field_74329_Q;
    public boolean field_181657_aC;
    public String field_74332_R = "";
    public boolean field_74326_T;
    public double field_74334_X = 70.0;
    public float field_243226_aM = 1.0f;
    public float field_243227_aN = 1.0f;
    public double field_74333_Y;
    public int field_74335_Z;
    public ParticleStatus field_74362_aa = ParticleStatus.ALL;
    public NarratorStatus field_192571_R = NarratorStatus.OFF;
    public String field_74363_ab = "en_us";
    public boolean field_241568_aS_;
    public int ofFogType = 1;
    public float ofFogStart = 0.8f;
    public int ofMipmapType = 0;
    public boolean ofOcclusionFancy = false;
    public boolean ofSmoothFps = false;
    public boolean ofSmoothWorld = Config.isSingleProcessor();
    public boolean ofLazyChunkLoading = Config.isSingleProcessor();
    public boolean ofRenderRegions = false;
    public boolean ofSmartAnimations = false;
    public double ofAoLevel = 1.0;
    public int ofAaLevel = 0;
    public int ofAfLevel = 1;
    public int ofClouds = 0;
    public double ofCloudsHeight = 0.0;
    public int ofTrees = 0;
    public int ofRain = 0;
    public int ofDroppedItems = 0;
    public int ofBetterGrass = 3;
    public int ofAutoSaveTicks = 4000;
    public boolean ofLagometer = false;
    public boolean ofProfiler = false;
    public boolean ofShowFps = false;
    public boolean ofWeather = true;
    public boolean ofSky = true;
    public boolean ofStars = true;
    public boolean ofSunMoon = true;
    public int ofVignette = 0;
    public int ofChunkUpdates = 1;
    public boolean ofChunkUpdatesDynamic = false;
    public int ofTime = 0;
    public boolean ofBetterSnow = false;
    public boolean ofSwampColors = true;
    public boolean ofRandomEntities = true;
    public boolean ofCustomFonts = true;
    public boolean ofCustomColors = true;
    public boolean ofCustomSky = true;
    public boolean ofShowCapes = true;
    public int ofConnectedTextures = 2;
    public boolean ofCustomItems = true;
    public boolean ofNaturalTextures = false;
    public boolean ofEmissiveTextures = true;
    public boolean ofFastMath = false;
    public boolean ofFastRender = false;
    public int ofTranslucentBlocks = 0;
    public boolean ofDynamicFov = true;
    public boolean ofAlternateBlocks = true;
    public int ofDynamicLights = 3;
    public boolean ofCustomEntityModels = true;
    public boolean ofCustomGuis = true;
    public boolean ofShowGlErrors = true;
    public int ofScreenshotSize = 1;
    public int ofChatBackground = 0;
    public boolean ofChatShadow = true;
    public int ofAnimatedWater = 0;
    public int ofAnimatedLava = 0;
    public boolean ofAnimatedFire = true;
    public boolean ofAnimatedPortal = true;
    public boolean ofAnimatedRedstone = true;
    public boolean ofAnimatedExplosion = true;
    public boolean ofAnimatedFlame = true;
    public boolean ofAnimatedSmoke = true;
    public boolean ofVoidParticles = true;
    public boolean ofWaterParticles = true;
    public boolean ofRainSplash = true;
    public boolean ofPortalParticles = true;
    public boolean ofPotionParticles = true;
    public boolean ofFireworkParticles = true;
    public boolean ofDrippingWaterLava = true;
    public boolean ofAnimatedTerrain = true;
    public boolean ofAnimatedTextures = true;
    public static final int DEFAULT = 0;
    public static final int FAST = 1;
    public static final int FANCY = 2;
    public static final int OFF = 3;
    public static final int SMART = 4;
    public static final int COMPACT = 5;
    public static final int ANIM_ON = 0;
    public static final int ANIM_GENERATED = 1;
    public static final int ANIM_OFF = 2;
    public static final String DEFAULT_STR = "Default";
    public static final double CHAT_WIDTH_SCALE = 4.0571431;
    private static final int[] OF_TREES_VALUES = new int[]{0, 1, 4, 2};
    private static final int[] OF_DYNAMIC_LIGHTS = new int[]{3, 1, 2};
    private static final String[] KEYS_DYNAMIC_LIGHTS = new String[]{"options.off", "options.graphics.fast", "options.graphics.fancy"};
    public KeyBinding ofKeyBindZoom;
    private File optionsFileOF;

    public GameSettings(Minecraft mcIn, File mcDataDir) {
        this.setForgeKeybindProperties();
        this.field_74317_L = mcIn;
        this.field_74354_ai = new File(mcDataDir, "options.txt");
        if (mcIn.func_147111_S() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            AbstractOption.field_216706_m.func_216728_a(32.0f);
            long MB = 1000000L;
            if (Runtime.getRuntime().maxMemory() >= 1500L * MB) {
                AbstractOption.field_216706_m.func_216728_a(48.0f);
            }
            if (Runtime.getRuntime().maxMemory() >= 2500L * MB) {
                AbstractOption.field_216706_m.func_216728_a(64.0f);
            }
        } else {
            AbstractOption.field_216706_m.func_216728_a(16.0f);
        }
        this.field_151451_c = mcIn.func_147111_S() ? 12 : 8;
        this.field_241568_aS_ = Util.func_110647_a() == Util.OS.WINDOWS;
        this.optionsFileOF = new File(mcDataDir, "optionsof.txt");
        this.field_74350_i = (int)AbstractOption.field_216701_h.func_216733_c();
        this.ofKeyBindZoom = new KeyBinding("of.key.zoom", 67, "key.categories.misc");
        this.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])this.field_74324_K, (Object)this.ofKeyBindZoom);
        KeyUtils.fixKeyConflicts((KeyBinding[])this.field_74324_K, (KeyBinding[])new KeyBinding[]{this.ofKeyBindZoom});
        this.field_151451_c = 8;
        this.func_74300_a();
        Config.initGameSettings((GameSettings)this);
    }

    public float func_216840_a(float opacityIn) {
        return this.field_216844_T ? opacityIn : (float)this.field_216845_l;
    }

    public int func_216841_b(float opacityIn) {
        return (int)(this.func_216840_a(opacityIn) * 255.0f) << 24 & 0xFF000000;
    }

    public int func_216839_a(int colorIn) {
        return this.field_216844_T ? colorIn : (int)(this.field_216845_l * 255.0) << 24 & 0xFF000000;
    }

    public void func_198014_a(KeyBinding keyBindingIn, InputMappings.Input inputIn) {
        keyBindingIn.func_197979_b(inputIn);
        this.func_74303_b();
    }

    public void func_74300_a() {
        try {
            if (!this.field_74354_ai.exists()) {
                return;
            }
            this.field_186714_aM.clear();
            CompoundNBT compoundnbt = new CompoundNBT();
            BufferedReader bufferedreader = Files.newReader((File)this.field_74354_ai, (Charset)Charsets.UTF_8);
            Object object = null;
            try {
                bufferedreader.lines().forEach(p_230004_1_ -> {
                    try {
                        Iterator iterator = field_230003_aR_.split((CharSequence)p_230004_1_).iterator();
                        compoundnbt.func_74778_a((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception2) {
                        field_151454_ax.warn("Skipping bad option: {}", p_230004_1_);
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bufferedreader != null) {
                    if (object != null) {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedreader.close();
                    }
                }
            }
            CompoundNBT compoundnbt1 = this.func_189988_a(compoundnbt);
            if (!compoundnbt1.func_74764_b("graphicsMode") && compoundnbt1.func_74764_b("fancyGraphics")) {
                this.field_238330_f_ = "true".equals(compoundnbt1.func_74779_i("fancyGraphics")) ? GraphicsFanciness.FANCY : GraphicsFanciness.FAST;
            }
            for (String s2 : compoundnbt1.func_150296_c()) {
                String s1 = compoundnbt1.func_74779_i(s2);
                try {
                    if ("autoJump".equals(s2)) {
                        AbstractOption.field_216719_z.func_216742_a(this, s1);
                    }
                    if ("autoSuggestions".equals(s2)) {
                        AbstractOption.field_216677_A.func_216742_a(this, s1);
                    }
                    if ("chatColors".equals(s2)) {
                        AbstractOption.field_216678_B.func_216742_a(this, s1);
                    }
                    if ("chatLinks".equals(s2)) {
                        AbstractOption.field_216679_C.func_216742_a(this, s1);
                    }
                    if ("chatLinksPrompt".equals(s2)) {
                        AbstractOption.field_216680_D.func_216742_a(this, s1);
                    }
                    if ("enableVsync".equals(s2)) {
                        AbstractOption.field_216682_F.func_216742_a(this, s1);
                        if (this.field_74352_v) {
                            this.field_74350_i = (int)AbstractOption.field_216701_h.func_216733_c();
                        }
                        this.updateVSync();
                    }
                    if ("entityShadows".equals(s2)) {
                        AbstractOption.field_216683_G.func_216742_a(this, s1);
                    }
                    if ("forceUnicodeFont".equals(s2)) {
                        AbstractOption.field_216684_H.func_216742_a(this, s1);
                    }
                    if ("discrete_mouse_scroll".equals(s2)) {
                        AbstractOption.field_216681_E.func_216742_a(this, s1);
                    }
                    if ("invertYMouse".equals(s2)) {
                        AbstractOption.field_216685_I.func_216742_a(this, s1);
                    }
                    if ("realmsNotifications".equals(s2)) {
                        AbstractOption.field_216686_J.func_216742_a(this, s1);
                    }
                    if ("reducedDebugInfo".equals(s2)) {
                        AbstractOption.field_216687_K.func_216742_a(this, s1);
                    }
                    if ("showSubtitles".equals(s2)) {
                        AbstractOption.field_216688_L.func_216742_a(this, s1);
                    }
                    if ("snooperEnabled".equals(s2)) {
                        AbstractOption.field_216689_M.func_216742_a(this, s1);
                    }
                    if ("touchscreen".equals(s2)) {
                        AbstractOption.field_216690_N.func_216742_a(this, s1);
                    }
                    if ("fullscreen".equals(s2)) {
                        AbstractOption.field_216691_O.func_216742_a(this, s1);
                    }
                    if ("bobView".equals(s2)) {
                        AbstractOption.field_216692_P.func_216742_a(this, s1);
                    }
                    if ("toggleCrouch".equals(s2)) {
                        this.field_228044_Y_ = "true".equals(s1);
                    }
                    if ("toggleSprint".equals(s2)) {
                        this.field_228045_Z_ = "true".equals(s1);
                    }
                    if ("mouseSensitivity".equals(s2)) {
                        this.field_74341_c = GameSettings.func_74305_a((String)s1);
                    }
                    if ("fov".equals(s2)) {
                        this.field_74334_X = GameSettings.func_74305_a((String)s1) * 40.0f + 70.0f;
                    }
                    if ("screenEffectScale".equals(s2)) {
                        this.field_243226_aM = GameSettings.func_74305_a((String)s1);
                    }
                    if ("fovEffectScale".equals(s2)) {
                        this.field_243227_aN = GameSettings.func_74305_a((String)s1);
                    }
                    if ("gamma".equals(s2)) {
                        this.field_74333_Y = GameSettings.func_74305_a((String)s1);
                    }
                    if ("renderDistance".equals(s2)) {
                        this.field_151451_c = Integer.parseInt(s1);
                    }
                    if ("entityDistanceScaling".equals(s2)) {
                        this.field_238329_c_ = Float.parseFloat(s1);
                    }
                    if ("guiScale".equals(s2)) {
                        this.field_74335_Z = Integer.parseInt(s1);
                    }
                    if ("particles".equals(s2)) {
                        this.field_74362_aa = ParticleStatus.func_216833_a((int)Integer.parseInt(s1));
                    }
                    if ("maxFps".equals(s2)) {
                        this.field_74350_i = Integer.parseInt(s1);
                        if (this.field_74352_v) {
                            this.field_74350_i = (int)AbstractOption.field_216701_h.func_216733_c();
                        }
                        if (this.field_74350_i <= 0) {
                            this.field_74350_i = (int)AbstractOption.field_216701_h.func_216733_c();
                        }
                        if (this.field_74317_L.func_228018_at_() != null) {
                            this.field_74317_L.func_228018_at_().func_216526_a(this.field_74350_i);
                        }
                    }
                    if ("difficulty".equals(s2)) {
                        this.field_74318_M = Difficulty.func_151523_a((int)Integer.parseInt(s1));
                    }
                    if ("graphicsMode".equals(s2)) {
                        this.field_238330_f_ = GraphicsFanciness.func_238163_a_((int)Integer.parseInt(s1));
                        this.updateRenderClouds();
                    }
                    if ("tutorialStep".equals(s2)) {
                        this.field_193631_S = TutorialSteps.func_193307_a((String)s1);
                    }
                    if ("ao".equals(s2)) {
                        this.field_74348_k = "true".equals(s1) ? AmbientOcclusionStatus.MAX : ("false".equals(s1) ? AmbientOcclusionStatus.OFF : AmbientOcclusionStatus.func_216570_a((int)Integer.parseInt(s1)));
                    }
                    if ("renderClouds".equals(s2)) {
                        if ("true".equals(s1)) {
                            this.field_74345_l = CloudOption.FANCY;
                        } else if ("false".equals(s1)) {
                            this.field_74345_l = CloudOption.OFF;
                        } else if ("fast".equals(s1)) {
                            this.field_74345_l = CloudOption.FAST;
                        }
                    }
                    if ("attackIndicator".equals(s2)) {
                        this.field_186716_M = AttackIndicatorStatus.func_216749_a((int)Integer.parseInt(s1));
                    }
                    if ("resourcePacks".equals(s2)) {
                        this.field_151453_l = (List)JSONUtils.func_233012_a_((Gson)field_151450_ay, (String)s1, (TypeToken)field_151449_az);
                        if (this.field_151453_l == null) {
                            this.field_151453_l = Lists.newArrayList();
                        }
                    }
                    if ("incompatibleResourcePacks".equals(s2)) {
                        this.field_183018_l = (List)JSONUtils.func_233012_a_((Gson)field_151450_ay, (String)s1, (TypeToken)field_151449_az);
                        if (this.field_183018_l == null) {
                            this.field_183018_l = Lists.newArrayList();
                        }
                    }
                    if ("lastServer".equals(s2)) {
                        this.field_74332_R = s1;
                    }
                    if ("lang".equals(s2)) {
                        this.field_74363_ab = s1;
                    }
                    if ("chatVisibility".equals(s2)) {
                        this.field_74343_n = ChatVisibility.func_221252_a((int)Integer.parseInt(s1));
                    }
                    if ("chatOpacity".equals(s2)) {
                        this.field_74357_r = GameSettings.func_74305_a((String)s1);
                    }
                    if ("chatLineSpacing".equals(s2)) {
                        this.field_238331_l_ = GameSettings.func_74305_a((String)s1);
                    }
                    if ("textBackgroundOpacity".equals(s2)) {
                        this.field_216845_l = GameSettings.func_74305_a((String)s1);
                    }
                    if ("backgroundForChatOnly".equals(s2)) {
                        this.field_216844_T = "true".equals(s1);
                    }
                    if ("fullscreenResolution".equals(s2)) {
                        this.field_198019_u = s1;
                    }
                    if ("hideServerAddress".equals(s2)) {
                        this.field_80005_w = "true".equals(s1);
                    }
                    if ("advancedItemTooltips".equals(s2)) {
                        this.field_82882_x = "true".equals(s1);
                    }
                    if ("pauseOnLostFocus".equals(s2)) {
                        this.field_82881_y = "true".equals(s1);
                    }
                    if ("overrideHeight".equals(s2)) {
                        this.field_92119_C = Integer.parseInt(s1);
                    }
                    if ("overrideWidth".equals(s2)) {
                        this.field_92118_B = Integer.parseInt(s1);
                    }
                    if ("heldItemTooltips".equals(s2)) {
                        this.field_92117_D = "true".equals(s1);
                    }
                    if ("chatHeightFocused".equals(s2)) {
                        this.field_96694_H = GameSettings.func_74305_a((String)s1);
                    }
                    if ("chatDelay".equals(s2)) {
                        this.field_238332_z_ = GameSettings.func_74305_a((String)s1);
                    }
                    if ("chatHeightUnfocused".equals(s2)) {
                        this.field_96693_G = GameSettings.func_74305_a((String)s1);
                    }
                    if ("chatScale".equals(s2)) {
                        this.field_96691_E = GameSettings.func_74305_a((String)s1);
                    }
                    if ("chatWidth".equals(s2)) {
                        this.field_96692_F = GameSettings.func_74305_a((String)s1);
                    }
                    if ("mipmapLevels".equals(s2)) {
                        this.field_151442_I = Integer.parseInt(s1);
                    }
                    if ("useNativeTransport".equals(s2)) {
                        this.field_181150_U = "true".equals(s1);
                    }
                    if ("mainHand".equals(s2)) {
                        HandSide handSide = this.field_186715_A = "left".equals(s1) ? HandSide.LEFT : HandSide.RIGHT;
                    }
                    if ("narrator".equals(s2)) {
                        this.field_192571_R = NarratorStatus.func_216825_a((int)Integer.parseInt(s1));
                    }
                    if ("biomeBlendRadius".equals(s2)) {
                        this.field_205217_U = Integer.parseInt(s1);
                    }
                    if ("mouseWheelSensitivity".equals(s2)) {
                        this.field_208033_V = GameSettings.func_74305_a((String)s1);
                    }
                    if ("rawMouseInput".equals(s2)) {
                        this.field_225307_E = "true".equals(s1);
                    }
                    if ("glDebugVerbosity".equals(s2)) {
                        this.field_209231_W = Integer.parseInt(s1);
                    }
                    if ("skipMultiplayerWarning".equals(s2)) {
                        this.field_230152_Z_ = "true".equals(s1);
                    }
                    if ("hideMatchedNames".equals(s2)) {
                        this.field_244794_ae = "true".equals(s1);
                    }
                    if ("joinedFirstServer".equals(s2)) {
                        this.field_244601_E = "true".equals(s1);
                    }
                    if ("syncChunkWrites".equals(s2)) {
                        this.field_241568_aS_ = "true".equals(s1);
                    }
                    for (KeyBinding keyBinding : this.field_74324_K) {
                        if (!s2.equals("key_" + keyBinding.func_151464_g())) continue;
                        if (Reflector.KeyModifier_valueFromString.exists()) {
                            if (s1.indexOf(58) != -1) {
                                String[] pts = s1.split(":");
                                Object keyModifier = Reflector.call(Reflector.KeyModifier_valueFromString, pts[1]);
                                Reflector.call(keyBinding, Reflector.ForgeKeyBinding_setKeyModifierAndCode, keyModifier, InputMappings.func_197955_a((String)pts[0]));
                                continue;
                            }
                            Object keyModifierNone = Reflector.getFieldValue(Reflector.KeyModifier_NONE);
                            Reflector.call(keyBinding, Reflector.ForgeKeyBinding_setKeyModifierAndCode, keyModifierNone, InputMappings.func_197955_a((String)s1));
                            continue;
                        }
                        keyBinding.func_197979_b(InputMappings.func_197955_a((String)s1));
                    }
                    for (KeyBinding keyBinding : SoundCategory.values()) {
                        if (!s2.equals("soundCategory_" + keyBinding.func_187948_a())) continue;
                        this.field_186714_aM.put(keyBinding, Float.valueOf(GameSettings.func_74305_a((String)s1)));
                    }
                    for (KeyBinding keyBinding : PlayerModelPart.values()) {
                        if (!s2.equals("modelPart_" + keyBinding.func_179329_c())) continue;
                        this.func_178878_a((PlayerModelPart)keyBinding, "true".equals(s1));
                    }
                }
                catch (Exception exception) {
                    field_151454_ax.warn("Skipping bad option: {}:{}", (Object)s2, (Object)s1);
                    exception.printStackTrace();
                }
            }
            KeyBinding.func_74508_b();
        }
        catch (Exception exception1) {
            field_151454_ax.error("Failed to load options", (Throwable)exception1);
        }
        this.loadOfOptions();
    }

    private CompoundNBT func_189988_a(CompoundNBT nbt) {
        int i2 = 0;
        try {
            i2 = Integer.parseInt(nbt.func_74779_i("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NBTUtil.func_210822_a((DataFixer)this.field_74317_L.func_184126_aj(), (DefaultTypeReferences)DefaultTypeReferences.OPTIONS, (CompoundNBT)nbt, (int)i2);
    }

    private static float func_74305_a(String stringIn) {
        if ("true".equals(stringIn)) {
            return 1.0f;
        }
        return "false".equals(stringIn) ? 0.0f : Float.parseFloat(stringIn);
    }

    public void func_74303_b() {
        if (Reflector.ClientModLoader_isLoading.exists() && Reflector.callBoolean(Reflector.ClientModLoader_isLoading, new Object[0])) {
            return;
        }
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.field_74354_ai), StandardCharsets.UTF_8));){
            printwriter.println("version:" + SharedConstants.func_215069_a().getWorldVersion());
            printwriter.println("autoJump:" + AbstractOption.field_216719_z.func_216741_b(this));
            printwriter.println("autoSuggestions:" + AbstractOption.field_216677_A.func_216741_b(this));
            printwriter.println("chatColors:" + AbstractOption.field_216678_B.func_216741_b(this));
            printwriter.println("chatLinks:" + AbstractOption.field_216679_C.func_216741_b(this));
            printwriter.println("chatLinksPrompt:" + AbstractOption.field_216680_D.func_216741_b(this));
            printwriter.println("enableVsync:" + AbstractOption.field_216682_F.func_216741_b(this));
            printwriter.println("entityShadows:" + AbstractOption.field_216683_G.func_216741_b(this));
            printwriter.println("forceUnicodeFont:" + AbstractOption.field_216684_H.func_216741_b(this));
            printwriter.println("discrete_mouse_scroll:" + AbstractOption.field_216681_E.func_216741_b(this));
            printwriter.println("invertYMouse:" + AbstractOption.field_216685_I.func_216741_b(this));
            printwriter.println("realmsNotifications:" + AbstractOption.field_216686_J.func_216741_b(this));
            printwriter.println("reducedDebugInfo:" + AbstractOption.field_216687_K.func_216741_b(this));
            printwriter.println("snooperEnabled:" + AbstractOption.field_216689_M.func_216741_b(this));
            printwriter.println("showSubtitles:" + AbstractOption.field_216688_L.func_216741_b(this));
            printwriter.println("touchscreen:" + AbstractOption.field_216690_N.func_216741_b(this));
            printwriter.println("fullscreen:" + AbstractOption.field_216691_O.func_216741_b(this));
            printwriter.println("bobView:" + AbstractOption.field_216692_P.func_216741_b(this));
            printwriter.println("toggleCrouch:" + this.field_228044_Y_);
            printwriter.println("toggleSprint:" + this.field_228045_Z_);
            printwriter.println("mouseSensitivity:" + this.field_74341_c);
            printwriter.println("fov:" + (this.field_74334_X - 70.0) / 40.0);
            printwriter.println("screenEffectScale:" + this.field_243226_aM);
            printwriter.println("fovEffectScale:" + this.field_243227_aN);
            printwriter.println("gamma:" + this.field_74333_Y);
            printwriter.println("renderDistance:" + this.field_151451_c);
            printwriter.println("entityDistanceScaling:" + this.field_238329_c_);
            printwriter.println("guiScale:" + this.field_74335_Z);
            printwriter.println("particles:" + this.field_74362_aa.func_216832_b());
            printwriter.println("maxFps:" + this.field_74350_i);
            printwriter.println("difficulty:" + this.field_74318_M.func_151525_a());
            printwriter.println("graphicsMode:" + this.field_238330_f_.func_238162_a_());
            printwriter.println("ao:" + this.field_74348_k.func_216572_a());
            printwriter.println("biomeBlendRadius:" + this.field_205217_U);
            switch (2.$SwitchMap$net$minecraft$client$settings$CloudOption[this.field_74345_l.ordinal()]) {
                case 1: {
                    printwriter.println("renderClouds:true");
                    break;
                }
                case 2: {
                    printwriter.println("renderClouds:fast");
                    break;
                }
                case 3: {
                    printwriter.println("renderClouds:false");
                }
            }
            printwriter.println("resourcePacks:" + field_151450_ay.toJson((Object)this.field_151453_l));
            printwriter.println("incompatibleResourcePacks:" + field_151450_ay.toJson((Object)this.field_183018_l));
            printwriter.println("lastServer:" + this.field_74332_R);
            printwriter.println("lang:" + this.field_74363_ab);
            printwriter.println("chatVisibility:" + this.field_74343_n.func_221254_a());
            printwriter.println("chatOpacity:" + this.field_74357_r);
            printwriter.println("chatLineSpacing:" + this.field_238331_l_);
            printwriter.println("textBackgroundOpacity:" + this.field_216845_l);
            printwriter.println("backgroundForChatOnly:" + this.field_216844_T);
            if (this.field_74317_L.func_228018_at_().func_198106_d().isPresent()) {
                printwriter.println("fullscreenResolution:" + ((VideoMode)this.field_74317_L.func_228018_at_().func_198106_d().get()).func_198066_g());
            }
            printwriter.println("hideServerAddress:" + this.field_80005_w);
            printwriter.println("advancedItemTooltips:" + this.field_82882_x);
            printwriter.println("pauseOnLostFocus:" + this.field_82881_y);
            printwriter.println("overrideWidth:" + this.field_92118_B);
            printwriter.println("overrideHeight:" + this.field_92119_C);
            printwriter.println("heldItemTooltips:" + this.field_92117_D);
            printwriter.println("chatHeightFocused:" + this.field_96694_H);
            printwriter.println("chatDelay: " + this.field_238332_z_);
            printwriter.println("chatHeightUnfocused:" + this.field_96693_G);
            printwriter.println("chatScale:" + this.field_96691_E);
            printwriter.println("chatWidth:" + (float)this.field_96692_F);
            printwriter.println("mipmapLevels:" + this.field_151442_I);
            printwriter.println("useNativeTransport:" + this.field_181150_U);
            printwriter.println("mainHand:" + (this.field_186715_A == HandSide.LEFT ? "left" : "right"));
            printwriter.println("attackIndicator:" + this.field_186716_M.func_216751_a());
            printwriter.println("narrator:" + this.field_192571_R.func_216827_a());
            printwriter.println("tutorialStep:" + this.field_193631_S.func_193308_a());
            printwriter.println("mouseWheelSensitivity:" + this.field_208033_V);
            printwriter.println("rawMouseInput:" + AbstractOption.field_225302_l.func_216741_b(this));
            printwriter.println("glDebugVerbosity:" + this.field_209231_W);
            printwriter.println("skipMultiplayerWarning:" + this.field_230152_Z_);
            printwriter.println("hideMatchedNames:" + this.field_244794_ae);
            printwriter.println("joinedFirstServer:" + this.field_244601_E);
            printwriter.println("syncChunkWrites:" + this.field_241568_aS_);
            for (KeyBinding keyBinding : this.field_74324_K) {
                if (Reflector.ForgeKeyBinding_getKeyModifier.exists()) {
                    Object keyModifierNone;
                    String keyString = "key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m();
                    Object keyModifier = Reflector.call(keyBinding, Reflector.ForgeKeyBinding_getKeyModifier, new Object[0]);
                    printwriter.println(keyModifier != (keyModifierNone = Reflector.getFieldValue(Reflector.KeyModifier_NONE)) ? keyString + ":" + keyModifier : keyString);
                    continue;
                }
                printwriter.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_197982_m());
            }
            for (KeyBinding keyBinding : SoundCategory.values()) {
                printwriter.println("soundCategory_" + keyBinding.func_187948_a() + ":" + this.func_186711_a((SoundCategory)keyBinding));
            }
            for (KeyBinding keyBinding : PlayerModelPart.values()) {
                printwriter.println("modelPart_" + keyBinding.func_179329_c() + ":" + this.field_178882_aU.contains(keyBinding));
            }
        }
        catch (Exception exception) {
            field_151454_ax.error("Failed to save options", (Throwable)exception);
        }
        this.saveOfOptions();
        this.func_82879_c();
    }

    public float func_186711_a(SoundCategory category) {
        return this.field_186714_aM.containsKey(category) ? ((Float)this.field_186714_aM.get(category)).floatValue() : 1.0f;
    }

    public void func_186712_a(SoundCategory category, float volume) {
        this.field_186714_aM.put(category, Float.valueOf(volume));
        this.field_74317_L.func_147118_V().func_184399_a(category, volume);
    }

    public void func_82879_c() {
        if (this.field_74317_L.field_71439_g != null) {
            int i2 = 0;
            for (PlayerModelPart playermodelpart : this.field_178882_aU) {
                i2 |= playermodelpart.func_179327_a();
            }
            this.field_74317_L.field_71439_g.field_71174_a.func_147297_a((IPacket)new CClientSettingsPacket(this.field_74363_ab, this.field_151451_c, this.field_74343_n, this.field_74344_o, i2, this.field_186715_A));
        }
    }

    public Set<PlayerModelPart> func_178876_d() {
        return ImmutableSet.copyOf((Collection)this.field_178882_aU);
    }

    public void func_178878_a(PlayerModelPart modelPart, boolean enable) {
        if (enable) {
            this.field_178882_aU.add(modelPart);
        } else {
            this.field_178882_aU.remove(modelPart);
        }
        this.func_82879_c();
    }

    public void func_178877_a(PlayerModelPart modelPart) {
        if (this.func_178876_d().contains(modelPart)) {
            this.field_178882_aU.remove(modelPart);
        } else {
            this.field_178882_aU.add(modelPart);
        }
        this.func_82879_c();
    }

    public CloudOption func_216842_e() {
        return this.field_151451_c >= 4 ? this.field_74345_l : CloudOption.OFF;
    }

    public boolean func_181148_f() {
        return this.field_181150_U;
    }

    public void setOptionFloatValueOF(AbstractOption option, double val) {
        int valInt;
        if (option == AbstractOption.CLOUD_HEIGHT) {
            this.ofCloudsHeight = val;
        }
        if (option == AbstractOption.AO_LEVEL) {
            this.ofAoLevel = val;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (option == AbstractOption.AA_LEVEL) {
            valInt = (int)val;
            if (valInt > 0 && Config.isShaders()) {
                Config.showGuiMessage(Lang.get("of.message.aa.shaders1"), Lang.get("of.message.aa.shaders2"));
                return;
            }
            if (valInt > 0 && Config.isGraphicsFabulous()) {
                Config.showGuiMessage(Lang.get("of.message.aa.gf1"), Lang.get("of.message.aa.gf2"));
                return;
            }
            this.ofAaLevel = valInt;
            this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
        }
        if (option == AbstractOption.AF_LEVEL) {
            this.ofAfLevel = valInt = (int)val;
            this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
            this.field_74317_L.func_213245_w();
            Shaders.uninit();
        }
        if (option == AbstractOption.MIPMAP_TYPE) {
            valInt = (int)val;
            this.ofMipmapType = Config.limit(valInt, 0, 3);
            this.updateMipmaps();
        }
    }

    public double getOptionFloatValueOF(AbstractOption settingOption) {
        if (settingOption == AbstractOption.CLOUD_HEIGHT) {
            return this.ofCloudsHeight;
        }
        if (settingOption == AbstractOption.AO_LEVEL) {
            return this.ofAoLevel;
        }
        if (settingOption == AbstractOption.AA_LEVEL) {
            return this.ofAaLevel;
        }
        if (settingOption == AbstractOption.AF_LEVEL) {
            return this.ofAfLevel;
        }
        if (settingOption == AbstractOption.MIPMAP_TYPE) {
            return this.ofMipmapType;
        }
        if (settingOption == AbstractOption.field_216701_h) {
            if ((double)this.field_74350_i == AbstractOption.field_216701_h.func_216733_c() && this.field_74352_v) {
                return 0.0;
            }
            return this.field_74350_i;
        }
        return 3.4028234663852886E38;
    }

    public void setOptionValueOF(AbstractOption par1EnumOptions, int par2) {
        if (par1EnumOptions == AbstractOption.FOG_FANCY) {
            switch (this.ofFogType) {
                case 1: {
                    this.ofFogType = 2;
                    if (Config.isFancyFogAvailable()) break;
                    this.ofFogType = 3;
                    break;
                }
                case 2: {
                    this.ofFogType = 3;
                    break;
                }
                case 3: {
                    this.ofFogType = 1;
                    break;
                }
                default: {
                    this.ofFogType = 1;
                }
            }
        }
        if (par1EnumOptions == AbstractOption.FOG_START) {
            this.ofFogStart += 0.2f;
            if (this.ofFogStart > 0.81f) {
                this.ofFogStart = 0.2f;
            }
        }
        if (par1EnumOptions == AbstractOption.SMOOTH_FPS) {
            boolean bl = this.ofSmoothFps = !this.ofSmoothFps;
        }
        if (par1EnumOptions == AbstractOption.SMOOTH_WORLD) {
            this.ofSmoothWorld = !this.ofSmoothWorld;
            Config.updateThreadPriorities();
        }
        if (par1EnumOptions == AbstractOption.CLOUDS) {
            ++this.ofClouds;
            if (this.ofClouds > 3) {
                this.ofClouds = 0;
            }
            this.updateRenderClouds();
        }
        if (par1EnumOptions == AbstractOption.TREES) {
            this.ofTrees = GameSettings.nextValue((int)this.ofTrees, (int[])OF_TREES_VALUES);
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.DROPPED_ITEMS) {
            ++this.ofDroppedItems;
            if (this.ofDroppedItems > 2) {
                this.ofDroppedItems = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.RAIN) {
            ++this.ofRain;
            if (this.ofRain > 3) {
                this.ofRain = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_WATER) {
            ++this.ofAnimatedWater;
            if (this.ofAnimatedWater == 1) {
                ++this.ofAnimatedWater;
            }
            if (this.ofAnimatedWater > 2) {
                this.ofAnimatedWater = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_LAVA) {
            ++this.ofAnimatedLava;
            if (this.ofAnimatedLava == 1) {
                ++this.ofAnimatedLava;
            }
            if (this.ofAnimatedLava > 2) {
                this.ofAnimatedLava = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_FIRE) {
            boolean bl = this.ofAnimatedFire = !this.ofAnimatedFire;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_PORTAL) {
            boolean bl = this.ofAnimatedPortal = !this.ofAnimatedPortal;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_REDSTONE) {
            boolean bl = this.ofAnimatedRedstone = !this.ofAnimatedRedstone;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_EXPLOSION) {
            boolean bl = this.ofAnimatedExplosion = !this.ofAnimatedExplosion;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_FLAME) {
            boolean bl = this.ofAnimatedFlame = !this.ofAnimatedFlame;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_SMOKE) {
            boolean bl = this.ofAnimatedSmoke = !this.ofAnimatedSmoke;
        }
        if (par1EnumOptions == AbstractOption.VOID_PARTICLES) {
            boolean bl = this.ofVoidParticles = !this.ofVoidParticles;
        }
        if (par1EnumOptions == AbstractOption.WATER_PARTICLES) {
            boolean bl = this.ofWaterParticles = !this.ofWaterParticles;
        }
        if (par1EnumOptions == AbstractOption.PORTAL_PARTICLES) {
            boolean bl = this.ofPortalParticles = !this.ofPortalParticles;
        }
        if (par1EnumOptions == AbstractOption.POTION_PARTICLES) {
            boolean bl = this.ofPotionParticles = !this.ofPotionParticles;
        }
        if (par1EnumOptions == AbstractOption.FIREWORK_PARTICLES) {
            boolean bl = this.ofFireworkParticles = !this.ofFireworkParticles;
        }
        if (par1EnumOptions == AbstractOption.DRIPPING_WATER_LAVA) {
            boolean bl = this.ofDrippingWaterLava = !this.ofDrippingWaterLava;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_TERRAIN) {
            boolean bl = this.ofAnimatedTerrain = !this.ofAnimatedTerrain;
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_TEXTURES) {
            boolean bl = this.ofAnimatedTextures = !this.ofAnimatedTextures;
        }
        if (par1EnumOptions == AbstractOption.RAIN_SPLASH) {
            boolean bl = this.ofRainSplash = !this.ofRainSplash;
        }
        if (par1EnumOptions == AbstractOption.LAGOMETER) {
            boolean bl = this.ofLagometer = !this.ofLagometer;
        }
        if (par1EnumOptions == AbstractOption.SHOW_FPS) {
            boolean bl = this.ofShowFps = !this.ofShowFps;
        }
        if (par1EnumOptions == AbstractOption.AUTOSAVE_TICKS) {
            int step = 900;
            this.ofAutoSaveTicks = Math.max(this.ofAutoSaveTicks / step * step, step);
            this.ofAutoSaveTicks *= 2;
            if (this.ofAutoSaveTicks > 32 * step) {
                this.ofAutoSaveTicks = step;
            }
        }
        if (par1EnumOptions == AbstractOption.BETTER_GRASS) {
            ++this.ofBetterGrass;
            if (this.ofBetterGrass > 3) {
                this.ofBetterGrass = 1;
            }
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.CONNECTED_TEXTURES) {
            ++this.ofConnectedTextures;
            if (this.ofConnectedTextures > 3) {
                this.ofConnectedTextures = 1;
            }
            if (this.ofConnectedTextures == 2) {
                this.field_74317_L.field_71438_f.func_72712_a();
            } else {
                this.field_74317_L.func_213245_w();
            }
        }
        if (par1EnumOptions == AbstractOption.WEATHER) {
            boolean bl = this.ofWeather = !this.ofWeather;
        }
        if (par1EnumOptions == AbstractOption.SKY) {
            boolean bl = this.ofSky = !this.ofSky;
        }
        if (par1EnumOptions == AbstractOption.STARS) {
            boolean bl = this.ofStars = !this.ofStars;
        }
        if (par1EnumOptions == AbstractOption.SUN_MOON) {
            boolean bl = this.ofSunMoon = !this.ofSunMoon;
        }
        if (par1EnumOptions == AbstractOption.VIGNETTE) {
            ++this.ofVignette;
            if (this.ofVignette > 2) {
                this.ofVignette = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.CHUNK_UPDATES) {
            ++this.ofChunkUpdates;
            if (this.ofChunkUpdates > 5) {
                this.ofChunkUpdates = 1;
            }
        }
        if (par1EnumOptions == AbstractOption.CHUNK_UPDATES_DYNAMIC) {
            boolean bl = this.ofChunkUpdatesDynamic = !this.ofChunkUpdatesDynamic;
        }
        if (par1EnumOptions == AbstractOption.TIME) {
            ++this.ofTime;
            if (this.ofTime > 2) {
                this.ofTime = 0;
            }
        }
        if (par1EnumOptions == AbstractOption.PROFILER) {
            boolean bl = this.ofProfiler = !this.ofProfiler;
        }
        if (par1EnumOptions == AbstractOption.BETTER_SNOW) {
            this.ofBetterSnow = !this.ofBetterSnow;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.SWAMP_COLORS) {
            this.ofSwampColors = !this.ofSwampColors;
            CustomColors.updateUseDefaultGrassFoliageColors();
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.RANDOM_ENTITIES) {
            this.ofRandomEntities = !this.ofRandomEntities;
            RandomEntities.update();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_FONTS) {
            this.ofCustomFonts = !this.ofCustomFonts;
            FontUtils.reloadFonts();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_COLORS) {
            this.ofCustomColors = !this.ofCustomColors;
            CustomColors.update();
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_ITEMS) {
            this.ofCustomItems = !this.ofCustomItems;
            this.field_74317_L.func_213245_w();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_SKY) {
            this.ofCustomSky = !this.ofCustomSky;
            CustomSky.update();
        }
        if (par1EnumOptions == AbstractOption.SHOW_CAPES) {
            boolean bl = this.ofShowCapes = !this.ofShowCapes;
        }
        if (par1EnumOptions == AbstractOption.NATURAL_TEXTURES) {
            this.ofNaturalTextures = !this.ofNaturalTextures;
            NaturalTextures.update();
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.EMISSIVE_TEXTURES) {
            this.ofEmissiveTextures = !this.ofEmissiveTextures;
            this.field_74317_L.func_213245_w();
        }
        if (par1EnumOptions == AbstractOption.FAST_MATH) {
            MathHelper.fastMath = this.ofFastMath = !this.ofFastMath;
        }
        if (par1EnumOptions == AbstractOption.FAST_RENDER) {
            boolean bl = this.ofFastRender = !this.ofFastRender;
        }
        if (par1EnumOptions == AbstractOption.TRANSLUCENT_BLOCKS) {
            this.ofTranslucentBlocks = this.ofTranslucentBlocks == 0 ? 1 : (this.ofTranslucentBlocks == 1 ? 2 : (this.ofTranslucentBlocks == 2 ? 0 : 0));
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.LAZY_CHUNK_LOADING) {
            boolean bl = this.ofLazyChunkLoading = !this.ofLazyChunkLoading;
        }
        if (par1EnumOptions == AbstractOption.RENDER_REGIONS) {
            this.ofRenderRegions = !this.ofRenderRegions;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.SMART_ANIMATIONS) {
            this.ofSmartAnimations = !this.ofSmartAnimations;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.DYNAMIC_FOV) {
            boolean bl = this.ofDynamicFov = !this.ofDynamicFov;
        }
        if (par1EnumOptions == AbstractOption.ALTERNATE_BLOCKS) {
            this.ofAlternateBlocks = !this.ofAlternateBlocks;
            this.field_74317_L.field_71438_f.func_72712_a();
        }
        if (par1EnumOptions == AbstractOption.DYNAMIC_LIGHTS) {
            this.ofDynamicLights = GameSettings.nextValue((int)this.ofDynamicLights, (int[])OF_DYNAMIC_LIGHTS);
            DynamicLights.removeLights((WorldRenderer)this.field_74317_L.field_71438_f);
        }
        if (par1EnumOptions == AbstractOption.SCREENSHOT_SIZE) {
            ++this.ofScreenshotSize;
            if (this.ofScreenshotSize > 4) {
                this.ofScreenshotSize = 1;
            }
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_ENTITY_MODELS) {
            this.ofCustomEntityModels = !this.ofCustomEntityModels;
            this.field_74317_L.func_213245_w();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_GUIS) {
            this.ofCustomGuis = !this.ofCustomGuis;
            CustomGuis.update();
        }
        if (par1EnumOptions == AbstractOption.SHOW_GL_ERRORS) {
            boolean bl = this.ofShowGlErrors = !this.ofShowGlErrors;
        }
        if (par1EnumOptions == AbstractOption.HELD_ITEM_TOOLTIPS) {
            boolean bl = this.field_92117_D = !this.field_92117_D;
        }
        if (par1EnumOptions == AbstractOption.ADVANCED_TOOLTIPS) {
            boolean bl = this.field_82882_x = !this.field_82882_x;
        }
        if (par1EnumOptions == AbstractOption.CHAT_BACKGROUND) {
            this.ofChatBackground = this.ofChatBackground == 0 ? 5 : (this.ofChatBackground == 5 ? 3 : 0);
        }
        if (par1EnumOptions == AbstractOption.CHAT_SHADOW) {
            this.ofChatShadow = !this.ofChatShadow;
        }
    }

    public ITextComponent getKeyComponentOF(AbstractOption option) {
        String str = this.getKeyBindingOF(option);
        StringTextComponent comp = new StringTextComponent(str);
        return comp;
    }

    public String getKeyBindingOF(AbstractOption par1EnumOptions) {
        String var2 = I18n.func_135052_a((String)par1EnumOptions.getResourceKey(), (Object[])new Object[0]) + ": ";
        if (var2 == null) {
            var2 = par1EnumOptions.getResourceKey();
        }
        String s2 = var2;
        if (par1EnumOptions == AbstractOption.field_216706_m) {
            int distChunks = (int)AbstractOption.field_216706_m.func_216729_a(this);
            String str = I18n.func_135052_a((String)"of.options.renderDistance.tiny", (Object[])new Object[0]);
            int baseDist = 2;
            if (distChunks >= 4) {
                str = I18n.func_135052_a((String)"of.options.renderDistance.short", (Object[])new Object[0]);
                baseDist = 4;
            }
            if (distChunks >= 8) {
                str = I18n.func_135052_a((String)"of.options.renderDistance.normal", (Object[])new Object[0]);
                baseDist = 8;
            }
            if (distChunks >= 16) {
                str = I18n.func_135052_a((String)"of.options.renderDistance.far", (Object[])new Object[0]);
                baseDist = 16;
            }
            if (distChunks >= 32) {
                str = Lang.get("of.options.renderDistance.extreme");
                baseDist = 32;
            }
            if (distChunks >= 48) {
                str = Lang.get("of.options.renderDistance.insane");
                baseDist = 48;
            }
            if (distChunks >= 64) {
                str = Lang.get("of.options.renderDistance.ludicrous");
                baseDist = 64;
            }
            int diff = this.field_151451_c - baseDist;
            String descr = str;
            if (diff > 0) {
                descr = descr + "+";
            }
            return var2 + distChunks + " " + descr + "";
        }
        if (par1EnumOptions == AbstractOption.FOG_FANCY) {
            switch (this.ofFogType) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
                case 3: {
                    return s2 + Lang.getOff();
                }
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.FOG_START) {
            return s2 + this.ofFogStart;
        }
        if (par1EnumOptions == AbstractOption.MIPMAP_TYPE) {
            return FloatOptions.getText((AbstractOption)par1EnumOptions, (double)this.ofMipmapType);
        }
        if (par1EnumOptions == AbstractOption.SMOOTH_FPS) {
            if (this.ofSmoothFps) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SMOOTH_WORLD) {
            if (this.ofSmoothWorld) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CLOUDS) {
            switch (this.ofClouds) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
                case 3: {
                    return s2 + Lang.getOff();
                }
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.TREES) {
            switch (this.ofTrees) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
                case 4: {
                    return s2 + Lang.get("of.general.smart");
                }
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.DROPPED_ITEMS) {
            switch (this.ofDroppedItems) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.RAIN) {
            switch (this.ofRain) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
                case 3: {
                    return s2 + Lang.getOff();
                }
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_WATER) {
            switch (this.ofAnimatedWater) {
                case 1: {
                    return s2 + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return s2 + Lang.getOff();
                }
            }
            return s2 + Lang.getOn();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_LAVA) {
            switch (this.ofAnimatedLava) {
                case 1: {
                    return s2 + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return s2 + Lang.getOff();
                }
            }
            return s2 + Lang.getOn();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_FIRE) {
            if (this.ofAnimatedFire) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_PORTAL) {
            if (this.ofAnimatedPortal) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_REDSTONE) {
            if (this.ofAnimatedRedstone) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_EXPLOSION) {
            if (this.ofAnimatedExplosion) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_FLAME) {
            if (this.ofAnimatedFlame) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_SMOKE) {
            if (this.ofAnimatedSmoke) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.VOID_PARTICLES) {
            if (this.ofVoidParticles) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.WATER_PARTICLES) {
            if (this.ofWaterParticles) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.PORTAL_PARTICLES) {
            if (this.ofPortalParticles) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.POTION_PARTICLES) {
            if (this.ofPotionParticles) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.FIREWORK_PARTICLES) {
            if (this.ofFireworkParticles) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.DRIPPING_WATER_LAVA) {
            if (this.ofDrippingWaterLava) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_TERRAIN) {
            if (this.ofAnimatedTerrain) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ANIMATED_TEXTURES) {
            if (this.ofAnimatedTextures) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.RAIN_SPLASH) {
            if (this.ofRainSplash) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.LAGOMETER) {
            if (this.ofLagometer) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SHOW_FPS) {
            if (this.ofShowFps) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.AUTOSAVE_TICKS) {
            int step = 900;
            if (this.ofAutoSaveTicks <= step) {
                return s2 + Lang.get("of.options.save.45s");
            }
            if (this.ofAutoSaveTicks <= 2 * step) {
                return s2 + Lang.get("of.options.save.90s");
            }
            if (this.ofAutoSaveTicks <= 4 * step) {
                return s2 + Lang.get("of.options.save.3min");
            }
            if (this.ofAutoSaveTicks <= 8 * step) {
                return s2 + Lang.get("of.options.save.6min");
            }
            if (this.ofAutoSaveTicks <= 16 * step) {
                return s2 + Lang.get("of.options.save.12min");
            }
            return s2 + Lang.get("of.options.save.24min");
        }
        if (par1EnumOptions == AbstractOption.BETTER_GRASS) {
            switch (this.ofBetterGrass) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CONNECTED_TEXTURES) {
            switch (this.ofConnectedTextures) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.WEATHER) {
            if (this.ofWeather) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SKY) {
            if (this.ofSky) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.STARS) {
            if (this.ofStars) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SUN_MOON) {
            if (this.ofSunMoon) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.VIGNETTE) {
            switch (this.ofVignette) {
                case 1: {
                    return s2 + Lang.getFast();
                }
                case 2: {
                    return s2 + Lang.getFancy();
                }
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.CHUNK_UPDATES) {
            return s2 + this.ofChunkUpdates;
        }
        if (par1EnumOptions == AbstractOption.CHUNK_UPDATES_DYNAMIC) {
            if (this.ofChunkUpdatesDynamic) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.TIME) {
            if (this.ofTime == 1) {
                return s2 + Lang.get("of.options.time.dayOnly");
            }
            if (this.ofTime == 2) {
                return s2 + Lang.get("of.options.time.nightOnly");
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.AA_LEVEL) {
            return FloatOptions.getText((AbstractOption)par1EnumOptions, (double)this.ofAaLevel);
        }
        if (par1EnumOptions == AbstractOption.AF_LEVEL) {
            return FloatOptions.getText((AbstractOption)par1EnumOptions, (double)this.ofAfLevel);
        }
        if (par1EnumOptions == AbstractOption.PROFILER) {
            if (this.ofProfiler) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.BETTER_SNOW) {
            if (this.ofBetterSnow) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SWAMP_COLORS) {
            if (this.ofSwampColors) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.RANDOM_ENTITIES) {
            if (this.ofRandomEntities) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_FONTS) {
            if (this.ofCustomFonts) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_COLORS) {
            if (this.ofCustomColors) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_SKY) {
            if (this.ofCustomSky) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SHOW_CAPES) {
            if (this.ofShowCapes) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_ITEMS) {
            if (this.ofCustomItems) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.NATURAL_TEXTURES) {
            if (this.ofNaturalTextures) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.EMISSIVE_TEXTURES) {
            if (this.ofEmissiveTextures) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.FAST_MATH) {
            if (this.ofFastMath) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.FAST_RENDER) {
            if (this.ofFastRender) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.TRANSLUCENT_BLOCKS) {
            if (this.ofTranslucentBlocks == 1) {
                return s2 + Lang.getFast();
            }
            if (this.ofTranslucentBlocks == 2) {
                return s2 + Lang.getFancy();
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.LAZY_CHUNK_LOADING) {
            if (this.ofLazyChunkLoading) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.RENDER_REGIONS) {
            if (this.ofRenderRegions) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SMART_ANIMATIONS) {
            if (this.ofSmartAnimations) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.DYNAMIC_FOV) {
            if (this.ofDynamicFov) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ALTERNATE_BLOCKS) {
            if (this.ofAlternateBlocks) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.DYNAMIC_LIGHTS) {
            int index = GameSettings.indexOf((int)this.ofDynamicLights, (int[])OF_DYNAMIC_LIGHTS);
            return s2 + GameSettings.getTranslation((String[])KEYS_DYNAMIC_LIGHTS, (int)index);
        }
        if (par1EnumOptions == AbstractOption.SCREENSHOT_SIZE) {
            if (this.ofScreenshotSize <= 1) {
                return s2 + Lang.getDefault();
            }
            return s2 + this.ofScreenshotSize + "x";
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_ENTITY_MODELS) {
            if (this.ofCustomEntityModels) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.CUSTOM_GUIS) {
            if (this.ofCustomGuis) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.SHOW_GL_ERRORS) {
            if (this.ofShowGlErrors) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.HELD_ITEM_TOOLTIPS) {
            if (this.field_92117_D) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.ADVANCED_TOOLTIPS) {
            if (this.field_82882_x) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions == AbstractOption.field_216701_h) {
            double var6 = AbstractOption.field_216701_h.func_216729_a(this);
            if (var6 == 0.0) {
                return var2 + Lang.get("of.options.framerateLimit.vsync");
            }
            if (var6 == AbstractOption.field_216701_h.func_216733_c()) {
                return var2 + I18n.func_135052_a((String)"options.framerateLimit.max", (Object[])new Object[0]);
            }
            return var2 + (int)var6 + " fps";
        }
        if (par1EnumOptions == AbstractOption.CHAT_BACKGROUND) {
            if (this.ofChatBackground == 3) {
                return s2 + Lang.getOff();
            }
            if (this.ofChatBackground == 5) {
                return s2 + Lang.get("of.general.compact");
            }
            return s2 + Lang.getDefault();
        }
        if (par1EnumOptions == AbstractOption.CHAT_SHADOW) {
            if (this.ofChatShadow) {
                return s2 + Lang.getOn();
            }
            return s2 + Lang.getOff();
        }
        if (par1EnumOptions instanceof SliderPercentageOption) {
            SliderPercentageOption spo = (SliderPercentageOption)par1EnumOptions;
            double d0 = spo.func_216729_a(this);
            return d0 == 0.0 ? s2 + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : s2 + (int)(d0 * 100.0) + "%";
        }
        return null;
    }

    public void loadOfOptions() {
        try {
            File ofReadFile = this.optionsFileOF;
            if (!ofReadFile.exists()) {
                ofReadFile = this.field_74354_ai;
            }
            if (!ofReadFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ofReadFile), StandardCharsets.UTF_8));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                try {
                    String[] as = s2.split(":");
                    if (as[0].equals("ofRenderDistanceChunks") && as.length >= 2) {
                        this.field_151451_c = Integer.valueOf(as[1]);
                        this.field_151451_c = Config.limit(this.field_151451_c, 2, 1024);
                    }
                    if (as[0].equals("ofFogType") && as.length >= 2) {
                        this.ofFogType = Integer.valueOf(as[1]);
                        this.ofFogType = Config.limit(this.ofFogType, 1, 3);
                    }
                    if (as[0].equals("ofFogStart") && as.length >= 2) {
                        this.ofFogStart = Float.valueOf(as[1]).floatValue();
                        if (this.ofFogStart < 0.2f) {
                            this.ofFogStart = 0.2f;
                        }
                        if (this.ofFogStart > 0.81f) {
                            this.ofFogStart = 0.8f;
                        }
                    }
                    if (as[0].equals("ofMipmapType") && as.length >= 2) {
                        this.ofMipmapType = Integer.valueOf(as[1]);
                        this.ofMipmapType = Config.limit(this.ofMipmapType, 0, 3);
                    }
                    if (as[0].equals("ofOcclusionFancy") && as.length >= 2) {
                        this.ofOcclusionFancy = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmoothFps") && as.length >= 2) {
                        this.ofSmoothFps = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmoothWorld") && as.length >= 2) {
                        this.ofSmoothWorld = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAoLevel") && as.length >= 2) {
                        this.ofAoLevel = Float.valueOf(as[1]).floatValue();
                        this.ofAoLevel = Config.limit(this.ofAoLevel, 0.0, 1.0);
                    }
                    if (as[0].equals("ofClouds") && as.length >= 2) {
                        this.ofClouds = Integer.valueOf(as[1]);
                        this.ofClouds = Config.limit(this.ofClouds, 0, 3);
                        this.updateRenderClouds();
                    }
                    if (as[0].equals("ofCloudsHeight") && as.length >= 2) {
                        this.ofCloudsHeight = Float.valueOf(as[1]).floatValue();
                        this.ofCloudsHeight = Config.limit(this.ofCloudsHeight, 0.0, 1.0);
                    }
                    if (as[0].equals("ofTrees") && as.length >= 2) {
                        this.ofTrees = Integer.valueOf(as[1]);
                        this.ofTrees = GameSettings.limit((int)this.ofTrees, (int[])OF_TREES_VALUES);
                    }
                    if (as[0].equals("ofDroppedItems") && as.length >= 2) {
                        this.ofDroppedItems = Integer.valueOf(as[1]);
                        this.ofDroppedItems = Config.limit(this.ofDroppedItems, 0, 2);
                    }
                    if (as[0].equals("ofRain") && as.length >= 2) {
                        this.ofRain = Integer.valueOf(as[1]);
                        this.ofRain = Config.limit(this.ofRain, 0, 3);
                    }
                    if (as[0].equals("ofAnimatedWater") && as.length >= 2) {
                        this.ofAnimatedWater = Integer.valueOf(as[1]);
                        this.ofAnimatedWater = Config.limit(this.ofAnimatedWater, 0, 2);
                    }
                    if (as[0].equals("ofAnimatedLava") && as.length >= 2) {
                        this.ofAnimatedLava = Integer.valueOf(as[1]);
                        this.ofAnimatedLava = Config.limit(this.ofAnimatedLava, 0, 2);
                    }
                    if (as[0].equals("ofAnimatedFire") && as.length >= 2) {
                        this.ofAnimatedFire = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedPortal") && as.length >= 2) {
                        this.ofAnimatedPortal = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedRedstone") && as.length >= 2) {
                        this.ofAnimatedRedstone = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedExplosion") && as.length >= 2) {
                        this.ofAnimatedExplosion = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedFlame") && as.length >= 2) {
                        this.ofAnimatedFlame = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedSmoke") && as.length >= 2) {
                        this.ofAnimatedSmoke = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofVoidParticles") && as.length >= 2) {
                        this.ofVoidParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofWaterParticles") && as.length >= 2) {
                        this.ofWaterParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofPortalParticles") && as.length >= 2) {
                        this.ofPortalParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofPotionParticles") && as.length >= 2) {
                        this.ofPotionParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofFireworkParticles") && as.length >= 2) {
                        this.ofFireworkParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDrippingWaterLava") && as.length >= 2) {
                        this.ofDrippingWaterLava = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedTerrain") && as.length >= 2) {
                        this.ofAnimatedTerrain = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedTextures") && as.length >= 2) {
                        this.ofAnimatedTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRainSplash") && as.length >= 2) {
                        this.ofRainSplash = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofLagometer") && as.length >= 2) {
                        this.ofLagometer = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowFps") && as.length >= 2) {
                        this.ofShowFps = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAutoSaveTicks") && as.length >= 2) {
                        this.ofAutoSaveTicks = Integer.valueOf(as[1]);
                        this.ofAutoSaveTicks = Config.limit(this.ofAutoSaveTicks, 40, 40000);
                    }
                    if (as[0].equals("ofBetterGrass") && as.length >= 2) {
                        this.ofBetterGrass = Integer.valueOf(as[1]);
                        this.ofBetterGrass = Config.limit(this.ofBetterGrass, 1, 3);
                    }
                    if (as[0].equals("ofConnectedTextures") && as.length >= 2) {
                        this.ofConnectedTextures = Integer.valueOf(as[1]);
                        this.ofConnectedTextures = Config.limit(this.ofConnectedTextures, 1, 3);
                    }
                    if (as[0].equals("ofWeather") && as.length >= 2) {
                        this.ofWeather = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSky") && as.length >= 2) {
                        this.ofSky = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofStars") && as.length >= 2) {
                        this.ofStars = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSunMoon") && as.length >= 2) {
                        this.ofSunMoon = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofVignette") && as.length >= 2) {
                        this.ofVignette = Integer.valueOf(as[1]);
                        this.ofVignette = Config.limit(this.ofVignette, 0, 2);
                    }
                    if (as[0].equals("ofChunkUpdates") && as.length >= 2) {
                        this.ofChunkUpdates = Integer.valueOf(as[1]);
                        this.ofChunkUpdates = Config.limit(this.ofChunkUpdates, 1, 5);
                    }
                    if (as[0].equals("ofChunkUpdatesDynamic") && as.length >= 2) {
                        this.ofChunkUpdatesDynamic = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofTime") && as.length >= 2) {
                        this.ofTime = Integer.valueOf(as[1]);
                        this.ofTime = Config.limit(this.ofTime, 0, 2);
                    }
                    if (as[0].equals("ofAaLevel") && as.length >= 2) {
                        this.ofAaLevel = Integer.valueOf(as[1]);
                        this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
                    }
                    if (as[0].equals("ofAfLevel") && as.length >= 2) {
                        this.ofAfLevel = Integer.valueOf(as[1]);
                        this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
                    }
                    if (as[0].equals("ofProfiler") && as.length >= 2) {
                        this.ofProfiler = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofBetterSnow") && as.length >= 2) {
                        this.ofBetterSnow = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSwampColors") && as.length >= 2) {
                        this.ofSwampColors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRandomEntities") && as.length >= 2) {
                        this.ofRandomEntities = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomFonts") && as.length >= 2) {
                        this.ofCustomFonts = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomColors") && as.length >= 2) {
                        this.ofCustomColors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomItems") && as.length >= 2) {
                        this.ofCustomItems = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomSky") && as.length >= 2) {
                        this.ofCustomSky = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowCapes") && as.length >= 2) {
                        this.ofShowCapes = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofNaturalTextures") && as.length >= 2) {
                        this.ofNaturalTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofEmissiveTextures") && as.length >= 2) {
                        this.ofEmissiveTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofLazyChunkLoading") && as.length >= 2) {
                        this.ofLazyChunkLoading = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRenderRegions") && as.length >= 2) {
                        this.ofRenderRegions = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmartAnimations") && as.length >= 2) {
                        this.ofSmartAnimations = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDynamicFov") && as.length >= 2) {
                        this.ofDynamicFov = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAlternateBlocks") && as.length >= 2) {
                        this.ofAlternateBlocks = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDynamicLights") && as.length >= 2) {
                        this.ofDynamicLights = Integer.valueOf(as[1]);
                        this.ofDynamicLights = GameSettings.limit((int)this.ofDynamicLights, (int[])OF_DYNAMIC_LIGHTS);
                    }
                    if (as[0].equals("ofScreenshotSize") && as.length >= 2) {
                        this.ofScreenshotSize = Integer.valueOf(as[1]);
                        this.ofScreenshotSize = Config.limit(this.ofScreenshotSize, 1, 4);
                    }
                    if (as[0].equals("ofCustomEntityModels") && as.length >= 2) {
                        this.ofCustomEntityModels = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomGuis") && as.length >= 2) {
                        this.ofCustomGuis = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowGlErrors") && as.length >= 2) {
                        this.ofShowGlErrors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofFastMath") && as.length >= 2) {
                        MathHelper.fastMath = this.ofFastMath = Boolean.valueOf(as[1]).booleanValue();
                    }
                    if (as[0].equals("ofFastRender") && as.length >= 2) {
                        this.ofFastRender = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofTranslucentBlocks") && as.length >= 2) {
                        this.ofTranslucentBlocks = Integer.valueOf(as[1]);
                        this.ofTranslucentBlocks = Config.limit(this.ofTranslucentBlocks, 0, 2);
                    }
                    if (as[0].equals("ofChatBackground") && as.length >= 2) {
                        this.ofChatBackground = Integer.valueOf(as[1]);
                    }
                    if (as[0].equals("ofChatShadow") && as.length >= 2) {
                        this.ofChatShadow = Boolean.valueOf(as[1]);
                    }
                    if (!as[0].equals("key_" + this.ofKeyBindZoom.func_151464_g())) continue;
                    this.ofKeyBindZoom.func_197979_b(InputMappings.func_197955_a((String)as[1]));
                }
                catch (Exception exception1) {
                    Config.dbg("Skipping bad option: " + s2);
                    exception1.printStackTrace();
                }
            }
            KeyUtils.fixKeyConflicts((KeyBinding[])this.field_74324_K, (KeyBinding[])new KeyBinding[]{this.ofKeyBindZoom});
            KeyBinding.func_74508_b();
            bufferedreader.close();
        }
        catch (Exception exception) {
            Config.warn("Failed to load options");
            exception.printStackTrace();
        }
    }

    public void saveOfOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFileOF), StandardCharsets.UTF_8));
            printwriter.println("ofFogType:" + this.ofFogType);
            printwriter.println("ofFogStart:" + this.ofFogStart);
            printwriter.println("ofMipmapType:" + this.ofMipmapType);
            printwriter.println("ofOcclusionFancy:" + this.ofOcclusionFancy);
            printwriter.println("ofSmoothFps:" + this.ofSmoothFps);
            printwriter.println("ofSmoothWorld:" + this.ofSmoothWorld);
            printwriter.println("ofAoLevel:" + this.ofAoLevel);
            printwriter.println("ofClouds:" + this.ofClouds);
            printwriter.println("ofCloudsHeight:" + this.ofCloudsHeight);
            printwriter.println("ofTrees:" + this.ofTrees);
            printwriter.println("ofDroppedItems:" + this.ofDroppedItems);
            printwriter.println("ofRain:" + this.ofRain);
            printwriter.println("ofAnimatedWater:" + this.ofAnimatedWater);
            printwriter.println("ofAnimatedLava:" + this.ofAnimatedLava);
            printwriter.println("ofAnimatedFire:" + this.ofAnimatedFire);
            printwriter.println("ofAnimatedPortal:" + this.ofAnimatedPortal);
            printwriter.println("ofAnimatedRedstone:" + this.ofAnimatedRedstone);
            printwriter.println("ofAnimatedExplosion:" + this.ofAnimatedExplosion);
            printwriter.println("ofAnimatedFlame:" + this.ofAnimatedFlame);
            printwriter.println("ofAnimatedSmoke:" + this.ofAnimatedSmoke);
            printwriter.println("ofVoidParticles:" + this.ofVoidParticles);
            printwriter.println("ofWaterParticles:" + this.ofWaterParticles);
            printwriter.println("ofPortalParticles:" + this.ofPortalParticles);
            printwriter.println("ofPotionParticles:" + this.ofPotionParticles);
            printwriter.println("ofFireworkParticles:" + this.ofFireworkParticles);
            printwriter.println("ofDrippingWaterLava:" + this.ofDrippingWaterLava);
            printwriter.println("ofAnimatedTerrain:" + this.ofAnimatedTerrain);
            printwriter.println("ofAnimatedTextures:" + this.ofAnimatedTextures);
            printwriter.println("ofRainSplash:" + this.ofRainSplash);
            printwriter.println("ofLagometer:" + this.ofLagometer);
            printwriter.println("ofShowFps:" + this.ofShowFps);
            printwriter.println("ofAutoSaveTicks:" + this.ofAutoSaveTicks);
            printwriter.println("ofBetterGrass:" + this.ofBetterGrass);
            printwriter.println("ofConnectedTextures:" + this.ofConnectedTextures);
            printwriter.println("ofWeather:" + this.ofWeather);
            printwriter.println("ofSky:" + this.ofSky);
            printwriter.println("ofStars:" + this.ofStars);
            printwriter.println("ofSunMoon:" + this.ofSunMoon);
            printwriter.println("ofVignette:" + this.ofVignette);
            printwriter.println("ofChunkUpdates:" + this.ofChunkUpdates);
            printwriter.println("ofChunkUpdatesDynamic:" + this.ofChunkUpdatesDynamic);
            printwriter.println("ofTime:" + this.ofTime);
            printwriter.println("ofAaLevel:" + this.ofAaLevel);
            printwriter.println("ofAfLevel:" + this.ofAfLevel);
            printwriter.println("ofProfiler:" + this.ofProfiler);
            printwriter.println("ofBetterSnow:" + this.ofBetterSnow);
            printwriter.println("ofSwampColors:" + this.ofSwampColors);
            printwriter.println("ofRandomEntities:" + this.ofRandomEntities);
            printwriter.println("ofCustomFonts:" + this.ofCustomFonts);
            printwriter.println("ofCustomColors:" + this.ofCustomColors);
            printwriter.println("ofCustomItems:" + this.ofCustomItems);
            printwriter.println("ofCustomSky:" + this.ofCustomSky);
            printwriter.println("ofShowCapes:" + this.ofShowCapes);
            printwriter.println("ofNaturalTextures:" + this.ofNaturalTextures);
            printwriter.println("ofEmissiveTextures:" + this.ofEmissiveTextures);
            printwriter.println("ofLazyChunkLoading:" + this.ofLazyChunkLoading);
            printwriter.println("ofRenderRegions:" + this.ofRenderRegions);
            printwriter.println("ofSmartAnimations:" + this.ofSmartAnimations);
            printwriter.println("ofDynamicFov:" + this.ofDynamicFov);
            printwriter.println("ofAlternateBlocks:" + this.ofAlternateBlocks);
            printwriter.println("ofDynamicLights:" + this.ofDynamicLights);
            printwriter.println("ofScreenshotSize:" + this.ofScreenshotSize);
            printwriter.println("ofCustomEntityModels:" + this.ofCustomEntityModels);
            printwriter.println("ofCustomGuis:" + this.ofCustomGuis);
            printwriter.println("ofShowGlErrors:" + this.ofShowGlErrors);
            printwriter.println("ofFastMath:" + this.ofFastMath);
            printwriter.println("ofFastRender:" + this.ofFastRender);
            printwriter.println("ofTranslucentBlocks:" + this.ofTranslucentBlocks);
            printwriter.println("ofChatBackground:" + this.ofChatBackground);
            printwriter.println("ofChatShadow:" + this.ofChatShadow);
            printwriter.println("key_" + this.ofKeyBindZoom.func_151464_g() + ":" + this.ofKeyBindZoom.func_197982_m());
            printwriter.close();
        }
        catch (Exception exception) {
            Config.warn("Failed to save options");
            exception.printStackTrace();
        }
    }

    public void updateRenderClouds() {
        Framebuffer framebuffer;
        WorldRenderer wr;
        switch (this.ofClouds) {
            case 3: {
                this.field_74345_l = CloudOption.OFF;
                break;
            }
            case 1: {
                this.field_74345_l = CloudOption.FAST;
                break;
            }
            case 2: {
                this.field_74345_l = CloudOption.FANCY;
                break;
            }
            default: {
                this.field_74345_l = this.field_238330_f_ != GraphicsFanciness.FAST ? CloudOption.FANCY : CloudOption.FAST;
            }
        }
        if (this.field_238330_f_ == GraphicsFanciness.FABULOUS && (wr = Minecraft.func_71410_x().field_71438_f) != null && (framebuffer = wr.func_239232_u_()) != null) {
            framebuffer.func_216493_b(Minecraft.field_142025_a);
        }
    }

    public void resetSettings() {
        this.field_151451_c = 8;
        this.field_238329_c_ = 1.0f;
        this.field_74336_f = true;
        this.field_74350_i = (int)AbstractOption.field_216701_h.func_216733_c();
        this.field_74352_v = false;
        this.updateVSync();
        this.field_151442_I = 4;
        this.field_238330_f_ = GraphicsFanciness.FANCY;
        this.field_74348_k = AmbientOcclusionStatus.MAX;
        this.field_74345_l = CloudOption.FANCY;
        this.field_74334_X = 70.0;
        this.field_74333_Y = 0.0;
        this.field_74335_Z = 0;
        this.field_74362_aa = ParticleStatus.ALL;
        this.field_92117_D = true;
        this.field_211842_aO = false;
        this.ofFogType = 1;
        this.ofFogStart = 0.8f;
        this.ofMipmapType = 0;
        this.ofOcclusionFancy = false;
        this.ofSmartAnimations = false;
        this.ofSmoothFps = false;
        Config.updateAvailableProcessors();
        this.ofSmoothWorld = Config.isSingleProcessor();
        this.ofLazyChunkLoading = false;
        this.ofRenderRegions = false;
        this.ofFastMath = false;
        this.ofFastRender = false;
        this.ofTranslucentBlocks = 0;
        this.ofDynamicFov = true;
        this.ofAlternateBlocks = true;
        this.ofDynamicLights = 3;
        this.ofScreenshotSize = 1;
        this.ofCustomEntityModels = true;
        this.ofCustomGuis = true;
        this.ofShowGlErrors = true;
        this.ofChatBackground = 0;
        this.ofChatShadow = true;
        this.ofAoLevel = 1.0;
        this.ofAaLevel = 0;
        this.ofAfLevel = 1;
        this.ofClouds = 0;
        this.ofCloudsHeight = 0.0;
        this.ofTrees = 0;
        this.ofRain = 0;
        this.ofBetterGrass = 3;
        this.ofAutoSaveTicks = 4000;
        this.ofLagometer = false;
        this.ofShowFps = false;
        this.ofProfiler = false;
        this.ofWeather = true;
        this.ofSky = true;
        this.ofStars = true;
        this.ofSunMoon = true;
        this.ofVignette = 0;
        this.ofChunkUpdates = 1;
        this.ofChunkUpdatesDynamic = false;
        this.ofTime = 0;
        this.ofBetterSnow = false;
        this.ofSwampColors = true;
        this.ofRandomEntities = true;
        this.field_205217_U = 2;
        this.ofCustomFonts = true;
        this.ofCustomColors = true;
        this.ofCustomItems = true;
        this.ofCustomSky = true;
        this.ofShowCapes = true;
        this.ofConnectedTextures = 2;
        this.ofNaturalTextures = false;
        this.ofEmissiveTextures = true;
        this.ofAnimatedWater = 0;
        this.ofAnimatedLava = 0;
        this.ofAnimatedFire = true;
        this.ofAnimatedPortal = true;
        this.ofAnimatedRedstone = true;
        this.ofAnimatedExplosion = true;
        this.ofAnimatedFlame = true;
        this.ofAnimatedSmoke = true;
        this.ofVoidParticles = true;
        this.ofWaterParticles = true;
        this.ofRainSplash = true;
        this.ofPortalParticles = true;
        this.ofPotionParticles = true;
        this.ofFireworkParticles = true;
        this.ofDrippingWaterLava = true;
        this.ofAnimatedTerrain = true;
        this.ofAnimatedTextures = true;
        Shaders.setShaderPack("OFF");
        Shaders.configAntialiasingLevel = 0;
        Shaders.uninit();
        Shaders.storeConfig();
        this.field_74317_L.func_213245_w();
        this.func_74303_b();
    }

    public void updateVSync() {
        if (this.field_74317_L.func_228018_at_() != null) {
            this.field_74317_L.func_228018_at_().func_216523_b(this.field_74352_v);
        }
    }

    public void updateMipmaps() {
        this.field_74317_L.func_228020_b_(this.field_151442_I);
        this.field_74317_L.func_213245_w();
    }

    public void setAllAnimations(boolean flag) {
        int animVal;
        this.ofAnimatedWater = animVal = flag ? 0 : 2;
        this.ofAnimatedLava = animVal;
        this.ofAnimatedFire = flag;
        this.ofAnimatedPortal = flag;
        this.ofAnimatedRedstone = flag;
        this.ofAnimatedExplosion = flag;
        this.ofAnimatedFlame = flag;
        this.ofAnimatedSmoke = flag;
        this.ofVoidParticles = flag;
        this.ofWaterParticles = flag;
        this.ofRainSplash = flag;
        this.ofPortalParticles = flag;
        this.ofPotionParticles = flag;
        this.ofFireworkParticles = flag;
        this.field_74362_aa = flag ? ParticleStatus.ALL : ParticleStatus.MINIMAL;
        this.ofDrippingWaterLava = flag;
        this.ofAnimatedTerrain = flag;
        this.ofAnimatedTextures = flag;
    }

    private static int nextValue(int val, int[] vals) {
        int index = GameSettings.indexOf((int)val, (int[])vals);
        if (index < 0) {
            return vals[0];
        }
        if (++index >= vals.length) {
            index = 0;
        }
        return vals[index];
    }

    private static int limit(int val, int[] vals) {
        int index = GameSettings.indexOf((int)val, (int[])vals);
        if (index < 0) {
            return vals[0];
        }
        return val;
    }

    private static int indexOf(int val, int[] vals) {
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (vals[i2] != val) continue;
            return i2;
        }
        return -1;
    }

    private static String getTranslation(String[] strArray, int index) {
        if (index < 0 || index >= strArray.length) {
            index = 0;
        }
        return I18n.func_135052_a((String)strArray[index], (Object[])new Object[0]);
    }

    private void setForgeKeybindProperties() {
        if (!Reflector.KeyConflictContext_IN_GAME.exists()) {
            return;
        }
        if (!Reflector.ForgeKeyBinding_setKeyConflictContext.exists()) {
            return;
        }
        Object inGame = Reflector.getFieldValue(Reflector.KeyConflictContext_IN_GAME);
        Reflector.call(this.field_74351_w, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74370_x, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74368_y, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74366_z, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74314_A, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_228046_af_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_151444_V, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74312_F, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74310_D, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74321_H, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_74323_J, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_151457_aa, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.field_151458_ab, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
    }

    public void func_198017_a(ResourcePackList resourcePackListIn) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator iterator = this.field_151453_l.iterator();
        while (iterator.hasNext()) {
            String s2 = (String)iterator.next();
            ResourcePackInfo resourcepackinfo = resourcePackListIn.func_198981_a(s2);
            if (resourcepackinfo == null && !s2.startsWith("file/")) {
                resourcepackinfo = resourcePackListIn.func_198981_a("file/" + s2);
            }
            if (resourcepackinfo == null) {
                field_151454_ax.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s2);
                iterator.remove();
                continue;
            }
            if (!resourcepackinfo.func_195791_d().func_198968_a() && !this.field_183018_l.contains(s2)) {
                field_151454_ax.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s2);
                iterator.remove();
                continue;
            }
            if (resourcepackinfo.func_195791_d().func_198968_a() && this.field_183018_l.contains(s2)) {
                field_151454_ax.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s2);
                this.field_183018_l.remove(s2);
                continue;
            }
            set.add(resourcepackinfo.func_195790_f());
        }
        resourcePackListIn.func_198985_a((Collection)set);
    }

    public PointOfView func_243230_g() {
        return this.field_243228_bb;
    }

    public void func_243229_a(PointOfView pointOfViewIn) {
        this.field_243228_bb = pointOfViewIn;
    }
}

