/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.BossInfo;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;

public class BossOverlayGui
extends AbstractGui {
    private static final ResourceLocation field_184058_a = new ResourceLocation("textures/gui/bars.png");
    private final Minecraft field_184059_f;
    private final Map<UUID, ClientBossInfo> field_184060_g = Maps.newLinkedHashMap();

    public BossOverlayGui(Minecraft clientIn) {
        this.field_184059_f = clientIn;
    }

    public void func_238484_a_(MatrixStack p_238484_1_) {
        if (!this.field_184060_g.isEmpty()) {
            int i2 = this.field_184059_f.func_228018_at_().func_198107_o();
            int j2 = 12;
            for (ClientBossInfo clientbossinfo : this.field_184060_g.values()) {
                int k2 = i2 / 2 - 91;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean render = true;
                int increment = 19;
                if (Reflector.ForgeHooksClient_bossBarRenderPre.exists()) {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = p_238484_1_;
                    objectArray[1] = this.field_184059_f.func_228018_at_();
                    objectArray[2] = clientbossinfo;
                    objectArray[3] = k2;
                    objectArray[4] = j2;
                    this.field_184059_f.field_71466_p.getClass();
                    objectArray[5] = 10 + 9;
                    Object event = Reflector.ForgeHooksClient_bossBarRenderPre.call(objectArray);
                    render = !Reflector.callBoolean(event, Reflector.Event_isCanceled, new Object[0]);
                    increment = Reflector.callInt(event, Reflector.RenderGameOverlayEvent_BossInfo_getIncrement, new Object[0]);
                }
                if (render) {
                    this.field_184059_f.func_110434_K().func_110577_a(field_184058_a);
                    this.func_238485_a_(p_238484_1_, k2, j2, (BossInfo)clientbossinfo);
                    ITextComponent itextcomponent = clientbossinfo.func_186744_e();
                    int l2 = this.field_184059_f.field_71466_p.func_238414_a_((ITextProperties)itextcomponent);
                    int i1 = i2 / 2 - l2 / 2;
                    int j1 = j2 - 9;
                    int col = 0xFFFFFF;
                    if (Config.isCustomColors()) {
                        col = CustomColors.getBossTextColor(col);
                    }
                    this.field_184059_f.field_71466_p.func_243246_a(p_238484_1_, itextcomponent, (float)i1, (float)j1, col);
                }
                Reflector.ForgeHooksClient_bossBarRenderPost.callVoid(p_238484_1_, this.field_184059_f.func_228018_at_());
                if ((j2 += increment) < this.field_184059_f.func_228018_at_().func_198087_p() / 3) continue;
                break;
            }
        }
    }

    private void func_238485_a_(MatrixStack p_238485_1_, int p_238485_2_, int p_238485_3_, BossInfo p_238485_4_) {
        int i2;
        this.func_238474_b_(p_238485_1_, p_238485_2_, p_238485_3_, 0, p_238485_4_.func_186736_g().ordinal() * 5 * 2, 182, 5);
        if (p_238485_4_.func_186740_h() != BossInfo.Overlay.PROGRESS) {
            this.func_238474_b_(p_238485_1_, p_238485_2_, p_238485_3_, 0, 80 + (p_238485_4_.func_186740_h().ordinal() - 1) * 5 * 2, 182, 5);
        }
        if ((i2 = (int)(p_238485_4_.func_186738_f() * 183.0f)) > 0) {
            this.func_238474_b_(p_238485_1_, p_238485_2_, p_238485_3_, 0, p_238485_4_.func_186736_g().ordinal() * 5 * 2 + 5, i2, 5);
            if (p_238485_4_.func_186740_h() != BossInfo.Overlay.PROGRESS) {
                this.func_238474_b_(p_238485_1_, p_238485_2_, p_238485_3_, 0, 80 + (p_238485_4_.func_186740_h().ordinal() - 1) * 5 * 2 + 5, i2, 5);
            }
        }
    }

    public void func_184055_a(SUpdateBossInfoPacket packetIn) {
        if (packetIn.func_186902_b() == SUpdateBossInfoPacket.Operation.ADD) {
            this.field_184060_g.put(packetIn.func_186908_a(), new ClientBossInfo(packetIn));
        } else if (packetIn.func_186902_b() == SUpdateBossInfoPacket.Operation.REMOVE) {
            this.field_184060_g.remove(packetIn.func_186908_a());
        } else {
            ((ClientBossInfo)this.field_184060_g.get(packetIn.func_186908_a())).func_186765_a(packetIn);
        }
    }

    public void func_184057_b() {
        this.field_184060_g.clear();
    }

    public boolean func_184054_d() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossinfo : this.field_184060_g.values()) {
                if (!bossinfo.func_186747_j()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_184053_e() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossinfo : this.field_184060_g.values()) {
                if (!bossinfo.func_186734_i()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_184056_f() {
        if (!this.field_184060_g.isEmpty()) {
            for (BossInfo bossinfo : this.field_184060_g.values()) {
                if (!bossinfo.func_186748_k()) continue;
                return true;
            }
        }
        return false;
    }
}

