/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexConsumer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.MultiTextureBuilder;
import net.optifine.render.MultiTextureData;
import net.optifine.render.RenderEnv;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.SVertexBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BufferBuilder
extends DefaultColorVertexBuilder
implements IVertexConsumer {
    private static final Logger field_187316_a = LogManager.getLogger();
    private ByteBuffer field_179001_a;
    private final List<DrawState> field_227821_i_ = Lists.newArrayList();
    private int field_227822_j_ = 0;
    private int field_227823_k_ = 0;
    private int field_227824_l_ = 0;
    private int field_227825_m_ = 0;
    private int field_178997_d;
    @Nullable
    private VertexFormatElement field_181677_f;
    private int field_181678_g;
    private int field_179006_k;
    private VertexFormat field_179011_q;
    private boolean field_227826_s_;
    private boolean field_227827_t_;
    private boolean field_179010_r;
    private RenderType renderType;
    private boolean renderBlocks;
    private TextureAtlasSprite[] quadSprites = null;
    private TextureAtlasSprite[] quadSpritesPrev = null;
    private TextureAtlasSprite quadSprite = null;
    private MultiTextureBuilder multiTextureBuilder = new MultiTextureBuilder();
    public SVertexBuilder sVertexBuilder;
    public RenderEnv renderEnv = null;
    public BitSet animatedSprites = null;
    public BitSet animatedSpritesCached = new BitSet();
    private ByteBuffer byteBufferTriangles;
    private Vector3f tempVec3f = new Vector3f();
    private float[] tempFloat4 = new float[4];
    private int[] tempInt4 = new int[4];
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private IRenderTypeBuffer.Impl renderTypeBuffer;
    private FloatBuffer floatBufferSort;
    private VertexPosition[] quadVertexPositions;
    private Vector3f midBlock = new Vector3f();

    public BufferBuilder(int bufferSizeIn) {
        this.field_179001_a = GLAllocation.func_74524_c((int)(bufferSizeIn * 4));
        this.intBuffer = this.field_179001_a.asIntBuffer();
        this.floatBuffer = this.field_179001_a.asFloatBuffer();
        SVertexBuilder.initVertexBuilder((BufferBuilder)this);
    }

    protected void func_227831_b_() {
        this.func_181670_b(this.field_179011_q.func_177338_f());
    }

    private void func_181670_b(int increaseAmount) {
        if (this.field_227824_l_ + increaseAmount > this.field_179001_a.capacity()) {
            int i2 = this.field_179001_a.capacity();
            int j2 = i2 + BufferBuilder.func_216566_c((int)increaseAmount);
            field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i2, (Object)j2);
            ByteBuffer bytebuffer = GLAllocation.func_74524_c((int)j2);
            ((Buffer)this.field_179001_a).position(0);
            bytebuffer.put(this.field_179001_a);
            ((Buffer)bytebuffer).rewind();
            this.field_179001_a = bytebuffer;
            this.intBuffer = this.field_179001_a.asIntBuffer();
            this.floatBuffer = this.field_179001_a.asFloatBuffer();
            if (this.quadSprites != null) {
                TextureAtlasSprite[] sprites = this.quadSprites;
                int quadSize = this.getBufferQuadSize();
                this.quadSprites = new TextureAtlasSprite[quadSize];
                System.arraycopy(sprites, 0, this.quadSprites, 0, Math.min(sprites.length, this.quadSprites.length));
                this.quadSpritesPrev = null;
            }
        }
    }

    private static int func_216566_c(int xIn) {
        int j2;
        int i2 = 0x200000;
        if (xIn == 0) {
            return i2;
        }
        if (xIn < 0) {
            i2 *= -1;
        }
        return (j2 = xIn % i2) == 0 ? xIn : xIn + i2 - j2;
    }

    public void func_181674_a(float cameraX, float cameraY, float cameraZ) {
        ((Buffer)this.field_179001_a).clear();
        FloatBuffer floatbuffer = this.field_179001_a.asFloatBuffer();
        FloatBuffer floatbuffer2 = floatbuffer.slice();
        int i2 = this.field_178997_d / 4;
        float[] afloat = new float[i2];
        for (int j2 = 0; j2 < i2; ++j2) {
            afloat[j2] = BufferBuilder.func_181665_a((FloatBuffer)floatbuffer, (float)cameraX, (float)cameraY, (float)cameraZ, (int)this.field_179011_q.func_181719_f(), (int)(this.field_227823_k_ / 4 + j2 * this.field_179011_q.func_177338_f()));
        }
        int[] aint = new int[i2];
        int k2 = 0;
        while (k2 < aint.length) {
            aint[k2] = k2++;
        }
        IntArrays.mergeSort((int[])aint, (p_227830_1_, p_227830_2_) -> Floats.compare((float)afloat[p_227830_2_], (float)afloat[p_227830_1_]));
        BitSet bitset = new BitSet();
        FloatBuffer floatbuffer1 = this.getFloatBufferSort(this.field_179011_q.func_181719_f() * 4);
        int l2 = bitset.nextClearBit(0);
        while (l2 < aint.length) {
            int i1 = aint[l2];
            if (i1 != l2) {
                this.func_227829_a_(floatbuffer, i1);
                ((Buffer)floatbuffer1).clear();
                floatbuffer1.put(floatbuffer);
                int j1 = i1;
                int k1 = aint[i1];
                while (j1 != l2) {
                    this.func_227829_a_(floatbuffer, k1);
                    floatbuffer2.clear();
                    floatbuffer2.position(floatbuffer.position());
                    floatbuffer2.limit(floatbuffer.limit());
                    this.func_227829_a_(floatbuffer, j1);
                    floatbuffer.put(floatbuffer2);
                    bitset.set(j1);
                    j1 = k1;
                    k1 = aint[k1];
                }
                this.func_227829_a_(floatbuffer, l2);
                ((Buffer)floatbuffer1).flip();
                floatbuffer.put(floatbuffer1);
            }
            bitset.set(l2);
            l2 = bitset.nextClearBit(l2 + 1);
        }
        if (this.quadSprites != null) {
            TextureAtlasSprite[] quadSpritesSorted = new TextureAtlasSprite[this.field_178997_d / 4];
            int quadStep = this.field_179011_q.func_177338_f() / 4 * 4;
            int ix = 0;
            while (ix < aint.length) {
                int indexQuad = aint[ix];
                int indexQuadSorted = ix++;
                quadSpritesSorted[indexQuadSorted] = this.quadSprites[indexQuad];
            }
            System.arraycopy(quadSpritesSorted, 0, this.quadSprites, 0, quadSpritesSorted.length);
        }
    }

    private void func_227829_a_(FloatBuffer floatBufferIn, int indexIn) {
        int i2 = this.field_179011_q.func_181719_f() * 4;
        ((Buffer)floatBufferIn).limit(this.field_227823_k_ / 4 + (indexIn + 1) * i2);
        ((Buffer)floatBufferIn).position(this.field_227823_k_ / 4 + indexIn * i2);
    }

    public State func_181672_a() {
        ((Buffer)this.field_179001_a).limit(this.field_227824_l_);
        ((Buffer)this.field_179001_a).position(this.field_227823_k_);
        ByteBuffer bytebuffer = ByteBuffer.allocate(this.field_178997_d * this.field_179011_q.func_177338_f());
        bytebuffer.put(this.field_179001_a);
        ((Buffer)this.field_179001_a).clear();
        TextureAtlasSprite[] quadSpritesCopy = this.getQuadSpritesCopy();
        return new State(bytebuffer, this.field_179011_q, quadSpritesCopy);
    }

    private TextureAtlasSprite[] getQuadSpritesCopy() {
        if (this.quadSprites == null) {
            return null;
        }
        int countQuads = this.field_178997_d / 4;
        TextureAtlasSprite[] quadSpritesCopy = new TextureAtlasSprite[countQuads];
        System.arraycopy(this.quadSprites, 0, quadSpritesCopy, 0, countQuads);
        return quadSpritesCopy;
    }

    private static float func_181665_a(FloatBuffer floatBufferIn, float x2, float y2, float z, int integerSize, int offset) {
        float f2 = floatBufferIn.get(offset + integerSize * 0 + 0);
        float f1 = floatBufferIn.get(offset + integerSize * 0 + 1);
        float f22 = floatBufferIn.get(offset + integerSize * 0 + 2);
        float f3 = floatBufferIn.get(offset + integerSize * 1 + 0);
        float f4 = floatBufferIn.get(offset + integerSize * 1 + 1);
        float f5 = floatBufferIn.get(offset + integerSize * 1 + 2);
        float f6 = floatBufferIn.get(offset + integerSize * 2 + 0);
        float f7 = floatBufferIn.get(offset + integerSize * 2 + 1);
        float f8 = floatBufferIn.get(offset + integerSize * 2 + 2);
        float f9 = floatBufferIn.get(offset + integerSize * 3 + 0);
        float f10 = floatBufferIn.get(offset + integerSize * 3 + 1);
        float f11 = floatBufferIn.get(offset + integerSize * 3 + 2);
        float f12 = (f2 + f3 + f6 + f9) * 0.25f - x2;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y2;
        float f14 = (f22 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public void func_178993_a(State state) {
        ((Buffer)State.access$000((State)state)).clear();
        int i2 = State.access$000((State)state).capacity();
        this.func_181670_b(i2);
        ((Buffer)this.field_179001_a).limit(this.field_179001_a.capacity());
        ((Buffer)this.field_179001_a).position(this.field_227823_k_);
        this.field_179001_a.put(State.access$000((State)state));
        ((Buffer)this.field_179001_a).clear();
        VertexFormat vertexformat = State.access$100((State)state);
        this.func_227828_a_(vertexformat);
        this.field_178997_d = i2 / vertexformat.func_177338_f();
        this.field_227824_l_ = this.field_227823_k_ + this.field_178997_d * vertexformat.func_177338_f();
        if (State.access$200((State)state) != null) {
            if (this.quadSprites == null) {
                this.quadSprites = this.quadSpritesPrev;
            }
            if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
                this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
            }
            TextureAtlasSprite[] src = State.access$200((State)state);
            System.arraycopy(src, 0, this.quadSprites, 0, src.length);
        } else {
            if (this.quadSprites != null) {
                this.quadSpritesPrev = this.quadSprites;
            }
            this.quadSprites = null;
        }
    }

    public void func_181668_a(int glMode, VertexFormat format) {
        if (this.field_179010_r) {
            throw new IllegalStateException("Already building!");
        }
        this.field_179010_r = true;
        this.field_179006_k = glMode;
        this.func_227828_a_(format);
        this.field_181677_f = (VertexFormatElement)format.func_227894_c_().get(0);
        this.field_181678_g = 0;
        ((Buffer)this.field_179001_a).clear();
        if (Config.isShaders()) {
            SVertexBuilder.endSetVertexFormat((BufferBuilder)this);
        }
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
        if (SmartAnimations.isActive()) {
            if (this.animatedSprites == null) {
                this.animatedSprites = this.animatedSpritesCached;
            }
            this.animatedSprites.clear();
        } else if (this.animatedSprites != null) {
            this.animatedSprites = null;
        }
    }

    public IVertexBuilder func_225583_a_(float u2, float v2) {
        if (this.quadSprite != null && this.quadSprites != null) {
            u2 = this.quadSprite.toSingleU(u2);
            v2 = this.quadSprite.toSingleV(v2);
            this.quadSprites[this.field_178997_d / 4] = this.quadSprite;
        }
        return super.func_225583_a_(u2, v2);
    }

    private void func_227828_a_(VertexFormat vertexFormatIn) {
        if (this.field_179011_q != vertexFormatIn) {
            this.field_179011_q = vertexFormatIn;
            boolean flag = vertexFormatIn == DefaultVertexFormats.field_227849_i_;
            boolean flag1 = vertexFormatIn == DefaultVertexFormats.field_176600_a;
            this.field_227826_s_ = flag || flag1;
            this.field_227827_t_ = flag;
        }
    }

    public void func_178977_d() {
        if (!this.field_179010_r) {
            throw new IllegalStateException("Not building!");
        }
        this.field_179010_r = false;
        MultiTextureData mtd = this.multiTextureBuilder.build(this.field_178997_d, this.renderType, this.quadSprites);
        this.field_227821_i_.add(new DrawState(this.field_179011_q, this.field_178997_d, this.field_179006_k, mtd, null));
        this.renderType = null;
        this.renderBlocks = false;
        if (this.quadSprites != null) {
            this.quadSpritesPrev = this.quadSprites;
        }
        this.quadSprites = null;
        this.quadSprite = null;
        this.field_227823_k_ += this.field_178997_d * this.field_179011_q.func_177338_f();
        this.field_178997_d = 0;
        this.field_181677_f = null;
        this.field_181678_g = 0;
    }

    public void func_225589_a_(int indexIn, byte byteIn) {
        this.field_179001_a.put(this.field_227824_l_ + indexIn, byteIn);
    }

    public void func_225591_a_(int indexIn, short shortIn) {
        this.field_179001_a.putShort(this.field_227824_l_ + indexIn, shortIn);
    }

    public void func_225590_a_(int indexIn, float floatIn) {
        this.field_179001_a.putFloat(this.field_227824_l_ + indexIn, floatIn);
    }

    public void func_181675_d() {
        if (this.field_181678_g != 0) {
            throw new IllegalStateException("Not filled all elements of the vertex");
        }
        ++this.field_178997_d;
        this.func_227831_b_();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertex((BufferBuilder)this);
        }
    }

    public void func_181667_k() {
        VertexFormatElement vertexformatelement;
        ImmutableList immutablelist = this.field_179011_q.func_227894_c_();
        this.field_181678_g = (this.field_181678_g + 1) % immutablelist.size();
        this.field_227824_l_ += this.field_181677_f.func_177368_f();
        this.field_181677_f = vertexformatelement = (VertexFormatElement)immutablelist.get(this.field_181678_g);
        if (vertexformatelement.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
        if (this.field_227854_a_ && this.field_181677_f.func_177375_c() == VertexFormatElement.Usage.COLOR) {
            super.func_225586_a_(this.field_227855_b_, this.field_227856_c_, this.field_227857_d_, this.field_227858_e_);
        }
    }

    public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        return super.func_225586_a_(red, green, blue, alpha);
    }

    public void func_225588_a_(float x2, float y2, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        if (this.field_227854_a_) {
            throw new IllegalStateException();
        }
        if (this.field_227826_s_) {
            int i2;
            this.func_225590_a_(0, x2);
            this.func_225590_a_(4, y2);
            this.func_225590_a_(8, z);
            this.func_225589_a_(12, (byte)(red * 255.0f));
            this.func_225589_a_(13, (byte)(green * 255.0f));
            this.func_225589_a_(14, (byte)(blue * 255.0f));
            this.func_225589_a_(15, (byte)(alpha * 255.0f));
            this.func_225590_a_(16, texU);
            this.func_225590_a_(20, texV);
            if (this.field_227827_t_) {
                this.func_225591_a_(24, (short)(overlayUV & 0xFFFF));
                this.func_225591_a_(26, (short)(overlayUV >> 16 & 0xFFFF));
                i2 = 28;
            } else {
                i2 = 24;
            }
            this.func_225591_a_(i2 + 0, (short)(lightmapUV & 0xFFFF));
            this.func_225591_a_(i2 + 2, (short)(lightmapUV >> 16 & 0xFFFF));
            this.func_225589_a_(i2 + 4, IVertexConsumer.func_227846_a_((float)normalX));
            this.func_225589_a_(i2 + 5, IVertexConsumer.func_227846_a_((float)normalY));
            this.func_225589_a_(i2 + 6, IVertexConsumer.func_227846_a_((float)normalZ));
            this.field_227824_l_ += this.field_179011_q.func_177338_f();
            this.func_181675_d();
        } else {
            super.func_225588_a_(x2, y2, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    public Pair<DrawState, ByteBuffer> func_227832_f_() {
        DrawState bufferbuilder$drawstate = (DrawState)this.field_227821_i_.get(this.field_227822_j_++);
        ((Buffer)this.field_179001_a).position(this.field_227825_m_);
        this.field_227825_m_ += bufferbuilder$drawstate.func_227839_b_() * bufferbuilder$drawstate.func_227838_a_().func_177338_f();
        ((Buffer)this.field_179001_a).limit(this.field_227825_m_);
        if (this.field_227822_j_ == this.field_227821_i_.size() && this.field_178997_d == 0) {
            this.func_178965_a();
        }
        ByteBuffer bytebuffer = this.field_179001_a.slice();
        bytebuffer.order(this.field_179001_a.order());
        ((Buffer)this.field_179001_a).clear();
        if (DrawState.access$400((DrawState)bufferbuilder$drawstate) == 7 && Config.isQuadsToTriangles()) {
            if (this.byteBufferTriangles == null) {
                this.byteBufferTriangles = GLAllocation.func_74524_c((int)(this.field_179001_a.capacity() * 2));
            }
            if (this.byteBufferTriangles.capacity() < this.field_179001_a.capacity() * 2) {
                this.byteBufferTriangles = GLAllocation.func_74524_c((int)(this.field_179001_a.capacity() * 2));
            }
            VertexFormat vfQuads = bufferbuilder$drawstate.func_227838_a_();
            int vcQuads = bufferbuilder$drawstate.func_227839_b_();
            BufferBuilder.quadsToTriangles((ByteBuffer)bytebuffer, (VertexFormat)vfQuads, (int)vcQuads, (ByteBuffer)this.byteBufferTriangles);
            VertexFormat vfTriangles = vfQuads;
            int vcTriangles = vcQuads * 6 / 4;
            DrawState stateTriangles = new DrawState(vfTriangles, vcTriangles, 4, null);
            return Pair.of((Object)stateTriangles, (Object)this.byteBufferTriangles);
        }
        return Pair.of((Object)bufferbuilder$drawstate, (Object)bytebuffer);
    }

    public void func_178965_a() {
        if (this.field_227823_k_ != this.field_227825_m_) {
            field_187316_a.warn("Bytes mismatch " + this.field_227823_k_ + " " + this.field_227825_m_);
        }
        this.func_227833_h_();
    }

    public void func_227833_h_() {
        this.field_227823_k_ = 0;
        this.field_227825_m_ = 0;
        this.field_227824_l_ = 0;
        this.field_227821_i_.clear();
        this.field_227822_j_ = 0;
        this.quadSprite = null;
    }

    public VertexFormatElement func_225592_i_() {
        if (this.field_181677_f == null) {
            throw new IllegalStateException("BufferBuilder not started");
        }
        return this.field_181677_f;
    }

    public boolean func_227834_j_() {
        return this.field_179010_r;
    }

    public void putSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            int countQuads = this.field_178997_d / 4;
            this.quadSprites[countQuads] = sprite;
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.isTerrain() && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            this.quadSprite = sprite;
        }
    }

    public boolean isMultiTexture() {
        return this.quadSprites != null;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderBlocks(boolean renderBlocks) {
        this.renderBlocks = renderBlocks;
        if (Config.isMultiTexture()) {
            this.initQuadSprites();
        }
    }

    public void setBlockLayer(RenderType layer) {
        this.renderType = layer;
        this.renderBlocks = true;
    }

    private void initQuadSprites() {
        if (!this.renderBlocks) {
            return;
        }
        if (this.renderType == null) {
            return;
        }
        if (this.quadSprites != null) {
            return;
        }
        if (!this.field_179010_r) {
            return;
        }
        if (this.field_178997_d > 0) {
            int drawModePrev = this.field_179006_k;
            VertexFormat vertexFormatPrev = this.field_179011_q;
            RenderType renderTypePrev = this.renderType;
            boolean renderBlocksPrev = this.renderBlocks;
            this.renderType.func_228631_a_(this, 0, 0, 0);
            this.func_181668_a(drawModePrev, vertexFormatPrev);
            this.renderType = renderTypePrev;
            this.renderBlocks = renderBlocksPrev;
        }
        this.quadSprites = this.quadSpritesPrev;
        if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
            this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
        }
    }

    private int getBufferQuadSize() {
        int quadSize = this.field_179001_a.capacity() / this.field_179011_q.func_177338_f();
        return quadSize;
    }

    public RenderEnv getRenderEnv(BlockState blockStateIn, BlockPos blockPosIn) {
        if (this.renderEnv == null) {
            this.renderEnv = new RenderEnv(blockStateIn, blockPosIn);
            return this.renderEnv;
        }
        this.renderEnv.reset(blockStateIn, blockPosIn);
        return this.renderEnv;
    }

    private static void quadsToTriangles(ByteBuffer byteBuffer, VertexFormat vertexFormat, int vertexCount, ByteBuffer byteBufferTriangles) {
        int vertexSize = vertexFormat.func_177338_f();
        int limit = byteBuffer.limit();
        byteBuffer.rewind();
        byteBufferTriangles.clear();
        for (int v2 = 0; v2 < vertexCount; v2 += 4) {
            byteBuffer.limit((v2 + 3) * vertexSize);
            byteBuffer.position(v2 * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v2 + 1) * vertexSize);
            byteBuffer.position(v2 * vertexSize);
            byteBufferTriangles.put(byteBuffer);
            byteBuffer.limit((v2 + 2 + 2) * vertexSize);
            byteBuffer.position((v2 + 2) * vertexSize);
            byteBufferTriangles.put(byteBuffer);
        }
        byteBuffer.limit(limit);
        byteBuffer.rewind();
        byteBufferTriangles.flip();
    }

    public int getDrawMode() {
        return this.field_179006_k;
    }

    public int getVertexCount() {
        return this.field_178997_d;
    }

    public Vector3f getTempVec3f(Vector3f vec) {
        this.tempVec3f.func_195905_a(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
        return this.tempVec3f;
    }

    public Vector3f getTempVec3f(float x2, float y2, float z) {
        this.tempVec3f.func_195905_a(x2, y2, z);
        return this.tempVec3f;
    }

    public float[] getTempFloat4(float f1, float f2, float f3, float f4) {
        this.tempFloat4[0] = f1;
        this.tempFloat4[1] = f2;
        this.tempFloat4[2] = f3;
        this.tempFloat4[3] = f4;
        return this.tempFloat4;
    }

    public int[] getTempInt4(int i1, int i2, int i3, int i4) {
        this.tempInt4[0] = i1;
        this.tempInt4[1] = i2;
        this.tempInt4[2] = i3;
        this.tempInt4[3] = i4;
        return this.tempInt4;
    }

    public ByteBuffer getByteBuffer() {
        return this.field_179001_a;
    }

    public FloatBuffer getFloatBuffer() {
        return this.floatBuffer;
    }

    public IntBuffer getIntBuffer() {
        return this.intBuffer;
    }

    public int getBufferIntSize() {
        return this.field_178997_d * this.field_179011_q.func_181719_f();
    }

    private FloatBuffer getFloatBufferSort(int size) {
        if (this.floatBufferSort == null || this.floatBufferSort.capacity() < size) {
            this.floatBufferSort = GLAllocation.func_74529_h((int)size);
        }
        return this.floatBufferSort;
    }

    public IRenderTypeBuffer.Impl getRenderTypeBuffer() {
        return this.renderTypeBuffer;
    }

    public void setRenderTypeBuffer(IRenderTypeBuffer.Impl renderTypeBuffer) {
        this.renderTypeBuffer = renderTypeBuffer;
    }

    public void addVertexText(float x2, float y2, float z, int red, int green, int blue, int alpha, float texU, float texV, int lightmapU, int lightmapV) {
        if (this.field_179011_q.func_177338_f() != DefaultVertexFormats.field_227852_q_.func_177338_f()) {
            throw new IllegalStateException("Invalid text vertex format: " + this.field_179011_q);
        }
        this.func_225590_a_(0, x2);
        this.func_225590_a_(4, y2);
        this.func_225590_a_(8, z);
        this.func_225589_a_(12, (byte)red);
        this.func_225589_a_(13, (byte)green);
        this.func_225589_a_(14, (byte)blue);
        this.func_225589_a_(15, (byte)alpha);
        this.func_225590_a_(16, texU);
        this.func_225590_a_(20, texV);
        this.func_225591_a_(24, (short)lightmapU);
        this.func_225591_a_(26, (short)lightmapV);
        this.field_227824_l_ += this.field_179011_q.func_177338_f();
        this.func_181675_d();
    }

    public void setQuadVertexPositions(VertexPosition[] vps) {
        this.quadVertexPositions = vps;
    }

    public VertexPosition[] getQuadVertexPositions() {
        return this.quadVertexPositions;
    }

    public void setMidBlock(float mx, float my, float mz) {
        this.midBlock.func_195905_a(mx, my, mz);
    }

    public Vector3f getMidBlock() {
        return this.midBlock;
    }

    public void putBulkData(ByteBuffer buffer) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertexData((BufferBuilder)this, (ByteBuffer)buffer);
        }
        this.func_181670_b(buffer.limit() + this.field_179011_q.func_177338_f());
        this.field_179001_a.position(this.field_178997_d * this.field_179011_q.func_177338_f());
        this.field_179001_a.put(buffer);
        this.field_178997_d += buffer.limit() / this.field_179011_q.func_177338_f();
        this.field_227824_l_ += buffer.limit();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertexData((BufferBuilder)this);
        }
    }

    public VertexFormat getVertexFormat() {
        return this.field_179011_q;
    }

    public int getStartPosition() {
        return this.field_227823_k_;
    }

    public int getIntStartPosition() {
        return this.field_227823_k_ / 4;
    }
}

