/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.optifine.Config;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpRequest;
import net.optifine.http.HttpResponse;
import net.optifine.player.CapeImageBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadingTexture
extends SimpleTexture {
    private static final Logger field_147644_c = LogManager.getLogger();
    @Nullable
    private final File field_152434_e;
    private final String field_110562_b;
    private final boolean field_229154_h_;
    @Nullable
    private final Runnable field_229155_i_;
    @Nullable
    private CompletableFuture<?> field_229156_j_;
    private boolean field_110559_g;
    public Boolean imageFound = null;
    public boolean pipeline = false;
    private boolean uploadPending = false;

    public DownloadingTexture(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, boolean legacySkinIn, @Nullable Runnable processTaskIn) {
        super(textureResourceLocation);
        this.field_152434_e = cacheFileIn;
        this.field_110562_b = imageUrlIn;
        this.field_229154_h_ = legacySkinIn;
        this.field_229155_i_ = processTaskIn;
    }

    private void func_195417_a(NativeImage nativeImageIn) {
        if (this.field_229155_i_ instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.field_229155_i_;
            nativeImageIn = cib.parseUserSkin(nativeImageIn);
            cib.skinAvailable();
        }
        this.setImageImpl(nativeImageIn);
    }

    private void setImageImpl(NativeImage nativeImageIn) {
        if (this.field_229155_i_ != null) {
            this.field_229155_i_.run();
        }
        Minecraft.func_71410_x().execute(() -> {
            this.field_110559_g = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.func_229160_b_(nativeImageIn));
            } else {
                this.func_229160_b_(nativeImageIn);
            }
        });
    }

    private void func_229160_b_(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
        this.imageFound = imageIn != null;
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.field_110559_g) {
                try {
                    super.func_195413_a(manager);
                }
                catch (IOException ioexception) {
                    field_147644_c.warn("Failed to load texture: {}", (Object)this.field_110568_b, (Object)ioexception);
                }
                this.field_110559_g = true;
            }
        });
        if (this.field_229156_j_ == null) {
            NativeImage nativeimage;
            if (this.field_152434_e != null && this.field_152434_e.isFile()) {
                field_147644_c.debug("Loading http texture from local cache ({})", (Object)this.field_152434_e);
                FileInputStream fileinputstream = new FileInputStream(this.field_152434_e);
                nativeimage = this.func_229159_a_((InputStream)fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.func_195417_a(nativeimage);
                this.loadingFinished();
            } else {
                this.field_229156_j_ = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    field_147644_c.debug("Downloading http texture from {} to {}", (Object)this.field_110562_b, (Object)this.field_152434_e);
                    if (this.shouldPipeline()) {
                        this.loadPipelined();
                        return;
                    }
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.field_110562_b).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.field_152434_e != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.field_152434_e);
                                inputstream = new FileInputStream(this.field_152434_e);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.func_229159_a_(inputstream);
                                if (nativeimage1 != null) {
                                    this.func_195417_a(nativeimage1);
                                    this.loadingFinished();
                                }
                            });
                            this.uploadPending = true;
                            return;
                        }
                        if (httpurlconnection.getErrorStream() != null) {
                            Config.readAll(httpurlconnection.getErrorStream());
                        }
                    }
                    catch (Exception exception) {
                        field_147644_c.error("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                        this.loadingFinished();
                    }
                }, this.getExecutor());
            }
        }
    }

    @Nullable
    private NativeImage func_229159_a_(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
            if (this.field_229154_h_) {
                nativeimage = DownloadingTexture.func_229163_c_((NativeImage)nativeimage);
            }
        }
        catch (IOException ioexception) {
            field_147644_c.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }

    private boolean shouldPipeline() {
        if (!this.pipeline) {
            return false;
        }
        Proxy proxy = Minecraft.func_71410_x().func_110437_J();
        if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
            return false;
        }
        return this.field_110562_b.startsWith("http://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPipelined() {
        try {
            HttpRequest req = HttpPipeline.makeRequest(this.field_110562_b, Minecraft.func_71410_x().func_110437_J());
            HttpResponse resp = HttpPipeline.executeRequest(req);
            if (resp.getStatus() / 100 == 2) {
                NativeImage ni;
                byte[] body = resp.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                if (this.field_152434_e != null) {
                    FileUtils.copyInputStreamToFile((InputStream)bais, (File)this.field_152434_e);
                    ni = NativeImage.func_195713_a((InputStream)new FileInputStream(this.field_152434_e));
                } else {
                    ni = NativeImage.func_195713_a((InputStream)bais);
                }
                this.func_195417_a(ni);
                this.uploadPending = true;
                return;
            }
        }
        catch (Exception var6) {
            field_147644_c.error("Couldn't download http texture: " + var6.getClass().getName() + ": " + var6.getMessage());
            return;
        }
        finally {
            this.loadingFinished();
        }
    }

    private void loadingFinished() {
        if (this.uploadPending) {
            return;
        }
        if (this.field_229155_i_ instanceof CapeImageBuffer) {
            CapeImageBuffer cib = (CapeImageBuffer)this.field_229155_i_;
            cib.cleanup();
        }
    }

    public Runnable getProcessTask() {
        return this.field_229155_i_;
    }

    private Executor getExecutor() {
        if (this.field_110562_b.startsWith("http://s.optifine.net")) {
            return Util.getCapeExecutor();
        }
        return Util.func_215072_e();
    }

    private static NativeImage func_229163_c_(NativeImage nativeImageIn) {
        boolean flag;
        boolean bl = flag = nativeImageIn.func_195714_b() == 32;
        if (flag) {
            NativeImage nativeimage = new NativeImage(64, 64, true);
            nativeimage.func_195703_a(nativeImageIn);
            nativeImageIn.close();
            nativeImageIn = nativeimage;
            nativeimage.func_195715_a(0, 32, 64, 32, 0);
            nativeimage.func_195699_a(4, 16, 16, 32, 4, 4, true, false);
            nativeimage.func_195699_a(8, 16, 16, 32, 4, 4, true, false);
            nativeimage.func_195699_a(0, 20, 24, 32, 4, 12, true, false);
            nativeimage.func_195699_a(4, 20, 16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(8, 20, 8, 32, 4, 12, true, false);
            nativeimage.func_195699_a(12, 20, 16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(44, 16, -8, 32, 4, 4, true, false);
            nativeimage.func_195699_a(48, 16, -8, 32, 4, 4, true, false);
            nativeimage.func_195699_a(40, 20, 0, 32, 4, 12, true, false);
            nativeimage.func_195699_a(44, 20, -8, 32, 4, 12, true, false);
            nativeimage.func_195699_a(48, 20, -16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(52, 20, -8, 32, 4, 12, true, false);
        }
        DownloadingTexture.func_229161_b_((NativeImage)nativeImageIn, (int)0, (int)0, (int)32, (int)16);
        if (flag) {
            DownloadingTexture.func_229158_a_((NativeImage)nativeImageIn, (int)32, (int)0, (int)64, (int)32);
        }
        DownloadingTexture.func_229161_b_((NativeImage)nativeImageIn, (int)0, (int)16, (int)64, (int)32);
        DownloadingTexture.func_229161_b_((NativeImage)nativeImageIn, (int)16, (int)48, (int)48, (int)64);
        return nativeImageIn;
    }

    private static void func_229158_a_(NativeImage image, int x2, int y2, int width, int height) {
        for (int i2 = x2; i2 < width; ++i2) {
            for (int j2 = y2; j2 < height; ++j2) {
                int k2 = image.func_195709_a(i2, j2);
                if ((k2 >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l2 = x2; l2 < width; ++l2) {
            for (int i1 = y2; i1 < height; ++i1) {
                image.func_195700_a(l2, i1, image.func_195709_a(l2, i1) & 0xFFFFFF);
            }
        }
    }

    private static void func_229161_b_(NativeImage image, int x2, int y2, int width, int height) {
        for (int i2 = x2; i2 < width; ++i2) {
            for (int j2 = y2; j2 < height; ++j2) {
                image.func_195700_a(i2, j2, image.func_195709_a(i2, j2) | 0xFF000000);
            }
        }
    }
}

