/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import net.optifine.Config;
import net.optifine.util.NativeMemory;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class NativeImage
implements AutoCloseable {
    private static final Logger field_227785_a_ = LogManager.getLogger();
    private static final Set<StandardOpenOption> field_209272_a = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final PixelFormat field_211680_b;
    private final int field_195719_a;
    private final int field_195720_b;
    private final boolean field_195721_c;
    private long field_195722_d;
    private final long field_195723_e;

    public NativeImage(int widthIn, int heightIn, boolean clear) {
        this(PixelFormat.RGBA, widthIn, heightIn, clear);
    }

    public NativeImage(PixelFormat pixelFormatIn, int widthIn, int heightIn, boolean initialize) {
        this.field_211680_b = pixelFormatIn;
        this.field_195719_a = widthIn;
        this.field_195720_b = heightIn;
        this.field_195723_e = (long)widthIn * (long)heightIn * (long)pixelFormatIn.func_211651_a();
        this.field_195721_c = false;
        this.field_195722_d = initialize ? MemoryUtil.nmemCalloc((long)1L, (long)this.field_195723_e) : MemoryUtil.nmemAlloc((long)this.field_195723_e);
        this.func_195696_g();
        NativeMemory.imageAllocated((NativeImage)this);
    }

    private NativeImage(PixelFormat pixelFormatIn, int widthIn, int heightIn, boolean stbiPointerIn, long pointer) {
        this.field_211680_b = pixelFormatIn;
        this.field_195719_a = widthIn;
        this.field_195720_b = heightIn;
        this.field_195721_c = stbiPointerIn;
        this.field_195722_d = pointer;
        this.field_195723_e = widthIn * heightIn * pixelFormatIn.func_211651_a();
    }

    public String toString() {
        return "NativeImage[" + this.field_211680_b + " " + this.field_195719_a + "x" + this.field_195720_b + "@" + this.field_195722_d + (this.field_195721_c ? "S" : "N") + "]";
    }

    public static NativeImage func_195713_a(InputStream inputStreamIn) throws IOException {
        return NativeImage.func_211679_a((PixelFormat)PixelFormat.RGBA, (InputStream)inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage func_211679_a(@Nullable PixelFormat pixelFormatIn, InputStream inputStreamIn) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.func_225684_a_((InputStream)inputStreamIn);
            ((Buffer)bytebuffer).rewind();
            nativeimage = NativeImage.func_211677_a((PixelFormat)pixelFormatIn, (ByteBuffer)bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)inputStreamIn);
        }
        return nativeimage;
    }

    public static NativeImage func_195704_a(ByteBuffer byteBufferIn) throws IOException {
        return NativeImage.func_211677_a((PixelFormat)PixelFormat.RGBA, (ByteBuffer)byteBufferIn);
    }

    public static NativeImage func_211677_a(@Nullable PixelFormat pixelFormatIn, ByteBuffer byteBufferIn) throws IOException {
        NativeImage nativeimage;
        if (pixelFormatIn != null && !pixelFormatIn.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to read format " + pixelFormatIn);
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBufferIn) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pixelFormatIn == null ? 0 : PixelFormat.access$000((PixelFormat)pixelFormatIn)));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new NativeImage(pixelFormatIn == null ? PixelFormat.access$100((int)intbuffer2.get(0)) : pixelFormatIn, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
            NativeMemory.imageAllocated((NativeImage)nativeimage);
        }
        return nativeimage;
    }

    public static void func_195707_b(boolean clamp) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (clamp) {
            GlStateManager.func_227677_b_((int)3553, (int)10242, (int)33071);
            GlStateManager.func_227677_b_((int)3553, (int)10243, (int)33071);
        } else {
            GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10497);
            GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10497);
        }
    }

    public static void func_195705_a(boolean linear, boolean mipmap) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (linear) {
            GlStateManager.func_227677_b_((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9729);
        } else {
            int mipmapType = Config.getMipmapType();
            GlStateManager.func_227677_b_((int)3553, (int)10241, (int)(mipmap ? mipmapType : 9728));
            GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9728);
        }
    }

    private void func_195696_g() {
        if (this.field_195722_d == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.field_195722_d != 0L) {
            if (this.field_195721_c) {
                STBImage.nstbi_image_free((long)this.field_195722_d);
            } else {
                MemoryUtil.nmemFree((long)this.field_195722_d);
            }
            NativeMemory.imageFreed((NativeImage)this);
        }
        this.field_195722_d = 0L;
    }

    public int func_195702_a() {
        return this.field_195719_a;
    }

    public int func_195714_b() {
        return this.field_195720_b;
    }

    public PixelFormat func_211678_c() {
        return this.field_211680_b;
    }

    public int func_195709_a(int x2, int y2) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", this.field_211680_b));
        }
        if (x2 >= 0 && y2 >= 0 && x2 < this.field_195719_a && y2 < this.field_195720_b) {
            this.func_195696_g();
            long i2 = (x2 + y2 * this.field_195719_a) * 4;
            return MemoryUtil.memGetInt((long)(this.field_195722_d + i2));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y2, this.field_195719_a, this.field_195720_b));
    }

    public void func_195700_a(int x2, int y2, int value) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", this.field_211680_b));
        }
        if (x2 < 0 || y2 < 0 || x2 >= this.field_195719_a || y2 >= this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y2, this.field_195719_a, this.field_195720_b));
        }
        this.func_195696_g();
        long i2 = (x2 + y2 * this.field_195719_a) * 4;
        MemoryUtil.memPutInt((long)(this.field_195722_d + i2), (int)value);
    }

    public byte func_211675_e(int x2, int y2) {
        if (!this.field_211680_b.func_211653_r()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", this.field_211680_b));
        }
        if (x2 >= 0 && y2 >= 0 && x2 < this.field_195719_a && y2 < this.field_195720_b) {
            int i2 = (x2 + y2 * this.field_195719_a) * this.field_211680_b.func_211651_a() + this.field_211680_b.func_211647_v() / 8;
            return MemoryUtil.memGetByte((long)(this.field_195722_d + (long)i2));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x2, y2, this.field_195719_a, this.field_195720_b));
    }

    @Deprecated
    public int[] func_195716_c() {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.func_195696_g();
        int[] aint = new int[this.func_195702_a() * this.func_195714_b()];
        for (int i2 = 0; i2 < this.func_195714_b(); ++i2) {
            for (int j2 = 0; j2 < this.func_195702_a(); ++j2) {
                int l1;
                int k2 = this.func_195709_a(j2, i2);
                int l2 = NativeImage.func_227786_a_((int)k2);
                int i1 = NativeImage.func_227795_d_((int)k2);
                int j1 = NativeImage.func_227793_c_((int)k2);
                int k1 = NativeImage.func_227791_b_((int)k2);
                aint[j2 + i2 * this.func_195702_a()] = l1 = l2 << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void func_195697_a(int level, int xOffset, int yOffset, boolean autoClose) {
        this.func_227788_a_(level, xOffset, yOffset, 0, 0, this.field_195719_a, this.field_195720_b, false, autoClose);
    }

    public void func_227788_a_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean mipmap, boolean autoClose) {
        this.func_227789_a_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, false, false, mipmap, autoClose);
    }

    public void func_227789_a_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.func_227792_b_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose));
        } else {
            this.func_227792_b_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose);
        }
    }

    private void func_227792_b_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_195696_g();
        NativeImage.func_195705_a((boolean)blur, (boolean)mipmap);
        NativeImage.func_195707_b((boolean)clamp);
        if (widthIn == this.func_195702_a()) {
            GlStateManager.func_227748_o_((int)3314, (int)0);
        } else {
            GlStateManager.func_227748_o_((int)3314, (int)this.func_195702_a());
        }
        GlStateManager.func_227748_o_((int)3316, (int)unpackSkipPixels);
        GlStateManager.func_227748_o_((int)3315, (int)unpackSkipRows);
        this.field_211680_b.func_211658_c();
        GlStateManager.func_227646_a_((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)widthIn, (int)heightIn, (int)this.field_211680_b.func_211650_d(), (int)5121, (long)this.field_195722_d);
        if (autoClose) {
            this.close();
        }
    }

    public void func_195717_a(int level, boolean opaque) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        GlStateManager.func_227649_a_((int)3553, (int)level, (int)this.field_211680_b.func_211650_d(), (int)5121, (long)this.field_195722_d);
        if (opaque && this.field_211680_b.func_211645_i()) {
            for (int i2 = 0; i2 < this.func_195714_b(); ++i2) {
                for (int j2 = 0; j2 < this.func_195702_a(); ++j2) {
                    this.func_195700_a(j2, i2, this.func_195709_a(j2, i2) | 255 << this.field_211680_b.func_211648_n());
                }
            }
        }
    }

    public void func_209271_a(File fileIn) throws IOException {
        this.func_209270_a(fileIn.toPath());
    }

    public void func_211676_a(STBTTFontinfo info, int glyphIndex, int widthIn, int heightIn, float scaleX, float scaleY, float shiftX, float shiftY, int x2, int y2) {
        if (x2 >= 0 && x2 + widthIn <= this.func_195702_a() && y2 >= 0 && y2 + heightIn <= this.func_195714_b()) {
            if (this.field_211680_b.func_211651_a() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", x2, y2, widthIn, heightIn, this.func_195702_a(), this.func_195714_b()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)info.address(), (long)(this.field_195722_d + (long)x2 + (long)(y2 * this.func_195702_a())), (int)widthIn, (int)heightIn, (int)this.func_195702_a(), (float)scaleX, (float)scaleY, (float)shiftX, (float)shiftY, (int)glyphIndex);
    }

    public void func_209270_a(Path pathIn) throws IOException {
        if (!this.field_211680_b.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to write format " + this.field_211680_b);
        }
        this.func_195696_g();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pathIn, field_209272_a, new FileAttribute[0]);){
            if (!this.func_227790_a_((WritableByteChannel)writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pathIn.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] func_227796_e_() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.func_227790_a_(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_227790_a_(WritableByteChannel channelIn) throws IOException {
        boolean flag;
        WriteCallback nativeimage$writecallback = new WriteCallback(channelIn, null);
        try {
            int i2 = Math.min(this.func_195714_b(), Integer.MAX_VALUE / this.func_195702_a() / this.field_211680_b.func_211651_a());
            if (i2 < this.func_195714_b()) {
                field_227785_a_.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.func_195714_b(), (Object)i2);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.func_195702_a(), (int)i2, (int)this.field_211680_b.func_211651_a(), (long)this.field_195722_d, (int)0) != 0) {
                nativeimage$writecallback.func_209267_a();
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void func_195703_a(NativeImage from) {
        if (from.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i2 = this.field_211680_b.func_211651_a();
        this.func_195696_g();
        from.func_195696_g();
        if (this.field_195719_a == from.field_195719_a) {
            MemoryUtil.memCopy((long)from.field_195722_d, (long)this.field_195722_d, (long)Math.min(this.field_195723_e, from.field_195723_e));
        } else {
            int j2 = Math.min(this.func_195702_a(), from.func_195702_a());
            int k2 = Math.min(this.func_195714_b(), from.func_195714_b());
            for (int l2 = 0; l2 < k2; ++l2) {
                int i1 = l2 * from.func_195702_a() * i2;
                int j1 = l2 * this.func_195702_a() * i2;
                MemoryUtil.memCopy((long)(from.field_195722_d + (long)i1), (long)(this.field_195722_d + (long)j1), (long)((long)j2 * (long)i2));
            }
        }
    }

    public void func_195715_a(int x2, int y2, int widthIn, int heightIn, int value) {
        for (int i2 = y2; i2 < y2 + heightIn; ++i2) {
            for (int j2 = x2; j2 < x2 + widthIn; ++j2) {
                this.func_195700_a(j2, i2, value);
            }
        }
    }

    public void func_195699_a(int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY) {
        for (int i2 = 0; i2 < heightIn; ++i2) {
            for (int j2 = 0; j2 < widthIn; ++j2) {
                int k2 = mirrorX ? widthIn - 1 - j2 : j2;
                int l2 = mirrorY ? heightIn - 1 - i2 : i2;
                int i1 = this.func_195709_a(xFrom + j2, yFrom + i2);
                this.func_195700_a(xFrom + xToDelta + k2, yFrom + yToDelta + l2, i1);
            }
        }
    }

    public void func_195710_e() {
        this.func_195696_g();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i2 = this.field_211680_b.func_211651_a();
            int j2 = this.func_195702_a() * i2;
            long k2 = memorystack.nmalloc(j2);
            for (int l2 = 0; l2 < this.func_195714_b() / 2; ++l2) {
                int i1 = l2 * this.func_195702_a() * i2;
                int j1 = (this.func_195714_b() - 1 - l2) * this.func_195702_a() * i2;
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)i1), (long)k2, (long)j2);
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)j1), (long)(this.field_195722_d + (long)i1), (long)j2);
                MemoryUtil.memCopy((long)k2, (long)(this.field_195722_d + (long)j1), (long)j2);
            }
        }
    }

    public void func_195708_a(int xIn, int yIn, int widthIn, int heightIn, NativeImage imageIn) {
        this.func_195696_g();
        if (imageIn.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i2 = this.field_211680_b.func_211651_a();
        STBImageResize.nstbir_resize_uint8((long)(this.field_195722_d + (long)((xIn + yIn * this.func_195702_a()) * i2)), (int)widthIn, (int)heightIn, (int)(this.func_195702_a() * i2), (long)imageIn.field_195722_d, (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b(), (int)0, (int)i2);
    }

    public void func_195711_f() {
        LWJGLMemoryUntracker.func_197933_a((long)this.field_195722_d);
    }

    public static NativeImage func_216511_b(String stringIn) throws IOException {
        NativeImage nativeimage;
        byte[] abyte = Base64.getDecoder().decode(stringIn.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            ((Buffer)bytebuffer).rewind();
            nativeimage = NativeImage.func_195704_a((ByteBuffer)bytebuffer);
        }
        return nativeimage;
    }

    public static int func_227786_a_(int col) {
        return col >> 24 & 0xFF;
    }

    public static int func_227791_b_(int col) {
        return col >> 0 & 0xFF;
    }

    public static int func_227793_c_(int col) {
        return col >> 8 & 0xFF;
    }

    public static int func_227795_d_(int col) {
        return col >> 16 & 0xFF;
    }

    public static int func_227787_a_(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public IntBuffer getBufferRGBA() {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", this.field_211680_b));
        }
        this.func_195696_g();
        return MemoryUtil.memIntBuffer((long)this.field_195722_d, (int)((int)this.field_195723_e));
    }

    public void fillRGBA(int rgba) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", this.field_211680_b));
        }
        this.func_195696_g();
        MemoryUtil.memSet((long)this.field_195722_d, (int)rgba, (long)this.field_195723_e);
    }

    public long getSize() {
        return this.field_195723_e;
    }

    public void downloadFromFramebuffer(boolean opaque) {
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        if (opaque) {
            GlStateManager.func_227675_b_((int)3357, (float)Float.MAX_VALUE);
        }
        GlStateManager.readPixels((int)0, (int)0, (int)this.field_195719_a, (int)this.field_195720_b, (int)this.field_211680_b.func_211650_d(), (int)5121, (long)this.field_195722_d);
        if (opaque) {
            GlStateManager.func_227675_b_((int)3357, (float)0.0f);
        }
    }
}

