/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.ShieldModel;
import net.minecraft.client.renderer.entity.model.TridentModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ConduitTileEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TrappedChestTileEntity;
import net.minecraft.util.Direction;
import net.optifine.EmissiveTextures;
import org.apache.commons.lang3.StringUtils;

public class ItemStackTileEntityRenderer {
    private static final ShulkerBoxTileEntity[] field_191274_b = (ShulkerBoxTileEntity[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::func_196059_a)).map(ShulkerBoxTileEntity::new).toArray(ShulkerBoxTileEntity[]::new);
    private static final ShulkerBoxTileEntity field_204401_c = new ShulkerBoxTileEntity((DyeColor)null);
    public static final ItemStackTileEntityRenderer field_147719_a = new ItemStackTileEntityRenderer();
    private final ChestTileEntity field_147717_b = new ChestTileEntity();
    private final ChestTileEntity field_147718_c = new TrappedChestTileEntity();
    private final EnderChestTileEntity field_147716_d = new EnderChestTileEntity();
    private final BannerTileEntity field_179024_e = new BannerTileEntity();
    private final BedTileEntity field_193843_g = new BedTileEntity();
    private final ConduitTileEntity field_205085_j = new ConduitTileEntity();
    private final ShieldModel field_187318_g = new ShieldModel();
    public TridentModel field_203084_j = new TridentModel();

    public void func_239207_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (EmissiveTextures.isActive()) {
            EmissiveTextures.beginRender();
        }
        this.renderRaw(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        if (EmissiveTextures.isActive()) {
            if (EmissiveTextures.hasEmissive()) {
                EmissiveTextures.beginRenderEmissive();
                this.renderRaw(itemStackIn, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn);
                EmissiveTextures.endRenderEmissive();
            }
            EmissiveTextures.endRender();
        }
    }

    public void renderRaw(ItemStack itemStackIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Item item = itemStackIn.func_77973_b();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof AbstractSkullBlock) {
                GameProfile gameprofile = null;
                if (itemStackIn.func_77942_o()) {
                    CompoundNBT compoundnbt = itemStackIn.func_77978_p();
                    if (compoundnbt.func_150297_b("SkullOwner", 10)) {
                        gameprofile = NBTUtil.func_152459_a((CompoundNBT)compoundnbt.func_74775_l("SkullOwner"));
                    } else if (compoundnbt.func_150297_b("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundnbt.func_74779_i("SkullOwner"))) {
                        GameProfile gameprofile1 = new GameProfile((UUID)null, compoundnbt.func_74779_i("SkullOwner"));
                        gameprofile = SkullTileEntity.func_174884_b((GameProfile)gameprofile1);
                        compoundnbt.func_82580_o("SkullOwner");
                        compoundnbt.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameprofile));
                    }
                }
                SkullTileEntityRenderer.func_228879_a_((Direction)null, (float)180.0f, (SkullBlock.ISkullType)((AbstractSkullBlock)block).func_196292_N_(), gameprofile, (float)0.0f, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn);
            } else {
                ConduitTileEntity tileentity;
                if (block instanceof AbstractBannerBlock) {
                    this.field_179024_e.func_195534_a(itemStackIn, ((AbstractBannerBlock)block).func_196285_M_());
                    tileentity = this.field_179024_e;
                } else if (block instanceof BedBlock) {
                    this.field_193843_g.func_193052_a(((BedBlock)block).func_196350_d());
                    tileentity = this.field_193843_g;
                } else if (block == Blocks.field_205165_jY) {
                    tileentity = this.field_205085_j;
                } else if (block == Blocks.field_150486_ae) {
                    tileentity = this.field_147717_b;
                } else if (block == Blocks.field_150477_bB) {
                    tileentity = this.field_147716_d;
                } else if (block == Blocks.field_150447_bR) {
                    tileentity = this.field_147718_c;
                } else {
                    if (!(block instanceof ShulkerBoxBlock)) {
                        return;
                    }
                    DyeColor dyecolor = ShulkerBoxBlock.func_190955_b((Item)item);
                    tileentity = dyecolor == null ? field_204401_c : field_191274_b[dyecolor.func_196059_a()];
                }
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_((TileEntity)tileentity, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
        } else if (item == Items.field_185159_cQ) {
            boolean flag = itemStackIn.func_179543_a("BlockEntityTag") != null;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(1.0f, -1.0f, -1.0f);
            RenderMaterial rendermaterial = flag ? ModelBakery.field_229316_g_ : ModelBakery.field_229317_h_;
            IVertexBuilder ivertexbuilder = rendermaterial.func_229314_c_().func_229230_a_(ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)this.field_187318_g.func_228282_a_(rendermaterial.func_229310_a_()), (boolean)true, (boolean)itemStackIn.func_77962_s()));
            this.field_187318_g.func_228294_b_().func_228309_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            if (flag) {
                List list = BannerTileEntity.func_230138_a_((DyeColor)ShieldItem.func_195979_f((ItemStack)itemStackIn), (ListNBT)BannerTileEntity.func_230139_a_((ItemStack)itemStackIn));
                BannerTileEntityRenderer.func_241717_a_((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (ModelRenderer)this.field_187318_g.func_228293_a_(), (RenderMaterial)rendermaterial, (boolean)false, (List)list, (boolean)itemStackIn.func_77962_s());
            } else {
                this.field_187318_g.func_228293_a_().func_228309_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
        } else if (item == Items.field_203184_eO) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(1.0f, -1.0f, -1.0f);
            IVertexBuilder ivertexbuilder1 = ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)this.field_203084_j.func_228282_a_(TridentModel.field_203080_a), (boolean)false, (boolean)itemStackIn.func_77962_s());
            this.field_203084_j.func_225598_a_(matrixStackIn, ivertexbuilder1, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
    }
}

