/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.optifine.Config;

public class SliderPercentageOption
extends AbstractOption {
    protected final float field_216734_Q;
    protected final double field_216735_R;
    protected double field_216736_S;
    protected Function<GameSettings, Double> field_216737_T;
    protected BiConsumer<GameSettings, Double> field_216738_U;
    protected BiFunction<GameSettings, SliderPercentageOption, ITextComponent> field_216739_V;
    protected double[] stepValues;

    public SliderPercentageOption(String translationKey, double minValueIn, double maxValueIn, float stepSizeIn, Function<GameSettings, Double> getter, BiConsumer<GameSettings, Double> setter, BiFunction<GameSettings, SliderPercentageOption, ITextComponent> getDisplayString) {
        super(translationKey);
        this.field_216735_R = minValueIn;
        this.field_216736_S = maxValueIn;
        this.field_216734_Q = stepSizeIn;
        this.field_216737_T = getter;
        this.field_216738_U = setter;
        this.field_216739_V = getDisplayString;
    }

    public SliderPercentageOption(String translationKey, double minValueIn, double maxValueIn, double[] stepValues, Function<GameSettings, Double> getter, BiConsumer<GameSettings, Double> setter, BiFunction<GameSettings, SliderPercentageOption, ITextComponent> getDisplayString) {
        super(translationKey);
        this.field_216735_R = minValueIn;
        this.field_216736_S = maxValueIn;
        this.field_216734_Q = 0.0f;
        this.field_216737_T = getter;
        this.field_216738_U = setter;
        this.field_216739_V = getDisplayString;
        this.stepValues = stepValues;
        if (stepValues != null) {
            stepValues = (double[])stepValues.clone();
            Arrays.sort(stepValues);
        }
    }

    public Widget func_216586_a(GameSettings options, int xIn, int yIn, int widthIn) {
        return new OptionSlider(options, xIn, yIn, widthIn, 20, this);
    }

    public double func_216726_a(double value) {
        return MathHelper.func_151237_a((double)((this.func_216731_c(value) - this.field_216735_R) / (this.field_216736_S - this.field_216735_R)), (double)0.0, (double)1.0);
    }

    public double func_216725_b(double value) {
        return this.func_216731_c(MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.field_216735_R, (double)this.field_216736_S));
    }

    private double func_216731_c(double valueIn) {
        if (this.field_216734_Q > 0.0f) {
            valueIn = this.field_216734_Q * (float)Math.round(valueIn / (double)this.field_216734_Q);
        }
        if (this.stepValues != null) {
            for (int i2 = 0; i2 < this.stepValues.length; ++i2) {
                double max;
                double min = i2 <= 0 ? -1.7976931348623157E308 : (this.stepValues[i2 - 1] + this.stepValues[i2]) / 2.0;
                double d2 = max = i2 >= this.stepValues.length - 1 ? Double.MAX_VALUE : (this.stepValues[i2] + this.stepValues[i2 + 1]) / 2.0;
                if (!Config.between(valueIn, min, max)) continue;
                valueIn = this.stepValues[i2];
                break;
            }
        }
        return MathHelper.func_151237_a((double)valueIn, (double)this.field_216735_R, (double)this.field_216736_S);
    }

    public double func_216732_b() {
        return this.field_216735_R;
    }

    public double func_216733_c() {
        return this.field_216736_S;
    }

    public void func_216728_a(float valueIn) {
        this.field_216736_S = valueIn;
    }

    public void func_216727_a(GameSettings options, double valueIn) {
        this.field_216738_U.accept(options, valueIn);
    }

    public double func_216729_a(GameSettings options) {
        return (Double)this.field_216737_T.apply(options);
    }

    public ITextComponent func_238334_c_(GameSettings options) {
        return (ITextComponent)this.field_216739_V.apply(options, this);
    }
}

