/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.FramebufferConstants;
import net.optifine.reflect.ReflectorForge;

public class Framebuffer {
    public int field_147622_a;
    public int field_147620_b;
    public int field_147621_c;
    public int field_147618_d;
    public final boolean field_147619_e;
    public int field_147616_f;
    private int field_147617_g;
    private int field_147624_h;
    public final float[] field_147625_i;
    public int field_147623_j;
    private boolean stencilEnabled = false;

    public Framebuffer(int widthIn, int heightIn, boolean useDepthIn, boolean onMacIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147619_e = useDepthIn;
        this.field_147616_f = -1;
        this.field_147617_g = -1;
        this.field_147624_h = -1;
        this.field_147625_i = new float[4];
        this.field_147625_i[0] = 1.0f;
        this.field_147625_i[1] = 1.0f;
        this.field_147625_i[2] = 1.0f;
        this.field_147625_i[3] = 0.0f;
        this.func_216491_a(widthIn, heightIn, onMacIn);
    }

    public void func_216491_a(int widthIn, int heightIn, boolean onMacIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227586_d_(widthIn, heightIn, onMacIn));
        } else {
            this.func_227586_d_(widthIn, heightIn, onMacIn);
        }
    }

    private void func_227586_d_(int widthIn, int heightIn, boolean onMacIn) {
        if (!GLX.isUsingFBOs()) {
            this.field_147621_c = widthIn;
            this.field_147618_d = heightIn;
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227734_k_();
        if (this.field_147616_f >= 0) {
            this.func_147608_a();
        }
        this.func_216492_b(widthIn, heightIn, onMacIn);
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0);
    }

    public void func_147608_a() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_147606_d();
        this.func_147609_e();
        if (this.field_147624_h > -1) {
            TextureUtil.func_225679_a_((int)this.field_147624_h);
            this.field_147624_h = -1;
        }
        if (this.field_147617_g > -1) {
            TextureUtil.func_225679_a_((int)this.field_147617_g);
            this.field_147617_g = -1;
        }
        if (this.field_147616_f > -1) {
            GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0);
            GlStateManager.func_227738_l_((int)this.field_147616_f);
            this.field_147616_f = -1;
        }
    }

    public void func_237506_a_(Framebuffer framebufferIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (GlStateManager.func_237508_S_()) {
            GlStateManager.func_227727_h_((int)36008, (int)framebufferIn.field_147616_f);
            GlStateManager.func_227727_h_((int)36009, (int)this.field_147616_f);
            GlStateManager.func_237510_a_((int)0, (int)0, (int)framebufferIn.field_147622_a, (int)framebufferIn.field_147620_b, (int)0, (int)0, (int)this.field_147622_a, (int)this.field_147620_b, (int)256, (int)9728);
        } else {
            GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)this.field_147616_f);
            int i2 = GlStateManager.func_237514_p_();
            if (i2 != 0) {
                int j2 = GlStateManager.func_237515_r_();
                GlStateManager.func_227760_t_((int)i2);
                GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)framebufferIn.field_147616_f);
                GlStateManager.func_237509_a_((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Math.min(this.field_147622_a, framebufferIn.field_147622_a), (int)Math.min(this.field_147620_b, framebufferIn.field_147620_b));
                GlStateManager.func_227760_t_((int)j2);
            }
        }
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0);
    }

    public void func_216492_b(int widthIn, int heightIn, boolean onMacIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147621_c = widthIn;
        this.field_147618_d = heightIn;
        this.field_147622_a = widthIn;
        this.field_147620_b = heightIn;
        if (!GLX.isUsingFBOs()) {
            this.func_216493_b(onMacIn);
            return;
        }
        this.field_147616_f = GlStateManager.func_227749_p_();
        this.field_147617_g = TextureUtil.func_225678_a_();
        if (this.field_147619_e) {
            this.field_147624_h = TextureUtil.func_225678_a_();
            GlStateManager.func_227760_t_((int)this.field_147624_h);
            GlStateManager.func_227677_b_((int)3553, (int)10241, (int)9728);
            GlStateManager.func_227677_b_((int)3553, (int)10240, (int)9728);
            GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10496);
            GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10496);
            GlStateManager.func_227677_b_((int)3553, (int)34892, (int)0);
            if (this.stencilEnabled) {
                GlStateManager.func_227647_a_((int)3553, (int)0, (int)36013, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)34041, (int)36269, null);
            } else {
                GlStateManager.func_227647_a_((int)3553, (int)0, (int)6402, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)6402, (int)5126, (IntBuffer)null);
            }
        }
        this.func_147607_a(9728);
        GlStateManager.func_227760_t_((int)this.field_147617_g);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.field_147622_a, (int)this.field_147620_b, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)this.field_147616_f);
        GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)FramebufferConstants.field_227594_c_, (int)3553, (int)this.field_147617_g, (int)0);
        if (this.field_147619_e) {
            if (this.stencilEnabled) {
                if (ReflectorForge.getForgeUseCombinedDepthStencilAttachment()) {
                    GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)33306, (int)3553, (int)this.field_147624_h, (int)0);
                } else {
                    GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)36096, (int)3553, (int)this.field_147624_h, (int)0);
                    GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)36128, (int)3553, (int)this.field_147624_h, (int)0);
                }
            } else {
                GlStateManager.func_227645_a_((int)FramebufferConstants.field_227592_a_, (int)FramebufferConstants.field_227595_d_, (int)3553, (int)this.field_147624_h, (int)0);
            }
        }
        this.func_147611_b();
        this.func_216493_b(onMacIn);
        this.func_147606_d();
    }

    public void func_147607_a(int framebufferFilterIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_147623_j = framebufferFilterIn;
        GlStateManager.func_227760_t_((int)this.field_147617_g);
        GlStateManager.func_227677_b_((int)3553, (int)10241, (int)framebufferFilterIn);
        GlStateManager.func_227677_b_((int)3553, (int)10240, (int)framebufferFilterIn);
        GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10496);
        GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10496);
        GlStateManager.func_227760_t_((int)0);
    }

    public void func_147611_b() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        int i2 = GlStateManager.func_227741_m_((int)FramebufferConstants.field_227592_a_);
        if (i2 != FramebufferConstants.field_227596_e_) {
            if (i2 == FramebufferConstants.field_227597_f_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i2 == FramebufferConstants.field_227598_g_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i2 == FramebufferConstants.field_227599_h_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i2 == FramebufferConstants.field_227600_i_) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i2);
        }
    }

    public void func_147612_c() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.func_227760_t_((int)this.field_147617_g);
    }

    public void func_147606_d() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227760_t_((int)0);
    }

    public void func_147610_a(boolean setViewportIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.func_227585_c_(setViewportIn));
        } else {
            this.func_227585_c_(setViewportIn);
        }
    }

    private void func_227585_c_(boolean setViewportIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)this.field_147616_f);
        if (setViewportIn) {
            GlStateManager.func_227714_e_((int)0, (int)0, (int)this.field_147621_c, (int)this.field_147618_d);
        }
    }

    public void func_147609_e() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0));
        } else {
            GlStateManager.func_227727_h_((int)FramebufferConstants.field_227592_a_, (int)0);
        }
    }

    public void func_147604_a(float red, float green, float blue, float alpha) {
        this.field_147625_i[0] = red;
        this.field_147625_i[1] = green;
        this.field_147625_i[2] = blue;
        this.field_147625_i[3] = alpha;
    }

    public void func_147615_c(int width, int height) {
        this.func_178038_a(width, height, true);
    }

    public void func_178038_a(int width, int height, boolean noBlend) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        if (!RenderSystem.isInInitPhase()) {
            RenderSystem.recordRenderCall(() -> this.func_227588_e_(width, height, noBlend));
        } else {
            this.func_227588_e_(width, height, noBlend);
        }
    }

    private void func_227588_e_(int width, int height, boolean noBlend) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.func_227731_j_();
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_227714_e_((int)0, (int)0, (int)width, (int)height);
        GlStateManager.func_227619_H_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227700_d_();
        if (noBlend) {
            GlStateManager.func_227737_l_();
            GlStateManager.func_227725_h_();
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147612_c();
        float f2 = width;
        float f1 = height;
        float f22 = (float)this.field_147621_c / (float)this.field_147622_a;
        float f3 = (float)this.field_147618_d / (float)this.field_147620_b;
        Tessellator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(0.0, (double)f1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)f2, (double)f1, 0.0).func_225583_a_(f22, 0.0f).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)f2, 0.0, 0.0).func_225583_a_(f22, f3).func_225586_a_(255, 255, 255, 255).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, f3).func_225586_a_(255, 255, 255, 255).func_181675_d();
        tessellator.func_78381_a();
        this.func_147606_d();
        GlStateManager.func_227667_a_((boolean)true);
        GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public void func_216493_b(boolean onMac) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_147610_a(true);
        GlStateManager.func_227673_b_((float)this.field_147625_i[0], (float)this.field_147625_i[1], (float)this.field_147625_i[2], (float)this.field_147625_i[3]);
        int i2 = 16384;
        if (this.field_147619_e) {
            GlStateManager.func_227631_a_((double)1.0);
            i2 |= 0x100;
        }
        GlStateManager.func_227658_a_((int)i2, (boolean)onMac);
        this.func_147609_e();
    }

    public int func_242996_f() {
        return this.field_147617_g;
    }

    public int func_242997_g() {
        return this.field_147624_h;
    }

    public void enableStencil() {
        if (this.stencilEnabled) {
            return;
        }
        this.stencilEnabled = true;
        this.func_216491_a(this.field_147621_c, this.field_147618_d, Minecraft.field_142025_a);
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }
}

