/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.FilledProfileResult;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IResultableProfiler;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.TimeTracker;
import net.minecraft.util.Util;
import net.optifine.Config;
import net.optifine.Lagometer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

/*
 * Exception performing whole class analysis ignored.
 */
public class Profiler
implements IResultableProfiler {
    private static final long field_219907_a = Duration.ofMillis(100L).toNanos();
    private static final Logger field_151234_b = LogManager.getLogger();
    private final List<String> field_76325_b = Lists.newArrayList();
    private final LongList field_76326_c = new LongArrayList();
    private final Map<String, Section> field_230078_e_ = Maps.newHashMap();
    private final IntSupplier field_219912_f;
    private final LongSupplier field_233501_g_;
    private final long field_219913_g;
    private final int field_219914_h;
    private String field_219915_i = "";
    private boolean field_219916_j;
    @Nullable
    private Section field_230079_k_;
    private final boolean field_226230_l_;
    private boolean clientProfiler = false;
    private boolean lagometerActive = false;
    private static final String SCHEDULED_EXECUTABLES = "scheduledExecutables";
    private static final String TICK = "tick";
    private static final String SOUND = "sound";
    private static final int HASH_SCHEDULED_EXECUTABLES = "scheduledExecutables".hashCode();
    private static final int HASH_TICK = "tick".hashCode();
    private static final int HASH_SOUND = "sound".hashCode();
    private static final ReflectorClass MINECRAFT = new ReflectorClass(Minecraft.class);
    private static final ReflectorField Minecraft_timeTracker = new ReflectorField(MINECRAFT, TimeTracker.class);

    public Profiler(LongSupplier p_i231482_1_, IntSupplier p_i231482_2_, boolean p_i231482_3_) {
        this.field_219913_g = p_i231482_1_.getAsLong();
        this.field_233501_g_ = p_i231482_1_;
        this.field_219914_h = p_i231482_2_.getAsInt();
        this.field_219912_f = p_i231482_2_;
        this.field_226230_l_ = p_i231482_3_;
    }

    public void func_219894_a() {
        TimeTracker timeTracker = (TimeTracker)Reflector.getFieldValue(Minecraft.func_71410_x(), Minecraft_timeTracker);
        this.clientProfiler = timeTracker != null && timeTracker.func_233508_d_() == this;
        boolean bl = this.lagometerActive = this.clientProfiler && Lagometer.isActive();
        if (this.field_219916_j) {
            field_151234_b.error("Profiler tick already started - missing endTick()?");
        } else {
            this.field_219916_j = true;
            this.field_219915_i = "";
            this.field_76325_b.clear();
            this.func_76320_a("root");
        }
    }

    public void func_219897_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Profiler tick already ended - missing startTick()?");
        } else {
            this.func_76319_b();
            this.field_219916_j = false;
            if (!this.field_219915_i.isEmpty()) {
                field_151234_b.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new Supplier[]{() -> IProfileResult.func_225434_b((String)this.field_219915_i)});
            }
        }
    }

    public void func_76320_a(String name) {
        if (this.lagometerActive) {
            int hashName = name.hashCode();
            if (hashName == HASH_SCHEDULED_EXECUTABLES && name.equals("scheduledExecutables")) {
                Lagometer.timerScheduledExecutables.start();
            } else if (hashName == HASH_TICK && name.equals("tick") && Config.isMinecraftThread()) {
                Lagometer.timerScheduledExecutables.end();
                Lagometer.timerTick.start();
            }
        }
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)name);
        } else {
            if (!this.field_219915_i.isEmpty()) {
                this.field_219915_i = this.field_219915_i + '\u001e';
            }
            this.field_219915_i = this.field_219915_i + name;
            this.field_76325_b.add(this.field_219915_i);
            this.field_76326_c.add(Util.func_211178_c());
            this.field_230079_k_ = null;
        }
    }

    public void func_194340_a(java.util.function.Supplier<String> nameSupplier) {
        this.func_76320_a(nameSupplier.get());
    }

    public void func_76319_b() {
        if (!this.field_219916_j) {
            field_151234_b.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
        } else if (this.field_76326_c.isEmpty()) {
            field_151234_b.error("Tried to pop one too many times! Mismatched push() and pop()?");
        } else {
            long i2 = Util.func_211178_c();
            long j2 = this.field_76326_c.removeLong(this.field_76326_c.size() - 1);
            this.field_76325_b.remove(this.field_76325_b.size() - 1);
            long k2 = i2 - j2;
            Section profiler$section = this.func_230081_e_();
            Section.access$002((Section)profiler$section, (long)((Section.access$000((Section)profiler$section) * 49L + k2) / 50L));
            Section.access$102((Section)profiler$section, (long)1L);
            if (this.field_226230_l_ && k2 > field_219907_a) {
                field_151234_b.warn("Something's taking too long! '{}' took aprox {} ms", new Supplier[]{() -> IProfileResult.func_225434_b((String)this.field_219915_i), () -> (double)k2 / 1000000.0});
            }
            this.field_219915_i = this.field_76325_b.isEmpty() ? "" : (String)this.field_76325_b.get(this.field_76325_b.size() - 1);
            this.field_230079_k_ = null;
        }
    }

    public void func_219895_b(String name) {
        int hashName;
        if (this.lagometerActive && (hashName = name.hashCode()) == HASH_SOUND && name.equals("sound")) {
            Lagometer.timerTick.end();
        }
        this.func_76319_b();
        this.func_76320_a(name);
    }

    public void func_194339_b(java.util.function.Supplier<String> nameSupplier) {
        this.func_76319_b();
        this.func_194340_a(nameSupplier);
    }

    private Section func_230081_e_() {
        if (this.field_230079_k_ == null) {
            this.field_230079_k_ = this.field_230078_e_.computeIfAbsent(this.field_219915_i, p_230080_0_ -> new Section(null));
        }
        return this.field_230079_k_;
    }

    public void func_230035_c_(String nameIn) {
        Section.access$200((Section)this.func_230081_e_()).addTo((Object)nameIn, 1L);
    }

    public void func_230036_c_(java.util.function.Supplier<String> nameSupplierIn) {
        Section.access$200((Section)this.func_230081_e_()).addTo((Object)nameSupplierIn.get(), 1L);
    }

    public IProfileResult func_219905_d() {
        return new FilledProfileResult(this.field_230078_e_, this.field_219913_g, this.field_219914_h, this.field_233501_g_.getAsLong(), this.field_219912_f.getAsInt());
    }
}

