/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.concurrent;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.optifine.Config;
import net.optifine.util.PacketRunnable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ThreadTaskExecutor<R extends Runnable>
implements ITaskExecutor<R>,
Executor {
    private final String field_213171_b;
    private static final Logger field_213172_c = LogManager.getLogger();
    private final Queue<R> field_213173_d = Queues.newConcurrentLinkedQueue();
    private int field_213174_e;

    protected ThreadTaskExecutor(String nameIn) {
        this.field_213171_b = nameIn;
    }

    protected abstract R func_212875_d_(Runnable var1);

    protected abstract boolean func_212874_c_(R var1);

    public boolean func_213162_bc() {
        return Thread.currentThread() == this.func_213170_ax();
    }

    protected abstract Thread func_213170_ax();

    protected boolean func_213164_aw() {
        return !this.func_213162_bc();
    }

    public int func_223704_be() {
        return this.field_213173_d.size();
    }

    public String func_213142_bd() {
        return this.field_213171_b;
    }

    public <V> CompletableFuture<V> func_213169_a(Supplier<V> supplier) {
        return this.func_213164_aw() ? CompletableFuture.supplyAsync(supplier, (Executor)this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> func_213165_a(Runnable taskIn) {
        return CompletableFuture.supplyAsync(() -> {
            taskIn.run();
            return null;
        }, (Executor)this);
    }

    public CompletableFuture<Void> func_222817_e(Runnable taskIn) {
        if (this.func_213164_aw()) {
            return this.func_213165_a(taskIn);
        }
        taskIn.run();
        return CompletableFuture.completedFuture(null);
    }

    public void func_213167_f(Runnable taskIn) {
        if (!this.func_213162_bc()) {
            this.func_213165_a(taskIn).join();
        } else {
            taskIn.run();
        }
    }

    public void func_212871_a_(R taskIn) {
        this.field_213173_d.add(taskIn);
        LockSupport.unpark(this.func_213170_ax());
    }

    @Override
    public void execute(Runnable p_execute_1_) {
        if (this.func_213164_aw()) {
            this.func_212871_a_(this.func_212875_d_(p_execute_1_));
        } else {
            p_execute_1_.run();
        }
    }

    protected void func_213159_be() {
        this.field_213173_d.clear();
    }

    protected void func_213160_bf() {
        int count = Integer.MAX_VALUE;
        if (Config.isLazyChunkLoading() && this == Minecraft.func_71410_x()) {
            count = this.getTaskCount();
        }
        while (this.func_213168_p() && --count > 0) {
        }
    }

    protected boolean func_213168_p() {
        Runnable r2 = (Runnable)this.field_213173_d.peek();
        if (r2 == null) {
            return false;
        }
        if (this.field_213174_e == 0 && !this.func_212874_c_(r2)) {
            return false;
        }
        this.func_213166_h((Runnable)this.field_213173_d.remove());
        return true;
    }

    public void func_213161_c(BooleanSupplier isDone) {
        ++this.field_213174_e;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.func_213168_p()) continue;
                this.func_223705_bi();
            }
        }
        finally {
            --this.field_213174_e;
        }
    }

    protected void func_223705_bi() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void func_213166_h(R taskIn) {
        block2: {
            try {
                taskIn.run();
            }
            catch (Exception exception) {
                field_213172_c.fatal("Error executing task on {}", (Object)this.func_213142_bd(), (Object)exception);
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block2;
                OutOfMemoryError oome = (OutOfMemoryError)exception.getCause();
                throw oome;
            }
        }
    }

    private int getTaskCount() {
        if (this.field_213173_d.isEmpty()) {
            return 0;
        }
        Runnable[] rs = this.field_213173_d.toArray(new Runnable[this.field_213173_d.size()]);
        double chunkUpdateWeight = this.getChunkUpdateWeight(rs);
        if (chunkUpdateWeight < 5.0) {
            return Integer.MAX_VALUE;
        }
        int queueSize = rs.length;
        int fps = Math.max(Config.getFpsAverage(), 1);
        double weight = queueSize * 10 / fps;
        int count = this.getCount(rs, weight);
        return count;
    }

    private int getCount(R[] rs, double maxWeight) {
        double weight = 0.0;
        for (int i2 = 0; i2 < rs.length; ++i2) {
            R r2 = rs[i2];
            if (!((weight += this.getChunkUpdateWeight(r2)) > maxWeight)) continue;
            return i2 + 1;
        }
        return rs.length;
    }

    private double getChunkUpdateWeight(R[] rs) {
        double weight = 0.0;
        for (int i2 = 0; i2 < rs.length; ++i2) {
            R r2 = rs[i2];
            weight += this.getChunkUpdateWeight(r2);
        }
        return weight;
    }

    private double getChunkUpdateWeight(Runnable r2) {
        if (r2 instanceof PacketRunnable) {
            PacketRunnable pr = (PacketRunnable)r2;
            IPacket p2 = pr.getPacket();
            if (p2 instanceof SChunkDataPacket) {
                return 1.0;
            }
            if (p2 instanceof SUpdateLightPacket) {
                return 0.2;
            }
            if (p2 instanceof SUnloadChunkPacket) {
                return 2.6;
            }
        }
        return 0.0;
    }
}

