/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColorFader;
import net.optifine.CustomColormap;
import net.optifine.LightMap;
import net.optifine.LightMapPack;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.render.RenderEnv;
import net.optifine.util.BiomeUtils;
import net.optifine.util.EntityUtils;
import net.optifine.util.PotionUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static dcn fogColorNether = null;
    private static dcn fogColorEnd = null;
    private static dcn skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static float[][] dyeColorsOriginal = null;
    private static int[] potionColors = null;
    private static final ceh BLOCK_STATE_DIRT = bup.j.n();
    private static final ceh BLOCK_STATE_WATER = bup.A.n();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        @Override
        public int getColor(ceh blockState, bra blockAccess, fx blockPos) {
            bsv biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampGrassColors != null && biome == BiomeUtils.SWAMP) {
                return swampGrassColors.getColor(biome, blockPos);
            }
            return biome.a((double)blockPos.u(), (double)blockPos.w());
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        @Override
        public int getColor(ceh blockState, bra blockAccess, fx blockPos) {
            bsv biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampFoliageColors != null && biome == BiomeUtils.SWAMP) {
                return swampFoliageColors.getColor(biome, blockPos);
            }
            return biome.g();
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        @Override
        public int getColor(ceh blockState, bra blockAccess, fx blockPos) {
            if (foliagePineColors != null) {
                return foliagePineColors.getColor(blockAccess, blockPos);
            }
            return brr.a();
        }

        @Override
        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        @Override
        public int getColor(ceh blockState, bra blockAccess, fx blockPos) {
            if (foliageBirchColors != null) {
                return foliageBirchColors.getColor(blockAccess, blockPos);
            }
            return brr.b();
        }

        @Override
        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        @Override
        public int getColor(ceh blockState, bra blockAccess, fx blockPos) {
            bsv biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (waterColors != null) {
                return waterColors.getColor(biome, blockPos);
            }
            return biome.m();
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        CustomColors.setDyeColors(dyeColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty("optifine/color.properties", "palette.format", CustomColormap.FORMAT_STRINGS, "vanilla");
        String mcpColormap = "optifine/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorx.png"};
        waterColors = CustomColors.getCustomColors(mcpColormap, waterPaths, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors(mcpColormap, pinePaths, 256, 256);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors(mcpColormap, birchPaths, 256, 256);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors(mcpColormap, swampGrassPaths, 256, 256);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors(mcpColormap, swampFoliagePaths, 256, 256);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors(mcpColormap, sky0Paths, 256, 256);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors(mcpColormap, fog0Paths, 256, 256);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors(mcpColormap, underwaterPaths, 256, 256);
        String[] underlavaPaths = new String[]{"underlava.png", "underlavacolor.png"};
        underlavaColors = CustomColors.getCustomColors(mcpColormap, underlavaPaths, 256, 256);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors(mcpColormap, redstonePaths, 16, 1);
        xpOrbColors = CustomColors.getCustomColors(mcpColormap + "xporb.png", -1, -1);
        durabilityColors = CustomColors.getCustomColors(mcpColormap + "durability.png", -1, -1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors(mcpColormap, stemPaths, 8, 1);
        stemPumpkinColors = CustomColors.getCustomColors(mcpColormap + "pumpkinstem.png", 8, 1);
        stemMelonColors = CustomColors.getCustomColors(mcpColormap + "melonstem.png", 8, 1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors(mcpColormap, myceliumPaths, -1, -1);
        Pair<LightMapPack[], Integer> lightMaps = CustomColors.parseLightMapPacks();
        lightMapPacks = (LightMapPack[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties("optifine/color.properties");
        blockColormaps = CustomColors.readBlockColormaps(new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, colorsBlockColormaps, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            vk loc = new vk(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return valDef;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String val = props.getProperty(key);
            if (val == null) {
                return valDef;
            }
            List<String> listValidValues = Arrays.asList(validValues);
            if (!listValidValues.contains(val)) {
                CustomColors.warn("Invalid value: " + key + "=" + val);
                CustomColors.warn("Expected values: " + Config.arrayToString(validValues));
                return valDef;
            }
            CustomColors.dbg("" + key + "=" + val);
            return val;
        }
        catch (FileNotFoundException e2) {
            return valDef;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String lightmapPrefix = "optifine/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles(lightmapPrefix, lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i2 = 0; i2 < pathsLightmap.length; ++i2) {
            String path = pathsLightmap[i2];
            String dimIdStr = StrUtils.removePrefixSuffix(path, lightmapPrefix, lightmapSuffix);
            int dimId = Config.parseInt(dimIdStr, Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + dimIdStr + ", path: " + path);
                continue;
            }
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i3 = 0; i3 < dimIds.length; ++i3) {
            Object dimId = dimIds[i3];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors(path, -1, -1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn("Invalid lightmap width: " + colors.getWidth() + ", path: " + path);
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        LightMapPack[] lmps = new LightMapPack[colormaps.length];
        for (int i4 = 0; i4 < colormaps.length; ++i4) {
            LightMapPack lmp;
            CustomColormap cm = colormaps[i4];
            if (cm == null) continue;
            String name = cm.name;
            String basePath = cm.basePath;
            CustomColormap cmRain = CustomColors.getCustomColors(basePath + "/" + name + "_rain.png", -1, -1);
            CustomColormap cmThunder = CustomColors.getCustomColors(basePath + "/" + name + "_thunder.png", -1, -1);
            LightMap lm = new LightMap(cm);
            LightMap lmRain = cmRain != null ? new LightMap(cmRain) : null;
            LightMap lmThunder = cmThunder != null ? new LightMap(cmThunder) : null;
            lmps[i4] = lmp = new LightMapPack(lm, lmRain, lmThunder);
        }
        return new ImmutablePair((Object)lmps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream(new vk(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e2) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            float[][] dyeColors;
            vk loc = new vk(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor((Properties)props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor((Properties)props, "particle.portal");
            lilyPadColor = CustomColors.readColor((Properties)props, "lilypad");
            expBarTextColor = CustomColors.readColor((Properties)props, "text.xpbar");
            bossTextColor = CustomColors.readColor((Properties)props, "text.boss");
            signTextColor = CustomColors.readColor((Properties)props, "text.sign");
            fogColorNether = CustomColors.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(props, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(props, fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(props, fileName, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(props, fileName, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(props, fileName, "text.code.", "Text");
            int[] mapColors = CustomColors.readMapColors(props, fileName, "map.", "Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(mapColors);
            }
            if ((dyeColors = CustomColors.readDyeColors(props, fileName, "dye.", "Dye")) != null) {
                if (dyeColorsOriginal == null) {
                    dyeColorsOriginal = CustomColors.getDyeColors();
                }
                CustomColors.setDyeColors(dyeColors);
            }
            potionColors = CustomColors.readPotionColors(props, fileName, "potion.", "Potion");
            xpOrbTime = Config.parseInt(props.getProperty("xporb.time"), -1);
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            Config.warn("Error parsing: " + fileName);
            Config.warn(e3.getClass().getName() + ": " + e3.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath(fileName);
            path = TextureUtils.fixResourcePath(path, basePath);
            CustomColormap colors = CustomColors.getCustomColors(path, 256, 256);
            if (colors == null) {
                CustomColors.warn("Colormap not found: " + path);
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn("Invalid match blocks: " + value);
                } else {
                    for (int m2 = 0; m2 < mbs.length; ++m2) {
                        MatchBlock mb = mbs[m2];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i2;
        Object[] paths = ResUtils.collectFiles(basePaths, new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i2 = 0; i2 < paths.length; ++i2) {
            Object path = paths[i2];
            CustomColors.dbg("Block colormap: " + (String)path);
            try {
                vk locFile = new vk("minecraft", (String)path);
                InputStream in = Config.getResourceStream(locFile);
                if (in == null) {
                    CustomColors.warn("File not found: " + (String)path);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomColormap cm = new CustomColormap(props, (String)path, width, height, paletteFormatDefault);
                if (!cm.isValid((String)path) || !cm.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList(cm, blockList);
                continue;
            }
            catch (FileNotFoundException e2) {
                CustomColors.warn("File not found: " + (String)path);
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i2 = 0; i2 < basePalettes.length; ++i2) {
                CustomColormap cm = basePalettes[i2];
                CustomColors.addToBlockList(cm, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm, List blockList) {
        int[] ids = cm.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn("No match blocks: " + Config.arrayToString(ids));
            return;
        }
        for (int i2 = 0; i2 < ids.length; ++i2) {
            int blockId = ids[i2];
            if (blockId < 0) {
                CustomColors.warn("Invalid block ID: " + blockId);
                continue;
            }
            CustomColors.addToList(cm, blockList, blockId);
        }
    }

    private static void addToList(CustomColormap cm, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i2] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            int col = CustomColors.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor(str = str.trim());
        if (color < 0) {
            CustomColors.warn("Invalid color: " + name + " = " + str);
            return color;
        }
        CustomColors.dbg(name + " = " + str);
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }

    private static dcn readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new dcn((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            path = basePath + path;
            CustomColormap cols = CustomColors.getCustomColors(path, width, height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            vk loc = new vk(pathImage);
            if (!Config.hasResource(loc)) {
                return null;
            }
            CustomColors.dbg("Colormap " + pathImage);
            PropertiesOrdered props = new PropertiesOrdered();
            String pathProps = StrUtils.replaceSuffix(pathImage, ".png", ".properties");
            vk locProps = new vk(pathProps);
            if (Config.hasResource(locProps)) {
                InputStream in = Config.getResourceStream(locProps);
                props.load(in);
                in.close();
                CustomColors.dbg("Colormap properties: " + pathProps);
            } else {
                ((Properties)props).put("format", paletteFormatDefault);
                ((Properties)props).put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm = new CustomColormap(props, pathProps, width, height, paletteFormatDefault);
            if (!cm.isValid(pathProps)) {
                return null;
            }
            return cm;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors();
    }

    public static int getColorMultiplier(eba quad, ceh blockState, bra blockAccess, fx blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        buo block = blockState.b();
        ceh blockStateColormap = blockState;
        if (blockColormaps != null) {
            CustomColormap cm;
            if (!quad.c()) {
                if (block == bup.i) {
                    blockStateColormap = BLOCK_STATE_DIRT;
                }
                if (block == bup.bS) {
                    return -1;
                }
            }
            if (block instanceof bwd && blockState.c((cfj)bwd.a) == cfd.a) {
                blockPos = blockPos.c();
                blockStateColormap = blockAccess.d_(blockPos);
            }
            if ((cm = CustomColors.getBlockColormap(blockStateColormap)) != null) {
                if (Config.isSmoothBiomes() && !cm.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, cm, renderEnv.getColorizerBlockPosM());
                }
                return cm.getColor(blockAccess, blockPos);
            }
        }
        if (!quad.c()) {
            return -1;
        }
        if (block == bup.dU) {
            return CustomColors.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block == bup.bS) {
            return CustomColors.getRedstoneColor(renderEnv.getBlockState());
        }
        if (block instanceof cam) {
            return CustomColors.getStemColorMultiplier(blockState, (brc)blockAccess, blockPos, renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        if (block == bup.i || block == bup.gY || block instanceof bwd) {
            colorizer = COLORIZER_GRASS;
        } else if (block instanceof bwd) {
            colorizer = COLORIZER_GRASS;
            if (blockState.c((cfj)bwd.a) == cfd.a) {
                blockPos = blockPos.c();
            }
        } else if (block instanceof bxx) {
            colorizer = block == bup.ah ? COLORIZER_FOLIAGE : (block == bup.ai ? COLORIZER_FOLIAGE_PINE : (block == bup.aj ? COLORIZER_FOLIAGE_BIRCH : COLORIZER_FOLIAGE));
        } else if (block == bup.dP) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockStateColormap, blockAccess, blockPos);
    }

    protected static bsv getColorBiome(bra blockAccess, fx blockPos) {
        bsv biome = BiomeUtils.getBiome(blockAccess, blockPos);
        if (!(biome != BiomeUtils.SWAMP && biome != BiomeUtils.SWAMP_HILLS || Config.isSwampColors())) {
            biome = BiomeUtils.PLAINS;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(ceh blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof ceh)) {
            return null;
        }
        ceh bs = blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms = blockColormaps[blockId];
        if (cms == null) {
            return null;
        }
        for (int i2 = 0; i2 < cms.length; ++i2) {
            CustomColormap cm = cms[i2];
            if (!cm.matchesBlock(bs)) continue;
            return cm;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(ceh blockState, bra blockAccess, fx blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x2 = blockPos.u();
        int y2 = blockPos.v();
        int z = blockPos.w();
        BlockPosM posM = blockPosM;
        int radius = Config.getBiomeBlendRadius();
        int width = radius * 2 + 1;
        int count = width * width;
        for (int ix = x2 - radius; ix <= x2 + radius; ++ix) {
            for (int iz = z - radius; iz <= z + radius; ++iz) {
                posM.setXyz(ix, y2, iz);
                int col = colorizer.getColor(blockState, blockAccess, posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r2 = sumRed / count;
        int g2 = sumGreen / count;
        int b2 = sumBlue / count;
        return r2 << 16 | g2 << 8 | b2;
    }

    public static int getFluidColor(bra blockAccess, ceh blockState, fx blockPos, RenderEnv renderEnv) {
        buo block = blockState.b();
        IColorizer colorizer = CustomColors.getBlockColormap(blockState);
        if (colorizer == null && blockState.c() == cva.j) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return CustomColors.getBlockColors().a(blockState, blockAccess, blockPos, 0);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static dko getBlockColors() {
        return djz.C().al();
    }

    public static void updatePortalFX(dyg fx2) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx2.a(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(dyg fx2) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx2.a(redF, greenF, blueF);
    }

    private static int getRedstoneColor(ceh blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel(blockState, 15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(dyg fx2, bra blockAccess, double x2, double y2, double z) {
        if (redstoneColors == null) {
            return;
        }
        ceh state = blockAccess.d_(new fx(x2, y2, z));
        int level = CustomColors.getRedstoneLevel(state, 15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx2.a(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(ceh state, int def) {
        buo block = state.b();
        if (!(block instanceof bzd)) {
            return def;
        }
        Comparable val = state.c((cfj)bzd.e);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float kt = 628.0f / (float)xpOrbTime;
        return timer * kt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)Math.round((double)((afm.a(timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static int getDurabilityColor(float dur, int color) {
        if (durabilityColors == null) {
            return color;
        }
        int index = (int)(dur * (float)durabilityColors.getLength());
        int col = durabilityColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(dyg fx2, bra blockAccess, double x2, double y2, double z, RenderEnv renderEnv) {
        if (waterColors == null && blockColormaps == null && particleWaterColor < 0) {
            return;
        }
        fx blockPos = new fx(x2, y2, z);
        renderEnv.reset(BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor(blockAccess, BLOCK_STATE_WATER, blockPos, renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF = (float)redDrop / 255.0f;
            greenF = (float)greenDrop / 255.0f;
            blueF = (float)blueDrop / 255.0f;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx2.a(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(bra blockAccess, fx blockPos) {
        if (lilyPadColor < 0) {
            return CustomColors.getBlockColors().a(bup.dU.n(), blockAccess, blockPos, 0);
        }
        return lilyPadColor;
    }

    private static dcn getFogColorNether(dcn col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static dcn getFogColorEnd(dcn col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static dcn getSkyColorEnd(dcn col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static dcn getSkyColor(dcn skyColor3d, bra blockAccess, double x2, double y2, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x2, y2, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.b / 0.5f;
        float cGreen = (float)skyColor3d.c / 0.66275f;
        float cBlue = (float)skyColor3d.d;
        dcn newCol = skyColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    private static dcn getFogColor(dcn fogColor3d, bra blockAccess, double x2, double y2, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x2, y2, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.b / 0.753f;
        float cGreen = (float)fogColor3d.c / 0.8471f;
        float cBlue = (float)fogColor3d.d;
        dcn newCol = fogColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    public static dcn getUnderwaterColor(bra blockAccess, double x2, double y2, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x2, y2, z, underwaterColors, underwaterColorFader);
    }

    public static dcn getUnderlavaColor(bra blockAccess, double x2, double y2, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x2, y2, z, underlavaColors, underlavaColorFader);
    }

    public static dcn getUnderFluidColor(bra blockAccess, double x2, double y2, double z, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int col = underFluidColors.getColorSmooth(blockAccess, x2, y2, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        dcn newCol = underFluidColorFader.getColor(redF, greenF, blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(ceh blockState, brc blockAccess, fx blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        buo blockStem = blockState.b();
        if (blockStem == bup.dN && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == bup.dO && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        if (!(blockStem instanceof cam)) {
            return -1;
        }
        int level = (Integer)blockState.c((cfj)cam.a);
        return colors.getColor(level);
    }

    public static boolean updateLightmap(dwt world, float torchFlickerX, det lmColors, boolean nightvision, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int dimensionId = WorldUtils.getDimensionId(world);
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapPacks.length) {
            return false;
        }
        LightMapPack lightMapPack = lightMapPacks[lightMapIndex];
        if (lightMapPack == null) {
            return false;
        }
        return lightMapPack.updateLightmap(world, torchFlickerX, lmColors, nightvision, partialTicks);
    }

    public static dcn getWorldFogColor(dcn fogVec, brx world, aqa renderViewEntity, float partialTicks) {
        djz mc = djz.C();
        if (WorldUtils.isNether(world)) {
            return CustomColors.getFogColorNether(fogVec);
        }
        if (WorldUtils.isOverworld(world)) {
            return CustomColors.getFogColor(fogVec, (bra)mc.r, renderViewEntity.cD(), renderViewEntity.cE() + 1.0, renderViewEntity.cH());
        }
        if (WorldUtils.isEnd(world)) {
            return CustomColors.getFogColorEnd(fogVec);
        }
        return fogVec;
    }

    public static dcn getWorldSkyColor(dcn skyVec, brx world, aqa renderViewEntity, float partialTicks) {
        djz mc = djz.C();
        if (WorldUtils.isOverworld(world)) {
            return CustomColors.getSkyColor(skyVec, (bra)mc.r, renderViewEntity.cD(), renderViewEntity.cE() + 1.0, renderViewEntity.cH());
        }
        if (WorldUtils.isEnd(world)) {
            return CustomColors.getSkyColorEnd(skyVec);
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int id = EntityUtils.getEntityIdByName(name);
            try {
                if (id < 0) {
                    id = EntityUtils.getEntityIdByLocation(new vk(name).toString());
                }
            }
            catch (v e2) {
                Config.warn("ResourceLocationException: " + e2.getMessage());
            }
            if (id < 0) {
                CustomColors.warn("Invalid spawn egg name: " + string);
                continue;
            }
            int color = CustomColors.parseColor(value);
            if (color < 0) {
                CustomColors.warn("Invalid spawn egg color: " + string + " = " + value);
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(bna item, bmb itemStack, int layer, int color) {
        int[] eggColors;
        if (spawnEggPrimaryColors == null && spawnEggSecondaryColors == null) {
            return color;
        }
        aqe entityType = item.a(itemStack.o());
        if (entityType == null) {
            return color;
        }
        int id = gm.S.a((Object)entityType);
        if (id < 0) {
            return color;
        }
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getColorFromItemStack(bmb itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        blx item = itemStack.b();
        if (item == null) {
            return color;
        }
        if (item instanceof bna) {
            return CustomColors.getSpawnEggColor((bna)item, itemStack, layer, color);
        }
        return color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        bkx[] dyeValues = bkx.values();
        HashMap<String, bkx> mapDyes = new HashMap<String, bkx>();
        for (int i2 = 0; i2 < dyeValues.length; ++i2) {
            bkx dye = dyeValues[i2];
            mapDyes.put(dye.a(), dye);
        }
        mapDyes.put("lightBlue", bkx.d);
        mapDyes.put("silver", bkx.i);
        float[][] colors = new float[dyeValues.length][];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            bkx dye = (bkx)((Object)mapDyes.get(name));
            int color = CustomColors.parseColor(value);
            if (dye == null || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            colors[dye.ordinal()] = rgb;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static float[] getDyeColors(bkx dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] customColors = dyeColors[dye.ordinal()];
        if (customColors == null) {
            return colors;
        }
        return customColors;
    }

    public static float[] getWolfCollarColors(bkx dye, float[] colors) {
        return CustomColors.getDyeColors(dye, wolfCollarColors, colors);
    }

    public static float[] getSheepColors(bkx dye, float[] colors) {
        return CustomColors.getDyeColors(dye, sheepColors, colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int code = Config.parseInt(name, -1);
            int color = CustomColors.parseColor(value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[cvb.a.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int index = CustomColors.getMapColorIndex(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[CustomColors.getMaxPotionId()];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int getMaxPotionId() {
        int maxId = 0;
        Set keys = gm.P.c();
        for (vk rl : keys) {
            aps potion = PotionUtils.getPotion(rl);
            int id = aps.a((aps)potion);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix(name, "potion.", "effect.");
        String nameMc = StrUtils.replacePrefix(name, "effect.", "effect.minecraft.");
        Set keys = gm.P.c();
        for (vk rl : keys) {
            aps potion = PotionUtils.getPotion(rl);
            if (potion.c().equals(name)) {
                return aps.a((aps)potion);
            }
            if (!potion.c().equals(nameMc)) continue;
            return aps.a((aps)potion);
        }
        return -1;
    }

    public static int getPotionColor(aps potion, int color) {
        int potionId = 0;
        if (potion != null) {
            potionId = aps.a((aps)potion);
        }
        return CustomColors.getPotionColor(potionId, color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return cvb.b.aj;
        }
        if (name.equals("grass")) {
            return cvb.c.aj;
        }
        if (name.equals("sand")) {
            return cvb.d.aj;
        }
        if (name.equals("cloth")) {
            return cvb.e.aj;
        }
        if (name.equals("tnt")) {
            return cvb.f.aj;
        }
        if (name.equals("ice")) {
            return cvb.g.aj;
        }
        if (name.equals("iron")) {
            return cvb.h.aj;
        }
        if (name.equals("foliage")) {
            return cvb.i.aj;
        }
        if (name.equals("clay")) {
            return cvb.k.aj;
        }
        if (name.equals("dirt")) {
            return cvb.l.aj;
        }
        if (name.equals("stone")) {
            return cvb.m.aj;
        }
        if (name.equals("water")) {
            return cvb.n.aj;
        }
        if (name.equals("wood")) {
            return cvb.o.aj;
        }
        if (name.equals("quartz")) {
            return cvb.p.aj;
        }
        if (name.equals("gold")) {
            return cvb.F.aj;
        }
        if (name.equals("diamond")) {
            return cvb.G.aj;
        }
        if (name.equals("lapis")) {
            return cvb.H.aj;
        }
        if (name.equals("emerald")) {
            return cvb.I.aj;
        }
        if (name.equals("obsidian")) {
            return cvb.J.aj;
        }
        if (name.equals("netherrack")) {
            return cvb.K.aj;
        }
        if (name.equals("snow") || name.equals("white")) {
            return cvb.j.aj;
        }
        if (name.equals("adobe") || name.equals("orange")) {
            return cvb.q.aj;
        }
        if (name.equals("magenta")) {
            return cvb.r.aj;
        }
        if (name.equals("light_blue") || name.equals("lightBlue")) {
            return cvb.s.aj;
        }
        if (name.equals("yellow")) {
            return cvb.t.aj;
        }
        if (name.equals("lime")) {
            return cvb.u.aj;
        }
        if (name.equals("pink")) {
            return cvb.v.aj;
        }
        if (name.equals("gray")) {
            return cvb.w.aj;
        }
        if (name.equals("silver") || name.equals("light_gray")) {
            return cvb.x.aj;
        }
        if (name.equals("cyan")) {
            return cvb.y.aj;
        }
        if (name.equals("purple")) {
            return cvb.z.aj;
        }
        if (name.equals("blue")) {
            return cvb.A.aj;
        }
        if (name.equals("brown")) {
            return cvb.B.aj;
        }
        if (name.equals("green")) {
            return cvb.C.aj;
        }
        if (name.equals("red")) {
            return cvb.D.aj;
        }
        if (name.equals("black")) {
            return cvb.E.aj;
        }
        if (name.equals("white_terracotta")) {
            return cvb.L.aj;
        }
        if (name.equals("orange_terracotta")) {
            return cvb.M.aj;
        }
        if (name.equals("magenta_terracotta")) {
            return cvb.N.aj;
        }
        if (name.equals("light_blue_terracotta")) {
            return cvb.O.aj;
        }
        if (name.equals("yellow_terracotta")) {
            return cvb.P.aj;
        }
        if (name.equals("lime_terracotta")) {
            return cvb.Q.aj;
        }
        if (name.equals("pink_terracotta")) {
            return cvb.R.aj;
        }
        if (name.equals("gray_terracotta")) {
            return cvb.S.aj;
        }
        if (name.equals("light_gray_terracotta")) {
            return cvb.T.aj;
        }
        if (name.equals("cyan_terracotta")) {
            return cvb.U.aj;
        }
        if (name.equals("purple_terracotta")) {
            return cvb.V.aj;
        }
        if (name.equals("blue_terracotta")) {
            return cvb.W.aj;
        }
        if (name.equals("brown_terracotta")) {
            return cvb.X.aj;
        }
        if (name.equals("green_terracotta")) {
            return cvb.Y.aj;
        }
        if (name.equals("red_terracotta")) {
            return cvb.Z.aj;
        }
        if (name.equals("black_terracotta")) {
            return cvb.aa.aj;
        }
        if (name.equals("crimson_nylium")) {
            return cvb.ab.aj;
        }
        if (name.equals("crimson_stem")) {
            return cvb.ac.aj;
        }
        if (name.equals("crimson_hyphae")) {
            return cvb.ad.aj;
        }
        if (name.equals("warped_nylium")) {
            return cvb.ae.aj;
        }
        if (name.equals("warped_stem")) {
            return cvb.af.aj;
        }
        if (name.equals("warped_hyphae")) {
            return cvb.ag.aj;
        }
        if (name.equals("warped_wart_block")) {
            return cvb.ah.aj;
        }
        return -1;
    }

    private static int[] getMapColors() {
        cvb[] mapColors = cvb.a;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i2 = 0; i2 < mapColors.length && i2 < colors.length; ++i2) {
            cvb mapColor = mapColors[i2];
            if (mapColor == null) continue;
            colors[i2] = mapColor.ai;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        cvb[] mapColors = cvb.a;
        for (int i2 = 0; i2 < mapColors.length && i2 < colors.length; ++i2) {
            int color;
            cvb mapColor = mapColors[i2];
            if (mapColor == null || (color = colors[i2]) < 0 || mapColor.ai == color) continue;
            mapColor.ai = color;
        }
    }

    private static float[][] getDyeColors() {
        bkx[] dyeColors = bkx.values();
        float[][] colors = new float[dyeColors.length][];
        for (int i2 = 0; i2 < dyeColors.length && i2 < colors.length; ++i2) {
            bkx dyeColor = dyeColors[i2];
            if (dyeColor == null) continue;
            colors[i2] = dyeColor.e();
        }
        return colors;
    }

    private static void setDyeColors(float[][] colors) {
        if (colors == null) {
            return;
        }
        bkx[] dyeColors = bkx.values();
        for (int i2 = 0; i2 < dyeColors.length && i2 < colors.length; ++i2) {
            float[] color;
            bkx dyeColor = dyeColors[i2];
            if (dyeColor == null || (color = colors[i2]) == null || dyeColor.e().equals(color)) continue;
            dyeColor.setColorComponentValues(color);
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (color != 0) {
            return color;
        }
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }

    public static interface IColorizer {
        public int getColor(ceh var1, bra var2, fx var3);

        public boolean isColorConstant();
    }
}

