/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static final String SUFFIX_PNG = ".png";
    private static final vk LOCATION_TEXTURE_EMPTY = TextureUtils.LOCATION_TEXTURE_EMPTY;
    private static final vk LOCATION_SPRITE_EMPTY = TextureUtils.LOCATION_SPRITE_EMPTY;
    private static ekd textureManager;
    private static int countRecursive;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        if (render) {
            ++countRecursive;
            return;
        }
        render = true;
        hasEmissive = false;
    }

    public static vk getEmissiveTexture(vk locationIn) {
        if (!render) {
            return locationIn;
        }
        ejq texture = textureManager.b(locationIn);
        if (texture instanceof ekb) {
            return locationIn;
        }
        vk locationEmissive = null;
        if (texture instanceof ejy) {
            locationEmissive = ((ejy)texture).locationEmissive;
        }
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return locationIn;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_TEXTURE_EMPTY;
        }
        return locationEmissive;
    }

    public static ekc getEmissiveSprite(ekc sprite) {
        if (!render) {
            return sprite;
        }
        ekc spriteEmissive = sprite.spriteEmissive;
        if (!renderEmissive) {
            if (spriteEmissive != null) {
                hasEmissive = true;
            }
            return sprite;
        }
        if (spriteEmissive == null) {
            spriteEmissive = sprite.m().a(LOCATION_SPRITE_EMPTY);
        }
        return spriteEmissive;
    }

    public static eba getEmissiveQuad(eba quad) {
        if (!render) {
            return quad;
        }
        eba quadEmissive = quad.getQuadEmissive();
        if (!renderEmissive) {
            if (quadEmissive != null) {
                hasEmissive = true;
            }
            return quad;
        }
        return quadEmissive;
    }

    public static boolean hasEmissive() {
        if (countRecursive > 0) {
            return false;
        }
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        renderEmissive = true;
    }

    public static boolean isRenderEmissive() {
        return renderEmissive;
    }

    public static void endRenderEmissive() {
        RenderUtils.flushRenderBuffers();
        renderEmissive = false;
    }

    public static void endRender() {
        if (countRecursive > 0) {
            --countRecursive;
            return;
        }
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        textureManager = djz.C().M();
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            vk loc = new vk(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void updateIcons(ekb textureMap, Set<vk> locations) {
        if (!active) {
            return;
        }
        for (vk loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(ekb textureMap, vk locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.a().endsWith(suffixEm)) {
            return;
        }
        vk locSpriteEm = new vk(locSprite.b(), locSprite.a() + suffixEm);
        vk locPngEm = textureMap.b(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        ekc sprite = textureMap.registerSprite(locSprite);
        ekc spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void refreshIcons(ekb textureMap) {
        Collection<ekc> sprites = textureMap.getRegisteredSprites();
        for (ekc sprite : sprites) {
            EmissiveTextures.refreshIcon(sprite, textureMap);
        }
    }

    private static void refreshIcon(ekc sprite, ekb textureMap) {
        if (sprite.spriteEmissive == null) {
            return;
        }
        ekc spriteNew = textureMap.getUploadedSprite(sprite.l());
        if (spriteNew == null) {
            return;
        }
        ekc spriteEmissiveNew = textureMap.getUploadedSprite(sprite.spriteEmissive.l());
        if (spriteEmissiveNew == null) {
            return;
        }
        spriteEmissiveNew.isSpriteEmissive = true;
        spriteNew.spriteEmissive = spriteEmissiveNew;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(vk loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.a().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(vk loc, ejy tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.a();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        vk locEmPng = new vk(loc.b(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        countRecursive = 0;
    }
}

