/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.config.BiomeId;
import net.optifine.config.INameGetter;
import net.optifine.config.MatchBlock;
import net.optifine.config.MatchProfession;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.BiomeUtils;
import net.optifine.util.BlockUtils;
import net.optifine.util.EntityTypeUtils;
import net.optifine.util.ItemUtils;

public class ConnectedParser {
    private String context = null;
    public static final MatchProfession[] PROFESSIONS_INVALID = new MatchProfession[0];
    public static final bkx[] DYE_COLORS_INVALID = new bkx[0];
    private static Map<vk, BiomeId> MAP_BIOMES_COMPACT = null;
    private static final INameGetter<Enum> NAME_GETTER_ENUM = new INameGetter<Enum>(){

        @Override
        public String getName(Enum en) {
            return en.name();
        }
    };
    private static final INameGetter<bkx> NAME_GETTER_DYE_COLOR = new INameGetter<bkx>(){

        @Override
        public String getName(bkx col) {
            return col.a();
        }
    };

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i2 = 0; i2 < blockStrs.length; ++i2) {
            String blockStr = blockStrs[i2];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public ceh parseBlockState(String str, ceh def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb = mbs[0];
        int blockId = mb.getBlockId();
        buo block = (buo)gm.Q.a(blockId);
        return block.n();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        buo[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            MatchBlock bd;
            buo block = blocks[i2];
            int blockId = gm.Q.a((Object)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i2] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length <= 1) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public buo[] parseBlockPart(String domain, String blockPart) {
        String fullName = domain + ":" + blockPart;
        vk fullLoc = new vk(fullName);
        buo block = BlockUtils.getBlock(fullLoc);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        buo[] blocks = new buo[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(buo block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        ceh stateDefault = block.n();
        Collection properties = stateDefault.r();
        HashMap<cfj, List<Comparable>> mapPropValues = new HashMap<cfj, List<Comparable>>();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String param = params[i2];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            cfj prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v2 = 0; v2 < vals.length; ++v2) {
                String val = vals[v2];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        int metaCount = BlockUtils.getMetadataCount(block);
        for (int md2 = 0; md2 < metaCount; ++md2) {
            try {
                ceh bs = BlockUtils.getBlockState(block, md2);
                if (!this.matchState(bs, mapPropValues)) continue;
                listMetadatas.add(md2);
                continue;
            }
            catch (IllegalArgumentException bs) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == metaCount) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i3 = 0; i3 < metadatas.length; ++i3) {
            metadatas[i3] = (Integer)listMetadatas.get(i3);
        }
        return metadatas;
    }

    public static Comparable parsePropertyValue(cfj prop, String valStr) {
        Class valueClass = prop.g();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.a();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof afs) {
            afs iss = (afs)obj;
            return iss.a();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(ceh bs, Map<cfj, List<Comparable>> mapPropValues) {
        Set<cfj> keys = mapPropValues.keySet();
        for (cfj prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Comparable bsVal = bs.c(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public BiomeId[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        List<BiomeId> list = new ArrayList<BiomeId>();
        for (int i2 = 0; i2 < biomeNames.length; ++i2) {
            String biomeName = biomeNames[i2];
            BiomeId biome = this.getBiomeId(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            HashSet<vk> allBiomes = new HashSet<vk>(BiomeUtils.getLocations());
            for (BiomeId bi : list) {
                allBiomes.remove(bi.getResourceLocation());
            }
            list = BiomeUtils.getBiomeIds(allBiomes);
        }
        BiomeId[] biomeArr = list.toArray(new BiomeId[list.size()]);
        return biomeArr;
    }

    public BiomeId getBiomeId(String biomeName) {
        vk biomeLoc = new vk(biomeName = biomeName.toLowerCase());
        BiomeId biome = BiomeUtils.getBiomeId(biomeLoc);
        if (biome != null) {
            return biome;
        }
        String biomeNameCompact = biomeName.replace(" ", "").replace("_", "");
        vk biomeLocCompact = new vk(biomeNameCompact);
        if (MAP_BIOMES_COMPACT == null) {
            MAP_BIOMES_COMPACT = new HashMap<vk, BiomeId>();
            Set<vk> biomeIds = BiomeUtils.getLocations();
            for (vk loc : biomeIds) {
                BiomeId biomeCompact = BiomeUtils.getBiomeId(loc);
                if (biomeCompact == null) continue;
                String pathCompact = loc.a().replace(" ", "").replace("_", "").toLowerCase();
                vk locCompact = new vk(loc.b(), pathCompact);
                MAP_BIOMES_COMPACT.put(locCompact, biomeCompact);
            }
        }
        if ((biome = MAP_BIOMES_COMPACT.get(biomeLocCompact)) != null) {
            return biome;
        }
        return null;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < intStrs.length; ++i2) {
            String intStr = intStrs[i2];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n2 = min; n2 <= max; ++n2) {
                    list.add(n2);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = (Integer)list.get(i3);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<gc> setFaces = EnumSet.allOf(gc.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < faceStrs.length; ++i2) {
            String faceStr = faceStrs[i2];
            if (faceStr.equals("sides")) {
                setFaces.add(gc.c);
                setFaces.add(gc.d);
                setFaces.add(gc.e);
                setFaces.add(gc.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(gc.n));
                continue;
            }
            gc face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[gc.n.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            faces[i3] = setFaces.contains((Object)gc.n[i3]);
        }
        return faces;
    }

    public gc parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return gc.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return gc.b;
        }
        if (str.equals("north")) {
            return gc.c;
        }
        if (str.equals("south")) {
            return gc.d;
        }
        if (str.equals("east")) {
            return gc.f;
        }
        if (str.equals("west")) {
            return gc.e;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri = this.parseRangeInt(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return true;
        }
        if (strLower.equals("false")) {
            return false;
        }
        this.warn("Invalid boolean: " + str);
        return defVal;
    }

    public Boolean parseBooleanObject(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return Boolean.TRUE;
        }
        if (strLower.equals("false")) {
            return Boolean.FALSE;
        }
        this.warn("Invalid boolean: " + str);
        return null;
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public eao parseBlockRenderLayer(String str, eao def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        eao[] layers = eao.CHUNK_RENDER_TYPES;
        for (int i2 = 0; i2 < layers.length; ++i2) {
            eao layer = layers[i2];
            if (!str.equals(layer.getName().toLowerCase())) continue;
            return layer;
        }
        return def;
    }

    public <T> T parseObject(String str, T[] objs, INameGetter nameGetter, String property) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        for (int i2 = 0; i2 < objs.length; ++i2) {
            T obj = objs[i2];
            String name = nameGetter.getName(obj);
            if (name == null || !name.toLowerCase().equals(strLower)) continue;
            return obj;
        }
        this.warn("Invalid " + property + ": " + str);
        return null;
    }

    public <T> T[] parseObjects(String str, T[] objs, INameGetter nameGetter, String property, T[] errValue) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase().trim();
        String[] parts = Config.tokenize(str, " ");
        Object[] arr = (Object[])Array.newInstance(objs.getClass().getComponentType(), parts.length);
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            T obj = this.parseObject(part, objs, nameGetter, property);
            if (obj == null) {
                return errValue;
            }
            arr[i2] = obj;
        }
        return arr;
    }

    public Enum parseEnum(String str, Enum[] enums, String property) {
        return this.parseObject(str, enums, NAME_GETTER_ENUM, property);
    }

    public Enum[] parseEnums(String str, Enum[] enums, String property, Enum[] errValue) {
        return this.parseObjects(str, enums, NAME_GETTER_ENUM, property, errValue);
    }

    public bkx[] parseDyeColors(String str, String property, bkx[] errValue) {
        return this.parseObjects(str, bkx.values(), NAME_GETTER_DYE_COLOR, property, errValue);
    }

    public Weather[] parseWeather(String str, String property, Weather[] errValue) {
        return this.parseObjects(str, Weather.values(), NAME_GETTER_ENUM, property, errValue);
    }

    public NbtTagValue parseNbtTagValue(String path, String value) {
        if (path == null || value == null) {
            return null;
        }
        return new NbtTagValue(path, value);
    }

    public MatchProfession[] parseProfessions(String profStr) {
        if (profStr == null) {
            return null;
        }
        ArrayList<MatchProfession> list = new ArrayList<MatchProfession>();
        String[] tokens = Config.tokenize(profStr, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String str = tokens[i2];
            MatchProfession prof = this.parseProfession(str);
            if (prof == null) {
                this.warn("Invalid profession: " + str);
                return PROFESSIONS_INVALID;
            }
            list.add(prof);
        }
        if (list.isEmpty()) {
            return null;
        }
        MatchProfession[] arr = list.toArray(new MatchProfession[list.size()]);
        return arr;
    }

    private MatchProfession parseProfession(String str) {
        bfm prof;
        String strProf = str;
        String strLevels = null;
        int pos = str.lastIndexOf(58);
        if (pos >= 0) {
            String part1 = str.substring(0, pos);
            String part2 = str.substring(pos + 1);
            if (part2.isEmpty() || part2.matches("[0-9].*")) {
                strProf = part1;
                strLevels = part2;
            }
        }
        if ((prof = this.parseVillagerProfession(strProf)) == null) {
            return null;
        }
        int[] levels = this.parseIntList(strLevels);
        MatchProfession mp2 = new MatchProfession(prof, levels);
        return mp2;
    }

    private bfm parseVillagerProfession(String str) {
        if (str == null) {
            return null;
        }
        gb registry = gm.ai;
        vk loc = new vk(str = str.toLowerCase());
        if (!registry.c(loc)) {
            return null;
        }
        return (bfm)registry.a(loc);
    }

    public int[] parseItems(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            vk loc = new vk(token);
            blx item = ItemUtils.getItem(loc);
            if (item == null) {
                this.warn("Item not found: " + token);
                continue;
            }
            int id = ItemUtils.getId(item);
            if (id < 0) {
                this.warn("Item has no ID: " + item + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }

    public int[] parseEntities(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            vk loc = new vk(token);
            aqe type = EntityTypeUtils.getEntityType(loc);
            if (type == null) {
                this.warn("Entity not found: " + token);
                continue;
            }
            int id = gm.S.a((Object)type);
            if (id < 0) {
                this.warn("Entity has no ID: " + type + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }
}

