/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;

public abstract class SlotGui
extends dmg
implements dmf {
    protected static final int NO_DRAG = -1;
    protected static final int DRAG_OUTSIDE = -2;
    protected final djz minecraft;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double yo;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(djz mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = mcIn;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public void updateSize(int p_updateSize_1_, int p_updateSize_2_, int p_updateSize_3_, int p_updateSize_4_) {
        this.width = p_updateSize_1_;
        this.height = p_updateSize_2_;
        this.y0 = p_updateSize_3_;
        this.y1 = p_updateSize_4_;
        this.x0 = 0;
        this.x1 = p_updateSize_1_;
    }

    public void setRenderSelection(boolean p_setRenderSelection_1_) {
        this.renderSelection = p_setRenderSelection_1_;
    }

    protected void setRenderHeader(boolean p_setRenderHeader_1_, int p_setRenderHeader_2_) {
        this.renderHeader = p_setRenderHeader_1_;
        this.headerHeight = p_setRenderHeader_2_;
        if (!p_setRenderHeader_1_) {
            this.headerHeight = 0;
        }
    }

    public void setVisible(boolean p_setVisible_1_) {
        this.visible = p_setVisible_1_;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends dmi> au_() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int p_selectItem_1_, int p_selectItem_2_, double p_selectItem_3_, double p_selectItem_5_) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int p_updateItemPosition_1_, int p_updateItemPosition_2_, int p_updateItemPosition_3_, float p_updateItemPosition_4_) {
    }

    protected abstract void renderItem(dfm var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int p_renderHeader_1_, int p_renderHeader_2_, dfo p_renderHeader_3_) {
    }

    protected void clickedHeader(int p_clickedHeader_1_, int p_clickedHeader_2_) {
    }

    protected void renderDecorations(int p_renderDecorations_1_, int p_renderDecorations_2_) {
    }

    public int getItemAtPosition(double p_getItemAtPosition_1_, double p_getItemAtPosition_3_) {
        int i2 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j2 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k2 = afm.c(p_getItemAtPosition_3_ - (double)this.y0) - this.headerHeight + (int)this.yo - 4;
        int l2 = k2 / this.itemHeight;
        return p_getItemAtPosition_1_ < (double)this.getScrollbarPosition() && p_getItemAtPosition_1_ >= (double)i2 && p_getItemAtPosition_1_ <= (double)j2 && l2 >= 0 && k2 >= 0 && l2 < this.getItemCount() ? l2 : -1;
    }

    protected void capYPosition() {
        this.yo = afm.a(this.yo, 0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public void centerScrollOn(int p_centerScrollOn_1_) {
        this.yo = p_centerScrollOn_1_ * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2;
        this.capYPosition();
    }

    public int getScroll() {
        return (int)this.yo;
    }

    public boolean isMouseInList(double p_isMouseInList_1_, double p_isMouseInList_3_) {
        return p_isMouseInList_3_ >= (double)this.y0 && p_isMouseInList_3_ <= (double)this.y1 && p_isMouseInList_1_ >= (double)this.x0 && p_isMouseInList_1_ <= (double)this.x1;
    }

    public int getScrollBottom() {
        return (int)this.yo - this.height - this.headerHeight;
    }

    public void scroll(int p_scroll_1_) {
        this.yo += (double)p_scroll_1_;
        this.capYPosition();
        this.yDrag = -2;
    }

    public void a(dfm matrixStackIn, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.visible) {
            this.renderBackground();
            int i2 = this.getScrollbarPosition();
            int j2 = i2 + 6;
            this.capYPosition();
            dfo tessellator = dfo.a();
            dfh bufferbuilder = tessellator.c();
            this.minecraft.M().a(dkw.f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f2 = 32.0f;
            bufferbuilder.a(7, dfk.p);
            bufferbuilder.a(this.x0, this.y1, 0.0).a((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).a(32, 32, 32, 255).d();
            bufferbuilder.a(this.x1, this.y1, 0.0).a((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.yo) / 32.0f).a(32, 32, 32, 255).d();
            bufferbuilder.a(this.x1, this.y0, 0.0).a((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).a(32, 32, 32, 255).d();
            bufferbuilder.a(this.x0, this.y0, 0.0).a((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.yo) / 32.0f).a(32, 32, 32, 255).d();
            tessellator.b();
            int k2 = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int l2 = this.y0 + 4 - (int)this.yo;
            if (this.renderHeader) {
                this.renderHeader(k2, l2, tessellator);
            }
            this.renderList(matrixStackIn, k2, l2, p_render_1_, p_render_2_, p_render_3_);
            RenderSystem.disableDepthTest();
            this.renderHoleBackground(0, this.y0, 255, 255);
            this.renderHoleBackground(this.y1, this.height, 255, 255);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((dem.r)dem.r.l, (dem.j)dem.j.j, (dem.r)dem.r.o, (dem.j)dem.j.e);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int i1 = 4;
            bufferbuilder.a(7, dfk.p);
            bufferbuilder.a(this.x0, this.y0 + 4, 0.0).a(0.0f, 1.0f).a(0, 0, 0, 0).d();
            bufferbuilder.a(this.x1, this.y0 + 4, 0.0).a(1.0f, 1.0f).a(0, 0, 0, 0).d();
            bufferbuilder.a(this.x1, this.y0, 0.0).a(1.0f, 0.0f).a(0, 0, 0, 255).d();
            bufferbuilder.a(this.x0, this.y0, 0.0).a(0.0f, 0.0f).a(0, 0, 0, 255).d();
            tessellator.b();
            bufferbuilder.a(7, dfk.p);
            bufferbuilder.a(this.x0, this.y1, 0.0).a(0.0f, 1.0f).a(0, 0, 0, 255).d();
            bufferbuilder.a(this.x1, this.y1, 0.0).a(1.0f, 1.0f).a(0, 0, 0, 255).d();
            bufferbuilder.a(this.x1, this.y1 - 4, 0.0).a(1.0f, 0.0f).a(0, 0, 0, 0).d();
            bufferbuilder.a(this.x0, this.y1 - 4, 0.0).a(0.0f, 0.0f).a(0, 0, 0, 0).d();
            tessellator.b();
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yo * (this.y1 - this.y0 - (k1 = afm.a(k1, 32, this.y1 - this.y0 - 8))) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.a(7, dfk.p);
                bufferbuilder.a(i2, this.y1, 0.0).a(0.0f, 1.0f).a(0, 0, 0, 255).d();
                bufferbuilder.a(j2, this.y1, 0.0).a(1.0f, 1.0f).a(0, 0, 0, 255).d();
                bufferbuilder.a(j2, this.y0, 0.0).a(1.0f, 0.0f).a(0, 0, 0, 255).d();
                bufferbuilder.a(i2, this.y0, 0.0).a(0.0f, 0.0f).a(0, 0, 0, 255).d();
                tessellator.b();
                bufferbuilder.a(7, dfk.p);
                bufferbuilder.a(i2, l1 + k1, 0.0).a(0.0f, 1.0f).a(128, 128, 128, 255).d();
                bufferbuilder.a(j2, l1 + k1, 0.0).a(1.0f, 1.0f).a(128, 128, 128, 255).d();
                bufferbuilder.a(j2, l1, 0.0).a(1.0f, 0.0f).a(128, 128, 128, 255).d();
                bufferbuilder.a(i2, l1, 0.0).a(0.0f, 0.0f).a(128, 128, 128, 255).d();
                tessellator.b();
                bufferbuilder.a(7, dfk.p);
                bufferbuilder.a(i2, l1 + k1 - 1, 0.0).a(0.0f, 1.0f).a(192, 192, 192, 255).d();
                bufferbuilder.a(j2 - 1, l1 + k1 - 1, 0.0).a(1.0f, 1.0f).a(192, 192, 192, 255).d();
                bufferbuilder.a(j2 - 1, l1, 0.0).a(1.0f, 0.0f).a(192, 192, 192, 255).d();
                bufferbuilder.a(i2, l1, 0.0).a(0.0f, 0.0f).a(192, 192, 192, 255).d();
                tessellator.b();
            }
            this.renderDecorations(p_render_1_, p_render_2_);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    protected void updateScrollingState(double p_updateScrollingState_1_, double p_updateScrollingState_3_, int p_updateScrollingState_5_) {
        this.scrolling = p_updateScrollingState_5_ == 0 && p_updateScrollingState_1_ >= (double)this.getScrollbarPosition() && p_updateScrollingState_1_ < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean a(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.updateScrollingState(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.isVisible() && this.isMouseInList(p_mouseClicked_1_, p_mouseClicked_3_)) {
            int i2 = this.getItemAtPosition(p_mouseClicked_1_, p_mouseClicked_3_);
            if (i2 == -1 && p_mouseClicked_5_ == 0) {
                this.clickedHeader((int)(p_mouseClicked_1_ - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(p_mouseClicked_3_ - (double)this.y0) + (int)this.yo - 4);
                return true;
            }
            if (i2 != -1 && this.selectItem(i2, p_mouseClicked_5_, p_mouseClicked_1_, p_mouseClicked_3_)) {
                if (this.au_().size() > i2) {
                    this.a(this.au_().get(i2));
                }
                this.b_(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean c(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.aw_() != null) {
            this.aw_().c(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }
        return false;
    }

    public boolean a(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (super.a(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (this.isVisible() && p_mouseDragged_5_ == 0 && this.scrolling) {
            if (p_mouseDragged_3_ < (double)this.y0) {
                this.yo = 0.0;
            } else if (p_mouseDragged_3_ > (double)this.y1) {
                this.yo = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i2 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i2 = afm.a(i2, 32, this.y1 - this.y0 - 8)));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yo += p_mouseDragged_8_ * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean a(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.isVisible()) {
            return false;
        }
        this.yo -= p_mouseScrolled_5_ * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean a(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.a(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 264) {
            this.moveSelection(1);
            return true;
        }
        if (p_keyPressed_1_ == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int p_moveSelection_1_) {
    }

    public boolean a(char p_charTyped_1_, int p_charTyped_2_) {
        return !this.isVisible() ? false : super.a(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean b(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.isMouseInList(p_isMouseOver_1_, p_isMouseOver_3_);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(dfm matrixStackIn, int p_renderList_1_, int p_renderList_2_, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        int i2 = this.getItemCount();
        dfo tessellator = dfo.a();
        dfh bufferbuilder = tessellator.c();
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = p_renderList_2_ + j2 * this.itemHeight + this.headerHeight;
            int l2 = this.itemHeight - 4;
            if (k2 > this.y1 || k2 + l2 < this.y0) {
                this.updateItemPosition(j2, p_renderList_1_, k2, p_renderList_5_);
            }
            if (this.renderSelection && this.isSelectedItem(j2)) {
                int i1 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int j1 = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float f2 = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)f2, (float)f2, (float)f2, (float)1.0f);
                bufferbuilder.a(7, dfk.k);
                bufferbuilder.a(i1, k2 + l2 + 2, 0.0).d();
                bufferbuilder.a(j1, k2 + l2 + 2, 0.0).d();
                bufferbuilder.a(j1, k2 - 2, 0.0).d();
                bufferbuilder.a(i1, k2 - 2, 0.0).d();
                tessellator.b();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.a(7, dfk.k);
                bufferbuilder.a(i1 + 1, k2 + l2 + 1, 0.0).d();
                bufferbuilder.a(j1 - 1, k2 + l2 + 1, 0.0).d();
                bufferbuilder.a(j1 - 1, k2 - 1, 0.0).d();
                bufferbuilder.a(i1 + 1, k2 - 1, 0.0).d();
                tessellator.b();
                RenderSystem.enableTexture();
            }
            if (k2 + this.itemHeight < this.y0 || k2 > this.y1) continue;
            this.renderItem(matrixStackIn, j2, p_renderList_1_, k2, l2, p_renderList_3_, p_renderList_4_, p_renderList_5_);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
        dfo tessellator = dfo.a();
        dfh bufferbuilder = tessellator.c();
        this.minecraft.M().a(dkw.f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f2 = 32.0f;
        bufferbuilder.a(7, dfk.p);
        bufferbuilder.a(this.x0, p_renderHoleBackground_2_, 0.0).a(0.0f, (float)p_renderHoleBackground_2_ / 32.0f).a(64, 64, 64, p_renderHoleBackground_4_).d();
        bufferbuilder.a(this.x0 + this.width, p_renderHoleBackground_2_, 0.0).a((float)this.width / 32.0f, (float)p_renderHoleBackground_2_ / 32.0f).a(64, 64, 64, p_renderHoleBackground_4_).d();
        bufferbuilder.a(this.x0 + this.width, p_renderHoleBackground_1_, 0.0).a((float)this.width / 32.0f, (float)p_renderHoleBackground_1_ / 32.0f).a(64, 64, 64, p_renderHoleBackground_3_).d();
        bufferbuilder.a(this.x0, p_renderHoleBackground_1_, 0.0).a(0.0f, (float)p_renderHoleBackground_1_ / 32.0f).a(64, 64, 64, p_renderHoleBackground_3_).d();
        tessellator.b();
    }

    public void setLeftPos(int p_setLeftPos_1_) {
        this.x0 = p_setLeftPos_1_;
        this.x1 = p_setLeftPos_1_ + this.width;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }
}

