/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChunkLayerMap<T> {
    private T[] values = new Object[eao.CHUNK_RENDER_TYPES.length];
    private Supplier<T> defaultValue;

    public ChunkLayerMap(Function<eao, T> initialValue) {
        int i2;
        eao[] renderTypes = eao.CHUNK_RENDER_TYPES;
        this.values = new Object[renderTypes.length];
        for (i2 = 0; i2 < renderTypes.length; ++i2) {
            eao renderType = renderTypes[i2];
            T t2 = initialValue.apply(renderType);
            this.values[renderType.ordinal()] = t2;
        }
        for (i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] != null) continue;
            throw new RuntimeException("Missing value at index: " + i2);
        }
    }

    public T get(eao layer) {
        return this.values[layer.ordinal()];
    }

    public Collection<T> values() {
        return Arrays.asList(this.values);
    }
}

