/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.GlErrors;
import net.optifine.Lang;
import net.optifine.config.ConnectedParser;
import net.optifine.expr.IExpressionBool;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlAlphaState;
import net.optifine.render.GlBlendState;
import net.optifine.render.RenderTypes;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.BlockAliases;
import net.optifine.shaders.ComputeProgram;
import net.optifine.shaders.CustomTexture;
import net.optifine.shaders.CustomTextureLocation;
import net.optifine.shaders.CustomTextureRaw;
import net.optifine.shaders.DrawBuffers;
import net.optifine.shaders.EntityAliases;
import net.optifine.shaders.FixedFramebuffer;
import net.optifine.shaders.GlState;
import net.optifine.shaders.HFNoiseTexture;
import net.optifine.shaders.ICustomTexture;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.ItemAliases;
import net.optifine.shaders.Program;
import net.optifine.shaders.ProgramStack;
import net.optifine.shaders.ProgramStage;
import net.optifine.shaders.ProgramUtils;
import net.optifine.shaders.Programs;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.SMath;
import net.optifine.shaders.ShaderPackDefault;
import net.optifine.shaders.ShaderPackFolder;
import net.optifine.shaders.ShaderPackNone;
import net.optifine.shaders.ShaderPackZip;
import net.optifine.shaders.ShaderUtils;
import net.optifine.shaders.ShadersFramebuffer;
import net.optifine.shaders.ShadersRender;
import net.optifine.shaders.ShadersTex;
import net.optifine.shaders.SimpleShaderTexture;
import net.optifine.shaders.config.EnumShaderOption;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.shaders.config.MacroState;
import net.optifine.shaders.config.PropertyDefaultFastFancyOff;
import net.optifine.shaders.config.PropertyDefaultTrueFalse;
import net.optifine.shaders.config.RenderScale;
import net.optifine.shaders.config.ScreenShaderOptions;
import net.optifine.shaders.config.ShaderLine;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderOptionProfile;
import net.optifine.shaders.config.ShaderOptionRest;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.config.ShaderParser;
import net.optifine.shaders.config.ShaderProfile;
import net.optifine.shaders.uniform.CustomUniforms;
import net.optifine.shaders.uniform.ShaderUniform1f;
import net.optifine.shaders.uniform.ShaderUniform1i;
import net.optifine.shaders.uniform.ShaderUniform2i;
import net.optifine.shaders.uniform.ShaderUniform3f;
import net.optifine.shaders.uniform.ShaderUniform4f;
import net.optifine.shaders.uniform.ShaderUniform4i;
import net.optifine.shaders.uniform.ShaderUniformM4;
import net.optifine.shaders.uniform.ShaderUniforms;
import net.optifine.shaders.uniform.Smoother;
import net.optifine.texture.InternalFormat;
import net.optifine.texture.PixelFormat;
import net.optifine.texture.PixelType;
import net.optifine.texture.TextureType;
import net.optifine.util.ArrayUtils;
import net.optifine.util.DynamicDimension;
import net.optifine.util.EntityUtils;
import net.optifine.util.LineBuffer;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import net.optifine.util.WorldUtils;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBGeometryShader4;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.EXTGeometryShader4;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;

public class Shaders {
    static djz mc;
    static dzz entityRenderer;
    public static boolean isInitializedOnce;
    public static boolean isShaderPackInitialized;
    public static GLCapabilities capabilities;
    public static String glVersionString;
    public static String glVendorString;
    public static String glRendererString;
    public static boolean hasGlGenMipmap;
    public static int countResetDisplayLists;
    private static int renderDisplayWidth;
    private static int renderDisplayHeight;
    public static int renderWidth;
    public static int renderHeight;
    public static boolean isRenderingWorld;
    public static boolean isRenderingSky;
    public static boolean isCompositeRendered;
    public static boolean isRenderingDfb;
    public static boolean isShadowPass;
    public static boolean isEntitiesGlowing;
    public static boolean isSleeping;
    private static boolean isRenderingFirstPersonHand;
    private static boolean isHandRenderedMain;
    private static boolean isHandRenderedOff;
    private static boolean skipRenderHandMain;
    private static boolean skipRenderHandOff;
    public static boolean renderItemKeepDepthMask;
    public static boolean itemToRenderMainTranslucent;
    public static boolean itemToRenderOffTranslucent;
    static float[] sunPosition;
    static float[] moonPosition;
    static float[] shadowLightPosition;
    static float[] upPosition;
    static float[] shadowLightPositionVector;
    static float[] upPosModelView;
    static float[] sunPosModelView;
    static float[] moonPosModelView;
    private static float[] tempMat;
    static h clearColor;
    static float skyColorR;
    static float skyColorG;
    static float skyColorB;
    static long worldTime;
    static long lastWorldTime;
    static long diffWorldTime;
    static float celestialAngle;
    static float sunAngle;
    static float shadowAngle;
    static int moonPhase;
    static long systemTime;
    static long lastSystemTime;
    static long diffSystemTime;
    static int frameCounter;
    static float frameTime;
    static float frameTimeCounter;
    static int systemTimeInt32;
    public static djl pointOfView;
    public static boolean pointOfViewChanged;
    static float rainStrength;
    static float wetness;
    public static float wetnessHalfLife;
    public static float drynessHalfLife;
    public static float eyeBrightnessHalflife;
    static boolean usewetness;
    static int isEyeInWater;
    static int eyeBrightness;
    static float eyeBrightnessFadeX;
    static float eyeBrightnessFadeY;
    static float eyePosY;
    static float centerDepth;
    static float centerDepthSmooth;
    static float centerDepthSmoothHalflife;
    static boolean centerDepthSmoothEnabled;
    static int superSamplingLevel;
    static float nightVision;
    static float blindness;
    static boolean lightmapEnabled;
    static boolean fogEnabled;
    static RenderStage renderStage;
    private static int baseAttribId;
    public static int entityAttrib;
    public static int midTexCoordAttrib;
    public static int tangentAttrib;
    public static int velocityAttrib;
    public static int midBlockAttrib;
    public static boolean useEntityAttrib;
    public static boolean useMidTexCoordAttrib;
    public static boolean useTangentAttrib;
    public static boolean useVelocityAttrib;
    public static boolean useMidBlockAttrib;
    public static boolean progUseEntityAttrib;
    public static boolean progUseMidTexCoordAttrib;
    public static boolean progUseTangentAttrib;
    public static boolean progUseVelocityAttrib;
    public static boolean progUseMidBlockAttrib;
    private static boolean progArbGeometryShader4;
    private static boolean progExtGeometryShader4;
    private static int progMaxVerticesOut;
    private static boolean hasGeometryShaders;
    public static int atlasSizeX;
    public static int atlasSizeY;
    private static ShaderUniforms shaderUniforms;
    public static ShaderUniform4f uniform_entityColor;
    public static ShaderUniform1i uniform_entityId;
    public static ShaderUniform1i uniform_blockEntityId;
    public static ShaderUniform1i uniform_texture;
    public static ShaderUniform1i uniform_lightmap;
    public static ShaderUniform1i uniform_normals;
    public static ShaderUniform1i uniform_specular;
    public static ShaderUniform1i uniform_shadow;
    public static ShaderUniform1i uniform_watershadow;
    public static ShaderUniform1i uniform_shadowtex0;
    public static ShaderUniform1i uniform_shadowtex1;
    public static ShaderUniform1i uniform_depthtex0;
    public static ShaderUniform1i uniform_depthtex1;
    public static ShaderUniform1i uniform_shadowcolor;
    public static ShaderUniform1i uniform_shadowcolor0;
    public static ShaderUniform1i uniform_shadowcolor1;
    public static ShaderUniform1i uniform_noisetex;
    public static ShaderUniform1i uniform_gcolor;
    public static ShaderUniform1i uniform_gdepth;
    public static ShaderUniform1i uniform_gnormal;
    public static ShaderUniform1i uniform_composite;
    public static ShaderUniform1i uniform_gaux1;
    public static ShaderUniform1i uniform_gaux2;
    public static ShaderUniform1i uniform_gaux3;
    public static ShaderUniform1i uniform_gaux4;
    public static ShaderUniform1i uniform_colortex0;
    public static ShaderUniform1i uniform_colortex1;
    public static ShaderUniform1i uniform_colortex2;
    public static ShaderUniform1i uniform_colortex3;
    public static ShaderUniform1i uniform_colortex4;
    public static ShaderUniform1i uniform_colortex5;
    public static ShaderUniform1i uniform_colortex6;
    public static ShaderUniform1i uniform_colortex7;
    public static ShaderUniform1i uniform_gdepthtex;
    public static ShaderUniform1i uniform_depthtex2;
    public static ShaderUniform1i uniform_colortex8;
    public static ShaderUniform1i uniform_colortex9;
    public static ShaderUniform1i uniform_colortex10;
    public static ShaderUniform1i uniform_colortex11;
    public static ShaderUniform1i uniform_colortex12;
    public static ShaderUniform1i uniform_colortex13;
    public static ShaderUniform1i uniform_colortex14;
    public static ShaderUniform1i uniform_colortex15;
    public static ShaderUniform1i uniform_colorimg0;
    public static ShaderUniform1i uniform_colorimg1;
    public static ShaderUniform1i uniform_colorimg2;
    public static ShaderUniform1i uniform_colorimg3;
    public static ShaderUniform1i uniform_colorimg4;
    public static ShaderUniform1i uniform_colorimg5;
    public static ShaderUniform1i uniform_shadowcolorimg0;
    public static ShaderUniform1i uniform_shadowcolorimg1;
    public static ShaderUniform1i uniform_tex;
    public static ShaderUniform1i uniform_heldItemId;
    public static ShaderUniform1i uniform_heldBlockLightValue;
    public static ShaderUniform1i uniform_heldItemId2;
    public static ShaderUniform1i uniform_heldBlockLightValue2;
    public static ShaderUniform1i uniform_fogMode;
    public static ShaderUniform1f uniform_fogDensity;
    public static ShaderUniform3f uniform_fogColor;
    public static ShaderUniform3f uniform_skyColor;
    public static ShaderUniform1i uniform_worldTime;
    public static ShaderUniform1i uniform_worldDay;
    public static ShaderUniform1i uniform_moonPhase;
    public static ShaderUniform1i uniform_frameCounter;
    public static ShaderUniform1f uniform_frameTime;
    public static ShaderUniform1f uniform_frameTimeCounter;
    public static ShaderUniform1f uniform_sunAngle;
    public static ShaderUniform1f uniform_shadowAngle;
    public static ShaderUniform1f uniform_rainStrength;
    public static ShaderUniform1f uniform_aspectRatio;
    public static ShaderUniform1f uniform_viewWidth;
    public static ShaderUniform1f uniform_viewHeight;
    public static ShaderUniform1f uniform_near;
    public static ShaderUniform1f uniform_far;
    public static ShaderUniform3f uniform_sunPosition;
    public static ShaderUniform3f uniform_moonPosition;
    public static ShaderUniform3f uniform_shadowLightPosition;
    public static ShaderUniform3f uniform_upPosition;
    public static ShaderUniform3f uniform_previousCameraPosition;
    public static ShaderUniform3f uniform_cameraPosition;
    public static ShaderUniformM4 uniform_gbufferModelView;
    public static ShaderUniformM4 uniform_gbufferModelViewInverse;
    public static ShaderUniformM4 uniform_gbufferPreviousProjection;
    public static ShaderUniformM4 uniform_gbufferProjection;
    public static ShaderUniformM4 uniform_gbufferProjectionInverse;
    public static ShaderUniformM4 uniform_gbufferPreviousModelView;
    public static ShaderUniformM4 uniform_shadowProjection;
    public static ShaderUniformM4 uniform_shadowProjectionInverse;
    public static ShaderUniformM4 uniform_shadowModelView;
    public static ShaderUniformM4 uniform_shadowModelViewInverse;
    public static ShaderUniform1f uniform_wetness;
    public static ShaderUniform1f uniform_eyeAltitude;
    public static ShaderUniform2i uniform_eyeBrightness;
    public static ShaderUniform2i uniform_eyeBrightnessSmooth;
    public static ShaderUniform2i uniform_terrainTextureSize;
    public static ShaderUniform1i uniform_terrainIconSize;
    public static ShaderUniform1i uniform_isEyeInWater;
    public static ShaderUniform1f uniform_nightVision;
    public static ShaderUniform1f uniform_blindness;
    public static ShaderUniform1f uniform_screenBrightness;
    public static ShaderUniform1i uniform_hideGUI;
    public static ShaderUniform1f uniform_centerDepthSmooth;
    public static ShaderUniform2i uniform_atlasSize;
    public static ShaderUniform4f uniform_spriteBounds;
    public static ShaderUniform4i uniform_blendFunc;
    public static ShaderUniform1i uniform_instanceId;
    public static ShaderUniform1f uniform_playerMood;
    public static ShaderUniform1i uniform_renderStage;
    static double previousCameraPositionX;
    static double previousCameraPositionY;
    static double previousCameraPositionZ;
    static double cameraPositionX;
    static double cameraPositionY;
    static double cameraPositionZ;
    static int cameraOffsetX;
    static int cameraOffsetZ;
    static boolean hasShadowMap;
    public static boolean needResizeShadow;
    static int shadowMapWidth;
    static int shadowMapHeight;
    static int spShadowMapWidth;
    static int spShadowMapHeight;
    static float shadowMapFOV;
    static float shadowMapHalfPlane;
    static boolean shadowMapIsOrtho;
    static float shadowDistanceRenderMul;
    public static boolean shouldSkipDefaultShadow;
    static boolean waterShadowEnabled;
    public static final int MaxDrawBuffers = 8;
    public static final int MaxColorBuffers = 16;
    public static final int MaxDepthBuffers = 3;
    public static final int MaxShadowColorBuffers = 2;
    public static final int MaxShadowDepthBuffers = 2;
    static int usedColorBuffers;
    static int usedDepthBuffers;
    static int usedShadowColorBuffers;
    static int usedShadowDepthBuffers;
    static int usedColorAttachs;
    static int usedDrawBuffers;
    static boolean bindImageTextures;
    static ShadersFramebuffer dfb;
    static ShadersFramebuffer sfb;
    private static int[] gbuffersFormat;
    public static boolean[] gbuffersClear;
    public static h[] gbuffersClearColor;
    private static final h CLEAR_COLOR_0;
    private static final h CLEAR_COLOR_1;
    private static int[] shadowBuffersFormat;
    public static boolean[] shadowBuffersClear;
    public static h[] shadowBuffersClearColor;
    private static Programs programs;
    public static final Program ProgramNone;
    public static final Program ProgramShadow;
    public static final Program ProgramShadowSolid;
    public static final Program ProgramShadowCutout;
    public static final Program[] ProgramsShadowcomp;
    public static final Program[] ProgramsPrepare;
    public static final Program ProgramBasic;
    public static final Program ProgramTextured;
    public static final Program ProgramTexturedLit;
    public static final Program ProgramSkyBasic;
    public static final Program ProgramSkyTextured;
    public static final Program ProgramClouds;
    public static final Program ProgramTerrain;
    public static final Program ProgramTerrainSolid;
    public static final Program ProgramTerrainCutoutMip;
    public static final Program ProgramTerrainCutout;
    public static final Program ProgramDamagedBlock;
    public static final Program ProgramBlock;
    public static final Program ProgramBeaconBeam;
    public static final Program ProgramItem;
    public static final Program ProgramEntities;
    public static final Program ProgramEntitiesGlowing;
    public static final Program ProgramArmorGlint;
    public static final Program ProgramSpiderEyes;
    public static final Program ProgramHand;
    public static final Program ProgramWeather;
    public static final Program ProgramDeferredPre;
    public static final Program[] ProgramsDeferred;
    public static final Program ProgramDeferred;
    public static final Program ProgramWater;
    public static final Program ProgramHandWater;
    public static final Program ProgramCompositePre;
    public static final Program[] ProgramsComposite;
    public static final Program ProgramComposite;
    public static final Program ProgramFinal;
    public static final int ProgramCount;
    public static final Program[] ProgramsAll;
    public static Program activeProgram;
    public static int activeProgramID;
    private static ProgramStack programStack;
    private static boolean hasDeferredPrograms;
    public static boolean hasShadowcompPrograms;
    public static boolean hasPreparePrograms;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static ejq defaultTexture;
    public static boolean[] shadowHardwareFilteringEnabled;
    public static boolean[] shadowMipmapEnabled;
    public static boolean[] shadowFilterNearest;
    public static boolean[] shadowColorMipmapEnabled;
    public static boolean[] shadowColorFilterNearest;
    public static boolean configTweakBlockDamage;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    public static float configRenderResMul;
    public static float configShadowResMul;
    public static int configTexMinFilB;
    public static int configTexMinFilN;
    public static int configTexMinFilS;
    public static int configTexMagFilB;
    public static int configTexMagFilN;
    public static int configTexMagFilS;
    public static boolean configShadowClipFrustrum;
    public static boolean configNormalMap;
    public static boolean configSpecularMap;
    public static PropertyDefaultTrueFalse configOldLighting;
    public static PropertyDefaultTrueFalse configOldHandLight;
    public static int configAntialiasingLevel;
    public static final int texMinFilRange = 3;
    public static final int texMagFilRange = 2;
    public static final String[] texMinFilDesc;
    public static final String[] texMagFilDesc;
    public static final int[] texMinFilValue;
    public static final int[] texMagFilValue;
    private static IShaderPack shaderPack;
    public static boolean shaderPackLoaded;
    public static String currentShaderName;
    public static final String SHADER_PACK_NAME_NONE = "OFF";
    public static final String SHADER_PACK_NAME_DEFAULT = "(internal)";
    public static final String SHADER_PACKS_DIR_NAME = "shaderpacks";
    public static final String OPTIONS_FILE_NAME = "optionsshaders.txt";
    public static final File shaderPacksDir;
    static File configFile;
    private static ShaderOption[] shaderPackOptions;
    private static Set<String> shaderPackOptionSliders;
    static ShaderProfile[] shaderPackProfiles;
    static Map<String, ScreenShaderOptions> shaderPackGuiScreens;
    static Map<String, IExpressionBool> shaderPackProgramConditions;
    public static final String PATH_SHADERS_PROPERTIES = "/shaders/shaders.properties";
    public static PropertyDefaultFastFancyOff shaderPackClouds;
    public static PropertyDefaultTrueFalse shaderPackOldLighting;
    public static PropertyDefaultTrueFalse shaderPackOldHandLight;
    public static PropertyDefaultTrueFalse shaderPackDynamicHandLight;
    public static PropertyDefaultTrueFalse shaderPackShadowTerrain;
    public static PropertyDefaultTrueFalse shaderPackShadowTranslucent;
    public static PropertyDefaultTrueFalse shaderPackShadowEntities;
    public static PropertyDefaultTrueFalse shaderPackShadowBlockEntities;
    public static PropertyDefaultTrueFalse shaderPackUnderwaterOverlay;
    public static PropertyDefaultTrueFalse shaderPackSun;
    public static PropertyDefaultTrueFalse shaderPackMoon;
    public static PropertyDefaultTrueFalse shaderPackVignette;
    public static PropertyDefaultTrueFalse shaderPackBackFaceSolid;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutout;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutoutMipped;
    public static PropertyDefaultTrueFalse shaderPackBackFaceTranslucent;
    public static PropertyDefaultTrueFalse shaderPackRainDepth;
    public static PropertyDefaultTrueFalse shaderPackBeaconBeamDepth;
    public static PropertyDefaultTrueFalse shaderPackSeparateAo;
    public static PropertyDefaultTrueFalse shaderPackFrustumCulling;
    private static Map<String, String> shaderPackResources;
    private static dwt currentWorld;
    private static List<Integer> shaderPackDimensions;
    private static ICustomTexture[] customTexturesGbuffers;
    private static ICustomTexture[] customTexturesComposite;
    private static ICustomTexture[] customTexturesDeferred;
    private static ICustomTexture[] customTexturesShadowcomp;
    private static ICustomTexture[] customTexturesPrepare;
    private static String noiseTexturePath;
    private static DynamicDimension[] colorBufferSizes;
    private static CustomUniforms customUniforms;
    public static final boolean saveFinalShaders;
    public static float blockLightLevel05;
    public static float blockLightLevel06;
    public static float blockLightLevel08;
    public static float aoLevel;
    public static float sunPathRotation;
    public static float shadowAngleInterval;
    public static int fogMode;
    public static float fogDensity;
    public static float fogColorR;
    public static float fogColorG;
    public static float fogColorB;
    public static float shadowIntervalSize;
    public static int terrainIconSize;
    public static int[] terrainTextureSize;
    private static ICustomTexture noiseTexture;
    private static boolean noiseTextureEnabled;
    private static int noiseTextureResolution;
    static final int[] colorTextureImageUnit;
    static final int[] depthTextureImageUnit;
    static final int[] shadowColorTextureImageUnit;
    static final int[] shadowDepthTextureImageUnit;
    static final int[] colorImageUnit;
    static final int[] shadowColorImageUnit;
    private static final int bigBufferSize;
    private static final ByteBuffer bigBuffer;
    static final float[] faProjection;
    static final float[] faProjectionInverse;
    static final float[] faModelView;
    static final float[] faModelViewInverse;
    static final float[] faShadowProjection;
    static final float[] faShadowProjectionInverse;
    static final float[] faShadowModelView;
    static final float[] faShadowModelViewInverse;
    static final FloatBuffer projection;
    static final FloatBuffer projectionInverse;
    static final FloatBuffer modelView;
    static final FloatBuffer modelViewInverse;
    static final FloatBuffer shadowProjection;
    static final FloatBuffer shadowProjectionInverse;
    static final FloatBuffer shadowModelView;
    static final FloatBuffer shadowModelViewInverse;
    static final FloatBuffer previousProjection;
    static final FloatBuffer previousModelView;
    static final FloatBuffer tempMatrixDirectBuffer;
    static final FloatBuffer tempDirectFloatBuffer;
    static final DrawBuffers dfbDrawBuffers;
    static final DrawBuffers sfbDrawBuffers;
    static final DrawBuffers drawBuffersNone;
    static final DrawBuffers[] drawBuffersColorAtt;
    static boolean glDebugGroups;
    static boolean glDebugGroupProgram;
    static Map<buo, Integer> mapBlockToEntityData;
    private static final String[] formatNames;
    private static final int[] formatIds;
    private static final Pattern patternLoadEntityDataMap;
    public static int[] entityData;
    public static int entityDataIndex;

    private Shaders() {
    }

    private static ByteBuffer nextByteBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size);
        return buffer.slice();
    }

    public static IntBuffer nextIntBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asIntBuffer();
    }

    private static FloatBuffer nextFloatBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asFloatBuffer();
    }

    private static IntBuffer[] nextIntBufferArray(int count, int size) {
        IntBuffer[] aib = new IntBuffer[count];
        for (int i2 = 0; i2 < count; ++i2) {
            aib[i2] = Shaders.nextIntBuffer(size);
        }
        return aib;
    }

    private static DrawBuffers[] makeDrawBuffersColorSingle(int count) {
        DrawBuffers[] dbs = new DrawBuffers[count];
        for (int i2 = 0; i2 < dbs.length; ++i2) {
            DrawBuffers db = new DrawBuffers("single" + i2, 16, 8);
            db.put(36064 + i2);
            db.position(0);
            db.limit(1);
            dbs[i2] = db;
        }
        return dbs;
    }

    public static void loadConfig() {
        SMCLog.info("Load shaders configuration.");
        try {
            if (!shaderPacksDir.exists()) {
                shaderPacksDir.mkdir();
            }
        }
        catch (Exception e2) {
            SMCLog.severe("Failed to open the shaderpacks directory: " + shaderPacksDir);
        }
        shadersConfig = new PropertiesOrdered();
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            EnumShaderOption op = ops[i2];
            String key = op.getPropertyKey();
            String def = op.getValueDefault();
            String val = shadersConfig.getProperty(key, def);
            Shaders.setEnumShaderOption(op, val);
        }
        Shaders.loadShaderPack();
    }

    private static void setEnumShaderOption(EnumShaderOption eso, String str) {
        if (str == null) {
            str = eso.getValueDefault();
        }
        switch (eso) {
            case ANTIALIASING: {
                configAntialiasingLevel = Config.parseInt(str, 0);
                break;
            }
            case NORMAL_MAP: {
                configNormalMap = Config.parseBoolean(str, true);
                break;
            }
            case SPECULAR_MAP: {
                configSpecularMap = Config.parseBoolean(str, true);
                break;
            }
            case RENDER_RES_MUL: {
                configRenderResMul = Config.parseFloat(str, 1.0f);
                break;
            }
            case SHADOW_RES_MUL: {
                configShadowResMul = Config.parseFloat(str, 1.0f);
                break;
            }
            case HAND_DEPTH_MUL: {
                configHandDepthMul = Config.parseFloat(str, 0.125f);
                break;
            }
            case CLOUD_SHADOW: {
                configCloudShadow = Config.parseBoolean(str, true);
                break;
            }
            case OLD_HAND_LIGHT: {
                configOldHandLight.setPropertyValue(str);
                break;
            }
            case OLD_LIGHTING: {
                configOldLighting.setPropertyValue(str);
                break;
            }
            case SHADER_PACK: {
                currentShaderName = str;
                break;
            }
            case TWEAK_BLOCK_DAMAGE: {
                configTweakBlockDamage = Config.parseBoolean(str, true);
                break;
            }
            case SHADOW_CLIP_FRUSTRUM: {
                configShadowClipFrustrum = Config.parseBoolean(str, true);
                break;
            }
            case TEX_MIN_FIL_B: {
                configTexMinFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MIN_FIL_N: {
                configTexMinFilN = Config.parseInt(str, 0);
                break;
            }
            case TEX_MIN_FIL_S: {
                configTexMinFilS = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_B: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_N: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_S: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown option: " + (Object)((Object)eso));
            }
        }
    }

    public static void storeConfig() {
        SMCLog.info("Save shaders configuration.");
        if (shadersConfig == null) {
            shadersConfig = new PropertiesOrdered();
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            EnumShaderOption op = ops[i2];
            String key = op.getPropertyKey();
            String val = Shaders.getEnumShaderOption(op);
            shadersConfig.setProperty(key, val);
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            SMCLog.severe("Error saving configuration: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static String getEnumShaderOption(EnumShaderOption eso) {
        switch (eso) {
            case ANTIALIASING: {
                return Integer.toString(configAntialiasingLevel);
            }
            case NORMAL_MAP: {
                return Boolean.toString(configNormalMap);
            }
            case SPECULAR_MAP: {
                return Boolean.toString(configSpecularMap);
            }
            case RENDER_RES_MUL: {
                return Float.toString(configRenderResMul);
            }
            case SHADOW_RES_MUL: {
                return Float.toString(configShadowResMul);
            }
            case HAND_DEPTH_MUL: {
                return Float.toString(configHandDepthMul);
            }
            case CLOUD_SHADOW: {
                return Boolean.toString(configCloudShadow);
            }
            case OLD_HAND_LIGHT: {
                return configOldHandLight.getPropertyValue();
            }
            case OLD_LIGHTING: {
                return configOldLighting.getPropertyValue();
            }
            case SHADER_PACK: {
                return currentShaderName;
            }
            case TWEAK_BLOCK_DAMAGE: {
                return Boolean.toString(configTweakBlockDamage);
            }
            case SHADOW_CLIP_FRUSTRUM: {
                return Boolean.toString(configShadowClipFrustrum);
            }
            case TEX_MIN_FIL_B: {
                return Integer.toString(configTexMinFilB);
            }
            case TEX_MIN_FIL_N: {
                return Integer.toString(configTexMinFilN);
            }
            case TEX_MIN_FIL_S: {
                return Integer.toString(configTexMinFilS);
            }
            case TEX_MAG_FIL_B: {
                return Integer.toString(configTexMagFilB);
            }
            case TEX_MAG_FIL_N: {
                return Integer.toString(configTexMagFilB);
            }
            case TEX_MAG_FIL_S: {
                return Integer.toString(configTexMagFilB);
            }
        }
        throw new IllegalArgumentException("Unknown option: " + (Object)((Object)eso));
    }

    public static void setShaderPack(String par1name) {
        currentShaderName = par1name;
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), par1name);
        Shaders.loadShaderPack();
    }

    public static void loadShaderPack() {
        boolean oldLightingChanged;
        boolean shaderPackLoadedPrev = shaderPackLoaded;
        boolean oldLightingPrev = Shaders.isOldLighting();
        if (Shaders.mc.e != null) {
            Shaders.mc.e.pauseChunkUpdates();
        }
        shaderPackLoaded = false;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
            shaderPackResources.clear();
            shaderPackDimensions.clear();
            shaderPackOptions = null;
            shaderPackOptionSliders = null;
            shaderPackProfiles = null;
            shaderPackGuiScreens = null;
            shaderPackProgramConditions.clear();
            shaderPackClouds.resetValue();
            shaderPackOldHandLight.resetValue();
            shaderPackDynamicHandLight.resetValue();
            shaderPackOldLighting.resetValue();
            Shaders.resetCustomTextures();
            noiseTexturePath = null;
        }
        boolean shadersBlocked = false;
        if (Config.isAntialiasing()) {
            SMCLog.info("Shaders can not be loaded, Antialiasing is enabled: " + Config.getAntialiasingLevel() + "x");
            shadersBlocked = true;
        }
        if (Config.isGraphicsFabulous()) {
            SMCLog.info("Shaders can not be loaded, Fabulous Graphics is enabled.");
            shadersBlocked = true;
        }
        String packName = shadersConfig.getProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), SHADER_PACK_NAME_DEFAULT);
        if (!shadersBlocked) {
            shaderPack = Shaders.getShaderPack(packName);
            boolean bl = shaderPackLoaded = shaderPack != null;
        }
        if (shaderPackLoaded) {
            SMCLog.info("Loaded shaderpack: " + Shaders.getShaderPackName());
        } else {
            SMCLog.info("No shaderpack loaded.");
            shaderPack = new ShaderPackNone();
        }
        if (saveFinalShaders) {
            Shaders.clearDirectory(new File(shaderPacksDir, "debug"));
        }
        Shaders.loadShaderPackResources();
        Shaders.loadShaderPackDimensions();
        shaderPackOptions = Shaders.loadShaderPackOptions();
        Shaders.loadShaderPackFixedProperties();
        Shaders.loadShaderPackDynamicProperties();
        boolean formatChanged = shaderPackLoaded != shaderPackLoadedPrev;
        boolean bl = oldLightingChanged = Shaders.isOldLighting() != oldLightingPrev;
        if (formatChanged || oldLightingChanged) {
            dfk.updateVertexFormats();
            if (Reflector.LightUtil.exists()) {
                Reflector.LightUtil_itemConsumer.setValue(null);
                Reflector.LightUtil_tessellator.setValue(null);
            }
            Shaders.updateBlockLightLevel();
        }
        if (mc.N() != null) {
            CustomBlockLayers.update();
        }
        if (Shaders.mc.e != null) {
            Shaders.mc.e.resumeChunkUpdates();
        }
        if ((formatChanged || oldLightingChanged) && mc.N() != null) {
            mc.D();
        }
    }

    public static IShaderPack getShaderPack(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).isEmpty() || name.equals(SHADER_PACK_NAME_NONE)) {
            return null;
        }
        if (name.equals(SHADER_PACK_NAME_DEFAULT)) {
            return new ShaderPackDefault();
        }
        try {
            File packFile = new File(shaderPacksDir, name);
            if (packFile.isDirectory()) {
                return new ShaderPackFolder(name, packFile);
            }
            if (packFile.isFile() && name.toLowerCase().endsWith(".zip")) {
                return new ShaderPackZip(name, packFile);
            }
            return null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static IShaderPack getShaderPack() {
        return shaderPack;
    }

    private static void loadShaderPackDimensions() {
        shaderPackDimensions.clear();
        for (int i2 = -128; i2 <= 128; ++i2) {
            String worldDir = "/shaders/world" + i2;
            if (!shaderPack.hasDirectory(worldDir)) continue;
            shaderPackDimensions.add(i2);
        }
        if (shaderPackDimensions.size() > 0) {
            Object[] ids = shaderPackDimensions.toArray(new Integer[shaderPackDimensions.size()]);
            Config.dbg("[Shaders] Worlds: " + Config.arrayToString(ids));
        }
    }

    private static void loadShaderPackFixedProperties() {
        shaderPackOldLighting.resetValue();
        shaderPackSeparateAo.resetValue();
        if (shaderPack == null) {
            return;
        }
        String path = PATH_SHADERS_PROPERTIES;
        try {
            InputStream in = shaderPack.getResourceAsStream(path);
            if (in == null) {
                return;
            }
            in = MacroProcessor.process(in, path, false);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            shaderPackOldLighting.loadFrom(props);
            shaderPackSeparateAo.loadFrom(props);
            shaderPackOptionSliders = ShaderPackParser.parseOptionSliders(props, shaderPackOptions);
            shaderPackProfiles = ShaderPackParser.parseProfiles(props, shaderPackOptions);
            shaderPackGuiScreens = ShaderPackParser.parseGuiScreens(props, shaderPackProfiles, shaderPackOptions);
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static void loadShaderPackDynamicProperties() {
        shaderPackClouds.resetValue();
        shaderPackOldHandLight.resetValue();
        shaderPackDynamicHandLight.resetValue();
        shaderPackShadowTerrain.resetValue();
        shaderPackShadowTranslucent.resetValue();
        shaderPackShadowEntities.resetValue();
        shaderPackShadowBlockEntities.resetValue();
        shaderPackUnderwaterOverlay.resetValue();
        shaderPackSun.resetValue();
        shaderPackMoon.resetValue();
        shaderPackVignette.resetValue();
        shaderPackBackFaceSolid.resetValue();
        shaderPackBackFaceCutout.resetValue();
        shaderPackBackFaceCutoutMipped.resetValue();
        shaderPackBackFaceTranslucent.resetValue();
        shaderPackRainDepth.resetValue();
        shaderPackBeaconBeamDepth.resetValue();
        shaderPackFrustumCulling.resetValue();
        BlockAliases.reset();
        ItemAliases.reset();
        EntityAliases.reset();
        customUniforms = null;
        for (int i2 = 0; i2 < ProgramsAll.length; ++i2) {
            Program p2 = ProgramsAll[i2];
            p2.resetProperties();
        }
        Arrays.fill(colorBufferSizes, null);
        if (shaderPack == null) {
            return;
        }
        BlockAliases.update(shaderPack);
        ItemAliases.update(shaderPack);
        EntityAliases.update(shaderPack);
        String path = PATH_SHADERS_PROPERTIES;
        try {
            InputStream in = shaderPack.getResourceAsStream(path);
            if (in == null) {
                return;
            }
            in = MacroProcessor.process(in, path, true);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            shaderPackClouds.loadFrom(props);
            shaderPackOldHandLight.loadFrom(props);
            shaderPackDynamicHandLight.loadFrom(props);
            shaderPackShadowTerrain.loadFrom(props);
            shaderPackShadowTranslucent.loadFrom(props);
            shaderPackShadowEntities.loadFrom(props);
            shaderPackShadowBlockEntities.loadFrom(props);
            shaderPackUnderwaterOverlay.loadFrom(props);
            shaderPackSun.loadFrom(props);
            shaderPackVignette.loadFrom(props);
            shaderPackMoon.loadFrom(props);
            shaderPackBackFaceSolid.loadFrom(props);
            shaderPackBackFaceCutout.loadFrom(props);
            shaderPackBackFaceCutoutMipped.loadFrom(props);
            shaderPackBackFaceTranslucent.loadFrom(props);
            shaderPackRainDepth.loadFrom(props);
            shaderPackBeaconBeamDepth.loadFrom(props);
            shaderPackFrustumCulling.loadFrom(props);
            shaderPackProgramConditions = ShaderPackParser.parseProgramConditions(props, shaderPackOptions);
            customTexturesGbuffers = Shaders.loadCustomTextures(props, ProgramStage.GBUFFERS);
            customTexturesComposite = Shaders.loadCustomTextures(props, ProgramStage.COMPOSITE);
            customTexturesDeferred = Shaders.loadCustomTextures(props, ProgramStage.DEFERRED);
            customTexturesShadowcomp = Shaders.loadCustomTextures(props, ProgramStage.SHADOWCOMP);
            customTexturesPrepare = Shaders.loadCustomTextures(props, ProgramStage.PREPARE);
            noiseTexturePath = props.getProperty("texture.noise");
            if (noiseTexturePath != null) {
                noiseTextureEnabled = true;
            }
            customUniforms = ShaderPackParser.parseCustomUniforms(props);
            ShaderPackParser.parseAlphaStates(props);
            ShaderPackParser.parseBlendStates(props);
            ShaderPackParser.parseRenderScales(props);
            ShaderPackParser.parseBuffersFlip(props);
            colorBufferSizes = ShaderPackParser.parseBufferSizes(props, 16);
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static ICustomTexture[] loadCustomTextures(Properties props, ProgramStage stage) {
        String PREFIX_TEXTURE = "texture." + stage.getName() + ".";
        Set<Object> keys = props.keySet();
        ArrayList<ICustomTexture> list = new ArrayList<ICustomTexture>();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_TEXTURE)) continue;
            String name = StrUtils.removePrefix(string, PREFIX_TEXTURE);
            name = StrUtils.removeSuffix(name, new String[]{".0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9"});
            String path = props.getProperty(string).trim();
            int index = Shaders.getTextureIndex(stage, name);
            if (index < 0) {
                SMCLog.warning("Invalid texture name: " + string);
                continue;
            }
            ICustomTexture ct = Shaders.loadCustomTexture(index, path);
            if (ct == null) continue;
            SMCLog.info("Custom texture: " + string + " = " + path);
            list.add(ct);
        }
        if (list.size() <= 0) {
            return null;
        }
        ICustomTexture[] cts = list.toArray(new ICustomTexture[list.size()]);
        return cts;
    }

    private static ICustomTexture loadCustomTexture(int textureUnit, String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).indexOf(58) >= 0) {
            return Shaders.loadCustomTextureLocation(textureUnit, path);
        }
        if (path.indexOf(32) >= 0) {
            return Shaders.loadCustomTextureRaw(textureUnit, path);
        }
        return Shaders.loadCustomTextureShaders(textureUnit, path);
    }

    private static ICustomTexture loadCustomTextureLocation(int textureUnit, String path) {
        String pathFull = path.trim();
        int variant = 0;
        if (pathFull.startsWith("minecraft:textures/")) {
            if ((pathFull = StrUtils.addSuffixCheck(pathFull, ".png")).endsWith("_n.png")) {
                pathFull = StrUtils.replaceSuffix(pathFull, "_n.png", ".png");
                variant = 1;
            } else if (pathFull.endsWith("_s.png")) {
                pathFull = StrUtils.replaceSuffix(pathFull, "_s.png", ".png");
                variant = 2;
            }
        }
        if (pathFull.startsWith("minecraft:dynamic/lightmap_")) {
            pathFull = pathFull.replace("lightmap", "light_map");
        }
        vk loc = new vk(pathFull);
        CustomTextureLocation ctv = new CustomTextureLocation(textureUnit, loc, variant);
        return ctv;
    }

    private static void reloadCustomTexturesLocation(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            if (!(ct instanceof CustomTextureLocation)) continue;
            CustomTextureLocation ctl = (CustomTextureLocation)ct;
            ctl.reloadTexture();
        }
    }

    private static ICustomTexture loadCustomTextureRaw(int textureUnit, String line) {
        ConnectedParser cp = new ConnectedParser("Shaders");
        String[] parts = Config.tokenize(line, " ");
        ArrayDeque<String> params = new ArrayDeque<String>(Arrays.asList(parts));
        String path = (String)params.poll();
        TextureType type = (TextureType)cp.parseEnum((String)params.poll(), TextureType.values(), "texture type");
        if (type == null) {
            SMCLog.warning("Invalid raw texture type: " + line);
            return null;
        }
        InternalFormat internalFormat = (InternalFormat)cp.parseEnum((String)params.poll(), InternalFormat.values(), "internal format");
        if (internalFormat == null) {
            SMCLog.warning("Invalid raw texture internal format: " + line);
            return null;
        }
        int width = 0;
        int height = 0;
        int depth = 0;
        switch (type) {
            case TEXTURE_1D: {
                width = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case TEXTURE_2D: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case TEXTURE_3D: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                depth = cp.parseInt((String)params.poll(), -1);
                break;
            }
            case TEXTURE_RECTANGLE: {
                width = cp.parseInt((String)params.poll(), -1);
                height = cp.parseInt((String)params.poll(), -1);
                break;
            }
            default: {
                SMCLog.warning("Invalid raw texture type: " + (Object)((Object)type));
                return null;
            }
        }
        if (width < 0 || height < 0 || depth < 0) {
            SMCLog.warning("Invalid raw texture size: " + line);
            return null;
        }
        PixelFormat pixelFormat = (PixelFormat)cp.parseEnum((String)params.poll(), PixelFormat.values(), "pixel format");
        if (pixelFormat == null) {
            SMCLog.warning("Invalid raw texture pixel format: " + line);
            return null;
        }
        PixelType pixelType = (PixelType)cp.parseEnum((String)params.poll(), PixelType.values(), "pixel type");
        if (pixelType == null) {
            SMCLog.warning("Invalid raw texture pixel type: " + line);
            return null;
        }
        if (!params.isEmpty()) {
            SMCLog.warning("Invalid raw texture, too many parameters: " + line);
            return null;
        }
        return Shaders.loadCustomTextureRaw(textureUnit, line, path, type, internalFormat, width, height, depth, pixelFormat, pixelType);
    }

    private static ICustomTexture loadCustomTextureRaw(int textureUnit, String line, String path, TextureType type, InternalFormat internalFormat, int width, int height, int depth, PixelFormat pixelFormat, PixelType pixelType) {
        try {
            String pathFull = "shaders/" + StrUtils.removePrefix(path, "/");
            InputStream in = shaderPack.getResourceAsStream(pathFull);
            if (in == null) {
                SMCLog.warning("Raw texture not found: " + path);
                return null;
            }
            byte[] bytes = Config.readAll(in);
            IOUtils.closeQuietly((InputStream)in);
            ByteBuffer bb = deq.a((int)bytes.length);
            bb.put(bytes);
            bb.flip();
            ell tms = SimpleShaderTexture.loadTextureMetadataSection(pathFull, new ell(true, true));
            CustomTextureRaw ctr = new CustomTextureRaw(type, internalFormat, width, height, depth, pixelFormat, pixelType, bb, textureUnit, tms.a(), tms.b());
            return ctr;
        }
        catch (IOException e2) {
            SMCLog.warning("Error loading raw texture: " + path);
            SMCLog.warning("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
    }

    private static ICustomTexture loadCustomTextureShaders(int textureUnit, String path) {
        if ((path = path.trim()).indexOf(46) < 0) {
            path = path + ".png";
        }
        try {
            String pathFull = "shaders/" + StrUtils.removePrefix(path, "/");
            InputStream in = shaderPack.getResourceAsStream(pathFull);
            if (in == null) {
                SMCLog.warning("Texture not found: " + path);
                return null;
            }
            IOUtils.closeQuietly((InputStream)in);
            SimpleShaderTexture tex = new SimpleShaderTexture(pathFull);
            tex.a(mc.N());
            CustomTexture ct = new CustomTexture(textureUnit, pathFull, tex);
            return ct;
        }
        catch (IOException e2) {
            SMCLog.warning("Error loading texture: " + path);
            SMCLog.warning("" + e2.getClass().getName() + ": " + e2.getMessage());
            return null;
        }
    }

    private static int getTextureIndex(ProgramStage stage, String name) {
        int colortexIndex;
        if (stage == ProgramStage.GBUFFERS) {
            colortexIndex = ShaderParser.getIndex(name, "colortex", 4, 15);
            if (colortexIndex >= 0) {
                return colorTextureImageUnit[colortexIndex];
            }
            if (name.equals("texture")) {
                return 0;
            }
            if (name.equals("lightmap")) {
                return 1;
            }
            if (name.equals("normals")) {
                return 2;
            }
            if (name.equals("specular")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0")) {
                return 6;
            }
            if (name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        if (stage.isAnyComposite()) {
            colortexIndex = ShaderParser.getIndex(name, "colortex", 0, 15);
            if (colortexIndex >= 0) {
                return colorTextureImageUnit[colortexIndex];
            }
            if (name.equals("colortex0")) {
                return 0;
            }
            if (name.equals("gdepth")) {
                return 1;
            }
            if (name.equals("gnormal")) {
                return 2;
            }
            if (name.equals("composite")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0") || name.equals("gdepthtex")) {
                return 6;
            }
            if (name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 11;
            }
            if (name.equals("depthtex2")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        return -1;
    }

    private static void bindCustomTextures(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            dem.q(33984 + ct.getTextureUnit());
            int texId = ct.getTextureId();
            int target = ct.getTarget();
            if (target == 3553) {
                dem.s(texId);
                continue;
            }
            GL11.glBindTexture((int)target, (int)texId);
        }
        dem.q(33984);
    }

    private static void resetCustomTextures() {
        Shaders.deleteCustomTextures(customTexturesGbuffers);
        Shaders.deleteCustomTextures(customTexturesComposite);
        Shaders.deleteCustomTextures(customTexturesDeferred);
        Shaders.deleteCustomTextures(customTexturesShadowcomp);
        Shaders.deleteCustomTextures(customTexturesPrepare);
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
        customTexturesShadowcomp = null;
        customTexturesPrepare = null;
    }

    private static void deleteCustomTextures(ICustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i2 = 0; i2 < cts.length; ++i2) {
            ICustomTexture ct = cts[i2];
            ct.deleteTexture();
        }
    }

    public static ShaderOption[] getShaderPackOptions(String screenName) {
        Object[] ops = (ShaderOption[])shaderPackOptions.clone();
        if (shaderPackGuiScreens == null) {
            if (shaderPackProfiles != null) {
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderPackProfiles, (ShaderOption[])ops);
                ops = (ShaderOption[])Config.addObjectToArray(ops, optionProfile, 0);
            }
            ops = Shaders.getVisibleOptions((ShaderOption[])ops);
            return ops;
        }
        String key = screenName != null ? "screen." + screenName : "screen";
        ScreenShaderOptions sso = shaderPackGuiScreens.get(key);
        if (sso == null) {
            return new ShaderOption[0];
        }
        ShaderOption[] sos = sso.getShaderOptions();
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < sos.length; ++i2) {
            ShaderOption so = sos[i2];
            if (so == null) {
                list.add(null);
                continue;
            }
            if (so instanceof ShaderOptionRest) {
                ShaderOption[] restOps = Shaders.getShaderOptionsRest(shaderPackGuiScreens, (ShaderOption[])ops);
                list.addAll(Arrays.asList(restOps));
                continue;
            }
            list.add(so);
        }
        ShaderOption[] sosExp = list.toArray(new ShaderOption[list.size()]);
        return sosExp;
    }

    public static int getShaderPackColumns(String screenName, int def) {
        String key;
        String string = key = screenName != null ? "screen." + screenName : "screen";
        if (shaderPackGuiScreens == null) {
            return def;
        }
        ScreenShaderOptions sso = shaderPackGuiScreens.get(key);
        if (sso == null) {
            return def;
        }
        return sso.getColumns();
    }

    private static ShaderOption[] getShaderOptionsRest(Map<String, ScreenShaderOptions> mapScreens, ShaderOption[] ops) {
        HashSet<String> setNames = new HashSet<String>();
        Set<String> keys = mapScreens.keySet();
        for (String key : keys) {
            ScreenShaderOptions sso = mapScreens.get(key);
            ShaderOption[] sos = sso.getShaderOptions();
            for (int v2 = 0; v2 < sos.length; ++v2) {
                ShaderOption so = sos[v2];
                if (so == null) continue;
                setNames.add(so.getName());
            }
        }
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            String name;
            ShaderOption so = ops[i2];
            if (!so.isVisible() || setNames.contains(name = so.getName())) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static ShaderOption getShaderOption(String name) {
        return ShaderUtils.getShaderOption(name, shaderPackOptions);
    }

    public static ShaderOption[] getShaderPackOptions() {
        return shaderPackOptions;
    }

    public static boolean isShaderPackOptionSlider(String name) {
        if (shaderPackOptionSliders == null) {
            return false;
        }
        return shaderPackOptionSliders.contains(name);
    }

    private static ShaderOption[] getVisibleOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption so = ops[i2];
            if (!so.isVisible()) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static void saveShaderPackOptions() {
        Shaders.saveShaderPackOptions(shaderPackOptions, shaderPack);
    }

    private static void saveShaderPackOptions(ShaderOption[] sos, IShaderPack sp) {
        PropertiesOrdered props = new PropertiesOrdered();
        if (shaderPackOptions != null) {
            for (int i2 = 0; i2 < sos.length; ++i2) {
                ShaderOption so = sos[i2];
                if (!so.isChanged() || !so.isEnabled()) continue;
                props.setProperty(so.getName(), so.getValue());
            }
        }
        try {
            Shaders.saveOptionProperties(sp, props);
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error saving configuration for " + shaderPack.getName());
            e2.printStackTrace();
        }
    }

    private static void saveOptionProperties(IShaderPack sp, Properties props) throws IOException {
        String path = "shaderpacks/" + sp.getName() + ".txt";
        File propFile = new File(djz.C().n, path);
        if (props.isEmpty()) {
            propFile.delete();
            return;
        }
        FileOutputStream fos = new FileOutputStream(propFile);
        props.store(fos, null);
        fos.flush();
        fos.close();
    }

    private static ShaderOption[] loadShaderPackOptions() {
        try {
            String[] programNames = programs.getProgramNames();
            Properties props = Shaders.loadOptionProperties(shaderPack);
            ShaderOption[] sos = ShaderPackParser.parseShaderPackOptions(shaderPack, programNames, shaderPackDimensions);
            for (int i2 = 0; i2 < sos.length; ++i2) {
                ShaderOption so = sos[i2];
                String val = props.getProperty(so.getName());
                if (val == null) continue;
                so.resetValue();
                if (so.setValue(val)) continue;
                Config.warn("[Shaders] Invalid value, option: " + so.getName() + ", value: " + val);
            }
            return sos;
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading configuration for " + shaderPack.getName());
            e2.printStackTrace();
            return null;
        }
    }

    private static Properties loadOptionProperties(IShaderPack sp) throws IOException {
        PropertiesOrdered props = new PropertiesOrdered();
        String path = "shaderpacks/" + sp.getName() + ".txt";
        File propFile = new File(djz.C().n, path);
        if (!(propFile.exists() && propFile.isFile() && propFile.canRead())) {
            return props;
        }
        FileInputStream fis = new FileInputStream(propFile);
        props.load(fis);
        fis.close();
        return props;
    }

    public static ShaderOption[] getChangedOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption op = ops[i2];
            if (!op.isEnabled() || !op.isChanged()) continue;
            list.add(op);
        }
        ShaderOption[] cops = list.toArray(new ShaderOption[list.size()]);
        return cops;
    }

    private static String applyOptions(String line, ShaderOption[] ops) {
        if (ops == null || ops.length <= 0) {
            return line;
        }
        for (int i2 = 0; i2 < ops.length; ++i2) {
            ShaderOption op = ops[i2];
            if (!op.matchesLine(line)) continue;
            line = op.getSourceLine();
            break;
        }
        return line;
    }

    public static ArrayList listOfShaders() {
        ArrayList<String> listDir = new ArrayList<String>();
        ArrayList<String> listZip = new ArrayList<String>();
        try {
            if (!shaderPacksDir.exists()) {
                shaderPacksDir.mkdir();
            }
            File[] listOfFiles = shaderPacksDir.listFiles();
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File file = listOfFiles[i2];
                String name = file.getName();
                if (file.isDirectory()) {
                    File subDir;
                    if (name.equals("debug") || !(subDir = new File(file, "shaders")).exists() || !subDir.isDirectory()) continue;
                    listDir.add(name);
                    continue;
                }
                if (!file.isFile() || !name.toLowerCase().endsWith(".zip")) continue;
                listZip.add(name);
            }
        }
        catch (Exception listOfFiles) {
            // empty catch block
        }
        Collections.sort(listDir, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(listZip, String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> list = new ArrayList<String>();
        list.add(SHADER_PACK_NAME_NONE);
        list.add(SHADER_PACK_NAME_DEFAULT);
        list.addAll(listDir);
        list.addAll(listZip);
        return list;
    }

    public static int checkFramebufferStatus(String location) {
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            SMCLog.severe("FramebufferStatus 0x%04X at '%s'", status, location);
        }
        return status;
    }

    public static int checkGLError(String location) {
        int errorCode = dem.T();
        if (errorCode != 0 && GlErrors.isEnabled(errorCode)) {
            String errorText = Config.getGlErrorString(errorCode);
            String shadersInfo = Shaders.getErrorInfo(errorCode, location);
            String messageLog = String.format("OpenGL error: %s (%s)%s, at: %s", errorCode, errorText, shadersInfo, location);
            SMCLog.severe(messageLog);
            if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlErrorShaders", 10000L)) {
                String messageChat = ekx.a((String)"of.message.openglError", (Object[])new Object[]{errorCode, errorText});
                Shaders.printChat(messageChat);
            }
        }
        return errorCode;
    }

    private static String getErrorInfo(int errorCode, String location) {
        String programName;
        StringBuilder sb = new StringBuilder();
        if (errorCode == 1286) {
            int statusCode = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            String statusText = Shaders.getFramebufferStatusText(statusCode);
            String info = ", fbStatus: " + statusCode + " (" + statusText + ")";
            sb.append(info);
        }
        if ((programName = activeProgram.getName()).isEmpty()) {
            programName = "none";
        }
        sb.append(", program: " + programName);
        Program activeProgramReal = Shaders.getProgramById(activeProgramID);
        if (activeProgramReal != activeProgram) {
            String programRealName = activeProgramReal.getName();
            if (programRealName.isEmpty()) {
                programRealName = "none";
            }
            sb.append(" (" + programRealName + ")");
        }
        if (location.equals("setDrawBuffers")) {
            sb.append(", drawBuffers: " + ArrayUtils.arrayToString(activeProgram.getDrawBufSettings()));
        }
        return sb.toString();
    }

    private static Program getProgramById(int programID) {
        for (int i2 = 0; i2 < ProgramsAll.length; ++i2) {
            Program pi = ProgramsAll[i2];
            if (pi.getId() != programID) continue;
            return pi;
        }
        return ProgramNone;
    }

    private static String getFramebufferStatusText(int fbStatusCode) {
        switch (fbStatusCode) {
            case 36053: {
                return "Complete";
            }
            case 33305: {
                return "Undefined";
            }
            case 36054: {
                return "Incomplete attachment";
            }
            case 36055: {
                return "Incomplete missing attachment";
            }
            case 36059: {
                return "Incomplete draw buffer";
            }
            case 36060: {
                return "Incomplete read buffer";
            }
            case 36061: {
                return "Unsupported";
            }
            case 36182: {
                return "Incomplete multisample";
            }
            case 36264: {
                return "Incomplete layer targets";
            }
        }
        return "Unknown";
    }

    private static void printChat(String str) {
        Shaders.mc.j.c().a((nr)new oe(str));
    }

    public static void printChatAndLogError(String str) {
        SMCLog.severe(str);
        Shaders.mc.j.c().a((nr)new oe(str));
    }

    public static void printIntBuffer(String title, IntBuffer buf) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(title).append(" [pos ").append(buf.position()).append(" lim ").append(buf.limit()).append(" cap ").append(buf.capacity()).append(" :");
        int lim = buf.limit();
        for (int i2 = 0; i2 < lim; ++i2) {
            sb.append(" ").append(buf.get(i2));
        }
        sb.append("]");
        SMCLog.info(sb.toString());
    }

    public static void startup(djz mc) {
        Shaders.checkShadersModInstalled();
        Shaders.mc = mc;
        mc = djz.C();
        capabilities = GL.getCapabilities();
        glVersionString = GL11.glGetString((int)7938);
        glVendorString = GL11.glGetString((int)7936);
        glRendererString = GL11.glGetString((int)7937);
        SMCLog.info("OpenGL Version: " + glVersionString);
        SMCLog.info("Vendor:  " + glVendorString);
        SMCLog.info("Renderer: " + glRendererString);
        SMCLog.info("Capabilities: " + (Shaders.capabilities.OpenGL20 ? " 2.0 " : " - ") + (Shaders.capabilities.OpenGL21 ? " 2.1 " : " - ") + (Shaders.capabilities.OpenGL30 ? " 3.0 " : " - ") + (Shaders.capabilities.OpenGL32 ? " 3.2 " : " - ") + (Shaders.capabilities.OpenGL40 ? " 4.0 " : " - "));
        SMCLog.info("GL_MAX_DRAW_BUFFERS: " + GL43.glGetInteger((int)34852));
        SMCLog.info("GL_MAX_COLOR_ATTACHMENTS_EXT: " + GL43.glGetInteger((int)36063));
        SMCLog.info("GL_MAX_TEXTURE_IMAGE_UNITS: " + GL43.glGetInteger((int)34930));
        hasGlGenMipmap = Shaders.capabilities.OpenGL30;
        boolean bl = glDebugGroups = Boolean.getBoolean("gl.debug.groups") && Shaders.capabilities.GL_KHR_debug;
        if (glDebugGroups) {
            SMCLog.info("glDebugGroups: true");
        }
        Shaders.loadConfig();
    }

    public static void updateBlockLightLevel() {
        if (Shaders.isOldLighting()) {
            blockLightLevel05 = 0.5f;
            blockLightLevel06 = 0.6f;
            blockLightLevel08 = 0.8f;
        } else {
            blockLightLevel05 = 1.0f;
            blockLightLevel06 = 1.0f;
            blockLightLevel08 = 1.0f;
        }
    }

    public static boolean isOldHandLight() {
        if (!configOldHandLight.isDefault()) {
            return configOldHandLight.isTrue();
        }
        if (!shaderPackOldHandLight.isDefault()) {
            return shaderPackOldHandLight.isTrue();
        }
        return true;
    }

    public static boolean isDynamicHandLight() {
        if (!shaderPackDynamicHandLight.isDefault()) {
            return shaderPackDynamicHandLight.isTrue();
        }
        return true;
    }

    public static boolean isOldLighting() {
        if (!configOldLighting.isDefault()) {
            return configOldLighting.isTrue();
        }
        if (!shaderPackOldLighting.isDefault()) {
            return shaderPackOldLighting.isTrue();
        }
        return true;
    }

    public static boolean isRenderShadowTerrain() {
        return !shaderPackShadowTerrain.isFalse();
    }

    public static boolean isRenderShadowTranslucent() {
        return !shaderPackShadowTranslucent.isFalse();
    }

    public static boolean isRenderShadowEntities() {
        return !shaderPackShadowEntities.isFalse();
    }

    public static boolean isRenderShadowBlockEntities() {
        return !shaderPackShadowBlockEntities.isFalse();
    }

    public static boolean isUnderwaterOverlay() {
        return !shaderPackUnderwaterOverlay.isFalse();
    }

    public static boolean isSun() {
        return !shaderPackSun.isFalse();
    }

    public static boolean isMoon() {
        return !shaderPackMoon.isFalse();
    }

    public static boolean isVignette() {
        return !shaderPackVignette.isFalse();
    }

    public static boolean isRenderBackFace(eao blockLayerIn) {
        if (blockLayerIn == RenderTypes.SOLID) {
            return shaderPackBackFaceSolid.isTrue();
        }
        if (blockLayerIn == RenderTypes.CUTOUT) {
            return shaderPackBackFaceCutout.isTrue();
        }
        if (blockLayerIn == RenderTypes.CUTOUT_MIPPED) {
            return shaderPackBackFaceCutoutMipped.isTrue();
        }
        if (blockLayerIn == RenderTypes.TRANSLUCENT) {
            return shaderPackBackFaceTranslucent.isTrue();
        }
        return false;
    }

    public static boolean isRainDepth() {
        return shaderPackRainDepth.isTrue();
    }

    public static boolean isBeaconBeamDepth() {
        return shaderPackBeaconBeamDepth.isTrue();
    }

    public static boolean isSeparateAo() {
        return shaderPackSeparateAo.isTrue();
    }

    public static boolean isFrustumCulling() {
        return !shaderPackFrustumCulling.isFalse();
    }

    public static void init() {
        boolean firstInit;
        if (!isInitializedOnce) {
            isInitializedOnce = true;
            firstInit = true;
        } else {
            firstInit = false;
        }
        if (!isShaderPackInitialized) {
            int i2;
            int dimId;
            Shaders.checkGLError("Shaders.init pre");
            if (Shaders.getShaderPackName() != null) {
                // empty if block
            }
            if (!Shaders.capabilities.OpenGL20) {
                Shaders.printChatAndLogError("No OpenGL 2.0");
            }
            if (!Shaders.capabilities.GL_EXT_framebuffer_object) {
                Shaders.printChatAndLogError("No EXT_framebuffer_object");
            }
            dfbDrawBuffers.position(0).limit(8);
            sfbDrawBuffers.position(0).limit(8);
            usedColorBuffers = 4;
            usedDepthBuffers = 1;
            usedShadowColorBuffers = 0;
            usedShadowDepthBuffers = 0;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            bindImageTextures = false;
            Arrays.fill(gbuffersFormat, 6408);
            Arrays.fill(gbuffersClear, true);
            Arrays.fill(gbuffersClearColor, null);
            Arrays.fill(shadowBuffersFormat, 6408);
            Arrays.fill(shadowBuffersClear, true);
            Arrays.fill(shadowBuffersClearColor, null);
            Arrays.fill(shadowHardwareFilteringEnabled, false);
            Arrays.fill(shadowMipmapEnabled, false);
            Arrays.fill(shadowFilterNearest, false);
            Arrays.fill(shadowColorMipmapEnabled, false);
            Arrays.fill(shadowColorFilterNearest, false);
            centerDepthSmoothEnabled = false;
            noiseTextureEnabled = false;
            sunPathRotation = 0.0f;
            shadowIntervalSize = 2.0f;
            shadowMapWidth = 1024;
            shadowMapHeight = 1024;
            spShadowMapWidth = 1024;
            spShadowMapHeight = 1024;
            shadowMapFOV = 90.0f;
            shadowMapHalfPlane = 160.0f;
            shadowMapIsOrtho = true;
            shadowDistanceRenderMul = -1.0f;
            aoLevel = -1.0f;
            useEntityAttrib = false;
            useMidTexCoordAttrib = false;
            useTangentAttrib = false;
            useVelocityAttrib = false;
            waterShadowEnabled = false;
            hasGeometryShaders = false;
            Shaders.updateBlockLightLevel();
            Smoother.resetValues();
            shaderUniforms.reset();
            if (customUniforms != null) {
                customUniforms.reset();
            }
            ShaderProfile activeProfile = ShaderUtils.detectProfile(shaderPackProfiles, shaderPackOptions, false);
            String worldPrefix = "";
            if (currentWorld != null && shaderPackDimensions.contains(dimId = WorldUtils.getDimensionId((vj<brx>)currentWorld.Y()))) {
                worldPrefix = "world" + dimId + "/";
            }
            Shaders.loadShaderPackDynamicProperties();
            for (int i3 = 0; i3 < ProgramsAll.length; ++i3) {
                Program p2 = ProgramsAll[i3];
                p2.resetId();
                p2.resetConfiguration();
                if (p2.getProgramStage() == ProgramStage.NONE) continue;
                String programName = p2.getName();
                String programPath = worldPrefix + programName;
                boolean enabled = true;
                if (shaderPackProgramConditions.containsKey(programPath)) {
                    boolean bl = enabled = enabled && shaderPackProgramConditions.get(programPath).eval();
                }
                if (activeProfile != null) {
                    boolean bl = enabled = enabled && !activeProfile.isProgramDisabled(programPath);
                }
                if (!enabled) {
                    SMCLog.info("Program disabled: " + programPath);
                    programName = "<disabled>";
                    programPath = worldPrefix + programName;
                }
                String programFullPath = "/shaders/" + programPath;
                String programFullPathVertex = programFullPath + ".vsh";
                String programFullPathGeometry = programFullPath + ".gsh";
                String programFullPathFragment = programFullPath + ".fsh";
                ComputeProgram[] cps = Shaders.setupComputePrograms(p2, "/shaders/", programPath, ".csh");
                p2.setComputePrograms(cps);
                Config.sleep(10L);
                Shaders.setupProgram(p2, programFullPathVertex, programFullPathGeometry, programFullPathFragment);
                int pr = p2.getId();
                if (pr > 0) {
                    SMCLog.info("Program loaded: " + programPath);
                }
                Shaders.initDrawBuffers(p2);
                Shaders.initBlendStatesIndexed(p2);
                Shaders.updateToggleBuffers(p2);
                Shaders.updateProgramSize(p2);
            }
            hasDeferredPrograms = ProgramUtils.hasActive(ProgramsDeferred);
            hasShadowcompPrograms = ProgramUtils.hasActive(ProgramsShadowcomp);
            hasPreparePrograms = ProgramUtils.hasActive(ProgramsPrepare);
            usedColorAttachs = usedColorBuffers;
            if (usedShadowDepthBuffers > 0 || usedShadowColorBuffers > 0) {
                hasShadowMap = true;
                usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, 1);
            }
            shouldSkipDefaultShadow = hasShadowMap;
            SMCLog.info("usedColorBuffers: " + usedColorBuffers);
            SMCLog.info("usedDepthBuffers: " + usedDepthBuffers);
            SMCLog.info("usedShadowColorBuffers: " + usedShadowColorBuffers);
            SMCLog.info("usedShadowDepthBuffers: " + usedShadowDepthBuffers);
            SMCLog.info("usedColorAttachs: " + usedColorAttachs);
            SMCLog.info("usedDrawBuffers: " + usedDrawBuffers);
            SMCLog.info("bindImageTextures: " + bindImageTextures);
            int maxDrawBuffers = GL43.glGetInteger((int)34852);
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError("[Shaders] Error: Not enough draw buffers, needed: " + usedDrawBuffers + ", available: " + maxDrawBuffers);
                usedDrawBuffers = maxDrawBuffers;
            }
            dfbDrawBuffers.position(0).limit(usedDrawBuffers);
            for (i2 = 0; i2 < usedDrawBuffers; ++i2) {
                dfbDrawBuffers.put(i2, 36064 + i2);
            }
            sfbDrawBuffers.position(0).limit(usedShadowColorBuffers);
            for (i2 = 0; i2 < usedShadowColorBuffers; ++i2) {
                sfbDrawBuffers.put(i2, 36064 + i2);
            }
            for (i2 = 0; i2 < ProgramsAll.length; ++i2) {
                Program pi;
                Program pn;
                for (pn = pi = ProgramsAll[i2]; pn.getId() == 0 && pn.getProgramBackup() != pn; pn = pn.getProgramBackup()) {
                }
                if (pn == pi || pi == ProgramShadow) continue;
                pi.copyFrom(pn);
            }
            Shaders.resize();
            Shaders.resizeShadow();
            if (noiseTextureEnabled) {
                Shaders.setupNoiseTexture();
            }
            if (defaultTexture == null) {
                defaultTexture = ShadersTex.createDefaultTexture();
            }
            dfm matrixStack = new dfm();
            matrixStack.a(g.d.a(-90.0f));
            Shaders.preCelestialRotate(matrixStack);
            Shaders.postCelestialRotate(matrixStack);
            isShaderPackInitialized = true;
            Shaders.loadEntityDataMap();
            Shaders.resetDisplayLists();
            if (!firstInit) {
                // empty if block
            }
            Shaders.checkGLError("Shaders.init");
        }
    }

    private static void initDrawBuffers(Program p2) {
        String infoGlBuffers;
        int maxDrawBuffers = GL43.glGetInteger((int)34852);
        Arrays.fill(p2.getToggleColorTextures(), false);
        if (p2 == ProgramFinal) {
            p2.setDrawBuffers(null);
            return;
        }
        if (p2.getId() == 0) {
            if (p2 == ProgramShadow) {
                p2.setDrawBuffers(drawBuffersNone);
            } else {
                p2.setDrawBuffers(drawBuffersColorAtt[0]);
            }
            return;
        }
        String[] drawBufSettings = p2.getDrawBufSettings();
        if (drawBufSettings == null) {
            if (p2 != ProgramShadow && p2 != ProgramShadowSolid && p2 != ProgramShadowCutout) {
                p2.setDrawBuffers(dfbDrawBuffers);
                usedDrawBuffers = Math.min(usedColorBuffers, maxDrawBuffers);
                Arrays.fill(p2.getToggleColorTextures(), 0, usedColorBuffers, true);
            } else {
                p2.setDrawBuffers(sfbDrawBuffers);
            }
            return;
        }
        DrawBuffers drawBuffers = p2.getDrawBuffersCustom();
        int numDB = drawBufSettings.length;
        usedDrawBuffers = Math.max(usedDrawBuffers, numDB);
        numDB = Math.min(numDB, maxDrawBuffers);
        p2.setDrawBuffers(drawBuffers);
        drawBuffers.limit(numDB);
        for (int i2 = 0; i2 < numDB; ++i2) {
            int drawBuffer = Shaders.getDrawBuffer(p2, drawBufSettings[i2]);
            drawBuffers.put(i2, drawBuffer);
        }
        String infoBuffers = drawBuffers.getInfo(false);
        if (!Config.equals(infoBuffers, infoGlBuffers = drawBuffers.getInfo(true))) {
            SMCLog.info("Draw buffers: " + infoBuffers + " -> " + infoGlBuffers);
        }
    }

    private static void initBlendStatesIndexed(Program p2) {
        GlBlendState[] blendStatesColorIndexed = p2.getBlendStatesColorIndexed();
        if (blendStatesColorIndexed == null) {
            return;
        }
        for (int i2 = 0; i2 < blendStatesColorIndexed.length; ++i2) {
            GlBlendState blendState = blendStatesColorIndexed[i2];
            if (blendState == null) continue;
            String bufferName = Integer.toHexString(i2).toUpperCase();
            int colAtt = 36064 + i2;
            int drawBufferIndex = p2.getDrawBuffers().indexOf(colAtt);
            if (drawBufferIndex < 0) {
                SMCLog.warning("Blend buffer not used in draw buffers: " + bufferName);
                continue;
            }
            p2.setBlendStateIndexed(drawBufferIndex, blendState);
            SMCLog.info("Blend buffer: " + bufferName);
        }
    }

    private static int getDrawBuffer(Program p2, String str) {
        int drawBuffer = 0;
        int ca = Config.parseInt(str, -1);
        if (p2 == ProgramShadow) {
            if (ca >= 0 && ca < 2) {
                drawBuffer = 36064 + ca;
                usedShadowColorBuffers = Math.max(usedShadowColorBuffers, ca + 1);
            }
            return drawBuffer;
        }
        if (ca >= 0 && ca < 16) {
            p2.getToggleColorTextures()[ca] = true;
            drawBuffer = 36064 + ca;
            usedColorAttachs = Math.max(usedColorAttachs, ca + 1);
            usedColorBuffers = Math.max(usedColorBuffers, ca + 1);
        }
        return drawBuffer;
    }

    private static void updateToggleBuffers(Program p2) {
        boolean[] toggleBuffers = p2.getToggleColorTextures();
        Boolean[] flipBuffers = p2.getBuffersFlip();
        for (int i2 = 0; i2 < flipBuffers.length; ++i2) {
            Boolean flip = flipBuffers[i2];
            if (flip == null) continue;
            toggleBuffers[i2] = flip;
        }
    }

    private static void updateProgramSize(Program p2) {
        if (!p2.getProgramStage().isMainComposite()) {
            return;
        }
        DynamicDimension drawSize = null;
        int countFixed = 0;
        int countMatching = 0;
        DrawBuffers db = p2.getDrawBuffers();
        if (db == null) {
            return;
        }
        for (int i2 = 0; i2 < db.limit(); ++i2) {
            DynamicDimension dim;
            int att = db.get(i2);
            int ix = att - 36064;
            if (ix < 0 || ix >= colorBufferSizes.length || (dim = colorBufferSizes[ix]) == null) continue;
            ++countFixed;
            if (drawSize == null) {
                drawSize = dim;
            }
            if (!dim.equals(drawSize)) continue;
            ++countMatching;
        }
        if (countFixed == 0) {
            return;
        }
        if (countMatching != db.limit()) {
            SMCLog.severe("Program " + p2.getName() + " draws to buffers with different sizes");
            return;
        }
        p2.setDrawSize(drawSize);
    }

    public static void resetDisplayLists() {
        SMCLog.info("Reset model renderers");
        ++countResetDisplayLists;
        SMCLog.info("Reset world renderers");
        Shaders.mc.e.e();
    }

    private static void setupProgram(Program program, String vShaderPath, String gShaderPath, String fShaderPath) {
        Shaders.checkGLError("pre setupProgram");
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        progUseVelocityAttrib = false;
        progUseMidBlockAttrib = false;
        int vShader = Shaders.createVertShader(program, vShaderPath);
        int gShader = Shaders.createGeomShader(program, gShaderPath);
        int fShader = Shaders.createFragShader(program, fShaderPath);
        Shaders.checkGLError("create");
        if (vShader != 0 || gShader != 0 || fShader != 0) {
            int programid = ARBShaderObjects.glCreateProgramObjectARB();
            Shaders.checkGLError("create");
            if (vShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)programid, (int)vShader);
                Shaders.checkGLError("attach");
            }
            if (gShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)programid, (int)gShader);
                Shaders.checkGLError("attach");
                if (progArbGeometryShader4) {
                    ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36315, (int)4);
                    ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36316, (int)5);
                    ARBGeometryShader4.glProgramParameteriARB((int)programid, (int)36314, (int)progMaxVerticesOut);
                    Shaders.checkGLError("arbGeometryShader4");
                }
                if (progExtGeometryShader4) {
                    EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36315, (int)4);
                    EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36316, (int)5);
                    EXTGeometryShader4.glProgramParameteriEXT((int)programid, (int)36314, (int)progMaxVerticesOut);
                    Shaders.checkGLError("extGeometryShader4");
                }
                hasGeometryShaders = true;
            }
            if (fShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)programid, (int)fShader);
                Shaders.checkGLError("attach");
            }
            if (progUseEntityAttrib) {
                ARBVertexShader.glBindAttribLocationARB((int)programid, (int)entityAttrib, (CharSequence)"mc_Entity");
                Shaders.checkGLError("mc_Entity");
            }
            if (progUseMidTexCoordAttrib) {
                ARBVertexShader.glBindAttribLocationARB((int)programid, (int)midTexCoordAttrib, (CharSequence)"mc_midTexCoord");
                Shaders.checkGLError("mc_midTexCoord");
            }
            if (progUseTangentAttrib) {
                ARBVertexShader.glBindAttribLocationARB((int)programid, (int)tangentAttrib, (CharSequence)"at_tangent");
                Shaders.checkGLError("at_tangent");
            }
            if (progUseVelocityAttrib) {
                ARBVertexShader.glBindAttribLocationARB((int)programid, (int)velocityAttrib, (CharSequence)"at_velocity");
                Shaders.checkGLError("at_velocity");
            }
            if (progUseMidBlockAttrib) {
                ARBVertexShader.glBindAttribLocationARB((int)programid, (int)midBlockAttrib, (CharSequence)"at_midBlock");
                Shaders.checkGLError("at_midBlock");
            }
            ARBShaderObjects.glLinkProgramARB((int)programid);
            if (GL43.glGetProgrami((int)programid, (int)35714) != 1) {
                SMCLog.severe("Error linking program: " + programid + " (" + program.getName() + ")");
            }
            Shaders.printLogInfo(programid, program.getName());
            if (vShader != 0) {
                ARBShaderObjects.glDetachObjectARB((int)programid, (int)vShader);
                ARBShaderObjects.glDeleteObjectARB((int)vShader);
            }
            if (gShader != 0) {
                ARBShaderObjects.glDetachObjectARB((int)programid, (int)gShader);
                ARBShaderObjects.glDeleteObjectARB((int)gShader);
            }
            if (fShader != 0) {
                ARBShaderObjects.glDetachObjectARB((int)programid, (int)fShader);
                ARBShaderObjects.glDeleteObjectARB((int)fShader);
            }
            program.setId(programid);
            program.setRef(programid);
            Shaders.useProgram(program);
            ARBShaderObjects.glValidateProgramARB((int)programid);
            Shaders.useProgram(ProgramNone);
            Shaders.printLogInfo(programid, program.getName());
            int valid = GL43.glGetProgrami((int)programid, (int)35715);
            if (valid != 1) {
                String Q = "\"";
                Shaders.printChatAndLogError("[Shaders] Error: Invalid program " + Q + program.getName() + Q);
                ARBShaderObjects.glDeleteObjectARB((int)programid);
                programid = 0;
                program.resetId();
            }
        }
    }

    private static ComputeProgram[] setupComputePrograms(Program program, String prefixShaders, String programPath, String shaderExt) {
        if (program.getProgramStage() == ProgramStage.GBUFFERS) {
            return new ComputeProgram[0];
        }
        ArrayList<ComputeProgram> list = new ArrayList<ComputeProgram>();
        int count = 27;
        for (int i2 = 0; i2 < count; ++i2) {
            String suffix = i2 > 0 ? "_" + (char)(97 + i2 - 1) : "";
            String computePath = programPath + suffix;
            String computeShaderFullPath = prefixShaders + computePath + shaderExt;
            ComputeProgram cp = new ComputeProgram(program.getName(), program.getProgramStage());
            Shaders.setupComputeProgram(cp, computeShaderFullPath);
            if (cp.getId() <= 0) continue;
            list.add(cp);
            SMCLog.info("Compute program loaded: " + computePath);
        }
        ComputeProgram[] cps = list.toArray(new ComputeProgram[list.size()]);
        return cps;
    }

    private static void setupComputeProgram(ComputeProgram program, String cShaderPath) {
        Shaders.checkGLError("pre setupProgram");
        int cShader = Shaders.createCompShader(program, cShaderPath);
        Shaders.checkGLError("create");
        if (cShader != 0) {
            int programid = ARBShaderObjects.glCreateProgramObjectARB();
            Shaders.checkGLError("create");
            if (cShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)programid, (int)cShader);
                Shaders.checkGLError("attach");
            }
            ARBShaderObjects.glLinkProgramARB((int)programid);
            if (GL43.glGetProgrami((int)programid, (int)35714) != 1) {
                SMCLog.severe("Error linking program: " + programid + " (" + program.getName() + ")");
            }
            Shaders.printLogInfo(programid, program.getName());
            if (cShader != 0) {
                ARBShaderObjects.glDetachObjectARB((int)programid, (int)cShader);
                ARBShaderObjects.glDeleteObjectARB((int)cShader);
            }
            program.setId(programid);
            program.setRef(programid);
            ARBShaderObjects.glUseProgramObjectARB((int)programid);
            ARBShaderObjects.glValidateProgramARB((int)programid);
            ARBShaderObjects.glUseProgramObjectARB((int)0);
            Shaders.printLogInfo(programid, program.getName());
            int valid = GL43.glGetProgrami((int)programid, (int)35715);
            if (valid != 1) {
                String Q = "\"";
                Shaders.printChatAndLogError("[Shaders] Error: Invalid program " + Q + program.getName() + Q);
                ARBShaderObjects.glDeleteObjectARB((int)programid);
                programid = 0;
                program.resetId();
            }
        }
    }

    private static int createCompShader(ComputeProgram program, String filename) {
        InputStream is = shaderPack.getResourceAsStream(filename);
        if (is == null) {
            return 0;
        }
        int compShader = ARBShaderObjects.glCreateShaderObjectARB((int)37305);
        if (compShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        LineBuffer writer = new LineBuffer();
        if (writer != null) {
            try {
                LineBuffer reader = LineBuffer.readAll(new InputStreamReader(is));
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                MacroState macroState = new MacroState();
                for (String line : reader) {
                    String name;
                    int bufferindex;
                    ShaderLine sl;
                    line = Shaders.applyOptions(line, activeOptions);
                    writer.add(line);
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine(line)) == null) continue;
                    if (sl.isUniform()) {
                        String uniform = sl.getName();
                        int index = ShaderParser.getShadowDepthIndex(uniform);
                        if (index >= 0) {
                            usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorIndex(uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorImageIndex(uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        index = ShaderParser.getDepthIndex(uniform);
                        if (index >= 0) {
                            usedDepthBuffers = Math.max(usedDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorIndex(uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorImageIndex(uniform);
                        if (index < 0) continue;
                        usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                        bindImageTextures = true;
                        continue;
                    }
                    if (sl.isLayout("in")) {
                        gr localSize = ShaderParser.parseLocalSize(sl.getValue());
                        if (localSize != null) {
                            program.setLocalSize(localSize);
                            continue;
                        }
                        SMCLog.severe("Invalid local size: " + line);
                        continue;
                    }
                    if (sl.isConstIVec3("workGroups")) {
                        gr workGroups = sl.getValueIVec3();
                        if (workGroups != null) {
                            program.setWorkGroups(workGroups);
                            continue;
                        }
                        SMCLog.severe("Invalid workGroups: " + line);
                        continue;
                    }
                    if (sl.isConstVec2("workGroupsRender")) {
                        dcm workGroupsRender = sl.getValueVec2();
                        if (workGroupsRender != null) {
                            program.setWorkGroupsRender(workGroupsRender);
                            continue;
                        }
                        SMCLog.severe("Invalid workGroupsRender: " + line);
                        continue;
                    }
                    if (!sl.isConstBoolSuffix("MipmapEnabled", true) || (bufferindex = Shaders.getBufferIndex(name = StrUtils.removeSuffix(sl.getName(), "MipmapEnabled"))) < 0) continue;
                    int compositeMipmapSetting = program.getCompositeMipmapSetting();
                    program.setCompositeMipmapSetting(compositeMipmapSetting |= 1 << bufferindex);
                    SMCLog.info("%s mipmap enabled", name);
                }
            }
            catch (Exception e2) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e2.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)compShader);
                return 0;
            }
        }
        String compCode = writer.toString();
        if (saveFinalShaders) {
            Shaders.saveShader(filename, compCode);
        }
        if (program.getLocalSize() == null) {
            SMCLog.severe("Missing local size: " + filename);
            GL43.glDeleteShader((int)compShader);
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)compShader, (CharSequence)compCode);
        ARBShaderObjects.glCompileShaderARB((int)compShader);
        if (GL43.glGetShaderi((int)compShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling compute shader: " + filename);
        }
        Shaders.printShaderLogInfo(compShader, filename, listFiles);
        return compShader;
    }

    private static int createVertShader(Program program, String filename) {
        InputStream is = shaderPack.getResourceAsStream(filename);
        if (is == null) {
            return 0;
        }
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        LineBuffer writer = new LineBuffer();
        if (writer != null) {
            try {
                LineBuffer reader = LineBuffer.readAll(new InputStreamReader(is));
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                reader = ShaderPackParser.remapTextureUnits(reader);
                MacroState macroState = new MacroState();
                for (String line : reader) {
                    ShaderLine sl;
                    line = Shaders.applyOptions(line, activeOptions);
                    writer.add(line);
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine(line)) == null) continue;
                    if (sl.isAttribute("mc_Entity")) {
                        useEntityAttrib = true;
                        progUseEntityAttrib = true;
                    } else if (sl.isAttribute("mc_midTexCoord")) {
                        useMidTexCoordAttrib = true;
                        progUseMidTexCoordAttrib = true;
                    } else if (sl.isAttribute("at_tangent")) {
                        useTangentAttrib = true;
                        progUseTangentAttrib = true;
                    } else if (sl.isAttribute("at_velocity")) {
                        useVelocityAttrib = true;
                        progUseVelocityAttrib = true;
                    } else if (sl.isAttribute("at_midBlock")) {
                        useMidBlockAttrib = true;
                        progUseMidBlockAttrib = true;
                    }
                    if (!sl.isConstInt("countInstances")) continue;
                    program.setCountInstances(sl.getValueInt());
                    SMCLog.info("countInstances: " + program.getCountInstances());
                }
            }
            catch (Exception e2) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e2.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        String vertexCode = writer.toString();
        if (saveFinalShaders) {
            Shaders.saveShader(filename, vertexCode);
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        if (GL43.glGetShaderi((int)vertShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling vertex shader: " + filename);
        }
        Shaders.printShaderLogInfo(vertShader, filename, listFiles);
        return vertShader;
    }

    private static int createGeomShader(Program program, String filename) {
        InputStream is = shaderPack.getResourceAsStream(filename);
        if (is == null) {
            return 0;
        }
        int geomShader = ARBShaderObjects.glCreateShaderObjectARB((int)36313);
        if (geomShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        progArbGeometryShader4 = false;
        progExtGeometryShader4 = false;
        progMaxVerticesOut = 3;
        LineBuffer writer = new LineBuffer();
        if (writer != null) {
            try {
                LineBuffer reader = LineBuffer.readAll(new InputStreamReader(is));
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                MacroState macroState = new MacroState();
                for (String line : reader) {
                    String val;
                    ShaderLine sl;
                    line = Shaders.applyOptions(line, activeOptions);
                    writer.add(line);
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine(line)) == null) continue;
                    if (sl.isExtension("GL_ARB_geometry_shader4") && ((val = Config.normalize(sl.getValue())).equals("enable") || val.equals("require") || val.equals("warn"))) {
                        progArbGeometryShader4 = true;
                    }
                    if (sl.isExtension("GL_EXT_geometry_shader4") && ((val = Config.normalize(sl.getValue())).equals("enable") || val.equals("require") || val.equals("warn"))) {
                        progExtGeometryShader4 = true;
                    }
                    if (!sl.isConstInt("maxVerticesOut")) continue;
                    progMaxVerticesOut = sl.getValueInt();
                }
            }
            catch (Exception e2) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e2.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)geomShader);
                return 0;
            }
        }
        String geomCode = writer.toString();
        if (saveFinalShaders) {
            Shaders.saveShader(filename, geomCode);
        }
        ARBShaderObjects.glShaderSourceARB((int)geomShader, (CharSequence)geomCode);
        ARBShaderObjects.glCompileShaderARB((int)geomShader);
        if (GL43.glGetShaderi((int)geomShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling geometry shader: " + filename);
        }
        Shaders.printShaderLogInfo(geomShader, filename, listFiles);
        return geomShader;
    }

    private static int createFragShader(Program program, String filename) {
        InputStream is = shaderPack.getResourceAsStream(filename);
        if (is == null) {
            return 0;
        }
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        LineBuffer writer = new LineBuffer();
        if (writer != null) {
            try {
                LineBuffer reader = LineBuffer.readAll(new InputStreamReader(is));
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                MacroState macroState = new MacroState();
                for (String line : reader) {
                    String val;
                    String name;
                    ShaderLine sl;
                    line = Shaders.applyOptions(line, activeOptions);
                    writer.add(line);
                    if (!macroState.processLine(line) || (sl = ShaderParser.parseLine(line)) == null) continue;
                    if (sl.isUniform()) {
                        String uniform = sl.getName();
                        int index = ShaderParser.getShadowDepthIndex(uniform);
                        if (index >= 0) {
                            usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorIndex(uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorImageIndex(uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        index = ShaderParser.getDepthIndex(uniform);
                        if (index >= 0) {
                            usedDepthBuffers = Math.max(usedDepthBuffers, index + 1);
                            continue;
                        }
                        if (uniform.equals("gdepth") && gbuffersFormat[1] == 6408) {
                            Shaders.gbuffersFormat[1] = 34836;
                            continue;
                        }
                        index = ShaderParser.getColorIndex(uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getColorImageIndex(uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            bindImageTextures = true;
                            continue;
                        }
                        if (!uniform.equals("centerDepthSmooth")) continue;
                        centerDepthSmoothEnabled = true;
                        continue;
                    }
                    if (sl.isConstInt("shadowMapResolution") || sl.isProperty("SHADOWRES")) {
                        spShadowMapWidth = spShadowMapHeight = sl.getValueInt();
                        shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                        SMCLog.info("Shadow map resolution: " + spShadowMapWidth);
                        continue;
                    }
                    if (sl.isConstFloat("shadowMapFov") || sl.isProperty("SHADOWFOV")) {
                        shadowMapFOV = sl.getValueFloat();
                        shadowMapIsOrtho = false;
                        SMCLog.info("Shadow map field of view: " + shadowMapFOV);
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistance") || sl.isProperty("SHADOWHPL")) {
                        shadowMapHalfPlane = sl.getValueFloat();
                        shadowMapIsOrtho = true;
                        SMCLog.info("Shadow map distance: " + shadowMapHalfPlane);
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistanceRenderMul")) {
                        shadowDistanceRenderMul = sl.getValueFloat();
                        SMCLog.info("Shadow distance render mul: " + shadowDistanceRenderMul);
                        continue;
                    }
                    if (sl.isConstFloat("shadowIntervalSize")) {
                        shadowIntervalSize = sl.getValueFloat();
                        SMCLog.info("Shadow map interval size: " + shadowIntervalSize);
                        continue;
                    }
                    if (sl.isConstBool("generateShadowMipmap", true)) {
                        Arrays.fill(shadowMipmapEnabled, true);
                        SMCLog.info("Generate shadow mipmap");
                        continue;
                    }
                    if (sl.isConstBool("generateShadowColorMipmap", true)) {
                        Arrays.fill(shadowColorMipmapEnabled, true);
                        SMCLog.info("Generate shadow color mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering", true)) {
                        Arrays.fill(shadowHardwareFilteringEnabled, true);
                        SMCLog.info("Hardware shadow filtering enabled.");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering0", true)) {
                        Shaders.shadowHardwareFilteringEnabled[0] = true;
                        SMCLog.info("shadowHardwareFiltering0");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering1", true)) {
                        Shaders.shadowHardwareFilteringEnabled[1] = true;
                        SMCLog.info("shadowHardwareFiltering1");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Mipmap", "shadowtexMipmap", true)) {
                        Shaders.shadowMipmapEnabled[0] = true;
                        SMCLog.info("shadowtex0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Mipmap", true)) {
                        Shaders.shadowMipmapEnabled[1] = true;
                        SMCLog.info("shadowtex1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Mipmap", "shadowColor0Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[0] = true;
                        SMCLog.info("shadowcolor0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Mipmap", "shadowColor1Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[1] = true;
                        SMCLog.info("shadowcolor1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Nearest", "shadowtexNearest", "shadow0MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[0] = true;
                        SMCLog.info("shadowtex0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Nearest", "shadow1MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[1] = true;
                        SMCLog.info("shadowtex1Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Nearest", "shadowColor0Nearest", "shadowColor0MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[0] = true;
                        SMCLog.info("shadowcolor0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Nearest", "shadowColor1Nearest", "shadowColor1MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[1] = true;
                        SMCLog.info("shadowcolor1Nearest");
                        continue;
                    }
                    if (sl.isConstFloat("wetnessHalflife") || sl.isProperty("WETNESSHL")) {
                        wetnessHalfLife = sl.getValueFloat();
                        SMCLog.info("Wetness halflife: " + wetnessHalfLife);
                        continue;
                    }
                    if (sl.isConstFloat("drynessHalflife") || sl.isProperty("DRYNESSHL")) {
                        drynessHalfLife = sl.getValueFloat();
                        SMCLog.info("Dryness halflife: " + drynessHalfLife);
                        continue;
                    }
                    if (sl.isConstFloat("eyeBrightnessHalflife")) {
                        eyeBrightnessHalflife = sl.getValueFloat();
                        SMCLog.info("Eye brightness halflife: " + eyeBrightnessHalflife);
                        continue;
                    }
                    if (sl.isConstFloat("centerDepthHalflife")) {
                        centerDepthSmoothHalflife = sl.getValueFloat();
                        SMCLog.info("Center depth halflife: " + centerDepthSmoothHalflife);
                        continue;
                    }
                    if (sl.isConstFloat("sunPathRotation")) {
                        sunPathRotation = sl.getValueFloat();
                        SMCLog.info("Sun path rotation: " + sunPathRotation);
                        continue;
                    }
                    if (sl.isConstFloat("ambientOcclusionLevel")) {
                        aoLevel = Config.limit(sl.getValueFloat(), 0.0f, 1.0f);
                        SMCLog.info("AO Level: " + aoLevel);
                        continue;
                    }
                    if (sl.isConstInt("superSamplingLevel")) {
                        int ssaa = sl.getValueInt();
                        if (ssaa > 1) {
                            SMCLog.info("Super sampling level: " + ssaa + "x");
                            superSamplingLevel = ssaa;
                            continue;
                        }
                        superSamplingLevel = 1;
                        continue;
                    }
                    if (sl.isConstInt("noiseTextureResolution")) {
                        noiseTextureResolution = sl.getValueInt();
                        noiseTextureEnabled = true;
                        SMCLog.info("Noise texture enabled");
                        SMCLog.info("Noise texture resolution: " + noiseTextureResolution);
                        continue;
                    }
                    if (sl.isConstIntSuffix("Format")) {
                        int shadowColorIndex;
                        name = StrUtils.removeSuffix(sl.getName(), "Format");
                        String value = sl.getValue();
                        int format = Shaders.getTextureFormatFromString(value);
                        if (format == 0) continue;
                        int bufferindex = Shaders.getBufferIndex(name);
                        if (bufferindex >= 0) {
                            Shaders.gbuffersFormat[bufferindex] = format;
                            SMCLog.info("%s format: %s", name, value);
                        }
                        if ((shadowColorIndex = ShaderParser.getShadowColorIndex(name)) < 0) continue;
                        Shaders.shadowBuffersFormat[shadowColorIndex] = format;
                        SMCLog.info("%s format: %s", name, value);
                        continue;
                    }
                    if (sl.isConstBoolSuffix("Clear", false)) {
                        int shadowColorIndex;
                        if (!program.getProgramStage().isAnyComposite()) continue;
                        name = StrUtils.removeSuffix(sl.getName(), "Clear");
                        int bufferindex = Shaders.getBufferIndex(name);
                        if (bufferindex >= 0) {
                            Shaders.gbuffersClear[bufferindex] = false;
                            SMCLog.info("%s clear disabled", name);
                        }
                        if ((shadowColorIndex = ShaderParser.getShadowColorIndex(name)) < 0) continue;
                        Shaders.shadowBuffersClear[shadowColorIndex] = false;
                        SMCLog.info("%s clear disabled", name);
                        continue;
                    }
                    if (sl.isConstVec4Suffix("ClearColor")) {
                        if (!program.getProgramStage().isAnyComposite()) continue;
                        name = StrUtils.removeSuffix(sl.getName(), "ClearColor");
                        h col = sl.getValueVec4();
                        if (col != null) {
                            int shadowColorIndex;
                            int bufferindex = Shaders.getBufferIndex(name);
                            if (bufferindex >= 0) {
                                Shaders.gbuffersClearColor[bufferindex] = col;
                                SMCLog.info("%s clear color: %s %s %s %s", name, Float.valueOf(col.a()), Float.valueOf(col.b()), Float.valueOf(col.c()), Float.valueOf(col.d()));
                            }
                            if ((shadowColorIndex = ShaderParser.getShadowColorIndex(name)) < 0) continue;
                            Shaders.shadowBuffersClearColor[shadowColorIndex] = col;
                            SMCLog.info("%s clear color: %s %s %s %s", name, Float.valueOf(col.a()), Float.valueOf(col.b()), Float.valueOf(col.c()), Float.valueOf(col.d()));
                            continue;
                        }
                        SMCLog.warning("Invalid color value: " + sl.getValue());
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGBA32F")) {
                        Shaders.gbuffersFormat[7] = 34836;
                        SMCLog.info("gaux4 format : RGB32AF");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB32F")) {
                        Shaders.gbuffersFormat[7] = 34837;
                        SMCLog.info("gaux4 format : RGB32F");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB16")) {
                        Shaders.gbuffersFormat[7] = 32852;
                        SMCLog.info("gaux4 format : RGB16");
                        continue;
                    }
                    if (sl.isConstBoolSuffix("MipmapEnabled", true)) {
                        int bufferindex;
                        if (!program.getProgramStage().isAnyComposite() || (bufferindex = Shaders.getBufferIndex(name = StrUtils.removeSuffix(sl.getName(), "MipmapEnabled"))) < 0) continue;
                        int compositeMipmapSetting = program.getCompositeMipmapSetting();
                        program.setCompositeMipmapSetting(compositeMipmapSetting |= 1 << bufferindex);
                        SMCLog.info("%s mipmap enabled", name);
                        continue;
                    }
                    if (sl.isProperty("DRAWBUFFERS")) {
                        val = sl.getValue();
                        String[] dbs = ShaderParser.parseDrawBuffers(val);
                        if (dbs != null) {
                            program.setDrawBufSettings(dbs);
                            continue;
                        }
                        SMCLog.warning("Invalid draw buffers: " + val);
                        continue;
                    }
                    if (!sl.isProperty("RENDERTARGETS")) continue;
                    val = sl.getValue();
                    String[] dbs = ShaderParser.parseRenderTargets(val);
                    if (dbs != null) {
                        program.setDrawBufSettings(dbs);
                        continue;
                    }
                    SMCLog.warning("Invalid render targets: " + val);
                }
            }
            catch (Exception e2) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e2.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        String fragCode = writer.toString();
        if (saveFinalShaders) {
            Shaders.saveShader(filename, fragCode);
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        if (GL43.glGetShaderi((int)fragShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling fragment shader: " + filename);
        }
        Shaders.printShaderLogInfo(fragShader, filename, listFiles);
        return fragShader;
    }

    public static void saveShader(String filename, String code) {
        try {
            File file = new File(shaderPacksDir, "debug/" + filename);
            file.getParentFile().mkdirs();
            Config.writeFile(file, code);
        }
        catch (IOException e2) {
            Config.warn("Error saving: " + filename);
            e2.printStackTrace();
        }
    }

    private static void clearDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isDirectory()) {
                Shaders.clearDirectory(file);
            }
            file.delete();
        }
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterivARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes, StandardCharsets.US_ASCII);
            out = StrUtils.trim(out, " \n\r\t");
            SMCLog.info("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    private static boolean printShaderLogInfo(int shader, String name, List<String> listFiles) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        int length = GL43.glGetShaderi((int)shader, (int)35716);
        if (length > 1) {
            for (int i2 = 0; i2 < listFiles.size(); ++i2) {
                String path = listFiles.get(i2);
                SMCLog.info("File: " + (i2 + 1) + " = " + path);
            }
            String log = GL43.glGetShaderInfoLog((int)shader, (int)length);
            log = StrUtils.trim(log, " \n\r\t");
            SMCLog.info("Shader info log: " + name + "\n" + log);
            return false;
        }
        return true;
    }

    public static void useProgram(Program program) {
        int programID;
        Shaders.checkGLError("pre-useProgram");
        if (isShadowPass) {
            program = ProgramShadow;
        } else if (isEntitiesGlowing) {
            program = ProgramEntitiesGlowing;
        }
        if (activeProgram == program) {
            return;
        }
        Shaders.flushRenderBuffers();
        Shaders.updateAlphaBlend(activeProgram, program);
        if (glDebugGroups && glDebugGroupProgram) {
            KHRDebug.glPopDebugGroup();
        }
        activeProgram = program;
        if (glDebugGroups) {
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)activeProgram.getRealProgramName());
            glDebugGroupProgram = true;
        }
        activeProgramID = programID = program.getId();
        ARBShaderObjects.glUseProgramObjectARB((int)programID);
        if (Shaders.checkGLError("useProgram") != 0) {
            program.setId(0);
            activeProgramID = programID = program.getId();
            ARBShaderObjects.glUseProgramObjectARB((int)programID);
        }
        shaderUniforms.setProgram(programID);
        if (customUniforms != null) {
            customUniforms.setProgram(programID);
        }
        if (programID == 0) {
            return;
        }
        DrawBuffers drawBuffers = program.getDrawBuffers();
        if (isRenderingDfb) {
            GlState.setDrawBuffers(drawBuffers);
        }
        Shaders.setProgramUniforms(program.getProgramStage());
        Shaders.setImageUniforms();
        Shaders.checkGLError("end useProgram");
    }

    private static void setProgramUniforms(ProgramStage programStage) {
        int blockLight2;
        switch (programStage) {
            case GBUFFERS: {
                Shaders.setProgramUniform1i(uniform_texture, 0);
                Shaders.setProgramUniform1i(uniform_lightmap, 2);
                Shaders.setProgramUniform1i(uniform_normals, 1);
                Shaders.setProgramUniform1i(uniform_specular, 3);
                Shaders.setProgramUniform1i(uniform_shadow, waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i(uniform_watershadow, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex0, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex1, 5);
                Shaders.setProgramUniform1i(uniform_depthtex0, 6);
                if (customTexturesGbuffers != null || hasDeferredPrograms) {
                    Shaders.setProgramUniform1i(uniform_gaux1, 7);
                    Shaders.setProgramUniform1i(uniform_gaux2, 8);
                    Shaders.setProgramUniform1i(uniform_gaux3, 9);
                    Shaders.setProgramUniform1i(uniform_gaux4, 10);
                    Shaders.setProgramUniform1i(uniform_colortex4, 7);
                    Shaders.setProgramUniform1i(uniform_colortex5, 8);
                    Shaders.setProgramUniform1i(uniform_colortex6, 9);
                    Shaders.setProgramUniform1i(uniform_colortex7, 10);
                    if (usedColorBuffers > 8) {
                        Shaders.setProgramUniform1i(uniform_colortex8, 16);
                        Shaders.setProgramUniform1i(uniform_colortex9, 17);
                        Shaders.setProgramUniform1i(uniform_colortex10, 18);
                        Shaders.setProgramUniform1i(uniform_colortex11, 19);
                        Shaders.setProgramUniform1i(uniform_colortex12, 20);
                        Shaders.setProgramUniform1i(uniform_colortex13, 21);
                        Shaders.setProgramUniform1i(uniform_colortex14, 22);
                        Shaders.setProgramUniform1i(uniform_colortex15, 23);
                    }
                }
                Shaders.setProgramUniform1i(uniform_depthtex1, 11);
                Shaders.setProgramUniform1i(uniform_shadowcolor, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor0, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor1, 14);
                Shaders.setProgramUniform1i(uniform_noisetex, 15);
                break;
            }
            case SHADOWCOMP: 
            case PREPARE: 
            case DEFERRED: 
            case COMPOSITE: {
                Shaders.setProgramUniform1i(uniform_gcolor, 0);
                Shaders.setProgramUniform1i(uniform_gdepth, 1);
                Shaders.setProgramUniform1i(uniform_gnormal, 2);
                Shaders.setProgramUniform1i(uniform_composite, 3);
                Shaders.setProgramUniform1i(uniform_gaux1, 7);
                Shaders.setProgramUniform1i(uniform_gaux2, 8);
                Shaders.setProgramUniform1i(uniform_gaux3, 9);
                Shaders.setProgramUniform1i(uniform_gaux4, 10);
                Shaders.setProgramUniform1i(uniform_colortex0, 0);
                Shaders.setProgramUniform1i(uniform_colortex1, 1);
                Shaders.setProgramUniform1i(uniform_colortex2, 2);
                Shaders.setProgramUniform1i(uniform_colortex3, 3);
                Shaders.setProgramUniform1i(uniform_colortex4, 7);
                Shaders.setProgramUniform1i(uniform_colortex5, 8);
                Shaders.setProgramUniform1i(uniform_colortex6, 9);
                Shaders.setProgramUniform1i(uniform_colortex7, 10);
                if (usedColorBuffers > 8) {
                    Shaders.setProgramUniform1i(uniform_colortex8, 16);
                    Shaders.setProgramUniform1i(uniform_colortex9, 17);
                    Shaders.setProgramUniform1i(uniform_colortex10, 18);
                    Shaders.setProgramUniform1i(uniform_colortex11, 19);
                    Shaders.setProgramUniform1i(uniform_colortex12, 20);
                    Shaders.setProgramUniform1i(uniform_colortex13, 21);
                    Shaders.setProgramUniform1i(uniform_colortex14, 22);
                    Shaders.setProgramUniform1i(uniform_colortex15, 23);
                }
                Shaders.setProgramUniform1i(uniform_shadow, waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i(uniform_watershadow, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex0, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex1, 5);
                Shaders.setProgramUniform1i(uniform_gdepthtex, 6);
                Shaders.setProgramUniform1i(uniform_depthtex0, 6);
                Shaders.setProgramUniform1i(uniform_depthtex1, 11);
                Shaders.setProgramUniform1i(uniform_depthtex2, 12);
                Shaders.setProgramUniform1i(uniform_shadowcolor, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor0, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor1, 14);
                Shaders.setProgramUniform1i(uniform_noisetex, 15);
                break;
            }
            case SHADOW: {
                Shaders.setProgramUniform1i(uniform_tex, 0);
                Shaders.setProgramUniform1i(uniform_texture, 0);
                Shaders.setProgramUniform1i(uniform_lightmap, 2);
                Shaders.setProgramUniform1i(uniform_normals, 1);
                Shaders.setProgramUniform1i(uniform_specular, 3);
                Shaders.setProgramUniform1i(uniform_shadow, waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i(uniform_watershadow, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex0, 4);
                Shaders.setProgramUniform1i(uniform_shadowtex1, 5);
                if (customTexturesGbuffers != null) {
                    Shaders.setProgramUniform1i(uniform_gaux1, 7);
                    Shaders.setProgramUniform1i(uniform_gaux2, 8);
                    Shaders.setProgramUniform1i(uniform_gaux3, 9);
                    Shaders.setProgramUniform1i(uniform_gaux4, 10);
                    Shaders.setProgramUniform1i(uniform_colortex4, 7);
                    Shaders.setProgramUniform1i(uniform_colortex5, 8);
                    Shaders.setProgramUniform1i(uniform_colortex6, 9);
                    Shaders.setProgramUniform1i(uniform_colortex7, 10);
                    if (usedColorBuffers > 8) {
                        Shaders.setProgramUniform1i(uniform_colortex8, 16);
                        Shaders.setProgramUniform1i(uniform_colortex9, 17);
                        Shaders.setProgramUniform1i(uniform_colortex10, 18);
                        Shaders.setProgramUniform1i(uniform_colortex11, 19);
                        Shaders.setProgramUniform1i(uniform_colortex12, 20);
                        Shaders.setProgramUniform1i(uniform_colortex13, 21);
                        Shaders.setProgramUniform1i(uniform_colortex14, 22);
                        Shaders.setProgramUniform1i(uniform_colortex15, 23);
                    }
                }
                Shaders.setProgramUniform1i(uniform_shadowcolor, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor0, 13);
                Shaders.setProgramUniform1i(uniform_shadowcolor1, 14);
                Shaders.setProgramUniform1i(uniform_noisetex, 15);
                break;
            }
        }
        bmb stack = Shaders.mc.s != null ? Shaders.mc.s.dD() : null;
        blx item = stack != null ? stack.b() : null;
        int itemID = -1;
        buo block = null;
        if (item != null) {
            itemID = gm.T.a((Object)item);
            if (item instanceof bkh) {
                block = ((bkh)item).e();
            }
            itemID = ItemAliases.getItemAliasId(itemID);
        }
        int blockLight = block != null ? block.n().f() : 0;
        bmb stack2 = Shaders.mc.s != null ? Shaders.mc.s.dE() : null;
        blx item2 = stack2 != null ? stack2.b() : null;
        int itemID2 = -1;
        buo block2 = null;
        if (item2 != null) {
            itemID2 = gm.T.a((Object)item2);
            if (item2 instanceof bkh) {
                block2 = ((bkh)item2).e();
            }
            itemID2 = ItemAliases.getItemAliasId(itemID2);
        }
        int n2 = blockLight2 = block2 != null ? block2.n().f() : 0;
        if (Shaders.isOldHandLight() && blockLight2 > blockLight) {
            itemID = itemID2;
            blockLight = blockLight2;
        }
        float playerMood = Shaders.mc.s != null ? Shaders.mc.s.w() : 0.0f;
        Shaders.setProgramUniform1i(uniform_heldItemId, itemID);
        Shaders.setProgramUniform1i(uniform_heldBlockLightValue, blockLight);
        Shaders.setProgramUniform1i(uniform_heldItemId2, itemID2);
        Shaders.setProgramUniform1i(uniform_heldBlockLightValue2, blockLight2);
        Shaders.setProgramUniform1i(uniform_fogMode, fogEnabled ? fogMode : 0);
        Shaders.setProgramUniform1f(uniform_fogDensity, fogEnabled ? fogDensity : 0.0f);
        Shaders.setProgramUniform3f(uniform_fogColor, fogColorR, fogColorG, fogColorB);
        Shaders.setProgramUniform3f(uniform_skyColor, skyColorR, skyColorG, skyColorB);
        Shaders.setProgramUniform1i(uniform_worldTime, (int)(worldTime % 24000L));
        Shaders.setProgramUniform1i(uniform_worldDay, (int)(worldTime / 24000L));
        Shaders.setProgramUniform1i(uniform_moonPhase, moonPhase);
        Shaders.setProgramUniform1i(uniform_frameCounter, frameCounter);
        Shaders.setProgramUniform1f(uniform_frameTime, frameTime);
        Shaders.setProgramUniform1f(uniform_frameTimeCounter, frameTimeCounter);
        Shaders.setProgramUniform1f(uniform_sunAngle, sunAngle);
        Shaders.setProgramUniform1f(uniform_shadowAngle, shadowAngle);
        Shaders.setProgramUniform1f(uniform_rainStrength, rainStrength);
        Shaders.setProgramUniform1f(uniform_aspectRatio, (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f(uniform_viewWidth, renderWidth);
        Shaders.setProgramUniform1f(uniform_viewHeight, renderHeight);
        Shaders.setProgramUniform1f(uniform_near, 0.05f);
        Shaders.setProgramUniform1f(uniform_far, Shaders.mc.k.b * 16);
        Shaders.setProgramUniform3f(uniform_sunPosition, sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f(uniform_moonPosition, moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f(uniform_shadowLightPosition, shadowLightPosition[0], shadowLightPosition[1], shadowLightPosition[2]);
        Shaders.setProgramUniform3f(uniform_upPosition, upPosition[0], upPosition[1], upPosition[2]);
        Shaders.setProgramUniform3f(uniform_previousCameraPosition, (float)previousCameraPositionX, (float)previousCameraPositionY, (float)previousCameraPositionZ);
        Shaders.setProgramUniform3f(uniform_cameraPosition, (float)cameraPositionX, (float)cameraPositionY, (float)cameraPositionZ);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferModelView, false, modelView);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferModelViewInverse, false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferPreviousProjection, false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferProjection, false, projection);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferProjectionInverse, false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferPreviousModelView, false, previousModelView);
        if (hasShadowMap) {
            Shaders.setProgramUniformMatrix4ARB(uniform_shadowProjection, false, shadowProjection);
            Shaders.setProgramUniformMatrix4ARB(uniform_shadowProjectionInverse, false, shadowProjectionInverse);
            Shaders.setProgramUniformMatrix4ARB(uniform_shadowModelView, false, shadowModelView);
            Shaders.setProgramUniformMatrix4ARB(uniform_shadowModelViewInverse, false, shadowModelViewInverse);
        }
        Shaders.setProgramUniform1f(uniform_wetness, wetness);
        Shaders.setProgramUniform1f(uniform_eyeAltitude, eyePosY);
        Shaders.setProgramUniform2i(uniform_eyeBrightness, eyeBrightness & 0xFFFF, eyeBrightness >> 16);
        Shaders.setProgramUniform2i(uniform_eyeBrightnessSmooth, Math.round(eyeBrightnessFadeX), Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform2i(uniform_terrainTextureSize, terrainTextureSize[0], terrainTextureSize[1]);
        Shaders.setProgramUniform1i(uniform_terrainIconSize, terrainIconSize);
        Shaders.setProgramUniform1i(uniform_isEyeInWater, isEyeInWater);
        Shaders.setProgramUniform1f(uniform_nightVision, nightVision);
        Shaders.setProgramUniform1f(uniform_blindness, blindness);
        Shaders.setProgramUniform1f(uniform_screenBrightness, (float)Shaders.mc.k.aR);
        Shaders.setProgramUniform1i(uniform_hideGUI, Shaders.mc.k.aI ? 1 : 0);
        Shaders.setProgramUniform1f(uniform_centerDepthSmooth, centerDepthSmooth);
        Shaders.setProgramUniform2i(uniform_atlasSize, atlasSizeX, atlasSizeY);
        Shaders.setProgramUniform1f(uniform_playerMood, playerMood);
        Shaders.setProgramUniform1i(uniform_renderStage, renderStage.ordinal());
        if (customUniforms != null) {
            customUniforms.update();
        }
    }

    private static void setImageUniforms() {
        if (!bindImageTextures) {
            return;
        }
        uniform_colorimg0.setValue(colorImageUnit[0]);
        uniform_colorimg1.setValue(colorImageUnit[1]);
        uniform_colorimg2.setValue(colorImageUnit[2]);
        uniform_colorimg3.setValue(colorImageUnit[3]);
        uniform_colorimg4.setValue(colorImageUnit[4]);
        uniform_colorimg5.setValue(colorImageUnit[5]);
        uniform_shadowcolorimg0.setValue(shadowColorImageUnit[0]);
        uniform_shadowcolorimg1.setValue(shadowColorImageUnit[1]);
    }

    private static void updateAlphaBlend(Program programOld, Program programNew) {
        GlBlendState blendNew;
        GlAlphaState alphaNew;
        if (programOld.getAlphaState() != null) {
            dem.unlockAlpha();
        }
        if (programOld.getBlendState() != null) {
            dem.unlockBlend();
        }
        if (programOld.getBlendStatesIndexed() != null) {
            dem.applyCurrentBlend();
        }
        if ((alphaNew = programNew.getAlphaState()) != null) {
            dem.lockAlpha(alphaNew);
        }
        if ((blendNew = programNew.getBlendState()) != null) {
            dem.lockBlend(blendNew);
        }
        if (programNew.getBlendStatesIndexed() != null) {
            dem.setBlendsIndexed(programNew.getBlendStatesIndexed());
        }
    }

    private static void setProgramUniform1i(ShaderUniform1i su, int value) {
        su.setValue(value);
    }

    private static void setProgramUniform2i(ShaderUniform2i su, int i0, int i1) {
        su.setValue(i0, i1);
    }

    private static void setProgramUniform1f(ShaderUniform1f su, float value) {
        su.setValue(value);
    }

    private static void setProgramUniform3f(ShaderUniform3f su, float f0, float f1, float f2) {
        su.setValue(f0, f1, f2);
    }

    private static void setProgramUniformMatrix4ARB(ShaderUniformM4 su, boolean transpose, FloatBuffer matrix) {
        su.setValue(transpose, matrix);
    }

    public static int getBufferIndex(String name) {
        int colortexIndex = ShaderParser.getIndex(name, "colortex", 0, 15);
        if (colortexIndex >= 0) {
            return colortexIndex;
        }
        int colorimgIndex = ShaderParser.getIndex(name, "colorimg", 0, 15);
        if (colorimgIndex >= 0) {
            return colorimgIndex;
        }
        if (name.equals("gcolor")) {
            return 0;
        }
        if (name.equals("gdepth")) {
            return 1;
        }
        if (name.equals("gnormal")) {
            return 2;
        }
        if (name.equals("composite")) {
            return 3;
        }
        if (name.equals("gaux1")) {
            return 4;
        }
        if (name.equals("gaux2")) {
            return 5;
        }
        if (name.equals("gaux3")) {
            return 6;
        }
        if (name.equals("gaux4")) {
            return 7;
        }
        return -1;
    }

    private static int getTextureFormatFromString(String par) {
        par = par.trim();
        for (int i2 = 0; i2 < formatNames.length; ++i2) {
            String name = formatNames[i2];
            if (!par.equals(name)) continue;
            return formatIds[i2];
        }
        return 0;
    }

    public static int getImageFormat(int textureFormat) {
        switch (textureFormat) {
            case 8194: {
                return 33321;
            }
            case 33319: {
                return 33323;
            }
            case 6407: {
                return 32849;
            }
            case 6408: {
                return 32856;
            }
            case 10768: {
                return 32849;
            }
            case 32855: {
                return 32856;
            }
            case 35901: {
                return 32852;
            }
        }
        return textureFormat;
    }

    private static void setupNoiseTexture() {
        if (noiseTexture == null && noiseTexturePath != null) {
            noiseTexture = Shaders.loadCustomTexture(15, noiseTexturePath);
        }
        if (noiseTexture == null) {
            noiseTexture = new HFNoiseTexture(noiseTextureResolution, noiseTextureResolution);
        }
    }

    private static void loadEntityDataMap() {
        mapBlockToEntityData = new IdentityHashMap<buo, Integer>(300);
        if (mapBlockToEntityData.isEmpty()) {
            for (vk key : gm.Q.c()) {
                buo block = (buo)gm.Q.a(key);
                int id = gm.Q.a((Object)block);
                mapBlockToEntityData.put(block, id);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream("/mc_Entity_x.txt")));
        }
        catch (Exception key) {
            // empty catch block
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m2 = patternLoadEntityDataMap.matcher(line);
                    if (m2.matches()) {
                        String name = m2.group(1);
                        String value = m2.group(2);
                        int id = Integer.parseInt(value);
                        vk loc = new vk(name);
                        if (gm.Q.c(loc)) {
                            buo block = (buo)gm.Q.a(loc);
                            mapBlockToEntityData.put(block, id);
                            continue;
                        }
                        SMCLog.warning("Unknown block name %s", name);
                        continue;
                    }
                    SMCLog.warning("unmatched %s\n", line);
                }
            }
            catch (Exception e2) {
                SMCLog.warning("Error parsing mc_Entity_x.txt");
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i2 = buf.position(); i2 < limit; ++i2) {
            buf.put(i2, 0);
        }
        return buf;
    }

    private static DrawBuffers fillIntBufferZero(DrawBuffers buf) {
        int limit = buf.limit();
        for (int i2 = buf.position(); i2 < limit; ++i2) {
            buf.put(i2, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isShaderPackInitialized) {
            int i2;
            Shaders.checkGLError("Shaders.uninit pre");
            for (i2 = 0; i2 < ProgramsAll.length; ++i2) {
                Program pi = ProgramsAll[i2];
                if (pi.getRef() != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)pi.getRef());
                    Shaders.checkGLError("del programRef");
                }
                pi.setRef(0);
                pi.setId(0);
                pi.setDrawBufSettings(null);
                pi.setDrawBuffers(null);
                pi.setCompositeMipmapSetting(0);
                ComputeProgram[] cps = pi.getComputePrograms();
                for (int c2 = 0; c2 < cps.length; ++c2) {
                    ComputeProgram cp = cps[c2];
                    if (cp.getRef() != 0) {
                        ARBShaderObjects.glDeleteObjectARB((int)cp.getRef());
                        Shaders.checkGLError("del programRef");
                    }
                    cp.setRef(0);
                    cp.setId(0);
                }
                pi.setComputePrograms(new ComputeProgram[0]);
            }
            hasDeferredPrograms = false;
            hasShadowcompPrograms = false;
            hasPreparePrograms = false;
            if (dfb != null) {
                dfb.delete();
                dfb = null;
                Shaders.checkGLError("del dfb");
            }
            if (sfb != null) {
                sfb.delete();
                sfb = null;
                Shaders.checkGLError("del sfb");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(dfbDrawBuffers);
            }
            if (sfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(sfbDrawBuffers);
            }
            if (noiseTexture != null) {
                noiseTexture.deleteTexture();
                noiseTexture = null;
            }
            for (i2 = 0; i2 < colorImageUnit.length; ++i2) {
                dem.bindImageTexture(colorImageUnit[i2], 0, 0, false, 0, 35000, 32856);
            }
            SMCLog.info("Uninit");
            hasShadowMap = false;
            shouldSkipDefaultShadow = false;
            isShaderPackInitialized = false;
            Shaders.checkGLError("Shaders.uninit");
        }
    }

    public static void scheduleResize() {
        renderDisplayHeight = 0;
    }

    public static void scheduleResizeShadow() {
        needResizeShadow = true;
    }

    private static void resize() {
        renderDisplayWidth = mc.aD().k();
        renderDisplayHeight = mc.aD().l();
        renderWidth = Math.round((float)renderDisplayWidth * configRenderResMul);
        renderHeight = Math.round((float)renderDisplayHeight * configRenderResMul);
        Shaders.setupFrameBuffer();
    }

    private static void resizeShadow() {
        needResizeShadow = false;
        shadowMapWidth = Math.round((float)spShadowMapWidth * configShadowResMul);
        shadowMapHeight = Math.round((float)spShadowMapHeight * configShadowResMul);
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupFrameBuffer() {
        if (dfb != null) {
            dfb.delete();
        }
        boolean[] depthFilterNearest = ArrayUtils.newBoolean(usedDepthBuffers, true);
        boolean[] depthFilterHardware = new boolean[usedDepthBuffers];
        boolean[] colorFilterNearest = new boolean[usedColorBuffers];
        int[] colorImageUnits = (int[])(bindImageTextures ? colorImageUnit : null);
        dfb = new ShadersFramebuffer("dfb", renderWidth, renderHeight, usedColorBuffers, usedDepthBuffers, 8, depthFilterNearest, depthFilterHardware, colorFilterNearest, colorBufferSizes, gbuffersFormat, colorTextureImageUnit, depthTextureImageUnit, colorImageUnits, dfbDrawBuffers);
        dfb.setup();
    }

    public static int getPixelFormat(int internalFormat) {
        switch (internalFormat) {
            case 33329: 
            case 33335: 
            case 36238: 
            case 36239: {
                return 36251;
            }
            case 33330: 
            case 33336: 
            case 36220: 
            case 36221: {
                return 36251;
            }
            case 33331: 
            case 33337: 
            case 36232: 
            case 36233: {
                return 36251;
            }
            case 33332: 
            case 33338: 
            case 36214: 
            case 36215: {
                return 36251;
            }
            case 33333: 
            case 33339: 
            case 36226: 
            case 36227: {
                return 36251;
            }
            case 33334: 
            case 33340: 
            case 36208: 
            case 36209: {
                return 36251;
            }
        }
        return 32993;
    }

    private static void setupShadowFrameBuffer() {
        if (!hasShadowMap) {
            return;
        }
        isShadowPass = true;
        if (sfb != null) {
            sfb.delete();
        }
        DynamicDimension[] shadowColorBufferSizes = new DynamicDimension[2];
        int[] shadowColorImageUnits = (int[])(bindImageTextures ? shadowColorImageUnit : null);
        sfb = new ShadersFramebuffer("sfb", shadowMapWidth, shadowMapHeight, usedShadowColorBuffers, usedShadowDepthBuffers, 8, shadowFilterNearest, shadowHardwareFilteringEnabled, shadowColorFilterNearest, shadowColorBufferSizes, shadowBuffersFormat, shadowColorTextureImageUnit, shadowDepthTextureImageUnit, shadowColorImageUnits, sfbDrawBuffers);
        sfb.setup();
        isShadowPass = false;
    }

    public static void beginRender(djz minecraft, djk activeRenderInfo, float partialTicks, long finishTimeNano) {
        block14: {
            Shaders.checkGLError("pre beginRender");
            Shaders.checkWorldChanged(Shaders.mc.r);
            mc = minecraft;
            mc.au().a("init");
            entityRenderer = Shaders.mc.h;
            if (!isShaderPackInitialized) {
                try {
                    Shaders.init();
                }
                catch (IllegalStateException e2) {
                    if (!Config.normalize(e2.getMessage()).equals("Function is not supported")) break block14;
                    Shaders.printChatAndLogError("[Shaders] Error: " + e2.getMessage());
                    e2.printStackTrace();
                    Shaders.setShaderPack(SHADER_PACK_NAME_NONE);
                    return;
                }
            }
        }
        if (mc.aD().k() != renderDisplayWidth || mc.aD().l() != renderDisplayHeight) {
            Shaders.resize();
        }
        if (needResizeShadow) {
            Shaders.resizeShadow();
        }
        if (++frameCounter >= 720720) {
            frameCounter = 0;
        }
        systemTime = System.currentTimeMillis();
        if (lastSystemTime == 0L) {
            lastSystemTime = systemTime;
        }
        diffSystemTime = systemTime - lastSystemTime;
        lastSystemTime = systemTime;
        frameTime = (float)diffSystemTime / 1000.0f;
        frameTimeCounter += frameTime;
        frameTimeCounter %= 3600.0f;
        pointOfViewChanged = pointOfView != Shaders.mc.k.g();
        pointOfView = Shaders.mc.k.g();
        dem.Q();
        ShadersRender.updateActiveRenderInfo(activeRenderInfo, minecraft, partialTicks);
        dem.R();
        dwt world = Shaders.mc.r;
        if (world != null) {
            worldTime = world.U();
            diffWorldTime = (worldTime - lastWorldTime) % 24000L;
            if (diffWorldTime < 0L) {
                diffWorldTime += 24000L;
            }
            lastWorldTime = worldTime;
            moonPhase = world.ag();
            rainStrength = world.d(partialTicks);
            float fadeScalarRain = (float)diffSystemTime * 0.01f;
            float tempRain = (float)Math.exp(Math.log(0.5) * (double)fadeScalarRain / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
            wetness = wetness * tempRain + rainStrength * (1.0f - tempRain);
            aqa renderViewEntity = activeRenderInfo.g();
            if (renderViewEntity != null) {
                isSleeping = renderViewEntity instanceof aqm && ((aqm)renderViewEntity).em();
                eyePosY = (float)activeRenderInfo.b().b();
                eyeBrightness = mc.ac().a(renderViewEntity, partialTicks);
                float fadeScalarBrightness = (float)diffSystemTime * 0.01f;
                float tempBrightness = (float)Math.exp(Math.log(0.5) * (double)fadeScalarBrightness / (double)eyeBrightnessHalflife);
                eyeBrightnessFadeX = eyeBrightnessFadeX * tempBrightness + (float)(eyeBrightness & 0xFFFF) * (1.0f - tempBrightness);
                eyeBrightnessFadeY = eyeBrightnessFadeY * tempBrightness + (float)(eyeBrightness >> 16) * (1.0f - tempBrightness);
                cux cameraFluidState = activeRenderInfo.k();
                isEyeInWater = cameraFluidState.a((ael)aef.b) ? 1 : (cameraFluidState.a((ael)aef.c) ? 2 : 0);
                if (renderViewEntity instanceof aqm) {
                    aqm player = (aqm)renderViewEntity;
                    nightVision = 0.0f;
                    if (player.a(apw.p)) {
                        nightVision = dzz.a(player, partialTicks);
                    }
                    blindness = 0.0f;
                    if (player.a(apw.o)) {
                        int blindnessTicks = player.b(apw.o).b();
                        blindness = Config.limit((float)blindnessTicks / 20.0f, 0.0f, 1.0f);
                    }
                }
                dcn skyColorV = world.a(renderViewEntity.cB(), partialTicks);
                skyColorV = CustomColors.getWorldSkyColor(skyColorV, world, renderViewEntity, partialTicks);
                skyColorR = (float)skyColorV.b;
                skyColorG = (float)skyColorV.c;
                skyColorB = (float)skyColorV.d;
            }
        }
        isRenderingWorld = true;
        isCompositeRendered = false;
        isShadowPass = false;
        isHandRenderedMain = false;
        isHandRenderedOff = false;
        skipRenderHandMain = false;
        skipRenderHandOff = false;
        dfb.setColorBuffersFiltering(9729, 9729);
        Shaders.bindGbuffersTextures();
        dfb.bindColorImages(true);
        if (sfb != null) {
            sfb.bindColorImages(true);
        }
        previousCameraPositionX = cameraPositionX;
        previousCameraPositionY = cameraPositionY;
        previousCameraPositionZ = cameraPositionZ;
        previousProjection.position(0);
        projection.position(0);
        previousProjection.put(projection);
        previousProjection.position(0);
        projection.position(0);
        previousModelView.position(0);
        modelView.position(0);
        previousModelView.put(modelView);
        previousModelView.position(0);
        modelView.position(0);
        Shaders.checkGLError("beginRender");
        ShadersRender.renderShadowMap(entityRenderer, activeRenderInfo, 0, partialTicks, finishTimeNano);
        mc.au().c();
        dfb.setColorTextures(true);
        Shaders.setRenderStage(RenderStage.NONE);
        Shaders.checkGLError("end beginRender");
    }

    private static void bindGbuffersTextures() {
        Shaders.bindTextures(4, customTexturesGbuffers);
    }

    private static void bindTextures(int startColorBuffer, ICustomTexture[] customTextures) {
        if (sfb != null) {
            sfb.bindColorTextures(0);
            sfb.bindDepthTextures(shadowDepthTextureImageUnit);
        }
        dfb.bindColorTextures(startColorBuffer);
        dfb.bindDepthTextures(depthTextureImageUnit);
        if (noiseTextureEnabled) {
            dem.q(33984 + noiseTexture.getTextureUnit());
            dem.s(noiseTexture.getTextureId());
            dem.q(33984);
        }
        Shaders.bindCustomTextures(customTextures);
    }

    public static void checkWorldChanged(dwt world) {
        if (currentWorld == world) {
            return;
        }
        dwt oldWorld = currentWorld;
        currentWorld = world;
        if (currentWorld == null) {
            cameraPositionX = 0.0;
            cameraPositionY = 0.0;
            cameraPositionZ = 0.0;
            previousCameraPositionX = 0.0;
            previousCameraPositionY = 0.0;
            previousCameraPositionZ = 0.0;
        }
        Shaders.setCameraOffset(mc.aa());
        int dimIdOld = WorldUtils.getDimensionId(oldWorld);
        int dimIdNew = WorldUtils.getDimensionId(world);
        if (dimIdNew != dimIdOld) {
            boolean dimShadersOld = shaderPackDimensions.contains(dimIdOld);
            boolean dimShadersNew = shaderPackDimensions.contains(dimIdNew);
            if (dimShadersOld || dimShadersNew) {
                Shaders.uninit();
            }
        }
        Smoother.resetValues();
    }

    public static void beginRenderPass(float partialTicks, long finishTimeNano) {
        if (isShadowPass) {
            return;
        }
        dfb.bindFramebuffer();
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        GlState.setDrawBuffers(null);
        ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        Shaders.useProgram(ProgramTextured);
        Shaders.checkGLError("end beginRenderPass");
    }

    public static void setViewport(int vx, int vy, int vw, int vh) {
        dem.a(true, true, true, true);
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        } else {
            GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
            dfb.bindFramebuffer();
            isRenderingDfb = true;
            dem.C();
            dem.m();
            GlState.setDrawBuffers(drawBuffersNone);
            Shaders.useProgram(ProgramTextured);
            Shaders.checkGLError("beginRenderPass");
        }
    }

    public static void setFogMode(int value) {
        fogMode = value;
        if (fogEnabled) {
            Shaders.setProgramUniform1i(uniform_fogMode, value);
        }
    }

    public static void setFogColor(float r2, float g2, float b2) {
        fogColorR = r2;
        fogColorG = g2;
        fogColorB = b2;
        Shaders.setProgramUniform3f(uniform_fogColor, fogColorR, fogColorG, fogColorB);
    }

    public static void setClearColor(float red, float green, float blue, float alpha) {
        clearColor.a(red, green, blue, 1.0f);
    }

    public static void clearRenderBuffer() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow clear pre");
            sfb.clearDepthBuffer(new h(1.0f, 1.0f, 1.0f, 1.0f));
            Shaders.checkGLError("shadow clear");
            return;
        }
        Shaders.checkGLError("clear pre");
        h[] clearColors = new h[usedColorBuffers];
        for (int i2 = 0; i2 < clearColors.length; ++i2) {
            clearColors[i2] = Shaders.getBufferClearColor(i2);
        }
        dfb.clearColorBuffers(gbuffersClear, clearColors);
        dfb.setDrawBuffers();
        Shaders.checkFramebufferStatus("clear");
        Shaders.checkGLError("clear");
    }

    public static void renderPrepare() {
        if (hasPreparePrograms) {
            Shaders.renderPrepareComposites();
            Shaders.bindGbuffersTextures();
            dfb.setDrawBuffers();
            dfb.setColorTextures(true);
        }
    }

    private static h getBufferClearColor(int buffer) {
        h col = gbuffersClearColor[buffer];
        if (col != null) {
            return col;
        }
        if (buffer == 0) {
            return clearColor;
        }
        if (buffer == 1) {
            return CLEAR_COLOR_1;
        }
        return CLEAR_COLOR_0;
    }

    public static void setCamera(dfm matrixStackIn, djk activeRenderInfo, float partialTicks) {
        aqa viewEntity = activeRenderInfo.g();
        dcn cameraPos = activeRenderInfo.b();
        double x2 = cameraPos.b;
        double y2 = cameraPos.c;
        double z = cameraPos.d;
        Shaders.updateCameraOffset(viewEntity);
        cameraPositionX = x2 - (double)cameraOffsetX;
        cameraPositionY = y2;
        cameraPositionZ = z - (double)cameraOffsetZ;
        Shaders.updateProjectionMatrix();
        b modelViewMat4 = matrixStackIn.c().a();
        b modelViewMat4T = new b(modelViewMat4);
        modelViewMat4T.e();
        modelViewMat4T.write(tempMat);
        modelView.position(0);
        modelView.put(tempMat);
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), faModelViewInverse, faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        Shaders.checkGLError("setCamera");
    }

    public static void updateProjectionMatrix() {
        GL43.glGetFloatv((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
        projection.position(0);
        projectionInverse.position(0);
    }

    private static void updateShadowProjectionMatrix() {
        GL43.glGetFloatv((int)2983, (FloatBuffer)((FloatBuffer)shadowProjection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)shadowProjectionInverse.position(0), (FloatBuffer)shadowProjection.position(0), faShadowProjectionInverse, faShadowProjection);
        shadowProjection.position(0);
        shadowProjectionInverse.position(0);
    }

    private static void updateCameraOffset(aqa viewEntity) {
        double adx = Math.abs(cameraPositionX - previousCameraPositionX);
        double adz = Math.abs(cameraPositionZ - previousCameraPositionZ);
        double apx = Math.abs(cameraPositionX);
        double apz = Math.abs(cameraPositionZ);
        if (adx > 1000.0 || adz > 1000.0 || apx > 1000000.0 || apz > 1000000.0) {
            Shaders.setCameraOffset(viewEntity);
        }
    }

    private static void setCameraOffset(aqa viewEntity) {
        if (viewEntity == null) {
            cameraOffsetX = 0;
            cameraOffsetZ = 0;
            return;
        }
        cameraOffsetX = (int)viewEntity.cD() / 1000 * 1000;
        cameraOffsetZ = (int)viewEntity.cH() / 1000 * 1000;
    }

    public static void setCameraShadow(dfm matrixStack, djk activeRenderInfo, float partialTicks) {
        float angleInterval;
        aqa viewEntity = activeRenderInfo.g();
        dcn cameraPos = activeRenderInfo.b();
        double x2 = cameraPos.b;
        double y2 = cameraPos.c;
        double z = cameraPos.d;
        Shaders.updateCameraOffset(viewEntity);
        cameraPositionX = x2 - (double)cameraOffsetX;
        cameraPositionY = y2;
        cameraPositionZ = z - (double)cameraOffsetZ;
        GL43.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        GL43.glMatrixMode((int)5889);
        GL43.glLoadIdentity();
        if (shadowMapIsOrtho) {
            GL43.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
        } else {
            dem.a(b.a((double)shadowMapFOV, (float)shadowMapWidth / (float)shadowMapHeight, 0.05f, 256.0f));
        }
        matrixStack.a(0.0, 0.0, -100.0);
        matrixStack.a(g.b.a(90.0f));
        celestialAngle = Shaders.mc.r.f(partialTicks);
        sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
        float angle = celestialAngle * -360.0f;
        float f2 = angleInterval = shadowAngleInterval > 0.0f ? angle % shadowAngleInterval - shadowAngleInterval * 0.5f : 0.0f;
        if ((double)sunAngle <= 0.5) {
            matrixStack.a(g.f.a(angle - angleInterval));
            matrixStack.a(g.b.a(sunPathRotation));
            shadowAngle = sunAngle;
        } else {
            matrixStack.a(g.f.a(angle + 180.0f - angleInterval));
            matrixStack.a(g.b.a(sunPathRotation));
            shadowAngle = sunAngle - 0.5f;
        }
        if (shadowMapIsOrtho) {
            float trans = shadowIntervalSize;
            float trans2 = trans / 2.0f;
            matrixStack.a((double)((float)x2 % trans - trans2), (double)((float)y2 % trans - trans2), (double)((float)z % trans - trans2));
        }
        float raSun = sunAngle * ((float)Math.PI * 2);
        float x1 = (float)Math.cos(raSun);
        float y1 = (float)Math.sin(raSun);
        float raTilt = sunPathRotation * ((float)Math.PI * 2);
        float x22 = x1;
        float y22 = y1 * (float)Math.cos(raTilt);
        float z2 = y1 * (float)Math.sin(raTilt);
        if ((double)sunAngle > 0.5) {
            x22 = -x22;
            y22 = -y22;
            z2 = -z2;
        }
        Shaders.shadowLightPositionVector[0] = x22;
        Shaders.shadowLightPositionVector[1] = y22;
        Shaders.shadowLightPositionVector[2] = z2;
        Shaders.shadowLightPositionVector[3] = 0.0f;
        Shaders.updateShadowProjectionMatrix();
        b shadowModelViewMat4 = matrixStack.c().a();
        shadowModelViewMat4.a((FloatBuffer)shadowModelView.position(0));
        SMath.invertMat4FBFA((FloatBuffer)shadowModelViewInverse.position(0), (FloatBuffer)shadowModelView.position(0), faShadowModelViewInverse, faShadowModelView);
        shadowModelView.position(0);
        shadowModelViewInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferProjection, false, projection);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferProjectionInverse, false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferPreviousProjection, false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferModelView, false, modelView);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferModelViewInverse, false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB(uniform_gbufferPreviousModelView, false, previousModelView);
        Shaders.setProgramUniformMatrix4ARB(uniform_shadowProjection, false, shadowProjection);
        Shaders.setProgramUniformMatrix4ARB(uniform_shadowProjectionInverse, false, shadowProjectionInverse);
        Shaders.setProgramUniformMatrix4ARB(uniform_shadowModelView, false, shadowModelView);
        Shaders.setProgramUniformMatrix4ARB(uniform_shadowModelViewInverse, false, shadowModelViewInverse);
        Shaders.checkGLError("setCamera");
    }

    public static void preCelestialRotate(dfm matrixStackIn) {
        matrixStackIn.a(g.f.a(sunPathRotation * 1.0f));
        Shaders.checkGLError("preCelestialRotate");
    }

    public static void postCelestialRotate(dfm matrixStackIn) {
        b modelViewMat4 = matrixStackIn.c().a();
        b modelViewMat4T = new b(modelViewMat4);
        modelViewMat4T.e();
        modelViewMat4T.write(tempMat);
        SMath.multiplyMat4xVec4(sunPosition, tempMat, sunPosModelView);
        SMath.multiplyMat4xVec4(moonPosition, tempMat, moonPosModelView);
        System.arraycopy(shadowAngle == sunAngle ? sunPosition : moonPosition, 0, shadowLightPosition, 0, 3);
        Shaders.setProgramUniform3f(uniform_sunPosition, sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f(uniform_moonPosition, moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f(uniform_shadowLightPosition, shadowLightPosition[0], shadowLightPosition[1], shadowLightPosition[2]);
        if (customUniforms != null) {
            customUniforms.update();
        }
        Shaders.checkGLError("postCelestialRotate");
    }

    public static void setUpPosition(dfm matrixStackIn) {
        b modelViewMat4 = matrixStackIn.c().a();
        b modelViewMat4T = new b(modelViewMat4);
        modelViewMat4T.e();
        modelViewMat4T.write(tempMat);
        SMath.multiplyMat4xVec4(upPosition, tempMat, upPosModelView);
        Shaders.setProgramUniform3f(uniform_upPosition, upPosition[0], upPosition[1], upPosition[2]);
        if (customUniforms != null) {
            customUniforms.update();
        }
    }

    public static void drawComposite() {
        GL43.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Shaders.drawCompositeQuad();
        int countInstances = activeProgram.getCountInstances();
        if (countInstances > 1) {
            for (int i2 = 1; i2 < countInstances; ++i2) {
                uniform_instanceId.setValue(i2);
                Shaders.drawCompositeQuad();
            }
            uniform_instanceId.setValue(0);
        }
    }

    private static void drawCompositeQuad() {
        if (!Shaders.canRenderQuads()) {
            GL43.glBegin((int)5);
            GL43.glTexCoord2f((float)0.0f, (float)0.0f);
            GL43.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL43.glTexCoord2f((float)1.0f, (float)0.0f);
            GL43.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL43.glTexCoord2f((float)0.0f, (float)1.0f);
            GL43.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL43.glTexCoord2f((float)1.0f, (float)1.0f);
            GL43.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
            GL43.glEnd();
            return;
        }
        GL43.glBegin((int)7);
        GL43.glTexCoord2f((float)0.0f, (float)0.0f);
        GL43.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL43.glTexCoord2f((float)1.0f, (float)0.0f);
        GL43.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL43.glTexCoord2f((float)1.0f, (float)1.0f);
        GL43.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL43.glTexCoord2f((float)0.0f, (float)1.0f);
        GL43.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL43.glEnd();
    }

    public static void renderDeferred() {
        if (isShadowPass) {
            return;
        }
        boolean buffersChanged = Shaders.checkBufferFlip(dfb, ProgramDeferredPre);
        if (hasDeferredPrograms) {
            Shaders.checkGLError("pre-render Deferred");
            Shaders.renderDeferredComposites();
            buffersChanged = true;
        }
        if (buffersChanged) {
            Shaders.bindGbuffersTextures();
            dfb.setColorTextures(true);
            DrawBuffers drawBuffersWater = ProgramWater.getDrawBuffers() != null ? ProgramWater.getDrawBuffers() : dfb.getDrawBuffers();
            GlState.setDrawBuffers(drawBuffersWater);
            dem.q(33984);
            mc.M().a(ekb.d);
        }
    }

    public static void renderCompositeFinal() {
        if (isShadowPass) {
            return;
        }
        Shaders.checkBufferFlip(dfb, ProgramCompositePre);
        Shaders.checkGLError("pre-render CompositeFinal");
        Shaders.renderComposites();
    }

    private static boolean checkBufferFlip(ShadersFramebuffer framebuffer, Program program) {
        boolean flipped = false;
        Boolean[] buffersFlip = program.getBuffersFlip();
        for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
            if (!Config.isTrue(buffersFlip[i2])) continue;
            framebuffer.flipColorTexture(i2);
            flipped = true;
        }
        return flipped;
    }

    private static void renderComposites() {
        if (isShadowPass) {
            return;
        }
        Shaders.renderComposites(ProgramsComposite, true, customTexturesComposite);
    }

    private static void renderDeferredComposites() {
        if (isShadowPass) {
            return;
        }
        Shaders.renderComposites(ProgramsDeferred, false, customTexturesDeferred);
    }

    public static void renderPrepareComposites() {
        Shaders.renderComposites(ProgramsPrepare, false, customTexturesPrepare);
    }

    private static void renderComposites(Program[] ps, boolean renderFinal, ICustomTexture[] customTextures) {
        Shaders.renderComposites(dfb, ps, renderFinal, customTextures);
    }

    public static void renderShadowComposites() {
        Shaders.renderComposites(sfb, ProgramsShadowcomp, false, customTexturesShadowcomp);
    }

    private static void renderComposites(ShadersFramebuffer framebuffer, Program[] ps, boolean renderFinal, ICustomTexture[] customTextures) {
        GL43.glPushMatrix();
        GL43.glLoadIdentity();
        GL43.glMatrixMode((int)5889);
        GL43.glPushMatrix();
        GL43.glLoadIdentity();
        GL43.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL43.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        dem.K();
        dem.d();
        dem.n();
        dem.m();
        dem.b(519);
        dem.a(false);
        dem.g();
        Shaders.bindTextures(0, customTextures);
        framebuffer.bindColorImages(true);
        framebuffer.setColorTextures(false);
        framebuffer.setDepthTexture();
        framebuffer.setDrawBuffers();
        Shaders.checkGLError("pre-composite");
        for (int i2 = 0; i2 < ps.length; ++i2) {
            Program program = ps[i2];
            Shaders.dispatchComputes(framebuffer, program.getComputePrograms());
            if (program.getId() == 0) continue;
            Shaders.useProgram(program);
            Shaders.checkGLError(program.getName());
            if (program.hasCompositeMipmaps()) {
                framebuffer.genCompositeMipmap(program.getCompositeMipmapSetting());
            }
            Shaders.preDrawComposite(framebuffer, program);
            Shaders.drawComposite();
            Shaders.postDrawComposite(framebuffer, program);
            framebuffer.flipColorTextures(program.getToggleColorTextures());
        }
        Shaders.checkGLError("composite");
        if (renderFinal) {
            Shaders.renderFinal();
            isCompositeRendered = true;
        }
        dem.K();
        dem.e();
        dem.o();
        dem.b(515);
        dem.a(true);
        GL43.glPopMatrix();
        GL43.glMatrixMode((int)5888);
        GL43.glPopMatrix();
        Shaders.useProgram(ProgramNone);
    }

    private static void preDrawComposite(ShadersFramebuffer framebuffer, Program program) {
        RenderScale rs;
        int drawWidth = framebuffer.getWidth();
        int drawHeight = framebuffer.getHeight();
        if (program.getDrawSize() != null) {
            Dimension dim = program.getDrawSize().getDimension(drawWidth, drawHeight);
            drawWidth = dim.width;
            drawHeight = dim.height;
            FixedFramebuffer ff = framebuffer.getFixedFramebuffer(drawWidth, drawHeight, program.getDrawBuffers(), false);
            ff.bindFramebuffer();
            GL43.glViewport((int)0, (int)0, (int)drawWidth, (int)drawHeight);
        }
        if ((rs = program.getRenderScale()) != null) {
            int x2 = (int)((float)drawWidth * rs.getOffsetX());
            int y2 = (int)((float)drawHeight * rs.getOffsetY());
            int w2 = (int)((float)drawWidth * rs.getScale());
            int h2 = (int)((float)drawHeight * rs.getScale());
            GL43.glViewport((int)x2, (int)y2, (int)w2, (int)h2);
        }
    }

    private static void postDrawComposite(ShadersFramebuffer framebuffer, Program program) {
        RenderScale rs;
        if (program.getDrawSize() != null) {
            framebuffer.bindFramebuffer();
            GL43.glViewport((int)0, (int)0, (int)framebuffer.getWidth(), (int)framebuffer.getHeight());
        }
        if ((rs = activeProgram.getRenderScale()) != null) {
            GL43.glViewport((int)0, (int)0, (int)framebuffer.getWidth(), (int)framebuffer.getHeight());
        }
    }

    public static void dispatchComputes(ShadersFramebuffer framebuffer, ComputeProgram[] cps) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            ComputeProgram cp = cps[i2];
            Shaders.dispatchCompute(cp);
            if (!cp.hasCompositeMipmaps()) continue;
            framebuffer.genCompositeMipmap(cp.getCompositeMipmapSetting());
        }
    }

    public static void dispatchCompute(ComputeProgram cp) {
        if (dfb == null) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)cp.getId());
        if (Shaders.checkGLError("useComputeProgram") != 0) {
            cp.setId(0);
            return;
        }
        shaderUniforms.setProgram(cp.getId());
        if (customUniforms != null) {
            customUniforms.setProgram(cp.getId());
        }
        Shaders.setProgramUniforms(cp.getProgramStage());
        Shaders.setImageUniforms();
        dfb.bindColorImages(true);
        gr workGroups = cp.getWorkGroups();
        if (workGroups == null) {
            dcm workGroupsRender = cp.getWorkGroupsRender();
            if (workGroupsRender == null) {
                workGroupsRender = new dcm(1.0f, 1.0f);
            }
            int computeWidth = (int)Math.ceil((float)renderWidth * workGroupsRender.i);
            int computeHeight = (int)Math.ceil((float)renderHeight * workGroupsRender.j);
            gr localSize = cp.getLocalSize();
            int groupsX = (int)Math.ceil(1.0 * (double)computeWidth / (double)localSize.u());
            int groupsY = (int)Math.ceil(1.0 * (double)computeHeight / (double)localSize.v());
            workGroups = new gr(groupsX, groupsY, 1);
        }
        GL43.glMemoryBarrier((int)40);
        GL43.glDispatchCompute((int)workGroups.u(), (int)workGroups.v(), (int)workGroups.w());
        GL43.glMemoryBarrier((int)40);
        Shaders.checkGLError("compute");
    }

    private static void renderFinal() {
        Shaders.dispatchComputes(dfb, ProgramFinal.getComputePrograms());
        isRenderingDfb = false;
        mc.f().a(true);
        dem.a(dek.a, dek.c, 3553, mc.f().f(), 0);
        GL43.glViewport((int)0, (int)0, (int)mc.aD().k(), (int)mc.aD().l());
        dem.a(true);
        GL43.glClearColor((float)clearColor.a(), (float)clearColor.b(), (float)clearColor.c(), (float)1.0f);
        GL43.glClear((int)16640);
        GL43.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        dem.K();
        dem.d();
        dem.n();
        dem.m();
        dem.b(519);
        dem.a(false);
        Shaders.checkGLError("pre-final");
        Shaders.useProgram(ProgramFinal);
        Shaders.checkGLError("final");
        if (ProgramFinal.hasCompositeMipmaps()) {
            dfb.genCompositeMipmap(ProgramFinal.getCompositeMipmapSetting());
        }
        Shaders.drawComposite();
        Shaders.checkGLError("renderCompositeFinal");
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow endRender");
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        dem.a(true, true, true, true);
        Shaders.useProgram(ProgramNone);
        Shaders.setRenderStage(RenderStage.NONE);
        dep.b();
        Shaders.checkGLError("endRender end");
    }

    public static void beginSky() {
        isRenderingSky = true;
        fogEnabled = true;
        Shaders.useProgram(ProgramSkyTextured);
        Shaders.pushEntity(-2, 0);
        Shaders.setRenderStage(RenderStage.SKY);
    }

    public static void setSkyColor(dcn v3color) {
        skyColorR = (float)v3color.b;
        skyColorG = (float)v3color.c;
        skyColorB = (float)v3color.d;
        Shaders.setProgramUniform3f(uniform_skyColor, skyColorR, skyColorG, skyColorB);
    }

    public static void drawHorizon(dfm matrixStackIn) {
        dfh tess = dfo.a().c();
        float farDistance = Shaders.mc.k.b * 16;
        double xzq = (double)farDistance * 0.9238;
        double xzp = (double)farDistance * 0.3826;
        double xzn = -xzp;
        double xzm = -xzq;
        double top = 16.0;
        double bot = -cameraPositionY + currentWorld.w().g() + 12.0 - 16.0;
        if (cameraPositionY < currentWorld.w().g()) {
            bot = -4.0;
        }
        dem.Q();
        dem.a(matrixStackIn.c().a());
        tess.a(7, dfk.k);
        tess.a(xzn, bot, xzm).d();
        tess.a(xzn, top, xzm).d();
        tess.a(xzm, top, xzn).d();
        tess.a(xzm, bot, xzn).d();
        tess.a(xzm, bot, xzn).d();
        tess.a(xzm, top, xzn).d();
        tess.a(xzm, top, xzp).d();
        tess.a(xzm, bot, xzp).d();
        tess.a(xzm, bot, xzp).d();
        tess.a(xzm, top, xzp).d();
        tess.a(xzn, top, xzq).d();
        tess.a(xzn, bot, xzq).d();
        tess.a(xzn, bot, xzq).d();
        tess.a(xzn, top, xzq).d();
        tess.a(xzp, top, xzq).d();
        tess.a(xzp, bot, xzq).d();
        tess.a(xzp, bot, xzq).d();
        tess.a(xzp, top, xzq).d();
        tess.a(xzq, top, xzp).d();
        tess.a(xzq, bot, xzp).d();
        tess.a(xzq, bot, xzp).d();
        tess.a(xzq, top, xzp).d();
        tess.a(xzq, top, xzn).d();
        tess.a(xzq, bot, xzn).d();
        tess.a(xzq, bot, xzn).d();
        tess.a(xzq, top, xzn).d();
        tess.a(xzp, top, xzm).d();
        tess.a(xzp, bot, xzm).d();
        tess.a(xzp, bot, xzm).d();
        tess.a(xzp, top, xzm).d();
        tess.a(xzn, top, xzm).d();
        tess.a(xzn, bot, xzm).d();
        tess.a(xzm, bot, xzm).d();
        tess.a(xzm, bot, xzq).d();
        tess.a(xzq, bot, xzq).d();
        tess.a(xzq, bot, xzm).d();
        dfo.a().b();
        dem.R();
    }

    public static void preSkyList(dfm matrixStackIn) {
        Shaders.setUpPosition(matrixStackIn);
        GL11.glColor3f((float)fogColorR, (float)fogColorG, (float)fogColorB);
        Shaders.drawHorizon(matrixStackIn);
        GL11.glColor3f((float)skyColorR, (float)skyColorG, (float)skyColorB);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
        Shaders.popEntity();
        Shaders.setRenderStage(RenderStage.NONE);
    }

    public static void beginUpdateChunks() {
        Shaders.checkGLError("beginUpdateChunks1");
        Shaders.checkFramebufferStatus("beginUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(ProgramTerrain);
        }
        Shaders.checkGLError("beginUpdateChunks2");
        Shaders.checkFramebufferStatus("beginUpdateChunks2");
    }

    public static void endUpdateChunks() {
        Shaders.checkGLError("endUpdateChunks1");
        Shaders.checkFramebufferStatus("endUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(ProgramTerrain);
        }
        Shaders.checkGLError("endUpdateChunks2");
        Shaders.checkFramebufferStatus("endUpdateChunks2");
    }

    public static boolean shouldRenderClouds(dkd gs2) {
        if (!shaderPackLoaded) {
            return true;
        }
        Shaders.checkGLError("shouldRenderClouds");
        return isShadowPass ? configCloudShadow : gs2.e != djn.a;
    }

    public static void beginClouds() {
        fogEnabled = true;
        Shaders.pushEntity(-3, 0);
        Shaders.useProgram(ProgramClouds);
        Shaders.setRenderStage(RenderStage.CLOUDS);
    }

    public static void endClouds() {
        Shaders.disableFog();
        Shaders.popEntity();
        Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
        Shaders.setRenderStage(RenderStage.NONE);
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(ProgramEntities);
            Shaders.setRenderStage(RenderStage.ENTITIES);
        }
    }

    public static void nextEntity(aqa entity) {
        if (isRenderingWorld) {
            if (entity.bE()) {
                Shaders.useProgram(ProgramEntitiesGlowing);
            } else {
                Shaders.useProgram(ProgramEntities);
            }
            Shaders.setEntityId(entity);
        }
    }

    public static void setEntityId(aqa entity) {
        if (uniform_entityId.isDefined()) {
            int id = EntityUtils.getEntityIdByClass(entity);
            int idAlias = EntityAliases.getEntityAliasId(id);
            uniform_entityId.setValue(idAlias);
        }
    }

    public static void beginSpiderEyes() {
        if (isRenderingWorld && ProgramSpiderEyes.getId() != ProgramNone.getId()) {
            Shaders.useProgram(ProgramSpiderEyes);
            dem.e();
            dem.a(516, 0.0f);
            dem.b(770, 771);
        }
    }

    public static void endSpiderEyes() {
        if (isRenderingWorld && ProgramSpiderEyes.getId() != ProgramNone.getId()) {
            Shaders.useProgram(ProgramEntities);
            dem.d();
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.setEntityId(null);
            Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
        }
    }

    public static void beginEntitiesGlowing() {
        if (isRenderingWorld) {
            isEntitiesGlowing = true;
        }
    }

    public static void endEntitiesGlowing() {
        if (isRenderingWorld) {
            isEntitiesGlowing = false;
        }
    }

    public static void setEntityColor(float r2, float g2, float b2, float a2) {
        if (isRenderingWorld && !isShadowPass) {
            uniform_entityColor.setValue(r2, g2, b2, a2);
        }
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            ShadersTex.bindTexture(defaultTexture);
            if (!isShadowPass) {
                GlState.setDrawBuffers(drawBuffersColorAtt[0]);
            }
        }
    }

    public static void endLivingDamage() {
        if (isRenderingWorld && !isShadowPass) {
            GlState.setDrawBuffers(ProgramEntities.getDrawBuffers());
        }
    }

    public static void beginBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("beginBlockEntities");
            Shaders.useProgram(ProgramBlock);
            Shaders.setRenderStage(RenderStage.BLOCK_ENTITIES);
        }
    }

    public static void nextBlockEntity(ccj tileEntity) {
        if (isRenderingWorld) {
            Shaders.checkGLError("nextBlockEntity");
            Shaders.useProgram(ProgramBlock);
            Shaders.setBlockEntityId(tileEntity);
        }
    }

    public static void setBlockEntityId(ccj tileEntity) {
        if (uniform_blockEntityId.isDefined()) {
            int blockId = Shaders.getBlockEntityId(tileEntity);
            uniform_blockEntityId.setValue(blockId);
        }
    }

    private static int getBlockEntityId(ccj tileEntity) {
        if (tileEntity == null) {
            return -1;
        }
        ceh blockState = tileEntity.p();
        int blockId = BlockAliases.getAliasBlockId(blockState);
        return blockId;
    }

    public static void endBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("endBlockEntities");
            Shaders.setBlockEntityId(null);
            Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
            ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        }
    }

    public static void beginLitParticles() {
        Shaders.useProgram(ProgramTexturedLit);
    }

    public static void beginParticles() {
        Shaders.useProgram(ProgramTextured);
        Shaders.setRenderStage(RenderStage.PARTICLES);
    }

    public static void endParticles() {
        Shaders.useProgram(ProgramTexturedLit);
        Shaders.setRenderStage(RenderStage.NONE);
    }

    public static void readCenterDepth() {
        if (!isShadowPass && centerDepthSmoothEnabled) {
            tempDirectFloatBuffer.clear();
            GL43.glReadPixels((int)(renderWidth / 2), (int)(renderHeight / 2), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)tempDirectFloatBuffer);
            centerDepth = tempDirectFloatBuffer.get(0);
            float fadeScalar = (float)diffSystemTime * 0.01f;
            float fadeFactor = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)centerDepthSmoothHalflife);
            centerDepthSmooth = centerDepthSmooth * fadeFactor + centerDepth * (1.0f - fadeFactor);
        }
    }

    public static void beginWeather() {
        if (!isShadowPass) {
            dem.m();
            dem.o();
            dem.b(770, 771);
            dem.e();
            Shaders.useProgram(ProgramWeather);
            Shaders.setRenderStage(RenderStage.RAIN_SNOW);
        }
    }

    public static void endWeather() {
        dem.n();
        Shaders.useProgram(ProgramTexturedLit);
        Shaders.setRenderStage(RenderStage.NONE);
    }

    public static void preRenderHand() {
        if (!isShadowPass && usedDepthBuffers >= 3) {
            dem.q(33996);
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            dem.q(33984);
        }
    }

    public static void preWater() {
        if (usedDepthBuffers >= 2) {
            dem.q(33995);
            Shaders.checkGLError("pre copy depth");
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            Shaders.checkGLError("copy depth");
            dem.q(33984);
        }
        ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            if (!isShadowPass) {
                Shaders.renderDeferred();
                Shaders.useProgram(ProgramWater);
                dem.o();
                dem.a(true);
            } else {
                dem.a(true);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                // empty if block
            }
            Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
        }
    }

    public static void applyHandDepth(dfm matrixStackIn) {
        if ((double)configHandDepthMul != 1.0) {
            matrixStackIn.a(1.0f, 1.0f, configHandDepthMul);
        }
    }

    public static void beginHand(dfm matrixStackIn, boolean translucent) {
        GL43.glMatrixMode((int)5888);
        GL43.glPushMatrix();
        GL43.glMatrixMode((int)5889);
        GL43.glPushMatrix();
        GL43.glMatrixMode((int)5888);
        matrixStackIn.a();
        if (translucent) {
            Shaders.useProgram(ProgramHandWater);
        } else {
            Shaders.useProgram(ProgramHand);
        }
        Shaders.checkGLError("beginHand");
        Shaders.checkFramebufferStatus("beginHand");
    }

    public static void endHand(dfm matrixStackIn) {
        Shaders.checkGLError("pre endHand");
        Shaders.checkFramebufferStatus("pre endHand");
        matrixStackIn.b();
        GL43.glMatrixMode((int)5889);
        GL43.glPopMatrix();
        GL43.glMatrixMode((int)5888);
        GL43.glPopMatrix();
        dem.b(770, 771);
        Shaders.checkGLError("endHand");
    }

    public static void beginFPOverlay() {
        dem.g();
        dem.n();
    }

    public static void endFPOverlay() {
    }

    public static void glEnableWrapper(int cap) {
        GL43.glEnable((int)cap);
        if (cap == 3553) {
            Shaders.enableTexture2D();
        } else if (cap == 2912) {
            Shaders.enableFog();
        }
    }

    public static void glDisableWrapper(int cap) {
        GL43.glDisable((int)cap);
        if (cap == 3553) {
            Shaders.disableTexture2D();
        } else if (cap == 2912) {
            Shaders.disableFog();
        }
    }

    public static void sglEnableT2D(int cap) {
        GL43.glEnable((int)cap);
        Shaders.enableTexture2D();
    }

    public static void sglDisableT2D(int cap) {
        GL43.glDisable((int)cap);
        Shaders.disableTexture2D();
    }

    public static void sglEnableFog(int cap) {
        GL43.glEnable((int)cap);
        Shaders.enableFog();
    }

    public static void sglDisableFog(int cap) {
        GL43.glDisable((int)cap);
        Shaders.disableFog();
    }

    public static void enableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(ProgramSkyTextured);
        } else if (activeProgram == ProgramBasic) {
            Shaders.useProgram(lightmapEnabled ? ProgramTexturedLit : ProgramTextured);
        }
    }

    public static void disableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(ProgramSkyBasic);
        } else if (activeProgram == ProgramTextured || activeProgram == ProgramTexturedLit) {
            Shaders.useProgram(ProgramBasic);
        }
    }

    public static void pushProgram() {
        programStack.push(activeProgram);
    }

    public static void popProgram() {
        Program program = programStack.pop();
        Shaders.useProgram(program);
    }

    public static void beginLeash() {
        Shaders.pushProgram();
        Shaders.useProgram(ProgramBasic);
    }

    public static void endLeash() {
        Shaders.popProgram();
    }

    public static void enableFog() {
        fogEnabled = true;
        Shaders.setProgramUniform1i(uniform_fogMode, fogMode);
        Shaders.setProgramUniform1f(uniform_fogDensity, fogDensity);
    }

    public static void disableFog() {
        fogEnabled = false;
        Shaders.setProgramUniform1i(uniform_fogMode, 0);
    }

    public static void setFogMode(dem.m fogMode) {
        Shaders.setFogMode(fogMode.d);
    }

    public static void setFogDensity(float value) {
        fogDensity = value;
        if (fogEnabled) {
            Shaders.setProgramUniform1f(uniform_fogDensity, value);
        }
    }

    public static void sglFogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
        if (pname == 2917) {
            fogMode = param;
            if (fogEnabled) {
                Shaders.setProgramUniform1i(uniform_fogMode, fogMode);
            }
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == ProgramTextured) {
            Shaders.useProgram(ProgramTexturedLit);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == ProgramTexturedLit) {
            Shaders.useProgram(ProgramTextured);
        }
    }

    public static int getEntityData() {
        return entityData[entityDataIndex * 2];
    }

    public static int getEntityData2() {
        return entityData[entityDataIndex * 2 + 1];
    }

    public static int setEntityData1(int data1) {
        Shaders.entityData[Shaders.entityDataIndex * 2] = entityData[entityDataIndex * 2] & 0xFFFF | data1 << 16;
        return data1;
    }

    public static int setEntityData2(int data2) {
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = entityData[entityDataIndex * 2 + 1] & 0xFFFF0000 | data2 & 0xFFFF;
        return data2;
    }

    public static void pushEntity(int data0, int data1) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF | data1 << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(int data0) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(buo block) {
        int blockRenderType = block.b(block.n()).ordinal();
        Shaders.entityData[++Shaders.entityDataIndex * 2] = gm.Q.a((Object)block) & 0xFFFF | blockRenderType << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void popEntity() {
        Shaders.entityData[Shaders.entityDataIndex * 2] = 0;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
        --entityDataIndex;
    }

    public static void mcProfilerEndSection() {
        mc.au().c();
    }

    public static String getShaderPackName() {
        if (shaderPack == null) {
            return null;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return null;
        }
        return shaderPack.getName();
    }

    public static InputStream getShaderPackResourceStream(String path) {
        if (shaderPack == null) {
            return null;
        }
        return shaderPack.getResourceAsStream(path);
    }

    public static void nextAntialiasingLevel(boolean forward) {
        if (forward) {
            if ((configAntialiasingLevel += 2) > 4) {
                configAntialiasingLevel = 0;
            }
        } else if ((configAntialiasingLevel -= 2) < 0) {
            configAntialiasingLevel = 4;
        }
        configAntialiasingLevel = configAntialiasingLevel / 2 * 2;
        configAntialiasingLevel = Config.limit(configAntialiasingLevel, 0, 4);
    }

    public static void checkShadersModInstalled() {
        try {
            Class<?> clazz = Class.forName("shadersmod.transform.SMCClassTransformer");
        }
        catch (Throwable e2) {
            return;
        }
        throw new RuntimeException("Shaders Mod detected. Please remove it, OptiFine has built-in support for shaders.");
    }

    public static void resourcesReloaded() {
        Shaders.loadShaderPackResources();
        Shaders.reloadCustomTexturesLocation(customTexturesGbuffers);
        Shaders.reloadCustomTexturesLocation(customTexturesComposite);
        Shaders.reloadCustomTexturesLocation(customTexturesDeferred);
        Shaders.reloadCustomTexturesLocation(customTexturesShadowcomp);
        Shaders.reloadCustomTexturesLocation(customTexturesPrepare);
        if (shaderPackLoaded) {
            BlockAliases.resourcesReloaded();
            ItemAliases.resourcesReloaded();
            EntityAliases.resourcesReloaded();
        }
    }

    private static void loadShaderPackResources() {
        shaderPackResources = new HashMap<String, String>();
        if (!shaderPackLoaded) {
            return;
        }
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "/shaders/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        listFiles.add(PREFIX + Shaders.getLocaleUppercase(EN_US) + SUFFIX);
        if (!Config.getGameSettings().aV.equals(EN_US)) {
            String language = Config.getGameSettings().aV;
            listFiles.add(PREFIX + language + SUFFIX);
            listFiles.add(PREFIX + Shaders.getLocaleUppercase(language) + SUFFIX);
        }
        try {
            for (String file : listFiles) {
                InputStream in = shaderPack.getResourceAsStream(file);
                if (in == null) continue;
                PropertiesOrdered props = new PropertiesOrdered();
                Lang.loadLocaleData(in, props);
                in.close();
                Set<Object> keys = ((Properties)props).keySet();
                for (String string : keys) {
                    String value = props.getProperty(string);
                    shaderPackResources.put(string, value);
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static String getLocaleUppercase(String name) {
        int pos = name.indexOf(95);
        if (pos < 0) {
            return name;
        }
        String nameUp = name.substring(0, pos) + name.substring(pos).toUpperCase(Locale.ROOT);
        return nameUp;
    }

    public static String translate(String key, String def) {
        String str = shaderPackResources.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    public static boolean isProgramPath(String path) {
        Program p2;
        if (path == null) {
            return false;
        }
        if (path.length() <= 0) {
            return false;
        }
        int pos = path.lastIndexOf("/");
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        return (p2 = Shaders.getProgram(path)) != null;
    }

    public static Program getProgram(String name) {
        return programs.getProgram(name);
    }

    public static void setItemToRenderMain(bmb itemToRenderMain) {
        itemToRenderMainTranslucent = Shaders.isTranslucentBlock(itemToRenderMain);
    }

    public static void setItemToRenderOff(bmb itemToRenderOff) {
        itemToRenderOffTranslucent = Shaders.isTranslucentBlock(itemToRenderOff);
    }

    public static boolean isItemToRenderMainTranslucent() {
        return itemToRenderMainTranslucent;
    }

    public static boolean isItemToRenderOffTranslucent() {
        return itemToRenderOffTranslucent;
    }

    public static boolean isBothHandsRendered() {
        return isHandRenderedMain && isHandRenderedOff;
    }

    private static boolean isTranslucentBlock(bmb stack) {
        if (stack == null) {
            return false;
        }
        blx item = stack.b();
        if (item == null) {
            return false;
        }
        if (!(item instanceof bkh)) {
            return false;
        }
        bkh itemBlock = (bkh)item;
        buo block = itemBlock.e();
        if (block == null) {
            return false;
        }
        eao blockRenderLayer = eab.a((ceh)block.n());
        return blockRenderLayer == RenderTypes.TRANSLUCENT;
    }

    public static boolean isSkipRenderHand(aot hand) {
        if (hand == aot.a && skipRenderHandMain) {
            return true;
        }
        return hand == aot.b && skipRenderHandOff;
    }

    public static boolean isRenderBothHands() {
        return !skipRenderHandMain && !skipRenderHandOff;
    }

    public static void setSkipRenderHands(boolean skipMain, boolean skipOff) {
        skipRenderHandMain = skipMain;
        skipRenderHandOff = skipOff;
    }

    public static void setHandsRendered(boolean handMain, boolean handOff) {
        isHandRenderedMain = handMain;
        isHandRenderedOff = handOff;
    }

    public static boolean isHandRenderedMain() {
        return isHandRenderedMain;
    }

    public static boolean isHandRenderedOff() {
        return isHandRenderedOff;
    }

    public static float getShadowRenderDistance() {
        if (shadowDistanceRenderMul < 0.0f) {
            return -1.0f;
        }
        return shadowMapHalfPlane * shadowDistanceRenderMul;
    }

    public static void beginRenderFirstPersonHand(boolean translucent) {
        isRenderingFirstPersonHand = true;
        if (translucent) {
            Shaders.setRenderStage(RenderStage.HAND_TRANSLUCENT);
        } else {
            Shaders.setRenderStage(RenderStage.HAND_SOLID);
        }
    }

    public static void endRenderFirstPersonHand() {
        isRenderingFirstPersonHand = false;
        Shaders.setRenderStage(RenderStage.NONE);
    }

    public static boolean isRenderingFirstPersonHand() {
        return isRenderingFirstPersonHand;
    }

    public static void beginBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram(ProgramBeaconBeam);
        }
    }

    public static void endBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram(ProgramBlock);
        }
    }

    public static dwt getCurrentWorld() {
        return currentWorld;
    }

    public static fx getWorldCameraPosition() {
        return new fx(cameraPositionX + (double)cameraOffsetX, cameraPositionY, cameraPositionZ + (double)cameraOffsetZ);
    }

    public static boolean isCustomUniforms() {
        return customUniforms != null;
    }

    public static boolean canRenderQuads() {
        if (hasGeometryShaders) {
            return Shaders.capabilities.GL_NV_geometry_shader4;
        }
        return true;
    }

    public static boolean isOverlayDisabled() {
        return shaderPackLoaded;
    }

    public static boolean isRemapLightmap() {
        return shaderPackLoaded;
    }

    public static boolean isEffectsModelView() {
        return shaderPackLoaded;
    }

    public static void flushRenderBuffers() {
        RenderUtils.flushRenderBuffers();
    }

    public static void setRenderStage(RenderStage stage) {
        if (!shaderPackLoaded) {
            return;
        }
        renderStage = stage;
        uniform_renderStage.setValue(stage.ordinal());
    }

    static {
        isInitializedOnce = false;
        isShaderPackInitialized = false;
        hasGlGenMipmap = false;
        countResetDisplayLists = 0;
        renderDisplayWidth = 0;
        renderDisplayHeight = 0;
        renderWidth = 0;
        renderHeight = 0;
        isRenderingWorld = false;
        isRenderingSky = false;
        isCompositeRendered = false;
        isRenderingDfb = false;
        isShadowPass = false;
        isEntitiesGlowing = false;
        renderItemKeepDepthMask = false;
        itemToRenderMainTranslucent = false;
        itemToRenderOffTranslucent = false;
        sunPosition = new float[4];
        moonPosition = new float[4];
        shadowLightPosition = new float[4];
        upPosition = new float[4];
        shadowLightPositionVector = new float[4];
        upPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        sunPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        moonPosModelView = new float[]{0.0f, -100.0f, 0.0f, 0.0f};
        tempMat = new float[16];
        clearColor = new h();
        worldTime = 0L;
        lastWorldTime = 0L;
        diffWorldTime = 0L;
        celestialAngle = 0.0f;
        sunAngle = 0.0f;
        shadowAngle = 0.0f;
        moonPhase = 0;
        systemTime = 0L;
        lastSystemTime = 0L;
        diffSystemTime = 0L;
        frameCounter = 0;
        frameTime = 0.0f;
        frameTimeCounter = 0.0f;
        systemTimeInt32 = 0;
        pointOfView = djl.a;
        pointOfViewChanged = false;
        rainStrength = 0.0f;
        wetness = 0.0f;
        wetnessHalfLife = 600.0f;
        drynessHalfLife = 200.0f;
        eyeBrightnessHalflife = 10.0f;
        usewetness = false;
        isEyeInWater = 0;
        eyeBrightness = 0;
        eyeBrightnessFadeX = 0.0f;
        eyeBrightnessFadeY = 0.0f;
        eyePosY = 0.0f;
        centerDepth = 0.0f;
        centerDepthSmooth = 0.0f;
        centerDepthSmoothHalflife = 1.0f;
        centerDepthSmoothEnabled = false;
        superSamplingLevel = 1;
        nightVision = 0.0f;
        blindness = 0.0f;
        lightmapEnabled = false;
        fogEnabled = true;
        renderStage = RenderStage.NONE;
        baseAttribId = 11;
        entityAttrib = baseAttribId + 0;
        midTexCoordAttrib = baseAttribId + 1;
        tangentAttrib = baseAttribId + 2;
        velocityAttrib = baseAttribId + 3;
        midBlockAttrib = baseAttribId + 4;
        useEntityAttrib = false;
        useMidTexCoordAttrib = false;
        useTangentAttrib = false;
        useVelocityAttrib = false;
        useMidBlockAttrib = false;
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        progUseVelocityAttrib = false;
        progUseMidBlockAttrib = false;
        progArbGeometryShader4 = false;
        progExtGeometryShader4 = false;
        progMaxVerticesOut = 3;
        hasGeometryShaders = false;
        atlasSizeX = 0;
        atlasSizeY = 0;
        shaderUniforms = new ShaderUniforms();
        uniform_entityColor = shaderUniforms.make4f("entityColor");
        uniform_entityId = shaderUniforms.make1i("entityId");
        uniform_blockEntityId = shaderUniforms.make1i("blockEntityId");
        uniform_texture = shaderUniforms.make1i("texture");
        uniform_lightmap = shaderUniforms.make1i("lightmap");
        uniform_normals = shaderUniforms.make1i("normals");
        uniform_specular = shaderUniforms.make1i("specular");
        uniform_shadow = shaderUniforms.make1i("shadow");
        uniform_watershadow = shaderUniforms.make1i("watershadow");
        uniform_shadowtex0 = shaderUniforms.make1i("shadowtex0");
        uniform_shadowtex1 = shaderUniforms.make1i("shadowtex1");
        uniform_depthtex0 = shaderUniforms.make1i("depthtex0");
        uniform_depthtex1 = shaderUniforms.make1i("depthtex1");
        uniform_shadowcolor = shaderUniforms.make1i("shadowcolor");
        uniform_shadowcolor0 = shaderUniforms.make1i("shadowcolor0");
        uniform_shadowcolor1 = shaderUniforms.make1i("shadowcolor1");
        uniform_noisetex = shaderUniforms.make1i("noisetex");
        uniform_gcolor = shaderUniforms.make1i("gcolor");
        uniform_gdepth = shaderUniforms.make1i("gdepth");
        uniform_gnormal = shaderUniforms.make1i("gnormal");
        uniform_composite = shaderUniforms.make1i("composite");
        uniform_gaux1 = shaderUniforms.make1i("gaux1");
        uniform_gaux2 = shaderUniforms.make1i("gaux2");
        uniform_gaux3 = shaderUniforms.make1i("gaux3");
        uniform_gaux4 = shaderUniforms.make1i("gaux4");
        uniform_colortex0 = shaderUniforms.make1i("colortex0");
        uniform_colortex1 = shaderUniforms.make1i("colortex1");
        uniform_colortex2 = shaderUniforms.make1i("colortex2");
        uniform_colortex3 = shaderUniforms.make1i("colortex3");
        uniform_colortex4 = shaderUniforms.make1i("colortex4");
        uniform_colortex5 = shaderUniforms.make1i("colortex5");
        uniform_colortex6 = shaderUniforms.make1i("colortex6");
        uniform_colortex7 = shaderUniforms.make1i("colortex7");
        uniform_gdepthtex = shaderUniforms.make1i("gdepthtex");
        uniform_depthtex2 = shaderUniforms.make1i("depthtex2");
        uniform_colortex8 = shaderUniforms.make1i("colortex8");
        uniform_colortex9 = shaderUniforms.make1i("colortex9");
        uniform_colortex10 = shaderUniforms.make1i("colortex10");
        uniform_colortex11 = shaderUniforms.make1i("colortex11");
        uniform_colortex12 = shaderUniforms.make1i("colortex12");
        uniform_colortex13 = shaderUniforms.make1i("colortex13");
        uniform_colortex14 = shaderUniforms.make1i("colortex14");
        uniform_colortex15 = shaderUniforms.make1i("colortex15");
        uniform_colorimg0 = shaderUniforms.make1i("colorimg0");
        uniform_colorimg1 = shaderUniforms.make1i("colorimg1");
        uniform_colorimg2 = shaderUniforms.make1i("colorimg2");
        uniform_colorimg3 = shaderUniforms.make1i("colorimg3");
        uniform_colorimg4 = shaderUniforms.make1i("colorimg4");
        uniform_colorimg5 = shaderUniforms.make1i("colorimg5");
        uniform_shadowcolorimg0 = shaderUniforms.make1i("shadowcolorimg0");
        uniform_shadowcolorimg1 = shaderUniforms.make1i("shadowcolorimg1");
        uniform_tex = shaderUniforms.make1i("tex");
        uniform_heldItemId = shaderUniforms.make1i("heldItemId");
        uniform_heldBlockLightValue = shaderUniforms.make1i("heldBlockLightValue");
        uniform_heldItemId2 = shaderUniforms.make1i("heldItemId2");
        uniform_heldBlockLightValue2 = shaderUniforms.make1i("heldBlockLightValue2");
        uniform_fogMode = shaderUniforms.make1i("fogMode");
        uniform_fogDensity = shaderUniforms.make1f("fogDensity");
        uniform_fogColor = shaderUniforms.make3f("fogColor");
        uniform_skyColor = shaderUniforms.make3f("skyColor");
        uniform_worldTime = shaderUniforms.make1i("worldTime");
        uniform_worldDay = shaderUniforms.make1i("worldDay");
        uniform_moonPhase = shaderUniforms.make1i("moonPhase");
        uniform_frameCounter = shaderUniforms.make1i("frameCounter");
        uniform_frameTime = shaderUniforms.make1f("frameTime");
        uniform_frameTimeCounter = shaderUniforms.make1f("frameTimeCounter");
        uniform_sunAngle = shaderUniforms.make1f("sunAngle");
        uniform_shadowAngle = shaderUniforms.make1f("shadowAngle");
        uniform_rainStrength = shaderUniforms.make1f("rainStrength");
        uniform_aspectRatio = shaderUniforms.make1f("aspectRatio");
        uniform_viewWidth = shaderUniforms.make1f("viewWidth");
        uniform_viewHeight = shaderUniforms.make1f("viewHeight");
        uniform_near = shaderUniforms.make1f("near");
        uniform_far = shaderUniforms.make1f("far");
        uniform_sunPosition = shaderUniforms.make3f("sunPosition");
        uniform_moonPosition = shaderUniforms.make3f("moonPosition");
        uniform_shadowLightPosition = shaderUniforms.make3f("shadowLightPosition");
        uniform_upPosition = shaderUniforms.make3f("upPosition");
        uniform_previousCameraPosition = shaderUniforms.make3f("previousCameraPosition");
        uniform_cameraPosition = shaderUniforms.make3f("cameraPosition");
        uniform_gbufferModelView = shaderUniforms.makeM4("gbufferModelView");
        uniform_gbufferModelViewInverse = shaderUniforms.makeM4("gbufferModelViewInverse");
        uniform_gbufferPreviousProjection = shaderUniforms.makeM4("gbufferPreviousProjection");
        uniform_gbufferProjection = shaderUniforms.makeM4("gbufferProjection");
        uniform_gbufferProjectionInverse = shaderUniforms.makeM4("gbufferProjectionInverse");
        uniform_gbufferPreviousModelView = shaderUniforms.makeM4("gbufferPreviousModelView");
        uniform_shadowProjection = shaderUniforms.makeM4("shadowProjection");
        uniform_shadowProjectionInverse = shaderUniforms.makeM4("shadowProjectionInverse");
        uniform_shadowModelView = shaderUniforms.makeM4("shadowModelView");
        uniform_shadowModelViewInverse = shaderUniforms.makeM4("shadowModelViewInverse");
        uniform_wetness = shaderUniforms.make1f("wetness");
        uniform_eyeAltitude = shaderUniforms.make1f("eyeAltitude");
        uniform_eyeBrightness = shaderUniforms.make2i("eyeBrightness");
        uniform_eyeBrightnessSmooth = shaderUniforms.make2i("eyeBrightnessSmooth");
        uniform_terrainTextureSize = shaderUniforms.make2i("terrainTextureSize");
        uniform_terrainIconSize = shaderUniforms.make1i("terrainIconSize");
        uniform_isEyeInWater = shaderUniforms.make1i("isEyeInWater");
        uniform_nightVision = shaderUniforms.make1f("nightVision");
        uniform_blindness = shaderUniforms.make1f("blindness");
        uniform_screenBrightness = shaderUniforms.make1f("screenBrightness");
        uniform_hideGUI = shaderUniforms.make1i("hideGUI");
        uniform_centerDepthSmooth = shaderUniforms.make1f("centerDepthSmooth");
        uniform_atlasSize = shaderUniforms.make2i("atlasSize");
        uniform_spriteBounds = shaderUniforms.make4f("spriteBounds");
        uniform_blendFunc = shaderUniforms.make4i("blendFunc");
        uniform_instanceId = shaderUniforms.make1i("instanceId");
        uniform_playerMood = shaderUniforms.make1f("playerMood");
        uniform_renderStage = shaderUniforms.make1i("renderStage");
        hasShadowMap = false;
        needResizeShadow = false;
        shadowMapWidth = 1024;
        shadowMapHeight = 1024;
        spShadowMapWidth = 1024;
        spShadowMapHeight = 1024;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        shadowDistanceRenderMul = -1.0f;
        shouldSkipDefaultShadow = false;
        waterShadowEnabled = false;
        usedColorBuffers = 0;
        usedDepthBuffers = 0;
        usedShadowColorBuffers = 0;
        usedShadowDepthBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        bindImageTextures = false;
        gbuffersFormat = new int[16];
        gbuffersClear = new boolean[16];
        gbuffersClearColor = new h[16];
        CLEAR_COLOR_0 = new h(0.0f, 0.0f, 0.0f, 0.0f);
        CLEAR_COLOR_1 = new h(1.0f, 1.0f, 1.0f, 1.0f);
        shadowBuffersFormat = new int[2];
        shadowBuffersClear = new boolean[2];
        shadowBuffersClearColor = new h[2];
        programs = new Programs();
        ProgramNone = programs.getProgramNone();
        ProgramShadow = programs.makeShadow("shadow", ProgramNone);
        ProgramShadowSolid = programs.makeShadow("shadow_solid", ProgramShadow);
        ProgramShadowCutout = programs.makeShadow("shadow_cutout", ProgramShadow);
        ProgramsShadowcomp = programs.makeShadowcomps("shadowcomp", 16);
        ProgramsPrepare = programs.makePrepares("prepare", 16);
        ProgramBasic = programs.makeGbuffers("gbuffers_basic", ProgramNone);
        ProgramTextured = programs.makeGbuffers("gbuffers_textured", ProgramBasic);
        ProgramTexturedLit = programs.makeGbuffers("gbuffers_textured_lit", ProgramTextured);
        ProgramSkyBasic = programs.makeGbuffers("gbuffers_skybasic", ProgramBasic);
        ProgramSkyTextured = programs.makeGbuffers("gbuffers_skytextured", ProgramTextured);
        ProgramClouds = programs.makeGbuffers("gbuffers_clouds", ProgramTextured);
        ProgramTerrain = programs.makeGbuffers("gbuffers_terrain", ProgramTexturedLit);
        ProgramTerrainSolid = programs.makeGbuffers("gbuffers_terrain_solid", ProgramTerrain);
        ProgramTerrainCutoutMip = programs.makeGbuffers("gbuffers_terrain_cutout_mip", ProgramTerrain);
        ProgramTerrainCutout = programs.makeGbuffers("gbuffers_terrain_cutout", ProgramTerrain);
        ProgramDamagedBlock = programs.makeGbuffers("gbuffers_damagedblock", ProgramTerrain);
        ProgramBlock = programs.makeGbuffers("gbuffers_block", ProgramTerrain);
        ProgramBeaconBeam = programs.makeGbuffers("gbuffers_beaconbeam", ProgramTextured);
        ProgramItem = programs.makeGbuffers("gbuffers_item", ProgramTexturedLit);
        ProgramEntities = programs.makeGbuffers("gbuffers_entities", ProgramTexturedLit);
        ProgramEntitiesGlowing = programs.makeGbuffers("gbuffers_entities_glowing", ProgramEntities);
        ProgramArmorGlint = programs.makeGbuffers("gbuffers_armor_glint", ProgramTextured);
        ProgramSpiderEyes = programs.makeGbuffers("gbuffers_spidereyes", ProgramTextured);
        ProgramHand = programs.makeGbuffers("gbuffers_hand", ProgramTexturedLit);
        ProgramWeather = programs.makeGbuffers("gbuffers_weather", ProgramTexturedLit);
        ProgramDeferredPre = programs.makeVirtual("deferred_pre");
        ProgramsDeferred = programs.makeDeferreds("deferred", 16);
        ProgramDeferred = ProgramsDeferred[0];
        ProgramWater = programs.makeGbuffers("gbuffers_water", ProgramTerrain);
        ProgramHandWater = programs.makeGbuffers("gbuffers_hand_water", ProgramHand);
        ProgramCompositePre = programs.makeVirtual("composite_pre");
        ProgramsComposite = programs.makeComposites("composite", 16);
        ProgramComposite = ProgramsComposite[0];
        ProgramFinal = programs.makeComposite("final");
        ProgramCount = programs.getCount();
        ProgramsAll = programs.getPrograms();
        activeProgram = ProgramNone;
        activeProgramID = 0;
        programStack = new ProgramStack();
        hasDeferredPrograms = false;
        hasShadowcompPrograms = false;
        hasPreparePrograms = false;
        loadedShaders = null;
        shadersConfig = null;
        defaultTexture = null;
        shadowHardwareFilteringEnabled = new boolean[2];
        shadowMipmapEnabled = new boolean[2];
        shadowFilterNearest = new boolean[2];
        shadowColorMipmapEnabled = new boolean[2];
        shadowColorFilterNearest = new boolean[2];
        configTweakBlockDamage = false;
        configCloudShadow = false;
        configHandDepthMul = 0.125f;
        configRenderResMul = 1.0f;
        configShadowResMul = 1.0f;
        configTexMinFilB = 0;
        configTexMinFilN = 0;
        configTexMinFilS = 0;
        configTexMagFilB = 0;
        configTexMagFilN = 0;
        configTexMagFilS = 0;
        configShadowClipFrustrum = true;
        configNormalMap = true;
        configSpecularMap = true;
        configOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        configOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        configAntialiasingLevel = 0;
        texMinFilDesc = new String[]{"Nearest", "Nearest-Nearest", "Nearest-Linear"};
        texMagFilDesc = new String[]{"Nearest", "Linear"};
        texMinFilValue = new int[]{9728, 9984, 9986};
        texMagFilValue = new int[]{9728, 9729};
        shaderPack = null;
        shaderPackLoaded = false;
        shaderPacksDir = new File(djz.C().n, SHADER_PACKS_DIR_NAME);
        configFile = new File(djz.C().n, OPTIONS_FILE_NAME);
        shaderPackOptions = null;
        shaderPackOptionSliders = null;
        shaderPackProfiles = null;
        shaderPackGuiScreens = null;
        shaderPackProgramConditions = new HashMap<String, IExpressionBool>();
        shaderPackClouds = new PropertyDefaultFastFancyOff("clouds", "Clouds", 0);
        shaderPackOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        shaderPackOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        shaderPackDynamicHandLight = new PropertyDefaultTrueFalse("dynamicHandLight", "Dynamic Hand Light", 0);
        shaderPackShadowTerrain = new PropertyDefaultTrueFalse("shadowTerrain", "Shadow Terrain", 0);
        shaderPackShadowTranslucent = new PropertyDefaultTrueFalse("shadowTranslucent", "Shadow Translucent", 0);
        shaderPackShadowEntities = new PropertyDefaultTrueFalse("shadowEntities", "Shadow Entities", 0);
        shaderPackShadowBlockEntities = new PropertyDefaultTrueFalse("shadowBlockEntities", "Shadow Block Entities", 0);
        shaderPackUnderwaterOverlay = new PropertyDefaultTrueFalse("underwaterOverlay", "Underwater Overlay", 0);
        shaderPackSun = new PropertyDefaultTrueFalse("sun", "Sun", 0);
        shaderPackMoon = new PropertyDefaultTrueFalse("moon", "Moon", 0);
        shaderPackVignette = new PropertyDefaultTrueFalse("vignette", "Vignette", 0);
        shaderPackBackFaceSolid = new PropertyDefaultTrueFalse("backFace.solid", "Back-face Solid", 0);
        shaderPackBackFaceCutout = new PropertyDefaultTrueFalse("backFace.cutout", "Back-face Cutout", 0);
        shaderPackBackFaceCutoutMipped = new PropertyDefaultTrueFalse("backFace.cutoutMipped", "Back-face Cutout Mipped", 0);
        shaderPackBackFaceTranslucent = new PropertyDefaultTrueFalse("backFace.translucent", "Back-face Translucent", 0);
        shaderPackRainDepth = new PropertyDefaultTrueFalse("rain.depth", "Rain Depth", 0);
        shaderPackBeaconBeamDepth = new PropertyDefaultTrueFalse("beacon.beam.depth", "Rain Depth", 0);
        shaderPackSeparateAo = new PropertyDefaultTrueFalse("separateAo", "Separate AO", 0);
        shaderPackFrustumCulling = new PropertyDefaultTrueFalse("frustum.culling", "Frustum Culling", 0);
        shaderPackResources = new HashMap<String, String>();
        currentWorld = null;
        shaderPackDimensions = new ArrayList<Integer>();
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
        customTexturesShadowcomp = null;
        customTexturesPrepare = null;
        noiseTexturePath = null;
        colorBufferSizes = new DynamicDimension[16];
        customUniforms = null;
        saveFinalShaders = System.getProperty("shaders.debug.save", "false").equals("true");
        blockLightLevel05 = 0.5f;
        blockLightLevel06 = 0.6f;
        blockLightLevel08 = 0.8f;
        aoLevel = -1.0f;
        sunPathRotation = 0.0f;
        shadowAngleInterval = 0.0f;
        fogMode = 0;
        fogDensity = 0.0f;
        shadowIntervalSize = 2.0f;
        terrainIconSize = 16;
        terrainTextureSize = new int[2];
        noiseTextureEnabled = false;
        noiseTextureResolution = 256;
        colorTextureImageUnit = new int[]{0, 1, 2, 3, 7, 8, 9, 10, 16, 17, 18, 19, 20, 21, 22, 23};
        depthTextureImageUnit = new int[]{6, 11, 12};
        shadowColorTextureImageUnit = new int[]{13, 14};
        shadowDepthTextureImageUnit = new int[]{4, 5};
        colorImageUnit = new int[]{0, 1, 2, 3, 4, 5};
        shadowColorImageUnit = new int[]{6, 7};
        bigBufferSize = (295 + 8 * ProgramCount) * 4;
        bigBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)bigBufferSize).limit(0);
        faProjection = new float[16];
        faProjectionInverse = new float[16];
        faModelView = new float[16];
        faModelViewInverse = new float[16];
        faShadowProjection = new float[16];
        faShadowProjectionInverse = new float[16];
        faShadowModelView = new float[16];
        faShadowModelViewInverse = new float[16];
        projection = Shaders.nextFloatBuffer(16);
        projectionInverse = Shaders.nextFloatBuffer(16);
        modelView = Shaders.nextFloatBuffer(16);
        modelViewInverse = Shaders.nextFloatBuffer(16);
        shadowProjection = Shaders.nextFloatBuffer(16);
        shadowProjectionInverse = Shaders.nextFloatBuffer(16);
        shadowModelView = Shaders.nextFloatBuffer(16);
        shadowModelViewInverse = Shaders.nextFloatBuffer(16);
        previousProjection = Shaders.nextFloatBuffer(16);
        previousModelView = Shaders.nextFloatBuffer(16);
        tempMatrixDirectBuffer = Shaders.nextFloatBuffer(16);
        tempDirectFloatBuffer = Shaders.nextFloatBuffer(16);
        dfbDrawBuffers = new DrawBuffers("dfbDrawBuffers", 16, 8);
        sfbDrawBuffers = new DrawBuffers("sfbDrawBuffers", 16, 8);
        drawBuffersNone = new DrawBuffers("drawBuffersNone", 16, 8).limit(0);
        drawBuffersColorAtt = Shaders.makeDrawBuffersColorSingle(16);
        formatNames = new String[]{"R8", "RG8", "RGB8", "RGBA8", "R8_SNORM", "RG8_SNORM", "RGB8_SNORM", "RGBA8_SNORM", "R8I", "RG8I", "RGB8I", "RGBA8I", "R8UI", "RG8UI", "RGB8UI", "RGBA8UI", "R16", "RG16", "RGB16", "RGBA16", "R16_SNORM", "RG16_SNORM", "RGB16_SNORM", "RGBA16_SNORM", "R16F", "RG16F", "RGB16F", "RGBA16F", "R16I", "RG16I", "RGB16I", "RGBA16I", "R16UI", "RG16UI", "RGB16UI", "RGBA16UI", "R32F", "RG32F", "RGB32F", "RGBA32F", "R32I", "RG32I", "RGB32I", "RGBA32I", "R32UI", "RG32UI", "RGB32UI", "RGBA32UI", "R3_G3_B2", "RGB5_A1", "RGB10_A2", "R11F_G11F_B10F", "RGB9_E5"};
        formatIds = new int[]{33321, 33323, 32849, 32856, 36756, 36757, 36758, 36759, 33329, 33335, 36239, 36238, 33330, 33336, 36221, 36220, 33322, 33324, 32852, 32859, 36760, 36761, 36762, 36763, 33325, 33327, 34843, 34842, 33331, 33337, 36233, 36232, 33332, 33338, 36215, 36214, 33326, 33328, 34837, 34836, 33333, 33339, 36227, 36226, 33334, 33340, 36209, 36208, 10768, 32855, 32857, 35898, 35901};
        patternLoadEntityDataMap = Pattern.compile("\\s*([\\w:]+)\\s*=\\s*([-]?\\d+)\\s*");
        entityData = new int[32];
        entityDataIndex = 0;
    }
}

