/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;

public abstract class IntExpiringCache<T> {
    private final int intervalMs;
    private long timeCheckMs;
    private Int2ObjectOpenHashMap<Wrapper<T>> map = new Int2ObjectOpenHashMap();

    public IntExpiringCache(int intervalMs) {
        this.intervalMs = intervalMs;
    }

    public T get(int key) {
        Wrapper<T> w2;
        long timeNowMs = System.currentTimeMillis();
        if (!this.map.isEmpty() && timeNowMs >= this.timeCheckMs) {
            this.timeCheckMs = timeNowMs + (long)this.intervalMs;
            long timeMinMs = timeNowMs - (long)this.intervalMs;
            IntSet keys = this.map.keySet();
            IntIterator it = keys.iterator();
            while (it.hasNext()) {
                Wrapper w3;
                int k2 = it.nextInt();
                if (k2 == key || (w3 = (Wrapper)this.map.get(k2)).getAccessTimeMs() > timeMinMs) continue;
                it.remove();
            }
        }
        if ((w2 = (Wrapper<T>)this.map.get(key)) == null) {
            T obj = this.make();
            w2 = new Wrapper<T>(obj);
            this.map.put(key, w2);
        }
        w2.setAccessTimeMs(timeNowMs);
        return w2.getValue();
    }

    protected abstract T make();

    public static class Wrapper<T> {
        private final T value;
        private long accessTimeMs;

        public Wrapper(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public long getAccessTimeMs() {
            return this.accessTimeMs;
        }

        public void setAccessTimeMs(long accessTimeMs) {
            this.accessTimeMs = accessTimeMs;
        }
    }
}

