/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.GLSLParserBaseVisitor;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.IterationConditionInitializer;
import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.VersionStatement;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.Declaration;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.FunctionDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.FunctionParameter;
import io.github.douira.glsl_transformer.ast.node.declaration.InterfaceBlockDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.PrecisionDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.declaration.VariableDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.ConditionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.SequenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.AdditionAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.AdditionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.ArrayAccessExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.AssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BinaryExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseAndAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseAndExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseOrAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseOrExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseXorAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BitwiseXorExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanAndExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanOrExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.BooleanXorExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.DivisionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.EqualityExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.GreaterThanEqualExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.GreaterThanExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.InequalityExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.LeftShiftAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.LeftShiftExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.LessThanEqualExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.LessThanExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.ModuloAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.ModuloExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.MultiplicationExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.RightShiftAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.RightShiftExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.SubtractionAssignmentExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.SubtractionExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.BitwiseNotExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.BooleanNotExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.DecrementPostfixExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.DecrementPrefixExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.FunctionCallExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.GroupingExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.IdentityExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.IncrementPostfixExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.IncrementPrefixExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.LengthAccessExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.MemberAccessExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.NegationExpression;
import io.github.douira.glsl_transformer.ast.node.expression.unary.UnaryExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.EmptyDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExtensionStatement;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.FunctionDefinition;
import io.github.douira.glsl_transformer.ast.node.external_declaration.LayoutDefaults;
import io.github.douira.glsl_transformer.ast.node.external_declaration.PragmaStatement;
import io.github.douira.glsl_transformer.ast.node.statement.CompoundStatement;
import io.github.douira.glsl_transformer.ast.node.statement.EmptyStatement;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.node.statement.loop.DoWhileLoopStatement;
import io.github.douira.glsl_transformer.ast.node.statement.loop.ForLoopStatement;
import io.github.douira.glsl_transformer.ast.node.statement.loop.WhileLoopStatement;
import io.github.douira.glsl_transformer.ast.node.statement.selection.SelectionStatement;
import io.github.douira.glsl_transformer.ast.node.statement.selection.SwitchStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.BreakStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.CaseStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.ContinueStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.DeclarationStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.DefaultStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.DemoteStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.DiscardStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.ExpressionStatement;
import io.github.douira.glsl_transformer.ast.node.statement.terminal.ReturnStatement;
import io.github.douira.glsl_transformer.ast.node.type.FullySpecifiedType;
import io.github.douira.glsl_transformer.ast.node.type.initializer.ExpressionInitializer;
import io.github.douira.glsl_transformer.ast.node.type.initializer.Initializer;
import io.github.douira.glsl_transformer.ast.node.type.initializer.NestedInitializer;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.InterpolationQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.InvariantQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.LayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.NamedLayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.PreciseQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.PrecisionQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.SharedLayoutQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifier;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.TypeQualifierPart;
import io.github.douira.glsl_transformer.ast.node.type.specifier.ArraySpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinFixedTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.FunctionPrototype;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeReference;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.struct.StructBody;
import io.github.douira.glsl_transformer.ast.node.type.struct.StructDeclarator;
import io.github.douira.glsl_transformer.ast.node.type.struct.StructMember;
import io.github.douira.glsl_transformer.ast.node.type.struct.StructSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.util.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import oculus.org.antlr.v4.runtime.ParserRuleContext;
import oculus.org.antlr.v4.runtime.Token;
import oculus.org.antlr.v4.runtime.misc.Interval;
import oculus.org.antlr.v4.runtime.tree.ParseTree;
import oculus.org.antlr.v4.runtime.tree.TerminalNode;
import oculus.org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class ASTBuilder
extends GLSLParserBaseVisitor<ASTNode> {
    private static final Deque<Interval> sourceLineStack = new ArrayDeque<Interval>();
    private static final Pattern intExtractor = Pattern.compile("(.*?)(?:us|ul|u|s)?$", 2);
    private static final Pattern floatExtractor = Pattern.compile("(.*?)(?:f|hf|lf)?$", 2);

    public static ASTNode build(ParseTree ctx) {
        return Root.indexNodes(() -> ASTBuilder.buildInternal(ctx));
    }

    public static ASTNode build(Root rootInstance, ParseTree ctx) {
        return Root.indexNodes(rootInstance, () -> ASTBuilder.buildInternal(ctx));
    }

    public static <TreeType extends ParseTree, ReturnType extends ASTNode> ReturnType build(TreeType ctx, BiFunction<ASTBuilder, TreeType, ReturnType> visitMethod) {
        return (ReturnType)Root.indexNodes(() -> ASTBuilder.buildInternal(ctx, visitMethod));
    }

    public static <TreeType extends ParseTree, ReturnType extends ASTNode> ReturnType build(Root rootInstance, TreeType ctx, BiFunction<ASTBuilder, TreeType, ReturnType> visitMethod) {
        return (ReturnType)Root.indexNodes(rootInstance, () -> ASTBuilder.buildInternal(ctx, visitMethod));
    }

    public static ASTNode buildSubtree(ASTNode parentTreeMember, ParseTree ctx) {
        return Root.indexNodes(parentTreeMember, () -> ASTBuilder.buildInternal(ctx));
    }

    public static <TreeType extends ParseTree, ReturnType extends ASTNode> ReturnType buildSubtree(ASTNode parentTreeMember, TreeType ctx, BiFunction<ASTBuilder, TreeType, ReturnType> visitMethod) {
        return (ReturnType)Root.indexNodes(parentTreeMember, () -> ASTBuilder.buildInternal(ctx, visitMethod));
    }

    private static ASTNode buildInternal(ParseTree ctx) {
        return (ASTNode)new ASTBuilder().visit(ctx);
    }

    private static <TreeType extends ParseTree, ReturnType extends ASTNode> ReturnType buildInternal(TreeType ctx, BiFunction<ASTBuilder, TreeType, ReturnType> visitMethod) {
        return (ReturnType)((ASTNode)visitMethod.apply(new ASTBuilder(), ctx));
    }

    private static <N, R> R applySafe(N ctx, Function<N, R> visitMethod) {
        return ctx == null ? null : (R)visitMethod.apply(ctx);
    }

    private static void startConstruction(Token token) {
        int line = token.getLine();
        sourceLineStack.push(Interval.of(line, line));
    }

    private static void startConstruction(ParseTree tree) {
        ParseTree parseTree = tree;
        if (parseTree instanceof ParserRuleContext) {
            ParserRuleContext ctx = (ParserRuleContext)parseTree;
            sourceLineStack.push(Interval.of(ctx.start.getLine(), ctx.stop.getLine()));
        } else {
            parseTree = tree;
            if (parseTree instanceof TerminalNodeImpl) {
                TerminalNodeImpl ctx = (TerminalNodeImpl)parseTree;
                ASTBuilder.startConstruction(ctx.getSymbol());
            } else {
                throw new IllegalStateException("Can't handle unknown parse tree type " + tree.getClass());
            }
        }
    }

    private static void endConstruction() {
        sourceLineStack.pop();
    }

    private static <R extends ASTNode> R constructSimple(ParseTree ctx, Supplier<R> constructor) {
        ASTBuilder.startConstruction(ctx);
        ASTNode result = (ASTNode)constructor.get();
        ASTBuilder.endConstruction();
        return (R)result;
    }

    public static Interval getActiveSourceLines() {
        Interval sourceLines = sourceLineStack.peekFirst();
        return sourceLines == null ? ASTNode.SYNTHETIC_SOURCE : sourceLines;
    }

    private static Identifier makeIdentifier(Token name) {
        if (name == null) {
            return null;
        }
        if (name.getType() != 257) {
            throw new IllegalStateException("Expected identifier, got: " + name.getText());
        }
        ASTBuilder.startConstruction(name);
        Identifier result = new Identifier(name);
        ASTBuilder.endConstruction();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TranslationUnit visitTranslationUnit(GLSLParser.TranslationUnitContext ctx) {
        VersionStatement versionStatement = this.visitVersionStatement(ctx.versionStatement());
        Stream<ExternalDeclaration> externalDeclarations = ctx.externalDeclaration().stream().map(this::visitExternalDeclaration);
        ASTBuilder.startConstruction(ctx);
        try {
            TranslationUnit translationUnit = versionStatement == null ? new TranslationUnit(externalDeclarations) : new TranslationUnit(versionStatement, externalDeclarations);
            return translationUnit;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public VersionStatement visitVersionStatement(GLSLParser.VersionStatementContext ctx) {
        if (ctx == null) {
            return null;
        }
        ASTBuilder.startConstruction(ctx);
        try {
            VersionStatement versionStatement = new VersionStatement(ASTBuilder.applySafe(ctx.version, Version::fromToken), ASTBuilder.applySafe(ctx.profile, Profile::fromToken));
            return versionStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public EmptyDeclaration visitEmptyDeclaration(GLSLParser.EmptyDeclarationContext ctx) {
        return ASTBuilder.constructSimple(ctx, EmptyDeclaration::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PragmaStatement visitPragmaStatement(GLSLParser.PragmaStatementContext ctx) {
        boolean stdGL = ctx.stdGL != null;
        PragmaStatement.PragmaType type = PragmaStatement.PragmaType.fromToken(ctx.type);
        ASTBuilder.startConstruction(ctx);
        try {
            PragmaStatement pragmaStatement = type == PragmaStatement.PragmaType.CUSTOM ? new PragmaStatement(stdGL, ctx.type.getText()) : new PragmaStatement(stdGL, type, PragmaStatement.PragmaState.fromToken(ctx.state));
            return pragmaStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtensionStatement visitExtensionStatement(GLSLParser.ExtensionStatementContext ctx) {
        String extensionName = ctx.extensionName.getText();
        ASTBuilder.startConstruction(ctx);
        try {
            ExtensionStatement extensionStatement = new ExtensionStatement(extensionName, ASTBuilder.applySafe(ctx.extensionBehavior, ExtensionStatement.ExtensionBehavior::fromToken));
            return extensionStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public LayoutDefaults visitLayoutDefaults(GLSLParser.LayoutDefaultsContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            LayoutDefaults layoutDefaults = new LayoutDefaults(this.visitLayoutQualifier(ctx.layoutQualifier()), LayoutDefaults.LayoutMode.fromToken(ctx.layoutMode));
            return layoutDefaults;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ConditionExpression visitConditionalExpression(GLSLParser.ConditionalExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ConditionExpression conditionExpression = new ConditionExpression(this.visitExpression(ctx.condition), this.visitExpression(ctx.trueAlternative), this.visitExpression(ctx.falseAlternative));
            return conditionExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionCallExpression visitFunctionCallExpression(GLSLParser.FunctionCallExpressionContext ctx) {
        TerminalNode functionIdentifier = ctx.IDENTIFIER();
        Identifier functionName = null;
        TypeSpecifier functionType = null;
        if (functionIdentifier != null) {
            functionName = this.visitIdentifier(functionIdentifier);
        } else {
            functionType = this.visitTypeSpecifier(ctx.typeSpecifier());
        }
        Stream<Expression> parameters = ctx.parameters.stream().map(this::visitExpression);
        ASTBuilder.startConstruction(ctx);
        try {
            FunctionCallExpression functionCallExpression = functionName != null ? new FunctionCallExpression(functionName, parameters) : new FunctionCallExpression(functionType, parameters);
            return functionCallExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupingExpression visitGroupingExpression(GLSLParser.GroupingExpressionContext ctx) {
        Expression expression = this.visitExpression(ctx.value);
        ASTBuilder.startConstruction(ctx);
        try {
            GroupingExpression grouping;
            Expression expression2 = expression;
            GroupingExpression groupingExpression = expression2 instanceof GroupingExpression ? (grouping = (GroupingExpression)expression2) : new GroupingExpression(expression);
            return groupingExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public MemberAccessExpression visitMemberAccessExpression(GLSLParser.MemberAccessExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            MemberAccessExpression memberAccessExpression = new MemberAccessExpression(this.visitExpression(ctx.operand), new Identifier(ctx.member));
            return memberAccessExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public LengthAccessExpression visitLengthAccessExpression(GLSLParser.LengthAccessExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            LengthAccessExpression lengthAccessExpression = new LengthAccessExpression(this.visitExpression(ctx.operand));
            return lengthAccessExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public UnaryExpression visitPostfixExpression(GLSLParser.PostfixExpressionContext ctx) {
        Expression operand = this.visitExpression(ctx.operand);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 209: {
                    IncrementPostfixExpression incrementPostfixExpression = new IncrementPostfixExpression(operand);
                    return incrementPostfixExpression;
                }
                case 210: {
                    DecrementPostfixExpression decrementPostfixExpression = new DecrementPostfixExpression(operand);
                    return decrementPostfixExpression;
                }
            }
            throw new IllegalArgumentException("Unknown postfix operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public UnaryExpression visitPrefixExpression(GLSLParser.PrefixExpressionContext ctx) {
        Expression operand = this.visitExpression(ctx.operand);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 209: {
                    IncrementPrefixExpression incrementPrefixExpression = new IncrementPrefixExpression(operand);
                    return incrementPrefixExpression;
                }
                case 210: {
                    DecrementPrefixExpression decrementPrefixExpression = new DecrementPrefixExpression(operand);
                    return decrementPrefixExpression;
                }
                case 240: {
                    IdentityExpression identityExpression = new IdentityExpression(operand);
                    return identityExpression;
                }
                case 241: {
                    NegationExpression negationExpression = new NegationExpression(operand);
                    return negationExpression;
                }
                case 242: {
                    BooleanNotExpression booleanNotExpression = new BooleanNotExpression(operand);
                    return booleanNotExpression;
                }
                case 243: {
                    BitwiseNotExpression bitwiseNotExpression = new BitwiseNotExpression(operand);
                    return bitwiseNotExpression;
                }
            }
            throw new IllegalStateException("Unexpected prefix operator type" + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceExpression visitSequenceExpression(GLSLParser.SequenceExpressionContext ctx) {
        GLSLParser.SequenceExpressionContext sequence;
        GLSLParser.ExpressionContext left = ctx;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        do {
            sequence = left;
            if (sequence.right instanceof GLSLParser.SequenceExpressionContext) {
                throw new IllegalStateException("Sequence expressions should not be nested on the right operand!");
            }
            Expression right = this.visitExpression(sequence.right);
            expressions.add(right);
        } while ((left = sequence.left) instanceof GLSLParser.SequenceExpressionContext);
        expressions.add(this.visitExpression(left));
        Collections.reverse(expressions);
        ASTBuilder.startConstruction(ctx);
        try {
            SequenceExpression sequenceExpression = new SequenceExpression(expressions.stream());
            return sequenceExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public LiteralExpression visitLiteralExpression(GLSLParser.LiteralExpressionContext ctx) {
        Token content = ctx.getStart();
        Type literalType = Type.ofLiteralTokenType(content.getType());
        String tokenContent = content.getText();
        ASTBuilder.startConstruction(ctx);
        try {
            switch (literalType.getNumberType()) {
                case BOOLEAN: {
                    LiteralExpression literalExpression = new LiteralExpression(tokenContent.equals("true"));
                    return literalExpression;
                }
                case SIGNED_INTEGER: 
                case UNSIGNED_INTEGER: {
                    Matcher intMatcher = intExtractor.matcher(tokenContent);
                    intMatcher.matches();
                    tokenContent = intMatcher.group(1);
                    if (tokenContent.equals("0")) {
                        LiteralExpression literalExpression = new LiteralExpression(literalType, 0L);
                        return literalExpression;
                    }
                    if (tokenContent.startsWith("0x")) {
                        LiteralExpression literalExpression = new LiteralExpression(literalType, Long.parseLong(tokenContent.substring(2), 16), LiteralExpression.IntegerFormat.HEXADECIMAL);
                        return literalExpression;
                    }
                    if (tokenContent.startsWith("0")) {
                        LiteralExpression literalExpression = new LiteralExpression(literalType, Long.parseLong(tokenContent.substring(1), 8), LiteralExpression.IntegerFormat.OCTAL);
                        return literalExpression;
                    }
                    LiteralExpression literalExpression = new LiteralExpression(literalType, Long.parseLong(tokenContent, 10), LiteralExpression.IntegerFormat.DECIMAL);
                    return literalExpression;
                }
                case FLOATING_POINT: {
                    Matcher floatMatcher = floatExtractor.matcher(tokenContent);
                    floatMatcher.matches();
                    tokenContent = floatMatcher.group(1);
                    LiteralExpression literalExpression = new LiteralExpression(literalType, Double.parseDouble(tokenContent));
                    return literalExpression;
                }
            }
            throw new IllegalArgumentException("Unsupported literal type: " + literalType);
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitAdditiveExpression(GLSLParser.AdditiveExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 240: {
                    AdditionExpression additionExpression = new AdditionExpression(left, right);
                    return additionExpression;
                }
                case 241: {
                    SubtractionExpression subtractionExpression = new SubtractionExpression(left, right);
                    return subtractionExpression;
                }
            }
            throw new IllegalArgumentException("Unknown additive operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ArrayAccessExpression visitArrayAccessExpression(GLSLParser.ArrayAccessExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ArrayAccessExpression arrayAccessExpression = new ArrayAccessExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return arrayAccessExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitAssignmentExpression(GLSLParser.AssignmentExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 253: {
                    AssignmentExpression assignmentExpression = new AssignmentExpression(left, right);
                    return assignmentExpression;
                }
                case 221: {
                    MultiplicationAssignmentExpression multiplicationAssignmentExpression = new MultiplicationAssignmentExpression(left, right);
                    return multiplicationAssignmentExpression;
                }
                case 222: {
                    DivisionAssignmentExpression divisionAssignmentExpression = new DivisionAssignmentExpression(left, right);
                    return divisionAssignmentExpression;
                }
                case 223: {
                    ModuloAssignmentExpression moduloAssignmentExpression = new ModuloAssignmentExpression(left, right);
                    return moduloAssignmentExpression;
                }
                case 224: {
                    AdditionAssignmentExpression additionAssignmentExpression = new AdditionAssignmentExpression(left, right);
                    return additionAssignmentExpression;
                }
                case 225: {
                    SubtractionAssignmentExpression subtractionAssignmentExpression = new SubtractionAssignmentExpression(left, right);
                    return subtractionAssignmentExpression;
                }
                case 228: {
                    BitwiseAndAssignmentExpression bitwiseAndAssignmentExpression = new BitwiseAndAssignmentExpression(left, right);
                    return bitwiseAndAssignmentExpression;
                }
                case 229: {
                    BitwiseXorAssignmentExpression bitwiseXorAssignmentExpression = new BitwiseXorAssignmentExpression(left, right);
                    return bitwiseXorAssignmentExpression;
                }
                case 230: {
                    BitwiseOrAssignmentExpression bitwiseOrAssignmentExpression = new BitwiseOrAssignmentExpression(left, right);
                    return bitwiseOrAssignmentExpression;
                }
                case 226: {
                    LeftShiftAssignmentExpression leftShiftAssignmentExpression = new LeftShiftAssignmentExpression(left, right);
                    return leftShiftAssignmentExpression;
                }
                case 227: {
                    RightShiftAssignmentExpression rightShiftAssignmentExpression = new RightShiftAssignmentExpression(left, right);
                    return rightShiftAssignmentExpression;
                }
            }
            throw new IllegalArgumentException("Unknown assignment operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BitwiseAndExpression visitBitwiseAndExpression(GLSLParser.BitwiseAndExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BitwiseAndExpression bitwiseAndExpression = new BitwiseAndExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return bitwiseAndExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BitwiseXorExpression visitBitwiseExclusiveOrExpression(GLSLParser.BitwiseExclusiveOrExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BitwiseXorExpression bitwiseXorExpression = new BitwiseXorExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return bitwiseXorExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BitwiseOrExpression visitBitwiseInclusiveOrExpression(GLSLParser.BitwiseInclusiveOrExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BitwiseOrExpression bitwiseOrExpression = new BitwiseOrExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return bitwiseOrExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitEqualityExpression(GLSLParser.EqualityExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 216: {
                    EqualityExpression equalityExpression = new EqualityExpression(left, right);
                    return equalityExpression;
                }
                case 217: {
                    InequalityExpression inequalityExpression = new InequalityExpression(left, right);
                    return inequalityExpression;
                }
            }
            throw new IllegalArgumentException("Unknown equality operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BooleanAndExpression visitLogicalAndExpression(GLSLParser.LogicalAndExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BooleanAndExpression booleanAndExpression = new BooleanAndExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return booleanAndExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BooleanXorExpression visitLogicalExclusiveOrExpression(GLSLParser.LogicalExclusiveOrExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BooleanXorExpression booleanXorExpression = new BooleanXorExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return booleanXorExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BooleanOrExpression visitLogicalInclusiveOrExpression(GLSLParser.LogicalInclusiveOrExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            BooleanOrExpression booleanOrExpression = new BooleanOrExpression(this.visitExpression(ctx.left), this.visitExpression(ctx.right));
            return booleanOrExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitRelationalExpression(GLSLParser.RelationalExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 247: {
                    LessThanExpression lessThanExpression = new LessThanExpression(left, right);
                    return lessThanExpression;
                }
                case 248: {
                    GreaterThanExpression greaterThanExpression = new GreaterThanExpression(left, right);
                    return greaterThanExpression;
                }
                case 214: {
                    LessThanEqualExpression lessThanEqualExpression = new LessThanEqualExpression(left, right);
                    return lessThanEqualExpression;
                }
                case 215: {
                    GreaterThanEqualExpression greaterThanEqualExpression = new GreaterThanEqualExpression(left, right);
                    return greaterThanEqualExpression;
                }
            }
            throw new IllegalArgumentException("Unknown relational operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitShiftExpression(GLSLParser.ShiftExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 212: {
                    LeftShiftExpression leftShiftExpression = new LeftShiftExpression(left, right);
                    return leftShiftExpression;
                }
                case 213: {
                    RightShiftExpression rightShiftExpression = new RightShiftExpression(left, right);
                    return rightShiftExpression;
                }
            }
            throw new IllegalArgumentException("Unknown shift operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public BinaryExpression visitMultiplicativeExpression(GLSLParser.MultiplicativeExpressionContext ctx) {
        Expression left = this.visitExpression(ctx.left);
        Expression right = this.visitExpression(ctx.right);
        ASTBuilder.startConstruction(ctx);
        try {
            switch (ctx.op.getType()) {
                case 244: {
                    MultiplicationExpression multiplicationExpression = new MultiplicationExpression(left, right);
                    return multiplicationExpression;
                }
                case 245: {
                    DivisionExpression divisionExpression = new DivisionExpression(left, right);
                    return divisionExpression;
                }
                case 246: {
                    ModuloExpression moduloExpression = new ModuloExpression(left, right);
                    return moduloExpression;
                }
            }
            throw new IllegalArgumentException("Unknown multiplicative operator: " + ctx.op.getText());
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ReferenceExpression visitReferenceExpression(GLSLParser.ReferenceExpressionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ReferenceExpression referenceExpression = new ReferenceExpression(this.visitIdentifier(ctx.IDENTIFIER()));
            return referenceExpression;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public CompoundStatement visitCompoundStatement(GLSLParser.CompoundStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            CompoundStatement compoundStatement = new CompoundStatement(ctx.statement().stream().map(this::visitStatement));
            return compoundStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ContinueStatement visitContinueStatement(GLSLParser.ContinueStatementContext ctx) {
        return ASTBuilder.constructSimple(ctx, ContinueStatement::new);
    }

    @Override
    public BreakStatement visitBreakStatement(GLSLParser.BreakStatementContext ctx) {
        return ASTBuilder.constructSimple(ctx, BreakStatement::new);
    }

    @Override
    public ReturnStatement visitReturnStatement(GLSLParser.ReturnStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ReturnStatement returnStatement = new ReturnStatement(ASTBuilder.applySafe(ctx.expression(), this::visitExpression));
            return returnStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public DiscardStatement visitDiscardStatement(GLSLParser.DiscardStatementContext ctx) {
        return ASTBuilder.constructSimple(ctx, DiscardStatement::new);
    }

    @Override
    public DemoteStatement visitDemoteStatement(GLSLParser.DemoteStatementContext ctx) {
        return ASTBuilder.constructSimple(ctx, DemoteStatement::new);
    }

    @Override
    public DeclarationStatement visitDeclarationStatement(GLSLParser.DeclarationStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            DeclarationStatement declarationStatement = new DeclarationStatement(this.visitDeclaration(ctx.declaration()));
            return declarationStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ExpressionStatement visitExpressionStatement(GLSLParser.ExpressionStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ExpressionStatement expressionStatement = new ExpressionStatement(this.visitExpression(ctx.expression()));
            return expressionStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public EmptyStatement visitEmptyStatement(GLSLParser.EmptyStatementContext ctx) {
        return ASTBuilder.constructSimple(ctx, EmptyStatement::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionStatement visitSelectionStatement(GLSLParser.SelectionStatementContext ctx) {
        Stream.Builder<Expression> conditions = Stream.builder();
        Stream.Builder<Statement> statements = Stream.builder();
        GLSLParser.SelectionStatementContext nextSelection = ctx;
        do {
            conditions.add(this.visitExpression(nextSelection.condition));
            statements.add(this.visitStatement(nextSelection.ifTrue));
            GLSLParser.StatementContext ifFalse = nextSelection.ifFalse;
            nextSelection = null;
            if (ifFalse == null) continue;
            GLSLParser.SelectionStatementContext nestedSelectionStatement = ifFalse.selectionStatement();
            if (nestedSelectionStatement != null) {
                nextSelection = nestedSelectionStatement;
                continue;
            }
            conditions.add(null);
            statements.add(this.visitStatement(ifFalse));
        } while (nextSelection != null);
        ASTBuilder.startConstruction(ctx);
        try {
            SelectionStatement selectionStatement = new SelectionStatement(conditions.build(), statements.build());
            return selectionStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public SwitchStatement visitSwitchStatement(GLSLParser.SwitchStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            SwitchStatement switchStatement = new SwitchStatement(this.visitExpression(ctx.condition), this.visitCompoundStatement(ctx.compoundStatement()));
            return switchStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public DefaultStatement visitDefaultCaseLabel(GLSLParser.DefaultCaseLabelContext ctx) {
        return ASTBuilder.constructSimple(ctx, DefaultStatement::new);
    }

    @Override
    public CaseStatement visitValuedCaseLabel(GLSLParser.ValuedCaseLabelContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            CaseStatement caseStatement = new CaseStatement(this.visitExpression(ctx.expression()));
            return caseStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForLoopStatement visitForStatement(GLSLParser.ForStatementContext ctx) {
        Expression initExpression = null;
        Declaration initDeclaration = null;
        GLSLParser.ExpressionStatementContext initExpressionStatement = ctx.expressionStatement();
        if (initExpressionStatement != null) {
            initExpression = this.visitExpression(initExpressionStatement.expression());
        } else {
            GLSLParser.DeclarationStatementContext initDeclarationStatement = ctx.declarationStatement();
            if (initDeclarationStatement != null) {
                initDeclaration = this.visitDeclaration(initDeclarationStatement.declaration());
            }
        }
        ASTBuilder.startConstruction(ctx);
        try {
            ForLoopStatement forLoopStatement = new ForLoopStatement(initExpression, initDeclaration, ASTBuilder.applySafe(ctx.condition, this::visitExpression), ASTBuilder.applySafe(ctx.initCondition, this::visitIterationCondition), ASTBuilder.applySafe(ctx.incrementer, this::visitExpression), this.visitStatement(ctx.statement()));
            return forLoopStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public WhileLoopStatement visitWhileStatement(GLSLParser.WhileStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            WhileLoopStatement whileLoopStatement = ctx.condition != null ? new WhileLoopStatement(this.visitExpression(ctx.condition), this.visitStatement(ctx.loopBody)) : new WhileLoopStatement(this.visitIterationCondition(ctx.initCondition), this.visitStatement(ctx.loopBody));
            return whileLoopStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public DoWhileLoopStatement visitDoWhileStatement(GLSLParser.DoWhileStatementContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            DoWhileLoopStatement doWhileLoopStatement = new DoWhileLoopStatement(this.visitStatement(ctx.loopBody), this.visitExpression(ctx.condition));
            return doWhileLoopStatement;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public IterationConditionInitializer visitIterationCondition(GLSLParser.IterationConditionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            IterationConditionInitializer iterationConditionInitializer = new IterationConditionInitializer(this.visitFullySpecifiedType(ctx.fullySpecifiedType()), new Identifier(ctx.name), this.visitInitializer(ctx.initializer()));
            return iterationConditionInitializer;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ArraySpecifier visitArraySpecifier(GLSLParser.ArraySpecifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ArraySpecifier arraySpecifier = new ArraySpecifier(ctx.arraySpecifierSegment().stream().map(child -> ASTBuilder.applySafe(child.expression(), this::visitExpression)));
            return arraySpecifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public FunctionDefinition visitFunctionDefinition(GLSLParser.FunctionDefinitionContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            FunctionDefinition functionDefinition = new FunctionDefinition(this.visitFunctionPrototype(ctx.functionPrototype()), this.visitCompoundStatement(ctx.compoundStatement()));
            return functionDefinition;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionPrototype visitFunctionPrototype(GLSLParser.FunctionPrototypeContext ctx) {
        FullySpecifiedType returnType = this.visitFullySpecifiedType(ctx.fullySpecifiedType());
        Identifier name = this.visitIdentifier(ctx.IDENTIFIER());
        ASTBuilder.startConstruction(ctx);
        try {
            FunctionPrototype functionPrototype = new FunctionPrototype(returnType, name, ASTBuilder.applySafe(ctx.functionParameterList().parameters, parameters -> parameters.stream().map(this::visitParameterDeclaration)));
            return functionPrototype;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeclarationMember visitDeclarationMember(GLSLParser.DeclarationMemberContext ctx) {
        GLSLParser.ArraySpecifierContext arraySpecifier = ctx.arraySpecifier();
        Identifier name = this.visitIdentifier(ctx.IDENTIFIER());
        GLSLParser.InitializerContext initializer = ctx.initializer();
        ASTBuilder.startConstruction(ctx);
        try {
            DeclarationMember declarationMember = new DeclarationMember(name, ASTBuilder.applySafe(arraySpecifier, this::visitArraySpecifier), ASTBuilder.applySafe(initializer, this::visitInitializer));
            return declarationMember;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public FullySpecifiedType visitFullySpecifiedType(GLSLParser.FullySpecifiedTypeContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            FullySpecifiedType fullySpecifiedType = new FullySpecifiedType(ASTBuilder.applySafe(ctx.typeQualifier(), this::visitTypeQualifier), this.visitTypeSpecifier(ctx.typeSpecifier()));
            return fullySpecifiedType;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public FunctionParameter visitParameterDeclaration(GLSLParser.ParameterDeclarationContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            FunctionParameter functionParameter = new FunctionParameter(this.visitFullySpecifiedType(ctx.fullySpecifiedType()), ASTBuilder.makeIdentifier(ctx.parameterName), ASTBuilder.applySafe(ctx.arraySpecifier(), this::visitArraySpecifier));
            return functionParameter;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public FunctionDeclaration visitFunctionDeclaration(GLSLParser.FunctionDeclarationContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            FunctionDeclaration functionDeclaration = new FunctionDeclaration(this.visitFunctionPrototype(ctx.functionPrototype()));
            return functionDeclaration;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public TypeAndInitDeclaration visitTypeAndInitDeclaration(GLSLParser.TypeAndInitDeclarationContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            TypeAndInitDeclaration typeAndInitDeclaration = new TypeAndInitDeclaration(this.visitFullySpecifiedType(ctx.fullySpecifiedType()), ctx.declarationMembers.stream().map(this::visitDeclarationMember));
            return typeAndInitDeclaration;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public PrecisionDeclaration visitPrecisionDeclaration(GLSLParser.PrecisionDeclarationContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            PrecisionDeclaration precisionDeclaration = new PrecisionDeclaration(this.visitPrecisionQualifier(ctx.precisionQualifier()), this.visitTypeSpecifier(ctx.typeSpecifier()));
            return precisionDeclaration;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterfaceBlockDeclaration visitInterfaceBlockDeclaration(GLSLParser.InterfaceBlockDeclarationContext ctx) {
        TypeQualifier typeQualifier = this.visitTypeQualifier(ctx.typeQualifier());
        Identifier name = new Identifier(ctx.blockName);
        StructBody structBody = this.visitStructBody(ctx.structBody());
        ASTBuilder.startConstruction(ctx);
        try {
            if (ctx.variableName != null) {
                Identifier variableName = new Identifier(ctx.variableName);
                GLSLParser.ArraySpecifierContext arraySpecifierContext = ctx.arraySpecifier();
                if (arraySpecifierContext != null) {
                    ArraySpecifier arraySpecifier = this.visitArraySpecifier(arraySpecifierContext);
                    InterfaceBlockDeclaration interfaceBlockDeclaration = new InterfaceBlockDeclaration(typeQualifier, name, structBody, variableName, arraySpecifier);
                    return interfaceBlockDeclaration;
                }
                InterfaceBlockDeclaration interfaceBlockDeclaration = new InterfaceBlockDeclaration(typeQualifier, name, structBody, variableName);
                return interfaceBlockDeclaration;
            }
            InterfaceBlockDeclaration interfaceBlockDeclaration = new InterfaceBlockDeclaration(typeQualifier, name, structBody);
            return interfaceBlockDeclaration;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public VariableDeclaration visitVariableDeclaration(GLSLParser.VariableDeclarationContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            VariableDeclaration variableDeclaration = new VariableDeclaration(this.visitTypeQualifier(ctx.typeQualifier()), ctx.variableNames.stream().map(ASTBuilder::makeIdentifier));
            return variableDeclaration;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Initializer visitInitializer(GLSLParser.InitializerContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            GLSLParser.ExpressionContext expressionContext = ctx.expression();
            if (expressionContext != null) {
                ExpressionInitializer expressionInitializer = new ExpressionInitializer(this.visitExpression(expressionContext));
                return expressionInitializer;
            }
            List<GLSLParser.InitializerContext> initializers = ctx.initializers;
            NestedInitializer nestedInitializer = initializers == null ? new NestedInitializer() : new NestedInitializer(initializers.stream().map(this::visitInitializer));
            return nestedInitializer;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public NamedLayoutQualifierPart visitNamedLayoutQualifier(GLSLParser.NamedLayoutQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            NamedLayoutQualifierPart namedLayoutQualifierPart = new NamedLayoutQualifierPart(new Identifier(ctx.getStart()), ASTBuilder.applySafe(ctx.expression(), this::visitExpression));
            return namedLayoutQualifierPart;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public SharedLayoutQualifierPart visitSharedLayoutQualifier(GLSLParser.SharedLayoutQualifierContext ctx) {
        return ASTBuilder.constructSimple(ctx, SharedLayoutQualifierPart::new);
    }

    public LayoutQualifierPart visitLayoutQualifierPart(GLSLParser.LayoutQualifierIdContext ctx) {
        return (LayoutQualifierPart)this.visit(ctx);
    }

    @Override
    public LayoutQualifier visitLayoutQualifier(GLSLParser.LayoutQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            LayoutQualifier layoutQualifier = new LayoutQualifier(ctx.layoutQualifiers.stream().map(this::visitLayoutQualifierPart));
            return layoutQualifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public PreciseQualifier visitPreciseQualifier(GLSLParser.PreciseQualifierContext ctx) {
        return ASTBuilder.constructSimple(ctx, PreciseQualifier::new);
    }

    @Override
    public InvariantQualifier visitInvariantQualifier(GLSLParser.InvariantQualifierContext ctx) {
        return ASTBuilder.constructSimple(ctx, InvariantQualifier::new);
    }

    @Override
    public InterpolationQualifier visitInterpolationQualifier(GLSLParser.InterpolationQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            InterpolationQualifier interpolationQualifier = new InterpolationQualifier(InterpolationQualifier.InterpolationType.fromToken(ctx.getStart()));
            return interpolationQualifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public PrecisionQualifier visitPrecisionQualifier(GLSLParser.PrecisionQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            PrecisionQualifier precisionQualifier = new PrecisionQualifier(PrecisionQualifier.PrecisionLevel.fromToken(ctx.getStart()));
            return precisionQualifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public ASTNode visitStorageQualifier(GLSLParser.StorageQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            StorageQualifier storageQualifier = ctx.typeNames.isEmpty() ? new StorageQualifier(StorageQualifier.StorageType.fromToken(ctx.getStart())) : new StorageQualifier(ctx.typeNames.stream().map(ASTBuilder::makeIdentifier));
            return storageQualifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public StructBody visitStructBody(GLSLParser.StructBodyContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            StructBody structBody = new StructBody(ctx.structMember().stream().map(this::visitStructMember));
            return structBody;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public StructMember visitStructMember(GLSLParser.StructMemberContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            StructMember structMember = new StructMember(this.visitFullySpecifiedType(ctx.fullySpecifiedType()), ctx.structDeclarators.stream().map(this::visitStructDeclarator));
            return structMember;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public StructDeclarator visitStructDeclarator(GLSLParser.StructDeclaratorContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            StructDeclarator structDeclarator = new StructDeclarator(new Identifier(ctx.getStart()), ASTBuilder.applySafe(ctx.arraySpecifier(), this::visitArraySpecifier));
            return structDeclarator;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSpecifier visitTypeSpecifier(GLSLParser.TypeSpecifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            ArraySpecifier arraySpecifier = ASTBuilder.applySafe(ctx.arraySpecifier(), this::visitArraySpecifier);
            GLSLParser.BuiltinTypeSpecifierFixedContext builtinTypeFixed = ctx.builtinTypeSpecifierFixed();
            if (builtinTypeFixed != null) {
                BuiltinFixedTypeSpecifier.BuiltinType type = BuiltinFixedTypeSpecifier.BuiltinType.fromToken(builtinTypeFixed.getStart());
                BuiltinFixedTypeSpecifier builtinFixedTypeSpecifier = new BuiltinFixedTypeSpecifier(type, arraySpecifier);
                return builtinFixedTypeSpecifier;
            }
            GLSLParser.BuiltinTypeSpecifierParseableContext builtinNumericType = ctx.builtinTypeSpecifierParseable();
            if (builtinNumericType != null) {
                Type type = Type.fromToken(builtinNumericType.getStart());
                BuiltinNumericTypeSpecifier builtinNumericTypeSpecifier = new BuiltinNumericTypeSpecifier(type, arraySpecifier);
                return builtinNumericTypeSpecifier;
            }
            GLSLParser.StructSpecifierContext structSpecifierContext = ctx.structSpecifier();
            if (structSpecifierContext != null) {
                StructSpecifier structSpecifier = new StructSpecifier(ASTBuilder.applySafe(structSpecifierContext.IDENTIFIER(), this::visitIdentifier), this.visitStructBody(structSpecifierContext.structBody()), arraySpecifier);
                return structSpecifier;
            }
            Identifier identifier = this.visitIdentifier(ctx.IDENTIFIER());
            TypeReference typeReference = new TypeReference(identifier, arraySpecifier);
            return typeReference;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    @Override
    public TypeQualifier visitTypeQualifier(GLSLParser.TypeQualifierContext ctx) {
        ASTBuilder.startConstruction(ctx);
        try {
            TypeQualifier typeQualifier = new TypeQualifier(ctx.children.stream().map(child -> (TypeQualifierPart)this.visit((ParseTree)child)));
            return typeQualifier;
        }
        finally {
            ASTBuilder.endConstruction();
        }
    }

    public Expression visitExpression(GLSLParser.ExpressionContext ctx) {
        return (Expression)this.visit(ctx);
    }

    @Override
    public Statement visitStatement(GLSLParser.StatementContext ctx) {
        return (Statement)super.visitStatement(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalDeclaration visitExternalDeclaration(GLSLParser.ExternalDeclarationContext ctx) {
        ASTNode result = (ASTNode)super.visitExternalDeclaration(ctx);
        ASTNode aSTNode = result;
        if (aSTNode instanceof Declaration) {
            Declaration declaration = (Declaration)aSTNode;
            ASTBuilder.startConstruction(ctx);
            try {
                aSTNode = new DeclarationExternalDeclaration(declaration);
                return aSTNode;
            }
            finally {
                ASTBuilder.endConstruction();
            }
        }
        return (ExternalDeclaration)result;
    }

    public Declaration visitDeclaration(GLSLParser.DeclarationContext ctx) {
        return (Declaration)this.visit(ctx);
    }

    @Override
    public ASTNode visitTerminal(TerminalNode node) {
        throw new AssertionError((Object)("visitTerminal should never be called instead of allowing the normal visitation to reach terminal nodes automatically. Content of this node: " + node.getText()));
    }

    public Identifier visitIdentifier(TerminalNode identifier) {
        return ASTBuilder.makeIdentifier(identifier.getSymbol());
    }
}

