/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shader_overrides;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkRenderShaderBackend;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ChunkRenderBackendExt;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkRenderShaderBackend.class})
public class MixinChunkRenderShaderBackend
implements ChunkRenderBackendExt {
    @Unique
    private IrisChunkProgramOverrides irisChunkProgramOverrides;
    @Unique
    private RenderDevice device;
    @Unique
    private ChunkProgram override;
    @Shadow(remap=false)
    protected ChunkProgram activeProgram;
    @Shadow
    @Final
    protected ChunkVertexType vertexType;

    @Shadow
    public void begin(MatrixStack poseStack) {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void iris$onInit(ChunkVertexType vertexType, CallbackInfo ci) {
        this.irisChunkProgramOverrides = new IrisChunkProgramOverrides();
    }

    @Redirect(method={"createShader"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/gl/shader/ShaderLoader;loadShader(Lme/jellysquid/mods/sodium/client/gl/device/RenderDevice;Lme/jellysquid/mods/sodium/client/gl/shader/ShaderType;Lnet/minecraft/resources/ResourceLocation;Ljava/util/List;)Lme/jellysquid/mods/sodium/client/gl/shader/GlShader;", ordinal=0))
    private GlShader iris$redirectOriginalShader(RenderDevice device, ShaderType type, ResourceLocation name, List<String> constants) {
        if (this.vertexType == IrisModelVertexFormats.MODEL_VERTEX_XHFP) {
            String shader = MixinChunkRenderShaderBackend.getShaderSource(MixinChunkRenderShaderBackend.getShaderPath(name));
            shader = shader.replace("v_LightCoord = a_LightCoord", "v_LightCoord = (iris_LightmapTextureMatrix * vec4(a_LightCoord, 0, 1)).xy");
            StringTransformations transformations = new StringTransformations(shader);
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "mat4 iris_LightmapTextureMatrix = mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0));");
            return new GlShader(device, type, name, transformations.toString(), ShaderConstants.fromStringList(constants));
        }
        return ShaderLoader.loadShader((RenderDevice)device, (ShaderType)type, (ResourceLocation)name, constants);
    }

    private static String getShaderPath(ResourceLocation name) {
        return String.format("/assets/%s/shaders/%s", name.func_110624_b(), name.func_110623_a());
    }

    private static String getShaderSource(String path) {
        try {
            String var3;
            try (InputStream in = ShaderLoader.class.getResourceAsStream(path);){
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                }
                var3 = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            return var3;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read shader sources", e);
        }
    }

    @Inject(method={"createShaders"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onCreateShaders(RenderDevice device, CallbackInfo ci) {
        this.device = device;
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        SodiumTerrainPipeline sodiumTerrainPipeline = null;
        if (worldRenderingPipeline != null) {
            sodiumTerrainPipeline = worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        this.irisChunkProgramOverrides.createShaders(sodiumTerrainPipeline, device);
    }

    @Override
    public void iris$begin(MatrixStack poseStack, BlockRenderPass pass) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            RenderSystem.disableCull();
        }
        this.override = this.irisChunkProgramOverrides.getProgramOverride(this.device, pass);
        Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::beginSodiumTerrainRendering);
        this.begin(poseStack);
    }

    @Inject(method={"begin"}, at={@At(value="FIELD", target="me/jellysquid/mods/sodium/client/render/chunk/shader/ChunkRenderShaderBackend.activeProgram: Lme/jellysquid/mods/sodium/client/render/chunk/shader/ChunkProgram;", args={"opcode=PUTFIELD"}, remap=false, shift=At.Shift.AFTER)})
    private void iris$applyOverride(MatrixStack poseStack, CallbackInfo ci) {
        if (this.override != null) {
            this.activeProgram = this.override;
        }
    }

    @Inject(method={"end"}, at={@At(value="RETURN")})
    private void iris$onEnd(MatrixStack poseStack, CallbackInfo ci) {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::endSodiumTerrainRendering);
    }

    @Inject(method={"delete"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onDelete(CallbackInfo ci) {
        this.irisChunkProgramOverrides.deleteShaders();
    }
}

