/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.widget.BaseOptionElementWidget;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.Profile;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuProfileElement;
import net.coderbot.iris.shaderpack.option.values.OptionValues;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ProfileElementWidget
extends BaseOptionElementWidget<OptionMenuProfileElement> {
    private static final IFormattableTextComponent PROFILE_LABEL = new TranslationTextComponent("options.iris.profile");
    private static final IFormattableTextComponent PROFILE_CUSTOM = new TranslationTextComponent("options.iris.profile.custom").func_240699_a_(TextFormatting.YELLOW);
    private Profile next;
    private Profile previous;
    private ITextComponent profileLabel;

    public ProfileElementWidget(OptionMenuProfileElement element) {
        super(element);
    }

    @Override
    public void init(ShaderPackScreen screen, NavigationController navigation) {
        super.init(screen, navigation);
        this.setLabel(PROFILE_LABEL);
        ProfileSet profiles = ((OptionMenuProfileElement)this.element).profiles;
        OptionSet options = ((OptionMenuProfileElement)this.element).options;
        OptionValues pendingValues = ((OptionMenuProfileElement)this.element).getPendingOptionValues();
        ProfileSet.ProfileResult result = profiles.scan(options, pendingValues);
        this.next = result.next;
        this.previous = result.previous;
        Optional<String> profileName = result.current.map(p -> p.name);
        this.profileLabel = (ITextComponent)profileName.map(name -> GuiUtil.translateOrDefault((IFormattableTextComponent)new StringTextComponent(name), "profile." + name, new Object[0])).orElse(PROFILE_CUSTOM);
    }

    @Override
    public void render(MatrixStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
        this.updateRenderParams(width, width - (Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)PROFILE_LABEL) + 16));
        this.renderOptionWithValue(poseStack, x, y, width, height, hovered);
    }

    @Override
    protected ITextComponent createValueLabel() {
        return this.profileLabel;
    }

    @Override
    public Optional<ITextComponent> getCommentTitle() {
        return Optional.of(PROFILE_LABEL);
    }

    @Override
    public String getCommentKey() {
        return "profile.comment";
    }

    @Override
    public boolean applyNextValue() {
        if (this.next == null) {
            return false;
        }
        Iris.queueShaderPackOptionsFromProfile(this.next);
        return true;
    }

    @Override
    public boolean applyPreviousValue() {
        if (this.previous == null) {
            return false;
        }
        Iris.queueShaderPackOptionsFromProfile(this.previous);
        return true;
    }

    @Override
    public boolean applyOriginalValue() {
        return false;
    }

    @Override
    public boolean isValueModified() {
        return false;
    }
}

