/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import net.coderbot.iris.helpers.ColorSRGB;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.NativeImage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MipmapGenerator.class})
public class MixinMipmapGenerator {
    @Overwrite
    private static int func_229172_a_(int one, int two, int three, int four, boolean checkAlpha) {
        return MixinMipmapGenerator.weightedAverageColor(MixinMipmapGenerator.weightedAverageColor(one, two), MixinMipmapGenerator.weightedAverageColor(three, four));
    }

    @Unique
    private static int weightedAverageColor(int one, int two) {
        int alphaTwo;
        int alphaOne = NativeImage.func_227786_a_((int)one);
        if (alphaOne == (alphaTwo = NativeImage.func_227786_a_((int)two))) {
            return MixinMipmapGenerator.averageRgb(one, two, alphaOne);
        }
        if (alphaOne == 0) {
            return two & 0xFFFFFF | alphaTwo >> 2 << 24;
        }
        if (alphaTwo == 0) {
            return one & 0xFFFFFF | alphaOne >> 2 << 24;
        }
        float scale = 1.0f / (float)(alphaOne + alphaTwo);
        float relativeWeightOne = (float)alphaOne * scale;
        float relativeWeightTwo = (float)alphaTwo * scale;
        float oneR = ColorSRGB.srgbToLinear(NativeImage.func_227791_b_((int)one)) * relativeWeightOne;
        float oneG = ColorSRGB.srgbToLinear(NativeImage.func_227793_c_((int)one)) * relativeWeightOne;
        float oneB = ColorSRGB.srgbToLinear(NativeImage.func_227795_d_((int)one)) * relativeWeightOne;
        float twoR = ColorSRGB.srgbToLinear(NativeImage.func_227791_b_((int)two)) * relativeWeightTwo;
        float twoG = ColorSRGB.srgbToLinear(NativeImage.func_227793_c_((int)two)) * relativeWeightTwo;
        float twoB = ColorSRGB.srgbToLinear(NativeImage.func_227795_d_((int)two)) * relativeWeightTwo;
        float linearR = oneR + twoR;
        float linearG = oneG + twoG;
        float linearB = oneB + twoB;
        int averageAlpha = alphaOne + alphaTwo >> 1;
        return ColorSRGB.linearToSrgb(linearR, linearG, linearB, averageAlpha);
    }

    @Unique
    private static int averageRgb(int a, int b, int alpha) {
        float ar = ColorSRGB.srgbToLinear(NativeImage.func_227791_b_((int)a));
        float ag = ColorSRGB.srgbToLinear(NativeImage.func_227793_c_((int)a));
        float ab = ColorSRGB.srgbToLinear(NativeImage.func_227795_d_((int)a));
        float br = ColorSRGB.srgbToLinear(NativeImage.func_227791_b_((int)b));
        float bg = ColorSRGB.srgbToLinear(NativeImage.func_227793_c_((int)b));
        float bb = ColorSRGB.srgbToLinear(NativeImage.func_227795_d_((int)b));
        return ColorSRGB.linearToSrgb((ar + br) * 0.5f, (ag + bg) * 0.5f, (ab + bb) * 0.5f, alpha);
    }
}

