/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gui.FeatureMissingErrorScreen;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.OrderBackedProperties;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSetInterface;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class ShaderPack {
    private static final Gson GSON = new Gson();
    private final ProgramSet base;
    private final Map<NamespacedId, ProgramSetInterface> overrides;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new EnumMap(TextureStage.class);
    private final CustomTextureData customNoiseTexture;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final ProfileSet.ProfileResult profile;
    private final String profileInfo;
    private final Function<AbsolutePackPath, String> sourceProvider;
    private final ShaderProperties shaderProperties;
    private List<String> dimensionIds;
    private Map<NamespacedId, String> dimensionMap;

    public ShaderPack(Path root, Iterable<StringPair> environmentDefines) throws IOException, IllegalStateException {
        this(root, Collections.emptyMap(), environmentDefines);
    }

    public ShaderPack(Path root, Map<String, String> changedConfigs, Iterable<StringPair> environmentDefines) throws IOException, IllegalStateException {
        List<String> optionalFeatureFlags;
        Objects.requireNonNull(root);
        ImmutableList.Builder starts = ImmutableList.builder();
        ImmutableList<String> potentialFileNames = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/"), potentialFileNames);
        this.dimensionIds = new ArrayList<String>();
        boolean[] hasDimensionIds = new boolean[]{false};
        List dimensionIdCreator = ShaderPack.loadProperties(root, "dimension.properties", environmentDefines).map(dimensionProperties -> {
            hasDimensionIds[0] = dimensionProperties.size() > 0;
            this.dimensionMap = ShaderPack.parseDimensionMap(dimensionProperties, "dimension.", "dimension.properties");
            return this.parseDimensionIds((Properties)dimensionProperties, "dimension.");
        }).orElse(new ArrayList());
        if (!hasDimensionIds[0]) {
            this.dimensionMap = new Object2ObjectArrayMap();
            if (Files.exists(root.resolve("world0"), new LinkOption[0])) {
                dimensionIdCreator.add("world0");
                this.dimensionMap.putIfAbsent(DimensionId.OVERWORLD, "world0");
                this.dimensionMap.putIfAbsent(new NamespacedId("*", "*"), "world0");
            }
            if (Files.exists(root.resolve("world-1"), new LinkOption[0])) {
                dimensionIdCreator.add("world-1");
                this.dimensionMap.putIfAbsent(DimensionId.NETHER, "world-1");
            }
            if (Files.exists(root.resolve("world1"), new LinkOption[0])) {
                dimensionIdCreator.add("world1");
                this.dimensionMap.putIfAbsent(DimensionId.END, "world1");
            }
        }
        for (String id : dimensionIdCreator) {
            if (!ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/" + id), potentialFileNames)) continue;
            this.dimensionIds.add(id);
        }
        IncludeGraph graph = new IncludeGraph(root, (ImmutableList<AbsolutePackPath>)starts.build());
        if (!graph.getFailures().isEmpty()) {
            graph.getFailures().forEach((path, error) -> Iris.logger.error("{}", error.toString()));
            throw new IOException("Failed to resolve some #include directives, see previous messages for details");
        }
        this.languageMap = new LanguageMap(root.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(graph, changedConfigs);
        graph = this.shaderPackOptions.getIncludes();
        ImmutableList finalEnvironmentDefines = environmentDefines;
        this.shaderProperties = ShaderPack.loadProperties(root, "shaders.properties").map(source -> new ShaderProperties((String)source, this.shaderPackOptions, (Iterable<StringPair>)finalEnvironmentDefines)).orElseGet(ShaderProperties::empty);
        List<FeatureFlags> invalidFlagList = this.shaderProperties.getRequiredFeatureFlags().stream().filter(FeatureFlags::isInvalid).map(FeatureFlags::getValue).collect(Collectors.toList());
        List invalidFeatureFlags = invalidFlagList.stream().map(FeatureFlags::getHumanReadableName).collect(Collectors.toList());
        if (!invalidFeatureFlags.isEmpty()) {
            if (Minecraft.func_71410_x().field_71462_r instanceof ShaderPackScreen) {
                Minecraft.func_71410_x().func_147108_a((Screen)new FeatureMissingErrorScreen(Minecraft.func_71410_x().field_71462_r, (ITextComponent)new TranslationTextComponent("iris.unsupported.pack"), (ITextComponent)new TranslationTextComponent("iris.unsupported.pack.description", new Object[]{FeatureFlags.getInvalidStatus(invalidFlagList), invalidFeatureFlags.stream().collect(Collectors.joining(", ", ": ", "."))})));
            }
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(false);
        }
        ArrayList<StringPair> newEnvDefines = new ArrayList<StringPair>();
        environmentDefines.forEach(newEnvDefines::add);
        if (this.shaderProperties.supportsColorCorrection().orElse(false)) {
            for (ColorSpace space : ColorSpace.values()) {
                newEnvDefines.add(new StringPair("COLOR_SPACE_" + space.name(), String.valueOf(space.ordinal())));
            }
        }
        if (!(optionalFeatureFlags = this.shaderProperties.getOptionalFeatureFlags().stream().filter(flag -> !FeatureFlags.isInvalid(flag)).collect(Collectors.toList())).isEmpty()) {
            optionalFeatureFlags.forEach(flag -> newEnvDefines.add(new StringPair("IRIS_FEATURE_" + flag, "")));
        }
        environmentDefines = ImmutableList.copyOf(newEnvDefines);
        ProfileSet profiles = ProfileSet.fromTree(this.shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        this.profile = profiles.scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList disabledPrograms = new ArrayList();
        this.profile.current.ifPresent(profile -> disabledPrograms.addAll(profile.disabledPrograms));
        this.shaderProperties.getConditionallyEnabledPrograms().forEach((program, shaderOption) -> {
            if ("true".equals(shaderOption)) {
                return;
            }
            if ("false".equals(shaderOption) || !this.shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)shaderOption)) {
                disabledPrograms.add(program);
            }
        });
        this.menuContainer = new OptionMenuContainer(this.shaderProperties, this.shaderPackOptions, profiles);
        String profileName = this.getCurrentProfileName();
        MutableOptionValues profileOptions = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), this.profile.current.map(p -> p.optionValues).orElse(new HashMap()));
        int userOptionsChanged = this.shaderPackOptions.getOptionValues().getOptionsChanged() - profileOptions.getOptionsChanged();
        this.profileInfo = "Profile: " + profileName + " (+" + userOptionsChanged + " option" + (userOptionsChanged == 1 ? "" : "s") + " changed by user)";
        Iris.logger.info(this.profileInfo);
        IncludeProcessor includeProcessor = new IncludeProcessor(graph);
        ImmutableList finalEnvironmentDefines1 = environmentDefines;
        this.sourceProvider = arg_0 -> ShaderPack.lambda$new$8(disabledPrograms, includeProcessor, (Iterable)finalEnvironmentDefines1, arg_0);
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/" + this.dimensionMap.getOrDefault(new NamespacedId("*", "*"), "")), this.sourceProvider, this.shaderProperties, this);
        this.overrides = new HashMap<NamespacedId, ProgramSetInterface>();
        this.idMap = new IdMap(root, this.shaderPackOptions, (Iterable<StringPair>)environmentDefines);
        this.customNoiseTexture = this.shaderProperties.getNoiseTexturePath().map(path -> {
            try {
                return this.readTexture(root, (String)path);
            }
            catch (IOException e) {
                Iris.logger.error("Unable to read the custom noise texture at " + path, e);
                return null;
            }
        }).orElse(null);
        this.shaderProperties.getCustomTextures().forEach((textureStage, customTexturePropertiesMap) -> {
            Object2ObjectOpenHashMap innerCustomTextureDataMap = new Object2ObjectOpenHashMap();
            customTexturePropertiesMap.forEach((arg_0, arg_1) -> this.lambda$new$10((Object2ObjectMap)innerCustomTextureDataMap, root, arg_0, arg_1));
            this.customTextureDataMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, CustomTextureData>)innerCustomTextureDataMap);
        });
    }

    private static Optional<Properties> loadProperties(Path shaderPath, String name, Iterable<StringPair> environmentDefines) {
        String fileContents = ShaderPack.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        String processed = PropertiesPreprocessor.preprocessSource(fileContents, environmentDefines);
        StringReader propertiesReader = new StringReader(processed);
        OrderBackedProperties properties = new OrderBackedProperties();
        try {
            properties.load(propertiesReader);
        }
        catch (IOException e) {
            Iris.logger.error("Error loading " + name + " at " + shaderPath, e);
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    private List<String> parseDimensionIds(Properties dimensionProperties, String keyPrefix) {
        ArrayList<String> names = new ArrayList<String>();
        dimensionProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, value) -> {
            String key = (String)keyObject;
            if (!key.startsWith(keyPrefix)) {
                return;
            }
            key = key.substring(keyPrefix.length());
            names.add(key);
        }));
        return names;
    }

    private static Map<NamespacedId, String> parseDimensionMap(Properties properties, String keyPrefix, String fileName) {
        Object2ObjectArrayMap overrides = new Object2ObjectArrayMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> ShaderPack.lambda$parseDimensionMap$13(keyPrefix, (Map)overrides, arg_0, arg_1)));
        return overrides;
    }

    private String getCurrentProfileName() {
        return this.profile.current.map(p -> p.name).orElse("Custom");
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    @Nullable
    private static ProgramSet loadOverrides(boolean has, AbsolutePackPath path, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack) {
        if (has) {
            return new ProgramSet(path, sourceProvider, shaderProperties, pack);
        }
        return null;
    }

    private static Optional<String> loadProperties(Path shaderPath, String name) {
        String fileContents = ShaderPack.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        return Optional.of(fileContents);
    }

    public CustomTextureData readTexture(Path root, String path) throws IOException {
        CustomTextureData customTextureData;
        if (path.contains(":")) {
            String[] parts = path.split(":");
            if (parts.length > 2) {
                Iris.logger.warn("Resource location " + path + " contained more than two parts?");
            }
            customTextureData = parts[0].equals("minecraft") && (parts[1].equals("dynamic/lightmap_1") || parts[1].equals("dynamic/light_map_1")) ? new CustomTextureData.LightmapMarker() : new CustomTextureData.ResourceData(parts[0], parts[1]);
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            boolean blur = false;
            boolean clamp = false;
            String mcMetaPath = path + ".mcmeta";
            Path mcMetaResolvedPath = root.resolve(mcMetaPath);
            if (Files.exists(mcMetaResolvedPath, new LinkOption[0])) {
                try {
                    JsonObject meta = this.loadMcMeta(mcMetaResolvedPath);
                    if (meta.get("texture") != null) {
                        if (meta.get("texture").getAsJsonObject().get("blur") != null) {
                            blur = meta.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                        }
                        if (meta.get("texture").getAsJsonObject().get("clamp") != null) {
                            clamp = meta.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                        }
                    }
                }
                catch (IOException e) {
                    Iris.logger.error("Unable to read the custom texture mcmeta at " + mcMetaPath + ", ignoring: " + e);
                }
            }
            byte[] content = Files.readAllBytes(root.resolve(path));
            customTextureData = new CustomTextureData.PngData(new TextureFilteringData(blur, clamp), content);
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path mcMetaPath) throws IOException, JsonParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(mcMetaPath, new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonReader jsonReader = new JsonReader((Reader)reader);
            JsonObject jsonObject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
            return jsonObject;
        }
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug("An " + name + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException e) {
            Iris.logger.error("An IOException occurred reading " + name + " from the current shaderpack", e);
            return null;
        }
    }

    public ProgramSet getProgramSet(NamespacedId dimension) {
        ProgramSetInterface overrides = this.overrides.computeIfAbsent(dimension, dim -> {
            if (this.dimensionMap.containsKey(dimension)) {
                String name = this.dimensionMap.get(dimension);
                if (this.dimensionIds.contains(name)) {
                    return new ProgramSet(AbsolutePackPath.fromAbsolutePath("/" + name), this.sourceProvider, this.shaderProperties, this);
                }
                Iris.logger.error("Attempted to load dimension folder " + name + " for dimension " + dimension + ", but it does not exist!");
                return ProgramSetInterface.Empty.INSTANCE;
            }
            return ProgramSetInterface.Empty.INSTANCE;
        });
        if (overrides instanceof ProgramSet) {
            return (ProgramSet)overrides;
        }
        return this.base;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    private static /* synthetic */ void lambda$parseDimensionMap$13(String keyPrefix, Map overrides, Object keyObject, Object valueObject) {
        String key = (String)keyObject;
        String value = (String)valueObject;
        if (!key.startsWith(keyPrefix)) {
            return;
        }
        key = key.substring(keyPrefix.length());
        for (String part : value.split("\\s+")) {
            if (part.equals("*")) {
                overrides.put(new NamespacedId("*", "*"), key);
            }
            overrides.put(new NamespacedId(part), key);
        }
    }

    private /* synthetic */ void lambda$new$10(Object2ObjectMap innerCustomTextureDataMap, Path root, String samplerName, String path) {
        try {
            innerCustomTextureDataMap.put((Object)samplerName, (Object)this.readTexture(root, path));
        }
        catch (IOException e) {
            Iris.logger.error("Unable to read the custom texture at " + path, e);
        }
    }

    private static /* synthetic */ String lambda$new$8(List disabledPrograms, IncludeProcessor includeProcessor, Iterable finalEnvironmentDefines1, AbsolutePackPath path) {
        String pathString;
        String programString = pathString.substring((pathString = path.getPathString()).indexOf("/") == 0 ? 1 : 0, pathString.lastIndexOf("."));
        if (disabledPrograms.contains(programString)) {
            return null;
        }
        ImmutableList<String> lines = includeProcessor.getIncludedFile(path);
        if (lines == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line);
            builder.append('\n');
        }
        String source = builder.toString();
        source = JcppProcessor.glslPreprocessSource(source, finalEnvironmentDefines1);
        return source;
    }
}

