/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import com.mojang.datafixers.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.texture.AnimationMetadataSectionAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasAccessor;
import net.coderbot.iris.mixin.texture.TextureAtlasSpriteAccessor;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasSpriteExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AtlasPBRLoader
implements PBRTextureLoader<AtlasTexture> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);

    @Override
    public void load(AtlasTexture atlas, IResourceManager resourceManager, PBRTextureLoader.PBRTextureConsumer pbrTextureConsumer) {
        TextureInfoCache.TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(atlas.func_110552_b());
        int atlasWidth = textureInfo.getWidth();
        int atlasHeight = textureInfo.getHeight();
        int mipLevel = AtlasPBRLoader.fetchAtlasMipLevel(atlas);
        PBRAtlasTexture normalAtlas = null;
        PBRAtlasTexture specularAtlas = null;
        for (TextureAtlasSprite sprite : ((TextureAtlasAccessor)atlas).getTexturesByName().values()) {
            PBRSpriteHolder pbrSpriteHolder;
            if (sprite instanceof MissingTextureSprite) continue;
            TextureAtlasSprite normalSprite = this.createPBRSprite(sprite, resourceManager, atlas, atlasWidth, atlasHeight, mipLevel, PBRType.NORMAL);
            TextureAtlasSprite specularSprite = this.createPBRSprite(sprite, resourceManager, atlas, atlasWidth, atlasHeight, mipLevel, PBRType.SPECULAR);
            if (normalSprite != null) {
                if (normalAtlas == null) {
                    normalAtlas = new PBRAtlasTexture(atlas, PBRType.NORMAL);
                }
                normalAtlas.addSprite(normalSprite);
                pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
                pbrSpriteHolder.setNormalSprite(normalSprite);
            }
            if (specularSprite == null) continue;
            if (specularAtlas == null) {
                specularAtlas = new PBRAtlasTexture(atlas, PBRType.SPECULAR);
            }
            specularAtlas.addSprite(specularSprite);
            pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
            pbrSpriteHolder.setSpecularSprite(specularSprite);
        }
        if (normalAtlas != null && normalAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel)) {
            pbrTextureConsumer.acceptNormalTexture(normalAtlas);
        }
        if (specularAtlas != null && specularAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel)) {
            pbrTextureConsumer.acceptSpecularTexture(specularAtlas);
        }
    }

    protected static int fetchAtlasMipLevel(AtlasTexture atlas) {
        TextureAtlasSprite missingSprite = atlas.func_195424_a(MissingTextureSprite.func_195675_b());
        return ((TextureAtlasSpriteAccessor)missingSprite).getMainImage().length - 1;
    }

    @Nullable
    protected TextureAtlasSprite createPBRSprite(TextureAtlasSprite sprite, IResourceManager resourceManager, AtlasTexture atlas, int atlasWidth, int atlasHeight, int mipLevel, PBRType pbrType) {
        ResourceLocation spriteName = sprite.func_195668_m();
        ResourceLocation imageLocation = ((TextureAtlasAccessor)atlas).callGetResourceLocation(spriteName);
        ResourceLocation pbrImageLocation = pbrType.appendToFileLocation(imageLocation);
        PBRTextureAtlasSprite pbrSprite = null;
        try (IResource resource2 = resourceManager.func_199002_a(pbrImageLocation);){
            NativeImage nativeImage = NativeImage.func_195713_a((InputStream)resource2.func_199027_b());
            AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource2.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
            if (animationMetadata == null) {
                animationMetadata = AnimationMetadataSection.field_229300_b_;
            }
            Pair frameSize = animationMetadata.func_225641_a_(nativeImage.func_195702_a(), nativeImage.func_195714_b());
            int frameWidth = (Integer)frameSize.getFirst();
            int frameHeight = (Integer)frameSize.getSecond();
            int targetFrameWidth = sprite.func_94211_a();
            int targetFrameHeight = sprite.func_94216_b();
            if (frameWidth != targetFrameWidth || frameHeight != targetFrameHeight) {
                int imageWidth = nativeImage.func_195702_a();
                int imageHeight = nativeImage.func_195714_b();
                int targetImageWidth = imageWidth / frameWidth * targetFrameWidth;
                int targetImageHeight = imageHeight / frameHeight * targetFrameHeight;
                NativeImage scaledImage = targetImageWidth % imageWidth == 0 && targetImageHeight % imageHeight == 0 ? ImageManipulationUtil.scaleNearestNeighbor(nativeImage, targetImageWidth, targetImageHeight) : ImageManipulationUtil.scaleBilinear(nativeImage, targetImageWidth, targetImageHeight);
                nativeImage.close();
                nativeImage = scaledImage;
                frameWidth = targetFrameWidth;
                frameHeight = targetFrameHeight;
                if (animationMetadata != AnimationMetadataSection.field_229300_b_) {
                    AnimationMetadataSectionAccessor animationAccessor = (AnimationMetadataSectionAccessor)animationMetadata;
                    int internalFrameWidth = animationAccessor.getFrameWidth();
                    int internalFrameHeight = animationAccessor.getFrameHeight();
                    if (internalFrameWidth != -1) {
                        animationAccessor.setFrameWidth(frameWidth);
                    }
                    if (internalFrameHeight != -1) {
                        animationAccessor.setFrameHeight(frameHeight);
                    }
                }
            }
            ResourceLocation pbrSpriteName = new ResourceLocation(spriteName.func_110624_b(), spriteName.func_110623_a() + pbrType.getSuffix());
            PBRTextureAtlasSpriteInfo pbrSpriteInfo = new PBRTextureAtlasSpriteInfo(pbrSpriteName, frameWidth, frameHeight, animationMetadata, pbrType);
            int x = ((TextureAtlasSpriteAccessor)sprite).getX();
            int y = ((TextureAtlasSpriteAccessor)sprite).getY();
            pbrSprite = new PBRTextureAtlasSprite(atlas, pbrSpriteInfo, mipLevel, atlasWidth, atlasHeight, x, y, nativeImage);
            this.syncAnimation(sprite, pbrSprite);
        }
        catch (FileNotFoundException resource2) {
        }
        catch (RuntimeException e) {
            Iris.logger.error("Unable to parse metadata from {} : {}", pbrImageLocation, e);
        }
        catch (IOException e) {
            Iris.logger.error("Unable to load {} : {}", pbrImageLocation, e);
        }
        return pbrSprite;
    }

    protected void syncAnimation(TextureAtlasSprite source, TextureAtlasSprite target) {
        int time;
        if (!source.func_130098_m() || !target.func_130098_m()) {
            return;
        }
        TextureAtlasSpriteAccessor sourceAccessor = (TextureAtlasSpriteAccessor)source;
        AnimationMetadataSection sourceMetadata = sourceAccessor.getMetadata();
        int ticks = 0;
        for (int f = 0; f < sourceAccessor.getFrame(); ++f) {
            ticks += sourceMetadata.func_110472_a(f);
        }
        TextureAtlasSpriteAccessor targetAccessor = (TextureAtlasSpriteAccessor)target;
        AnimationMetadataSection targetMetadata = targetAccessor.getMetadata();
        int cycleTime = 0;
        int frameCount = targetMetadata.func_110473_c();
        for (int f = 0; f < frameCount; ++f) {
            cycleTime += targetMetadata.func_110472_a(f);
        }
        ticks %= cycleTime;
        int targetFrame = 0;
        while (ticks >= (time = targetMetadata.func_110472_a(targetFrame))) {
            ++targetFrame;
            ticks -= time;
        }
        targetAccessor.setFrame(targetFrame);
        targetAccessor.setSubFrame(ticks + sourceAccessor.getSubFrame());
    }

    protected static class PBRTextureAtlasSpriteInfo
    extends TextureAtlasSprite.Info {
        protected final PBRType pbrType;

        public PBRTextureAtlasSpriteInfo(ResourceLocation name, int width, int height, AnimationMetadataSection metadata, PBRType pbrType) {
            super(name, width, height, metadata);
            this.pbrType = pbrType;
        }
    }

    public static class PBRTextureAtlasSprite
    extends TextureAtlasSprite
    implements CustomMipmapGenerator.Provider {
        protected PBRTextureAtlasSprite(AtlasTexture atlas, TextureAtlasSprite.Info info, int mipLevel, int atlasWidth, int atlasHeight, int x, int y, NativeImage nativeImage) {
            super(atlas, info, mipLevel, atlasWidth, atlasHeight, x, y, nativeImage);
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator(TextureAtlasSprite.Info info, int atlasWidth, int atlasHeight) {
            if (info instanceof PBRTextureAtlasSpriteInfo) {
                CustomMipmapGenerator generator;
                PBRType pbrType = ((PBRTextureAtlasSpriteInfo)info).pbrType;
                TextureFormat format = TextureFormatLoader.getFormat();
                if (format != null && (generator = format.getMipmapGenerator(pbrType)) != null) {
                    return generator;
                }
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }
}

