/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.irisshaders.iris.api.v0.item.IrisItemLightProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public final class IdMapUniforms {
    private IdMapUniforms() {
    }

    public static void addIdMapUniforms(FrameUpdateNotifier notifier, DynamicUniformHolder uniforms, IdMap idMap, boolean isOldHandLight) {
        HeldItemSupplier mainHandSupplier = new HeldItemSupplier(Hand.MAIN_HAND, idMap.getItemIdMap(), isOldHandLight);
        HeldItemSupplier offHandSupplier = new HeldItemSupplier(Hand.OFF_HAND, idMap.getItemIdMap(), false);
        notifier.addListener(mainHandSupplier::update);
        notifier.addListener(offHandSupplier::update);
        uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId", mainHandSupplier::getIntID).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldItemId2", offHandSupplier::getIntID).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue", mainHandSupplier::getLightValue).uniform1i(UniformUpdateFrequency.PER_FRAME, "heldBlockLightValue2", offHandSupplier::getLightValue);
        uniforms.uniform1i("entityId", CapturedRenderingState.INSTANCE::getCurrentRenderedEntity, CapturedRenderingState.INSTANCE.getEntityIdNotifier());
        uniforms.uniform1i("blockEntityId", CapturedRenderingState.INSTANCE::getCurrentRenderedBlockEntity, CapturedRenderingState.INSTANCE.getBlockEntityIdNotifier());
    }

    private static class HeldItemSupplier {
        private final Hand hand;
        private final Object2IntFunction<NamespacedId> itemIdMap;
        private final boolean applyOldHandLight;
        private int intID;
        private int lightValue;
        private Vector3f lightColor;

        HeldItemSupplier(Hand hand, Object2IntFunction<NamespacedId> itemIdMap, boolean shouldApplyOldHandLight) {
            this.hand = hand;
            this.itemIdMap = itemIdMap;
            this.applyOldHandLight = shouldApplyOldHandLight && hand == Hand.MAIN_HAND;
        }

        private void invalidate() {
            this.intID = -1;
            this.lightValue = 0;
            this.lightColor = IrisItemLightProvider.DEFAULT_LIGHT_COLOR;
        }

        public void update() {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                this.invalidate();
                return;
            }
            ItemStack heldStack = player.func_184586_b(this.hand);
            if (heldStack == null) {
                this.invalidate();
                return;
            }
            Item heldItem = heldStack.func_77973_b();
            if (heldItem == null) {
                this.invalidate();
                return;
            }
            ResourceLocation heldItemId = Registry.field_212630_s.func_177774_c((Object)heldItem);
            this.intID = this.itemIdMap.applyAsInt((Object)new NamespacedId(heldItemId.func_110624_b(), heldItemId.func_110623_a()));
            IrisItemLightProvider lightProvider = (IrisItemLightProvider)heldItem;
            this.lightValue = lightProvider.getLightEmission((PlayerEntity)Minecraft.func_71410_x().field_71439_g, heldStack);
            if (this.applyOldHandLight) {
                lightProvider = this.applyOldHandLighting(player, lightProvider);
            }
            this.lightColor = lightProvider.getLightColor((PlayerEntity)Minecraft.func_71410_x().field_71439_g, heldStack);
        }

        private IrisItemLightProvider applyOldHandLighting(@NotNull ClientPlayerEntity player, IrisItemLightProvider existing) {
            ItemStack offHandStack = player.func_184586_b(Hand.OFF_HAND);
            if (offHandStack == null) {
                return existing;
            }
            Item offHandItem = offHandStack.func_77973_b();
            if (offHandItem == null) {
                return existing;
            }
            IrisItemLightProvider lightProvider = (IrisItemLightProvider)offHandItem;
            int newEmission = lightProvider.getLightEmission((PlayerEntity)Minecraft.func_71410_x().field_71439_g, offHandStack);
            if (this.lightValue < newEmission) {
                this.lightValue = newEmission;
                return lightProvider;
            }
            return existing;
        }

        public int getIntID() {
            return this.intID;
        }

        public int getLightValue() {
            return this.lightValue;
        }

        public Vector3f getLightColor() {
            return this.lightColor;
        }
    }
}

